/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.ProcessingContext;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class P4DeleteOperation
extends VcsOperationOnPath {
    public P4DeleteOperation() {
    }

    public P4DeleteOperation(String changeList, FilePath item) {
        super(changeList, FileUtil.toSystemIndependentName((String)item.getPath()));
    }

    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        P4File p4File = P4File.createInefficientFromLocalPath(this.myPath);
        long list = this.getPerforceChangeList(project, p4File, context);
        PerforceRunner.getInstance(project).assureDel(p4File, list);
        VcsUtil.markFileAsDirty((Project)project, (String)this.myPath);
    }

    @Override
    public Change getChange(Project project, ChangeListManagerGate addGate) {
        FilePath path = VcsContextFactory.getInstance().createFilePathOn(new File(this.myPath));
        ContentRevision beforeRevision = PerforceCachingContentRevision.createOffline(project, path, path);
        return new Change(beforeRevision, null);
    }

    @Override
    @Nullable
    public VcsOperation checkMerge(VcsOperation oldOp) {
        if (oldOp instanceof VcsOperationOnPath) {
            boolean pathsEqual = FileUtil.pathsEqual((String)((VcsOperationOnPath)oldOp).getPath(), (String)this.myPath);
            if (oldOp instanceof P4AddOperation && pathsEqual) {
                return null;
            }
            if (oldOp instanceof P4EditOperation && pathsEqual) {
                return this;
            }
        }
        return super.checkMerge(oldOp);
    }
}

