/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.UnsupportedGradleVersionIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "causedByOldGradleClasspathInferer", "", "rootCause", "", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.gradle.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUnsupportedGradleVersionIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsupportedGradleVersionIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        GradleVersion gradleVersion2;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        GradleVersion gradleVersionUsed = null;
        if (issueData.getBuildEnvironment() != null) {
            gradleVersionUsed = GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
        }
        Intrinsics.checkNotNullExpressionValue((Object)rootCause, (String)"rootCause");
        boolean isOldGradleClasspathInfererIssue = this.causedByOldGradleClasspathInferer(rootCause);
        boolean isUnsupportedModelBuilderApi = StringsKt.endsWith$default((String)rootCauseText, (String)"does not support the ModelBuilder API. Support for this is available in Gradle 1.2 and all later versions.", (boolean)false, (int)2, null);
        boolean isUnsupportedByIdea = gradleVersionUsed != null && !GradleJvmSupportMatrix.Companion.isGradleSupportedByIdea(gradleVersionUsed);
        boolean isAncientGradleVersion = isOldGradleClasspathInfererIssue || isUnsupportedModelBuilderApi || isUnsupportedByIdea;
        String unsupportedVersionMessagePrefix = "org.gradle.tooling.UnsupportedVersionException: Support for builds using Gradle versions older than ";
        if (!isAncientGradleVersion && !StringsKt.startsWith$default((String)rootCauseText, (String)unsupportedVersionMessagePrefix, (boolean)false, (int)2, null)) {
            return null;
        }
        String minRequiredVersionCandidate = isAncientGradleVersion ? GradleJvmSupportMatrix.Companion.getOldestSupportedGradleVersionByIdea().getVersion() : StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)rootCauseText, (String)unsupportedVersionMessagePrefix, null, (int)2, null), (String)" ", (String)"");
        try {
            gradleVersion2 = GradleVersion.version((String)minRequiredVersionCandidate);
        }
        catch (IllegalArgumentException e) {
            gradleVersion2 = GradleVersion.current();
        }
        GradleVersion gradleMinimumVersionRequired = gradleVersion2;
        String string2 = issueData.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)gradleMinimumVersionRequired, (String)"gradleMinimumVersionRequired");
        return new UnsupportedGradleVersionIssue(gradleVersionUsed, string2, gradleMinimumVersionRequired);
    }

    private final boolean causedByOldGradleClasspathInferer(Throwable rootCause) {
        Object object;
        block3: {
            String string2 = rootCause.getMessage();
            if (string2 == null) {
                return false;
            }
            String message = string2;
            if (!StringsKt.startsWith$default((String)message, (String)"Cannot determine classpath for resource", (boolean)false, (int)2, null)) {
                return false;
            }
            StackTraceElement[] stackTraceElementArray = rootCause.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"rootCause.stackTrace");
            for (Object object2 : (Object[])stackTraceElementArray) {
                StackTraceElement it = (StackTraceElement)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"org.gradle.tooling.internal.provider.ClasspathInferer")) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return object != null;
    }
}

