/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0013B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataUpdater;", "T", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "", "dataStorage", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;", "(Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;)V", "configUrl", "", "getConfigUrl", "()Ljava/lang/String;", "updateInterval", "", "getUpdateInterval", "()I", "checkForUpdates", "Ljava/util/concurrent/Future;", "retrieveNewData", "", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
public abstract class IdeVersionedDataUpdater<T extends IdeVersionedDataState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdeVersionedDataStorage<T> dataStorage;
    @NotNull
    private static final Logger LOG;

    public IdeVersionedDataUpdater(@NotNull IdeVersionedDataStorage<T> dataStorage) {
        Intrinsics.checkNotNullParameter(dataStorage, (String)"dataStorage");
        this.dataStorage = dataStorage;
    }

    @NotNull
    public abstract String getConfigUrl();

    public abstract int getUpdateInterval();

    @NotNull
    public Future<?> checkForUpdates() {
        Future future;
        if (this.getUpdateInterval() == 0 || StringUtil.isEmpty((String)this.getConfigUrl())) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"{\n      CompletableFutur\u2026dFuture<Any?>(null)\n    }");
            future = completableFuture;
        } else {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> IdeVersionedDataUpdater.checkForUpdates$lambda$0(this));
            future = future2;
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"getApplication().execute\u2026(configUrl)\n      }\n    }");
        }
        return future;
    }

    private final void retrieveNewData(String configUrl) {
        try {
            String string2 = HttpRequests.request((String)configUrl).forceHttps(!ApplicationManager.getApplication().isUnitTestMode()).productNameAsUserAgent().readString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request(configUrl)\n     \u2026t()\n        .readString()");
            String json = string2;
            this.dataStorage.setStateAsString(json);
        }
        catch (Exception e) {
            LOG.warn("Could not download new IDE versioned data for " + this.getClass().getName(), (Throwable)e);
        }
    }

    private static final void checkForUpdates$lambda$0(IdeVersionedDataUpdater this$0) {
        long lastUpdateTime;
        Object state;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object t = state = this$0.dataStorage.getState();
        long l = lastUpdateTime = t != null ? ((IdeVersionedDataState)((Object)t)).getLastUpdateTime() : 0L;
        if (lastUpdateTime + TimeUnit.DAYS.toMillis(this$0.getUpdateInterval()) <= System.currentTimeMillis()) {
            this$0.retrieveNewData(this$0.getConfigUrl());
        }
    }

    static {
        Logger logger = Logger.getInstance(IdeVersionedDataUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(IdeVersionedDataUpdater::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataUpdater$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

