/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.properties.base.BasePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/base/BasePropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "()V", "propertiesFileName", "", "getPropertiesFileName", "()Ljava/lang/String;", "findAndMergeProperties", "possiblePropertiesFiles", "", "Ljava/nio/file/Path;", "getGradleHomePropertiesPath", "getGradleProjectPropertiesPath", "kotlin.jvm.PlatformType", "externalProjectPath", "getGradleServiceDirectoryPath", "project", "Lcom/intellij/openapi/project/Project;", "serviceDirectoryStr", "getPossiblePropertiesFiles", "getProperties", "loadGradleProperties", "propertiesPath", "mergeGradleProperties", "most", "other", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradlePropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n2188#2,7:96\n1#3:103\n*S KotlinDebug\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n*L\n35#1:96,7\n*E\n"})
public final class GradlePropertiesFile
extends BasePropertiesFile<GradleProperties> {
    @NotNull
    public static final GradlePropertiesFile INSTANCE = new GradlePropertiesFile();
    @NotNull
    private static final String propertiesFileName = "gradle.properties";

    private GradlePropertiesFile() {
    }

    @Override
    @NotNull
    public String getPropertiesFileName() {
        return propertiesFileName;
    }

    @Override
    @NotNull
    public GradleProperties getProperties(@NotNull Project project, @NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        return this.findAndMergeProperties(this.getPossiblePropertiesFiles(project, externalProjectPath2));
    }

    @NotNull
    public final GradleProperties getProperties(@Nullable String serviceDirectoryStr, @NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        return this.findAndMergeProperties(this.getPossiblePropertiesFiles(serviceDirectoryStr, externalProjectPath2));
    }

    /*
     * WARNING - void declaration
     */
    private final GradleProperties findAndMergeProperties(List<? extends Path> possiblePropertiesFiles) {
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possiblePropertiesFiles), (Function1)findAndMergeProperties.1.INSTANCE), (Function1)((Function1)new Function1<Path, GradleProperties>((Object)this){

            @NotNull
            public final GradleProperties invoke(@NotNull Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GradlePropertiesFile.access$loadGradleProperties((GradlePropertiesFile)this.receiver, p0);
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p0 = (GradleProperties)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeGradleProperties(p0, (GradleProperties)p1);
        }
        return (GradleProperties)accumulator$iv;
    }

    private final List<Path> getPossiblePropertiesFiles(Project project, Path externalProjectPath2) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(project), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(externalProjectPath2)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final List<Path> getPossiblePropertiesFiles(String serviceDirectoryStr, Path externalProjectPath2) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(serviceDirectoryStr), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(externalProjectPath2)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final Path getGradleServiceDirectoryPath(Project project) {
        String string2 = GradleLocalSettings.getInstance(project).getGradleUserHome();
        if (string2 == null) {
            return null;
        }
        String gradleUserHome2 = string2;
        String[] stringArray = new String[]{this.getPropertiesFileName()};
        return Paths.get(gradleUserHome2, stringArray);
    }

    private final Path getGradleServiceDirectoryPath(String serviceDirectoryStr) {
        Path path;
        String string2 = serviceDirectoryStr;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String[] stringArray = new String[]{INSTANCE.getPropertiesFileName()};
            path = Paths.get(serviceDirectoryStr, stringArray);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final Path getGradleHomePropertiesPath() {
        String gradleUserHome2 = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome2 != null) {
            String[] stringArray = new String[]{this.getPropertiesFileName()};
            return Paths.get(gradleUserHome2, stringArray);
        }
        String userHome = Environment.Companion.getProperty("user.home");
        if (userHome != null) {
            String[] stringArray = new String[]{".gradle", this.getPropertiesFileName()};
            return Paths.get(userHome, stringArray);
        }
        return null;
    }

    private final Path getGradleProjectPropertiesPath(Path externalProjectPath2) {
        return externalProjectPath2.resolve(this.getPropertiesFileName());
    }

    private final GradleProperties loadGradleProperties(Path propertiesPath) {
        Property<String> property2;
        String logLevel;
        Property<String> property3;
        String javaHome;
        Properties properties = this.loadProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String string2 = javaHome = properties2.getProperty("org.gradle.java.home");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            property3 = new Property<String>(it, ((Object)propertiesPath).toString());
        } else {
            property3 = null;
        }
        Property<String> javaHomeProperty = property3;
        String string3 = logLevel = properties2.getProperty("org.gradle.logging.level");
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            property2 = new Property<String>(it, ((Object)propertiesPath).toString());
        } else {
            property2 = null;
        }
        Property<String> logLevelProperty = property2;
        return new GradlePropertiesImpl(javaHomeProperty, logLevelProperty);
    }

    private final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            Property<String> property2;
            Property<String> property3 = most.getJavaHomeProperty();
            if (property3 == null) {
                property3 = other.getJavaHomeProperty();
            }
            if ((property2 = most.getGradleLoggingLevel()) == null) {
                property2 = other.getGradleLoggingLevel();
            }
            gradleProperties = new GradlePropertiesImpl(property3, property2);
        }
        return gradleProperties;
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(GradlePropertiesFile $this, Path propertiesPath) {
        return $this.loadGradleProperties(propertiesPath);
    }
}

