/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleGroovyUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\b\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\u001a\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u0006\u0010\u0015\u001a\u00020\u000b\u001a(\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a\u001a\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u001fH\u0002\u001a!\u0010 \u001a\u00020\u00022\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\"\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010#\u001a\u001c\u0010$\u001a\u00020\u00022\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0001H\u0002\u001a\u0006\u0010&\u001a\u00020\u0002\u001a\u0006\u0010'\u001a\u00020\u0002\u001a\u001c\u0010(\u001a\u00020\u00022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010*\u001a\u00020\u0002H\u0002\u001a0\u0010(\u001a\u00020\u00022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010*\u001a\u00020\u00022\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020,H\u0002\u001a&\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u00022\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020,H\u0002\u001a\u0016\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002\u001a:\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00022\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\b\u00103\u001a\u0004\u0018\u00010\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"ASSERTION_FAILED_ERROR", "", "", "FILE_COMPARISON_FAILURE", "JUNIT_3_COMPARISON_FAILURE", "JUNIT_4_COMPARISON_FAILURE", "MAIN_INIT_SCRIPT_NAME", "MAPPER_INIT_SCRIPT_NAME", "TEST_INIT_SCRIPT_NAME", "WRAPPER_INIT_SCRIPT_NAME", "createInitScript", "Ljava/nio/file/Path;", "prefix", "content", "createMainInitScript", "isBuildSrcProject", "", "toolingExtensionClasses", "", "Ljava/lang/Class;", "createTargetPathMapperInitScript", "createTestInitScript", "createWrapperInitScript", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "jarFile", "Ljava/io/File;", "scriptFile", "fileWithPathToProperties", "isContentEquals", "path", "", "joinInitScripts", "initScripts", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadEnhanceGradleDaemonClasspathInit", "classesNames", "loadFileComparisonTestLoggerInitScript", "loadIjTestLoggerInitScript", "loadInitScript", "aClass", "resourcePath", "parameters", "", "loadJvmDebugInitScript", "debuggerId", "loadTaskInitScript", "projectPath", "taskName", "taskType", "taskConfiguration", "intellij.gradle.common"})
@JvmName(name="GradleInitScriptUtil")
public final class GradleInitScriptUtil {
    @NotNull
    public static final String MAIN_INIT_SCRIPT_NAME = "ijInit";
    @NotNull
    public static final String MAPPER_INIT_SCRIPT_NAME = "ijMapper";
    @NotNull
    public static final String WRAPPER_INIT_SCRIPT_NAME = "ijWrapper";
    @NotNull
    public static final String TEST_INIT_SCRIPT_NAME = "ijTestInit";
    @NotNull
    private static final List<String> JUNIT_3_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"junit.framework.ComparisonFailure");
    @NotNull
    private static final List<String> JUNIT_4_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"org.junit.ComparisonFailure");
    @NotNull
    private static final List<String> ASSERTION_FAILED_ERROR = CollectionsKt.listOf((Object)"org.opentest4j.AssertionFailedError");
    @NotNull
    private static final List<String> FILE_COMPARISON_FAILURE;

    @NotNull
    public static final Path createMainInitScript(boolean isBuildSrcProject, @NotNull Set<? extends Class<?>> toolingExtensionClasses) {
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        Set<String> set = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getToolingExtensionsJarP\u2026(toolingExtensionClasses)");
        Set<String> jarPaths = set;
        String[] stringArray = new String[3];
        stringArray[0] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/RegistryProcessor.gradle", null, 2, null);
        stringArray[1] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/JetGradlePlugin.gradle", null, 2, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"EXTENSIONS_JARS_PATH", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)jarPaths, createMainInitScript.initScript.1.INSTANCE)), TuplesKt.to((Object)"IS_BUILD_SCR_PROJECT", (Object)String.valueOf(isBuildSrcProject))};
        stringArray[2] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/Init.gradle", MapsKt.mapOf((Pair[])pairArray));
        String initScript2 = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(MAIN_INIT_SCRIPT_NAME, initScript2);
    }

    @NotNull
    public static final String loadTaskInitScript(@NotNull String projectPath, @NotNull String taskName, @NotNull String taskType, @NotNull Set<? extends Class<?>> toolingExtensionClasses, @Nullable String taskConfiguration) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        Set<String> set = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getToolingExtensionsJarP\u2026(toolingExtensionClasses)");
        Set<String> jarPaths = set;
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"EXTENSIONS_JARS_PATH", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)jarPaths, loadTaskInitScript.1.INSTANCE));
        pairArray[1] = TuplesKt.to((Object)"PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(projectPath));
        pairArray[2] = TuplesKt.to((Object)"TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName));
        pairArray[3] = TuplesKt.to((Object)"TASK_TYPE", (Object)taskType);
        String string2 = taskConfiguration;
        if (string2 == null) {
            string2 = "";
        }
        pairArray[4] = TuplesKt.to((Object)"TASK_CONFIGURATION", (Object)string2);
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/TaskInit.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final Path createTargetPathMapperInitScript() {
        String initScript2 = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/MapperInit.gradle", null, 2, null);
        return GradleInitScriptUtil.createInitScript(MAPPER_INIT_SCRIPT_NAME, initScript2);
    }

    @NotNull
    public static final Path createWrapperInitScript(@Nullable GradleVersion gradleVersion2, @NotNull File jarFile, @NotNull File scriptFile, @NotNull File fileWithPathToProperties) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)fileWithPathToProperties, (String)"fileWithPathToProperties");
        Pair[] pairArray = new Pair[4];
        Object object = gradleVersion2;
        if (object == null || (object = object.getVersion()) == null || (object = GradleGroovyUtil.toGroovyStringLiteral((String)object)) == null) {
            object = "null";
        }
        pairArray[0] = TuplesKt.to((Object)"GRADLE_VERSION", (Object)object);
        String string2 = jarFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jarFile.path");
        pairArray[1] = TuplesKt.to((Object)"JAR_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string2));
        String string3 = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scriptFile.path");
        pairArray[2] = TuplesKt.to((Object)"SCRIPT_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string3));
        String string4 = fileWithPathToProperties.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fileWithPathToProperties.path");
        pairArray[3] = TuplesKt.to((Object)"FILE_WITH_PATH_TO_PROPERTIES", (Object)GradleGroovyUtil.toGroovyStringLiteral(string4));
        String initScript2 = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/WrapperInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.createInitScript(WRAPPER_INIT_SCRIPT_NAME, initScript2);
    }

    @NotNull
    public static final Path createTestInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestInit.gradle", null, 2, null)};
        String initScript2 = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(TEST_INIT_SCRIPT_NAME, initScript2);
    }

    @NotNull
    public static final String loadJvmDebugInitScript(@NotNull String debuggerId, @NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)debuggerId, (String)"debuggerId");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String[] stringArray = new String[2];
        stringArray[0] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/GradleTasksUtil.gradle", null, 2, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUGGER_ID", (Object)GradleGroovyUtil.toGroovyStringLiteral(debuggerId)), TuplesKt.to((Object)"PROCESS_PARAMETERS", (Object)GradleGroovyUtil.toGroovyStringLiteral(parameters))};
        stringArray[1] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/JvmDebugInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadIjTestLoggerInitScript() {
        String[] stringArray = new String[4];
        stringArray[0] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null);
        stringArray[1] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLogger.gradle", null, 2, null);
        stringArray[2] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLoggerInit.gradle", null, 2, null);
        Object[] objectArray = new List[]{JUNIT_3_COMPARISON_FAILURE, JUNIT_4_COMPARISON_FAILURE, ASSERTION_FAILED_ERROR, FILE_COMPARISON_FAILURE};
        stringArray[3] = GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf((Object[])objectArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadFileComparisonTestLoggerInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLoggerInit.gradle", null, 2, null), GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf(FILE_COMPARISON_FAILURE))};
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit(List<? extends List<String>> classesNames) {
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/EnhanceGradleDaemonClasspathInit.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLASS_NAMES", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)classesNames, loadEnhanceGradleDaemonClasspathInit.1.INSTANCE))));
    }

    private static final String joinInitScripts(String ... initScripts) {
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
        return ArraysKt.joinToString$default((Object[])initScripts, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null);
    }

    private static final String loadInitScript(String resourcePath, Map<String, String> parameters) {
        return GradleInitScriptUtil.loadInitScript(Init.class, resourcePath, parameters);
    }

    static /* synthetic */ String loadInitScript$default(String string2, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return GradleInitScriptUtil.loadInitScript(string2, map);
    }

    private static final String loadInitScript(Class<?> aClass, String resourcePath, Map<String, String> parameters) {
        String script = GradleInitScriptUtil.loadInitScript(aClass, resourcePath);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String replacement = Matcher.quoteReplacement(value);
            CharSequence charSequence = script;
            Regex regex = new Regex(key);
            Intrinsics.checkNotNullExpressionValue((Object)replacement, (String)"replacement");
            String string2 = replacement;
            script = regex.replaceFirst(charSequence, string2);
        }
        return script;
    }

    private static final String loadInitScript(Class<?> aClass, String resourcePath) {
        URL resource = aClass.getResource(resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot find init file " + resourcePath);
        }
        try {
            URL uRL = resource;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return new String(byArray, charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read init file " + resourcePath, e);
        }
    }

    @NotNull
    public static final Path createInitScript(@NotNull String prefix, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        byte[] contentBytes = StringsKt.encodeToByteArray((String)content);
        Path tempDirectory = Path.of(FileUtil.getTempDirectory(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)tempDirectory, (String)"tempDirectory");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(tempDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        int suffix = 0;
        while (true) {
            String candidateName = prefix + ++suffix + ".gradle";
            Path candidate = tempDirectory.resolve(candidateName);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)candidate, (String)"candidate");
                FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(candidate, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(this, *attributes)");
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(candidate, contentBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
                candidate.toFile().deleteOnExit();
                return candidate;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                Intrinsics.checkNotNullExpressionValue((Object)candidate, (String)"candidate");
                if (!GradleInitScriptUtil.isContentEquals(candidate, contentBytes)) continue;
                return candidate;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isContentEquals(Path path, byte[] content) {
        if ((long)content.length != Files.size(path)) return false;
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        if (!Arrays.equals(content, byArray)) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"com.intellij.rt.execution.junit.FileComparisonFailure", "junit.framework.ComparisonFailure"};
        FILE_COMPARISON_FAILURE = CollectionsKt.listOf((Object[])objectArray);
    }
}

