/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.frameworkSupport.buildscript.GradleBuildScriptBuilderUtil;
import org.jetbrains.plugins.gradle.service.GradleFileModificationTracker;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.GradleTasksIndices;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskResultListener;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    public static final Key<Collection<VersionSpecificInitScript>> VERSION_SPECIFIC_SCRIPTS_KEY = Key.create((String)"VERSION_SPECIFIC_SCRIPTS_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(0);
        }
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(3);
        }
        List<String> tasks2 = taskNames.stream().flatMap(s -> ParametersListUtil.parse((String)s, (boolean)false, (boolean)true).stream()).collect(Collectors.toList());
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, tasks2, projectPath, settings2, jvmParametersSetup, listener2)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings2 == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings2;
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        this.myCancellationMap.put(id, cancellationTokenSource);
        try {
            if (effectiveSettings.getDistributionType() == DistributionType.WRAPPED) {
                String rootProjectPath = GradleUtil.determineRootProject(projectPath);
                CancellationToken cancellationToken = cancellationTokenSource.token();
                this.myHelper.ensureInstalledWrapper(id, rootProjectPath, effectiveSettings, listener2, cancellationToken);
            }
            this.myHelper.execute(projectPath, effectiveSettings, id, listener2, cancellationTokenSource, connection -> {
                this.executeTasks(id, tasks2, projectPath, effectiveSettings, jvmParametersSetup, listener2, (ProjectConnection)connection, cancellationTokenSource);
                return null;
            });
        }
        finally {
            this.myCancellationMap.remove(id);
        }
    }

    private void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> tasks2, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull CancellationTokenSource cancellationTokenSource) {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(4);
        }
        if (tasks2 == null) {
            GradleTaskManager.$$$reportNull$$$0(5);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(6);
        }
        if (settings2 == null) {
            GradleTaskManager.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            GradleTaskManager.$$$reportNull$$$0(9);
        }
        if (cancellationTokenSource == null) {
            GradleTaskManager.$$$reportNull$$$0(10);
        }
        BuildEnvironment buildEnvironment = null;
        try {
            buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, cancellationTokenSource, settings2);
            GradleVersion gradleVersion2 = GradleTaskManager.getGradleVersion(buildEnvironment);
            GradleTaskManager.setupGradleScriptDebugging(settings2);
            GradleTaskManager.setupDebuggerDispatchPort(settings2);
            GradleTaskManager.setupBuiltInTestEvents(settings2, gradleVersion2);
            GradleTaskManager.appendInitScriptArgument(tasks2, jvmParametersSetup, settings2, gradleVersion2);
            for (GradleBuildParticipant buildParticipant : settings2.getExecutionWorkspace().getBuildParticipants()) {
                settings2.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
            GradleTaskManager.prepareTaskState(id, settings2, listener2);
            if (Registry.is((String)"gradle.report.recently.saved.paths")) {
                ((GradleFileModificationTracker)ApplicationManager.getApplication().getService(GradleFileModificationTracker.class)).notifyConnectionAboutChangedPaths(connection);
            }
            if (GradleTaskManager.isApplicableTestLauncher(id, projectPath, tasks2, settings2, gradleVersion2)) {
                launcher = this.myHelper.getTestLauncher(connection, id, tasks2, settings2, listener2);
                launcher.withCancellationToken(cancellationTokenSource.token());
                launcher.run();
            } else {
                launcher = this.myHelper.getBuildLauncher(connection, id, tasks2, settings2, listener2);
                launcher.withCancellationToken(cancellationTokenSource.token());
                launcher.run();
            }
            GradleTaskResultListener.EP_NAME.forEachExtensionSafe(ext -> ext.onSuccess(id, projectPath));
        }
        catch (RuntimeException e) {
            LOG.debug("Gradle build launcher error", (Throwable)e);
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
            throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
        }
    }

    @Nullable
    private static GradleVersion getGradleVersion(@Nullable BuildEnvironment buildEnvironment) {
        return Optional.ofNullable(buildEnvironment).map(it -> it.getGradle()).map(it -> it.getGradleVersion()).map(it -> GradleInstallationManager.getGradleVersionSafe(it)).orElse(null);
    }

    private static boolean isApplicableTestLauncher(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion2) {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(11);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(12);
        }
        if (tasksAndArguments == null) {
            GradleTaskManager.$$$reportNull$$$0(13);
        }
        if (settings2 == null) {
            GradleTaskManager.$$$reportNull$$$0(14);
        }
        if (!Registry.is((String)"gradle.testLauncherAPI.enabled")) {
            LOG.debug("TestLauncher isn't applicable: disabled by registry");
            return false;
        }
        if (!settings2.isTestTaskRerun()) {
            LOG.debug("TestLauncher isn't applicable: RC doesn't expect task rerun");
            return false;
        }
        if (gradleVersion2 == null || GradleBuildScriptBuilderUtil.isGradleOlderThan(gradleVersion2, "8.2")) {
            LOG.debug("TestLauncher isn't applicable: unsupported Gradle version " + gradleVersion2);
            return false;
        }
        Project project = id.findProject();
        if (project == null) {
            LOG.debug("TestLauncher isn't applicable: Project is already closed");
            return false;
        }
        GradleCommandLine commandLine = GradleCommandLineUtil.parseCommandLine(tasksAndArguments, settings2.getArguments());
        if (!GradleTaskManager.hasJvmTestTasks(commandLine, project, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC hasn't JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonJvmTestTasks(commandLine, project, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC has non-JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonTestOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC tasks have non-test options");
            return false;
        }
        if (GradleTaskManager.hasUnrecognizedOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC has unrecognized options");
            return false;
        }
        LOG.debug("TestLauncher is applicable");
        return true;
    }

    private static boolean hasJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(16);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(17);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project);
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task2.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(18);
        }
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(19);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(20);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project);
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task2.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isTest() && !it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonTestOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(21);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            if (!ContainerUtil.exists((Iterable)task2.getOptions(), it -> !GradleCommandLineUtil.isTestPattern(it))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnrecognizedOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(22);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            if (!task2.getName().startsWith("-")) continue;
            return true;
        }
        return false;
    }

    private static void prepareTaskState(@NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        TargetEnvironmentConfigurationProvider provider2;
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(23);
        }
        if (settings2 == null) {
            GradleTaskManager.$$$reportNull$$$0(24);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(25);
        }
        if ((provider2 = ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings2)) != null) {
            return;
        }
        RunConfigurationTaskState taskState = (RunConfigurationTaskState)settings2.getUserData(RunConfigurationTaskState.getKEY());
        if (taskState == null) {
            return;
        }
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetProgressIndicator progressIndicator = TargetProgressIndicator.EMPTY;
        try {
            taskState.prepareTargetEnvironmentRequest((TargetEnvironmentRequest)request, progressIndicator);
            LocalTargetEnvironment environment = request.prepareEnvironment(progressIndicator);
            String taskStateInitScript = taskState.handleCreatedTargetEnvironment((TargetEnvironment)environment, progressIndicator);
            if (taskStateInitScript != null) {
                GradleTaskManager.writeAndAppendScript(settings2, taskStateInitScript, "ijtgttaskstate");
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        listener2.onEnvironmentPrepared(id);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(26);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(27);
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings) {
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(28);
        }
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(29);
        }
        GradleTaskManager.appendInitScriptArgument(taskNames, jvmParametersSetup, effectiveSettings, null);
    }

    private static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings, @Nullable GradleVersion gradleVersion2) {
        String initScript2;
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(30);
        }
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(31);
        }
        ArrayList initScripts = new ArrayList();
        List<GradleProjectResolverExtension> extensions = GradleProjectResolverUtil.createProjectResolvers(null).toList();
        for (GradleProjectResolverExtension resolverExtension : extensions) {
            String debugDispatchAddr;
            String resolverClassName = resolverExtension.getClass().getName();
            HashMap<String, String> enhancementParameters = new HashMap<String, String>();
            enhancementParameters.put("JVM_PARAMETERS_SETUP", jvmParametersSetup);
            boolean isRunAsTest = effectiveSettings.isRunAsTest();
            enhancementParameters.put("IS_RUN_AS_TEST", String.valueOf(isRunAsTest));
            boolean isBuiltInTestEventsUsed = effectiveSettings.isBuiltInTestEventsUsed();
            enhancementParameters.put("IS_BUILT_IN_TEST_EVENTS_USED", String.valueOf(isBuiltInTestEventsUsed));
            Integer debugDispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
            if (debugDispatchPort != null) {
                enhancementParameters.put("DEBUG_DISPATCH_PORT", String.valueOf(debugDispatchPort));
                String debugOptions = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_PARAMETERS_KEY);
                enhancementParameters.put("DEBUG_OPTIONS", debugOptions);
            }
            if ((debugDispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
                enhancementParameters.put("DEBUG_DISPATCH_ADDR", debugDispatchAddr);
            }
            if (gradleVersion2 != null) {
                enhancementParameters.put("GRADLE_VERSION", gradleVersion2.getVersion());
            }
            resolverExtension.enhanceTaskProcessing(taskNames, (Consumer<String>)((Consumer)script -> {
                if (StringUtil.isNotEmpty((String)script)) {
                    ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                }
            }), enhancementParameters);
        }
        if (!initScripts.isEmpty()) {
            GradleTaskManager.writeAndAppendScript(effectiveSettings, StringUtil.join(initScripts, (String)System.lineSeparator()), "ijresolvers");
        }
        if (StringUtil.isNotEmpty((String)(initScript2 = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY)))) {
            GradleTaskManager.writeAndAppendScript(effectiveSettings, initScript2, StringUtil.notNullize((String)((String)effectiveSettings.getUserData(INIT_SCRIPT_PREFIX_KEY)), (String)"ijmiscinit"));
        }
        Collection scripts = (Collection)effectiveSettings.getUserData(VERSION_SPECIFIC_SCRIPTS_KEY);
        if (gradleVersion2 != null && scripts != null && !scripts.isEmpty()) {
            scripts.stream().filter(script -> script.isApplicableTo(gradleVersion2)).filter(script -> StringUtil.isNotEmpty((String)script.getScript())).forEach(script -> GradleTaskManager.writeAndAppendScript(effectiveSettings, script.getScript(), StringUtil.notNullize((String)script.getFilePrefix(), (String)"ijverspecinit")));
        }
        if (effectiveSettings.getArguments().contains("--init-script")) {
            GradleExecutionHelper.attachTargetPathMapperInitScript(effectiveSettings);
        }
    }

    private static void writeAndAppendScript(@NotNull GradleExecutionSettings effectiveSettings, @NotNull String initScript2, @NotNull String initScriptPrefix) {
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(32);
        }
        if (initScript2 == null) {
            GradleTaskManager.$$$reportNull$$$0(33);
        }
        if (initScriptPrefix == null) {
            GradleTaskManager.$$$reportNull$$$0(34);
        }
        String initScriptPrefixName = FileUtil.sanitizeFileName((String)initScriptPrefix);
        Path initScriptPath = GradleInitScriptUtil.createInitScript(initScriptPrefixName, initScript2);
        effectiveSettings.withArguments(new String[]{"--init-script", initScriptPath.toString()});
    }

    public static void setupGradleScriptDebugging(@NotNull GradleExecutionSettings effectiveSettings) {
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(35);
        }
        Integer gradleScriptDebugPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        if (effectiveSettings.isDebugServerProcess() && gradleScriptDebugPort != null && gradleScriptDebugPort > 0) {
            boolean isJdk9orLater;
            String dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY);
            String debugAddress = dispatchAddr != null ? dispatchAddr + ":" + gradleScriptDebugPort : ((isJdk9orLater = ExternalSystemJdkUtil.isJdk9orLater((String)effectiveSettings.getJavaHome())) ? "127.0.0.1:" : "") + gradleScriptDebugPort;
            String jvmOpt = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugAddress;
            effectiveSettings.withVmOption(jvmOpt);
        }
        if (effectiveSettings.isDebugAllEnabled()) {
            effectiveSettings.withVmOption("-Didea.gradle.debug.all=true");
        }
    }

    public static void setupDebuggerDispatchPort(@NotNull GradleExecutionSettings effectiveSettings) {
        String dispatchAddr;
        Integer dispatchPort;
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(36);
        }
        if ((dispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY)) != null) {
            effectiveSettings.withVmOption(String.format("-D%s=%d", "idea.debugger.dispatch.port", dispatchPort));
        }
        if ((dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
            effectiveSettings.withVmOption(String.format("-D%s=%s", "idea.debugger.dispatch.addr", dispatchAddr));
        }
    }

    private static void setupBuiltInTestEvents(@NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion2) {
        if (settings2 == null) {
            GradleTaskManager.$$$reportNull$$$0(37);
        }
        if (gradleVersion2 != null && !GradleBuildScriptBuilderUtil.isGradleOlderThan(gradleVersion2, "7.6")) {
            settings2.setBuiltInTestEventsUsed(true);
        }
    }

    public static void runCustomTaskScript(@NotNull Project project, @NotNull @Nls String executionName, @NotNull String projectPath, @NotNull String gradlePath2, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull String initScript2, @NotNull String taskName) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(38);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(39);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(40);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(41);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(42);
        }
        if (initScript2 == null) {
            GradleTaskManager.$$$reportNull$$$0(43);
        }
        if (taskName == null) {
            GradleTaskManager.$$$reportNull$$$0(44);
        }
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript2);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExecutionName(executionName);
        settings2.setExternalProjectPath(projectPath);
        Object taskPrefix = gradlePath2.endsWith(":") ? gradlePath2 : gradlePath2 + ":";
        settings2.setTaskNames(Collections.singletonList((String)taskPrefix + taskName));
        settings2.setVmOptions(gradleVmOptions);
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }

    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull Set<Class<?>> toolingExtensionClasses) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(45);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(46);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(47);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(48);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(49);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(50);
        }
        if (toolingExtensionClasses == null) {
            GradleTaskManager.$$$reportNull$$$0(51);
        }
        String taskName = taskClass.getSimpleName();
        String taskType = taskClass.getName();
        HashSet tools = new HashSet(toolingExtensionClasses);
        tools.add(taskClass);
        tools.add(GsonBuilder.class);
        tools.add(ExternalSystemException.class);
        String initScript2 = GradleInitScriptUtil.loadTaskInitScript(gradlePath2, taskName, taskType, tools, taskConfiguration);
        GradleTaskManager.runCustomTaskScript(project, executionName, projectPath, gradlePath2, progressExecutionMode, callback, initScript2, taskName);
    }

    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(52);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(53);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(54);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(55);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(56);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(57);
        }
        GradleTaskManager.runCustomTask(project, executionName, taskClass, projectPath, gradlePath2, taskConfiguration, progressExecutionMode, callback, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 17: 
            case 20: 
            case 40: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 8: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 7: 
            case 14: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationTokenSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksAndArguments";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: 
            case 19: 
            case 38: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSettings";
                break;
            }
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScript";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptPrefix";
                break;
            }
            case 39: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionName";
                break;
            }
            case 41: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 42: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/GradleTaskManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTasks";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTestLauncher";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "hasJvmTestTasks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonJvmTestTasks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonTestOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUnrecognizedOptions";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTaskState";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInitScriptArgument";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAndAppendScript";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "setupGradleScriptDebugging";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDebuggerDispatchPort";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBuiltInTestEvents";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTaskScript";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

