/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J!\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001f0$\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!J\u0015\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b'J\u001a\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u0016H\u0007R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0016\u0010\u0012\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "", "dataNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)V", "directoryToRunTask", "", "getDirectoryToRunTask", "()Ljava/lang/String;", "fullGradlePath", "getFullGradlePath$annotations", "()V", "getFullGradlePath", "gradleIdentityPath", "getGradleIdentityPath", "gradlePath", "getGradlePath", "gradleProjectDir", "Lorg/jetbrains/annotations/NotNull;", "getGradleProjectDir", "isBuildSrcModule", "", "()Z", "isIncludedBuild", "moduleData", "getModuleData", "()Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "moduleName", "getModuleName", "find", "T", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "(Lcom/intellij/openapi/externalSystem/model/Key;)Ljava/lang/Object;", "findAll", "", "getTaskPath", "simpleTaskName", "getTaskPathOfSimpleTaskName", "prependCompositeBuildPath", "intellij.gradle.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleModuleData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleModuleData.kt\norg/jetbrains/plugins/gradle/util/GradleModuleData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n1#2:118\n1603#3,9:108\n1855#3:117\n1856#3:119\n1612#3:120\n*S KotlinDebug\n*F\n+ 1 GradleModuleData.kt\norg/jetbrains/plugins/gradle/util/GradleModuleData\n*L\n63#1:118\n63#1:108,9\n63#1:117\n63#1:119\n63#1:120\n*E\n"})
public final class GradleModuleData {
    @NotNull
    private final DataNode<? extends ModuleData> dataNode;
    @NotNull
    private final ModuleData moduleData;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String gradleProjectDir;

    public GradleModuleData(@NotNull DataNode<? extends ModuleData> dataNode) {
        Intrinsics.checkNotNullParameter(dataNode, (String)"dataNode");
        this.dataNode = dataNode;
        this.moduleData = (ModuleData)this.dataNode.getData();
        ProjectSystemId projectSystemId = this.moduleData.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"moduleData.owner");
        ProjectSystemId systemId = projectSystemId;
        if (!Intrinsics.areEqual((Object)systemId, (Object)GradleConstants.SYSTEM_ID)) {
            boolean bl = false;
            String string2 = "Gradle module expected but '" + systemId + "' module has been got.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = this.moduleData.getModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"moduleData.moduleName");
        this.moduleName = string3;
        String string4 = this.moduleData.getLinkedExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"moduleData.linkedExternalProjectPath");
        this.gradleProjectDir = string4;
    }

    @NotNull
    public final ModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getGradleProjectDir() {
        return this.gradleProjectDir;
    }

    @NotNull
    public final String getDirectoryToRunTask() {
        return GradleModuleDataKt.getDirectoryToRunTask(this.moduleData);
    }

    @NotNull
    public final String getGradlePath() {
        return GradleModuleDataKt.getGradlePath(this.moduleData);
    }

    @NotNull
    public final String getGradleIdentityPath() {
        return GradleModuleDataKt.getGradleIdentityPath(this.moduleData);
    }

    @NotNull
    public final String getFullGradlePath() {
        return this.getGradleIdentityPath();
    }

    @Deprecated(message="Use gradleIdentityPath instead")
    public static /* synthetic */ void getFullGradlePath$annotations() {
    }

    public final boolean isBuildSrcModule() {
        return GradleModuleDataKt.isBuildSrcModule(this.moduleData);
    }

    public final boolean isIncludedBuild() {
        return GradleModuleDataKt.isIncludedBuild(this.moduleData);
    }

    @Deprecated(message="Use 'getTaskPath(String) instead")
    @NotNull
    public final String getTaskPath(@NotNull String simpleTaskName, boolean prependCompositeBuildPath) {
        Intrinsics.checkNotNullParameter((Object)simpleTaskName, (String)"simpleTaskName");
        return this.getTaskPathOfSimpleTaskName(simpleTaskName);
    }

    public static /* synthetic */ String getTaskPath$default(GradleModuleData gradleModuleData, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleModuleData.getTaskPath(string2, bl);
    }

    @JvmName(name="getTaskPathOfSimpleTaskName")
    @NotNull
    public final String getTaskPathOfSimpleTaskName(@NotNull String simpleTaskName) {
        Intrinsics.checkNotNullParameter((Object)simpleTaskName, (String)"simpleTaskName");
        String identityPath = GradleModuleDataKt.getGradleIdentityPath(this.moduleData);
        return ((CharSequence)identityPath).length() == 0 || Intrinsics.areEqual((Object)identityPath, (Object)":") ? ":" + simpleTaskName : identityPath + ":" + simpleTaskName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Collection<T> findAll(@NotNull Key<T> key) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Collection collection = ExternalSystemApiUtil.findAll(this.dataNode, key);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(dataNode, key)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            if (it.getData() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T> T find(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        DataNode dataNode = ExternalSystemApiUtil.find(this.dataNode, key);
        return (T)(dataNode != null ? dataNode.getData() : null);
    }
}

