/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.cmd.node;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineParser;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineTokenizer;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineNode;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOptions;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTasks;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineNode;", "tasks", "", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTask;", "options", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption;", "(Ljava/util/List;Ljava/util/List;)V", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;", "(Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;)V", "getOptions", "()Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;", "getTasks", "()Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;", "text", "", "getText", "()Ljava/lang/String;", "tokens", "getTokens", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleCommandLine
implements GradleCommandLineNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCommandLineTasks tasks;
    @NotNull
    private final GradleCommandLineOptions options;
    @NotNull
    private final List<String> tokens;
    @NotNull
    private final String text;

    public GradleCommandLine(@NotNull GradleCommandLineTasks tasks2, @NotNull GradleCommandLineOptions options) {
        Intrinsics.checkNotNullParameter((Object)tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.tasks = tasks2;
        this.options = options;
        this.tokens = CollectionsKt.plus((Collection)this.tasks.getTokens(), (Iterable)this.options.getTokens());
        this.text = CollectionsKt.joinToString$default((Iterable)this.getTokens(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final GradleCommandLineTasks getTasks() {
        return this.tasks;
    }

    @NotNull
    public final GradleCommandLineOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<String> getTokens() {
        return this.tokens;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    public GradleCommandLine(@NotNull List<GradleCommandLineTask> tasks2, @NotNull List<? extends GradleCommandLineOption> options) {
        Intrinsics.checkNotNullParameter(tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this(new GradleCommandLineTasks(tasks2), new GradleCommandLineOptions(options));
    }

    @NotNull
    public final GradleCommandLineTasks component1() {
        return this.tasks;
    }

    @NotNull
    public final GradleCommandLineOptions component2() {
        return this.options;
    }

    @NotNull
    public final GradleCommandLine copy(@NotNull GradleCommandLineTasks tasks2, @NotNull GradleCommandLineOptions options) {
        Intrinsics.checkNotNullParameter((Object)tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new GradleCommandLine(tasks2, options);
    }

    public static /* synthetic */ GradleCommandLine copy$default(GradleCommandLine gradleCommandLine, GradleCommandLineTasks gradleCommandLineTasks, GradleCommandLineOptions gradleCommandLineOptions, int n, Object object) {
        if ((n & 1) != 0) {
            gradleCommandLineTasks = gradleCommandLine.tasks;
        }
        if ((n & 2) != 0) {
            gradleCommandLineOptions = gradleCommandLine.options;
        }
        return gradleCommandLine.copy(gradleCommandLineTasks, gradleCommandLineOptions);
    }

    @NotNull
    public String toString() {
        return "GradleCommandLine(tasks=" + this.tasks + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.tasks.hashCode();
        result = result * 31 + this.options.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GradleCommandLine)) {
            return false;
        }
        GradleCommandLine gradleCommandLine = (GradleCommandLine)other;
        if (!Intrinsics.areEqual((Object)this.tasks, (Object)gradleCommandLine.tasks)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.options, (Object)gradleCommandLine.options);
    }

    @JvmStatic
    @NotNull
    public static final GradleCommandLine parse(@NotNull String commandLine) {
        return Companion.parse(commandLine);
    }

    @JvmStatic
    @NotNull
    public static final GradleCommandLine parse(@NotNull List<String> commandLine) {
        return Companion.parse(commandLine);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine$Companion;", "", "()V", "parse", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "commandLine", "", "", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleCommandLine parse(@NotNull String commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            return new GradleCommandLineParser(new GradleCommandLineTokenizer(commandLine)).parse();
        }

        @JvmStatic
        @NotNull
        public final GradleCommandLine parse(@NotNull List<String> commandLine) {
            Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
            return new GradleCommandLineParser(new GradleCommandLineTokenizer(commandLine)).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

