/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.importing.MavenCompilerConfiguration;
import org.jetbrains.idea.maven.importing.MavenCompilerConfigurator;
import org.jetbrains.idea.maven.importing.MavenCompilerExtension;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0002>?B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u001c\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u001dH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010#\u001a\u00020\"H\u0016J(\u0010$\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016JZ\u0010)\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\b\u00104\u001a\u00020\"H\u0016J(\u00105\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u0004\u0018\u00010\u00132\f\u0010;\u001a\b\u0012\u0004\u0012\u0002000<H\u0002J\"\u0010=\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "afterModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "applyCompilerExtensionConfiguration", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "module", "Lcom/intellij/openapi/module/Module;", "ideCompilerConfiguration", "Lcom/intellij/compiler/CompilerConfigurationImpl;", "defaultCompilerExtension", "Lorg/jetbrains/idea/maven/importing/MavenCompilerExtension;", "beforeModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "configureModules", "project", "Lcom/intellij/openapi/project/Project;", "mavenProjectWithModule", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "configureTargetLevel", "Lcom/intellij/compiler/CompilerConfiguration;", "excludeArchetypeResources", "getCompilerConfigurationWhenApplicable", "Lorg/jdom/Element;", "isApplicable", "", "isMigratedToConfigurator", "preProcess", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "process", "rootModel", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "mavenModel", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "", "postTasks", "", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "processChangedModulesOnly", "resolve", "nativeMavenProject", "Lorg/jetbrains/idea/maven/server/NativeMavenProjectHolder;", "embedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "selectDefaultCompilerExtension", "allCompilers", "", "setDefaultProjectCompiler", "Companion", "MavenProjectWithModulesData", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenCompilerConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1126#2:361\n1295#2:362\n1296#2:365\n1127#2:366\n1295#2:367\n1296#2:370\n1#3:363\n1#3:364\n1855#4,2:368\n*S KotlinDebug\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n*L\n69#1:361\n69#1:362\n69#1:365\n69#1:366\n184#1:367\n184#1:370\n69#1:364\n185#1:368,2\n*E\n"})
public final class MavenCompilerConfigurator
extends MavenImporter
implements MavenWorkspaceConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOG;
    @NotNull
    private static final Key<Set<String>> ALL_PROJECTS_COMPILERS;
    @NotNull
    private static final Key<MavenCompilerExtension> DEFAULT_COMPILER_EXTENSION;
    @NotNull
    private static final Key<Boolean> DEFAULT_COMPILER_IS_SET;
    @NotNull
    private static final String JAVAC_ID = "javac";
    @NotNull
    private static final String MAVEN_COMPILER_PARAMETERS = "maven.compiler.parameters";
    @NotNull
    private static final String propStartTag = "${";
    @NotNull
    private static final String propEndTag = "}";

    public MavenCompilerConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
        Logger logger = Logger.getInstance(MavenCompilerConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MavenCompilerConfigurator::class.java)");
        this.LOG = logger;
    }

    @Override
    public boolean isApplicable(@Nullable MavenProject mavenProject2) {
        return true;
    }

    @Override
    public boolean processChangedModulesOnly() {
        return false;
    }

    @Override
    public void resolve(@NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)nativeMavenProject, (String)"nativeMavenProject");
            Intrinsics.checkNotNullParameter((Object)embedder, (String)"embedder");
            if (!super.isApplicable(mavenProject2)) {
                return;
            }
            if (!Registry.is((String)"maven.import.compiler.arguments", (boolean)true) || !MavenProjectsManager.getInstance(project2).getImportingSettings().isAutoDetectCompiler()) {
                return;
            }
            for (Object object2 : MavenCompilerExtension.EP_NAME.getExtensions()) {
                MavenCompilerExtension it = (MavenCompilerExtension)object2;
                boolean bl = false;
                if (!it.resolveDefaultCompiler(project2, mavenProject2, nativeMavenProject, embedder)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)object;
        if (project2.getUserData(DEFAULT_COMPILER_EXTENSION) == null) {
            project2.putUserData(DEFAULT_COMPILER_EXTENSION, (Object)defaultCompilerExtension);
        }
    }

    @Override
    public boolean isMigratedToConfigurator() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getProject().getUserData(DEFAULT_COMPILER_EXTENSION);
        context2.putUserData(DEFAULT_COMPILER_EXTENSION, null);
        if (defaultCompilerExtension == null) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Sequence sequence = context2.getMavenProjectsWithModules();
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                MavenWorkspaceConfigurator.MavenProjectWithModules it = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv;
                boolean bl2 = false;
                if (this.getCompilerConfigurationWhenApplicable(context2.getProject(), it.getMavenProject()) != null) {
                    Element config;
                    boolean bl3 = false;
                    string = MavenCompilerConfigurator.Companion.getCompilerId(config);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv = string;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            Set allCompilers = (Set)destination$iv;
            defaultCompilerExtension = this.selectDefaultCompilerExtension(allCompilers);
        }
        context2.putUserData(DEFAULT_COMPILER_EXTENSION, defaultCompilerExtension);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getUserData(DEFAULT_COMPILER_EXTENSION);
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)context2.getProject());
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl ideCompilerConfiguration = (CompilerConfigurationImpl)compilerConfiguration;
        this.setDefaultProjectCompiler(context2.getProject(), ideCompilerConfiguration, defaultCompilerExtension);
        Sequence data2 = SequencesKt.map(context2.getMavenProjectsWithModules(), (Function1)afterModelApplied.data.1.INSTANCE);
        this.configureModules(context2.getProject(), (Sequence<MavenProjectWithModulesData>)data2, ideCompilerConfiguration, defaultCompilerExtension);
        MavenProjectImporterBase.Companion.removeOutdatedCompilerConfigSettings(context2.getProject());
    }

    @Override
    public void preProcess(@NotNull Module module2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)module2.getProject().getUserData(DEFAULT_COMPILER_EXTENSION);
        if (defaultCompilerExtension != null) {
            modifiableModelsProvider.putUserData(DEFAULT_COMPILER_EXTENSION, (Object)defaultCompilerExtension);
            module2.getProject().putUserData(DEFAULT_COMPILER_EXTENSION, null);
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Element element = this.getCompilerConfigurationWhenApplicable(project2, mavenProject2);
        if (element == null) {
            return;
        }
        Element config = element;
        Set compilers = (Set)modifiableModelsProvider.getUserData(ALL_PROJECTS_COMPILERS);
        if (compilers == null) {
            compilers = new LinkedHashSet();
            modifiableModelsProvider.putUserData(ALL_PROJECTS_COMPILERS, (Object)compilers);
        }
        compilers.add(MavenCompilerConfigurator.Companion.getCompilerId(config));
    }

    private final Element getCompilerConfigurationWhenApplicable(Project project2, MavenProject mavenProject2) {
        if (!Registry.is((String)"maven.import.compiler.arguments", (boolean)true) || !MavenProjectsManager.getInstance(project2).getImportingSettings().isAutoDetectCompiler()) {
            return null;
        }
        if (!super.isApplicable(mavenProject2)) {
            return null;
        }
        return this.getConfig(mavenProject2);
    }

    public void process(@NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module2, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenProjectsProcessorTask> postTasks) {
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)modifiableModelsProvider.getUserData(DEFAULT_COMPILER_EXTENSION);
        if (defaultCompilerExtension == null) {
            Set set = (Set)modifiableModelsProvider.getUserData(ALL_PROJECTS_COMPILERS);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            defaultCompilerExtension = this.selectDefaultCompilerExtension(set);
            modifiableModelsProvider.putUserData(DEFAULT_COMPILER_EXTENSION, (Object)defaultCompilerExtension);
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project3);
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl ideCompilerConfiguration = (CompilerConfigurationImpl)compilerConfiguration;
        if (modifiableModelsProvider.getUserData(DEFAULT_COMPILER_IS_SET) == null) {
            this.setDefaultProjectCompiler(project3, ideCompilerConfiguration, defaultCompilerExtension);
            modifiableModelsProvider.putUserData(DEFAULT_COMPILER_IS_SET, (Object)true);
        }
        Project project4 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"module.project");
        Object[] objectArray = new MavenProjectWithModulesData[]{new MavenProjectWithModulesData(mavenProject2, CollectionsKt.listOf((Object)module2))};
        this.configureModules(project4, (Sequence<MavenProjectWithModulesData>)SequencesKt.sequenceOf((Object[])objectArray), ideCompilerConfiguration, defaultCompilerExtension);
    }

    private final MavenCompilerExtension selectDefaultCompilerExtension(Set<String> allCompilers) {
        Object object;
        block2: {
            String string = (String)CollectionsKt.singleOrNull((Iterable)allCompilers);
            if (string == null) {
                string = JAVAC_ID;
            }
            String defaultCompilerId = string;
            for (Object object2 : MavenCompilerExtension.EP_NAME.getExtensions()) {
                MavenCompilerExtension it = (MavenCompilerExtension)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)defaultCompilerId, (Object)it.getMavenCompilerId())) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (MavenCompilerExtension)object;
    }

    private final void setDefaultProjectCompiler(Project project2, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        if (mavenCompilerExtension == null || (mavenCompilerExtension = mavenCompilerExtension.getCompiler(project2)) == null) {
            return;
        }
        MavenCompilerExtension backendCompiler = mavenCompilerExtension;
        boolean autoDetectCompiler = MavenProjectsManager.getInstance(project2).getImportingSettings().isAutoDetectCompiler();
        Object[] objectArray = new Object[]{autoDetectCompiler};
        MavenLog.LOG.debug("maven compiler autodetect = ", objectArray);
        if (!Intrinsics.areEqual((Object)ideCompilerConfiguration.getDefaultCompiler(), (Object)backendCompiler) && autoDetectCompiler) {
            if (ideCompilerConfiguration.getRegisteredJavaCompilers().contains(backendCompiler)) {
                ideCompilerConfiguration.setDefaultCompiler((BackendCompiler)backendCompiler);
            } else {
                this.LOG.error((BackendCompiler)backendCompiler + " is not registered.");
            }
        }
    }

    private final void configureModules(Project project2, Sequence<MavenProjectWithModulesData> mavenProjectWithModule, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        Sequence<MavenProjectWithModulesData> $this$forEach$iv = mavenProjectWithModule;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)element$iv;
            boolean bl = false;
            MavenProject mavenProject2 = mavenProjectWithModulesData.component1();
            List<Module> modules = mavenProjectWithModulesData.component2();
            Iterable $this$forEach$iv2 = modules;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Module module2 = (Module)element$iv2;
                boolean bl2 = false;
                this.applyCompilerExtensionConfiguration(mavenProject2, module2, ideCompilerConfiguration, defaultCompilerExtension);
                this.configureTargetLevel(mavenProject2, module2, (CompilerConfiguration)ideCompilerConfiguration, defaultCompilerExtension);
            }
            this.excludeArchetypeResources(project2, mavenProject2, (CompilerConfiguration)ideCompilerConfiguration);
        }
    }

    private final void applyCompilerExtensionConfiguration(MavenProject mavenProject2, Module module2, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        String string;
        Object object = mavenProject2.getProperties().get(MAVEN_COMPILER_PARAMETERS);
        MavenCompilerConfiguration mavenConfiguration = new MavenCompilerConfiguration(object != null ? object.toString() : null, this.getConfig(mavenProject2));
        if (!Intrinsics.areEqual((Object)mavenProject2.getPackaging(), (Object)"pom")) {
            Element element = mavenConfiguration.getPluginConfiguration();
            if (element != null) {
                Element it = element;
                boolean bl = false;
                string = MavenCompilerConfigurator.Companion.getCompilerId(it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String projectCompilerId = string;
        for (MavenCompilerExtension compilerExtension : (MavenCompilerExtension[])MavenCompilerExtension.EP_NAME.getExtensions()) {
            JpsJavaCompilerOptions it;
            CompilerOptions compilerOptions;
            boolean applyThisExtension = Intrinsics.areEqual((Object)projectCompilerId, (Object)compilerExtension.getMavenCompilerId()) || projectCompilerId == null && Intrinsics.areEqual((Object)compilerExtension, (Object)defaultCompilerExtension);
            BackendCompiler backendCompiler = compilerExtension.getCompiler(module2.getProject());
            Object object2 = compilerOptions = backendCompiler != null ? backendCompiler.getOptions() : null;
            if (applyThisExtension && !mavenConfiguration.isEmpty()) {
                compilerExtension.configureOptions(compilerOptions, module2, mavenProject2, MavenCompilerConfigurator.Companion.collectCompilerArgs(mavenConfiguration));
                continue;
            }
            if ((compilerOptions instanceof JpsJavaCompilerOptions ? (JpsJavaCompilerOptions)compilerOptions : null) == null) continue;
            it = it;
            boolean bl = false;
            ideCompilerConfiguration.setAdditionalOptions(it, module2, CollectionsKt.emptyList());
        }
    }

    private final void configureTargetLevel(MavenProject mavenProject2, Module module2, CompilerConfiguration ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        String targetLevel;
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        String string = targetLevel = mavenCompilerExtension != null ? mavenCompilerExtension.getDefaultCompilerTargetLevel(mavenProject2, module2) : null;
        if (targetLevel == null) {
            LanguageLevel level = null;
            if (MavenImportUtil.isTestModule(module2.getName())) {
                level = MavenImportUtil.getTargetTestLanguageLevel(mavenProject2);
                if (level == null) {
                    level = MavenImportUtil.getTargetLanguageLevel(mavenProject2);
                }
            } else {
                level = MavenImportUtil.getTargetLanguageLevel(mavenProject2);
            }
            if (level == null) {
                level = MavenImportUtil.getDefaultLevel(mavenProject2);
            }
            level = MavenImportUtil.adjustLevelAndNotify(module2.getProject(), level);
            targetLevel = level.toJavaVersion().toString();
        }
        ideCompilerConfiguration.setBytecodeTargetLevel(module2, targetLevel);
    }

    private final void excludeArchetypeResources(Project project2, MavenProject mavenProject2, CompilerConfiguration ideCompilerConfiguration) {
        Object object;
        Object object2 = this;
        try {
            MavenCompilerConfigurator $this$excludeArchetypeResources_u24lambda_u248 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"src", "main", "resources", "archetype-resources"};
            object = Result.constructor-impl((Object)VfsUtil.findRelativeFile((VirtualFile)mavenProject2.getDirectoryFile(), (String[])stringArray));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        VirtualFile dir2 = (VirtualFile)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (dir2 != null && !ideCompilerConfiguration.isExcludedFromCompilation(dir2)) {
            ExcludesConfiguration cfg = ideCompilerConfiguration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir2, true, false, (Disposable)MavenDisposable.getInstance(project2)));
        }
    }

    static {
        Key key = Key.create((String)"maven.compilers");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<MutableSet<String>>(\"maven.compilers\")");
        ALL_PROJECTS_COMPILERS = key;
        Key key2 = Key.create((String)"default.compiler");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create<MavenCompilerExtension>(\"default.compiler\")");
        DEFAULT_COMPILER_EXTENSION = key2;
        Key key3 = Key.create((String)"default.compiler.updated");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create<Boolean>(\"default.compiler.updated\")");
        DEFAULT_COMPILER_IS_SET = key3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f0\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$Companion;", "", "()V", "ALL_PROJECTS_COMPILERS", "Lcom/intellij/openapi/util/Key;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "DEFAULT_COMPILER_EXTENSION", "Lorg/jetbrains/idea/maven/importing/MavenCompilerExtension;", "DEFAULT_COMPILER_IS_SET", "", "JAVAC_ID", "MAVEN_COMPILER_PARAMETERS", "propEndTag", "propStartTag", "collectCompilerArgs", "", "mavenCompilerConfiguration", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfiguration;", "findClosingBraceOrNextUnresolvedProperty", "", "index", "s", "getCompilerId", "config", "Lorg/jdom/Element;", "getResolvedText", "txt", "it", "hasUnresolvedProperty", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenCompilerConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1549#2:361\n1620#2,2:362\n1622#2:365\n1#3:364\n*S KotlinDebug\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$Companion\n*L\n321#1:361\n321#1:362,2\n321#1:365\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCompilerId(Element config) {
            String compilerId;
            block3: {
                block2: {
                    compilerId = config.getChildTextTrim("compilerId");
                    CharSequence charSequence = compilerId;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)MavenCompilerConfigurator.JAVAC_ID, (Object)compilerId)) break block2;
                    Intrinsics.checkNotNullExpressionValue((Object)compilerId, (String)"compilerId");
                    if (!this.hasUnresolvedProperty(compilerId)) break block3;
                }
                return MavenCompilerConfigurator.JAVAC_ID;
            }
            return compilerId;
        }

        private final boolean hasUnresolvedProperty(String txt) {
            int i2 = StringsKt.indexOf$default((CharSequence)txt, (String)MavenCompilerConfigurator.propStartTag, (int)0, (boolean)false, (int)6, null);
            return i2 >= 0 && this.findClosingBraceOrNextUnresolvedProperty(i2 + 1, txt) != -1;
        }

        private final int findClosingBraceOrNextUnresolvedProperty(int index, String s) {
            if (index == -1) {
                return -1;
            }
            Object[] objectArray = new String[]{MavenCompilerConfigurator.propEndTag, MavenCompilerConfigurator.propStartTag};
            Pair pair = StringsKt.findAnyOf$default((CharSequence)s, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)index, (boolean)false, (int)4, null);
            if (pair == null) {
                return -1;
            }
            Pair pair2 = pair;
            if (Intrinsics.areEqual((Object)pair2.getSecond(), (Object)MavenCompilerConfigurator.propEndTag)) {
                return ((Number)pair2.getFirst()).intValue();
            }
            int nextIndex = Intrinsics.areEqual((Object)pair2.getSecond(), (Object)MavenCompilerConfigurator.propStartTag) ? ((Number)pair2.getFirst()).intValue() + 2 : ((Number)pair2.getFirst()).intValue() + 1;
            return this.findClosingBraceOrNextUnresolvedProperty(nextIndex, s);
        }

        private final String getResolvedText(String txt) {
            String string = StringKt.nullize$default((String)txt, (boolean)false, (int)1, null);
            if (string == null) {
                return null;
            }
            String result2 = string;
            if (this.hasUnresolvedProperty(result2)) {
                return null;
            }
            return result2;
        }

        private final String getResolvedText(Element it) {
            return this.getResolvedText(it.getTextTrim());
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> collectCompilerArgs(MavenCompilerConfiguration mavenCompilerConfiguration) {
            Element pluginConfiguration;
            List options = new ArrayList();
            Element element = pluginConfiguration = mavenCompilerConfiguration.getPluginConfiguration();
            Object parameters = element != null ? element.getChild("parameters") : null;
            Object object = parameters;
            boolean bl = object != null && (object = object.getTextTrim()) != null ? Boolean.parseBoolean((String)object) : false;
            if (bl) {
                ((Collection)options).add("-parameters");
            } else if (parameters == null) {
                String string = mavenCompilerConfiguration.getPropertyCompilerParameters();
                boolean bl2 = string != null ? Boolean.parseBoolean(string) : false;
                if (bl2) {
                    ((Collection)options).add("-parameters");
                }
            }
            if (pluginConfiguration == null) {
                return options;
            }
            Element compilerArguments = pluginConfiguration.getChild("compilerArguments");
            if (compilerArguments != null) {
                void $this$mapTo$iv$iv;
                Set unresolvedArgs = new LinkedHashSet();
                List list = compilerArguments.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compilerArguments.children");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Element element2 = (Element)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String $this$collectCompilerArgs_u24lambda_u241_u24lambda_u240 = it.getName();
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$collectCompilerArgs_u24lambda_u241_u24lambda_u240, (String)"collectCompilerArgs$lambda$1$lambda$0");
                    Object key = StringsKt.startsWith$default((String)$this$collectCompilerArgs_u24lambda_u241_u24lambda_u240, (String)"-", (boolean)false, (int)2, null) ? $this$collectCompilerArgs_u24lambda_u241_u24lambda_u240 : "-" + $this$collectCompilerArgs_u24lambda_u241_u24lambda_u240;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    String value = Companion.getResolvedText((Element)it);
                    if (value == null) {
                        String string = it.getTextTrim();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.textTrim");
                        if (Companion.hasUnresolvedProperty(string)) {
                            ((Collection)unresolvedArgs).add(key);
                        }
                    }
                    collection.add(TuplesKt.to((Object)key, (Object)value));
                }
                Map effectiveArguments = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                effectiveArguments.forEach((arg_0, arg_1) -> Companion.collectCompilerArgs$lambda$2((Function2)new Function2<String, String, Unit>((List<String>)options, (Set<String>)unresolvedArgs){
                    final /* synthetic */ List<String> $options;
                    final /* synthetic */ Set<String> $unresolvedArgs;
                    {
                        this.$options = $options;
                        this.$unresolvedArgs = $unresolvedArgs;
                        super(2);
                    }

                    public final void invoke(String key, @Nullable String value) {
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        if (StringsKt.startsWith$default((String)key, (String)"-A", (boolean)false, (int)2, null) && value != null) {
                            this.$options.add(key + "=" + value);
                        } else if (!this.$unresolvedArgs.contains(key)) {
                            this.$options.add(key);
                            ContainerUtil.addIfNotNull((Collection)this.$options, (Object)value);
                        }
                    }
                }, arg_0, arg_1));
            }
            ContainerUtil.addIfNotNull((Collection)options, (Object)this.getResolvedText(pluginConfiguration.getChildTextTrim("compilerArgument")));
            Element compilerArgs = pluginConfiguration.getChild("compilerArgs");
            if (compilerArgs != null) {
                for (Element arg : compilerArgs.getChildren("arg")) {
                    Collection collection = options;
                    Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                    ContainerUtil.addIfNotNull((Collection)collection, (Object)this.getResolvedText(arg));
                }
                for (Element compilerArg : compilerArgs.getChildren("compilerArg")) {
                    Collection collection = options;
                    Intrinsics.checkNotNullExpressionValue((Object)compilerArg, (String)"compilerArg");
                    ContainerUtil.addIfNotNull((Collection)collection, (Object)this.getResolvedText(compilerArg));
                }
            }
            return options;
        }

        private static final void collectCompilerArgs$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "modules", "", "Lcom/intellij/openapi/module/Module;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/List;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.maven"})
    private static final class MavenProjectWithModulesData {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final List<Module> modules;

        public MavenProjectWithModulesData(@NotNull MavenProject mavenProject2, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            this.mavenProject = mavenProject2;
            this.modules = modules;
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> getModules() {
            return this.modules;
        }

        @NotNull
        public final MavenProject component1() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> component2() {
            return this.modules;
        }

        @NotNull
        public final MavenProjectWithModulesData copy(@NotNull MavenProject mavenProject2, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            return new MavenProjectWithModulesData(mavenProject2, modules);
        }

        public static /* synthetic */ MavenProjectWithModulesData copy$default(MavenProjectWithModulesData mavenProjectWithModulesData, MavenProject mavenProject2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                mavenProject2 = mavenProjectWithModulesData.mavenProject;
            }
            if ((n & 2) != 0) {
                list = mavenProjectWithModulesData.modules;
            }
            return mavenProjectWithModulesData.copy(mavenProject2, list);
        }

        @NotNull
        public String toString() {
            return "MavenProjectWithModulesData(mavenProject=" + this.mavenProject + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            int result2 = this.mavenProject.hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MavenProjectWithModulesData)) {
                return false;
            }
            MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)other;
            if (!Intrinsics.areEqual((Object)this.mavenProject, (Object)mavenProjectWithModulesData.mavenProject)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, mavenProjectWithModulesData.modules);
        }
    }
}

