/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;

public final class MavenModuleNameMapper {
    public static void map(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        MavenModuleNameMapper.resolveModuleNames(projects, mavenProjectToModule, mavenProjectToModuleName);
        MavenModuleNameMapper.resolveModulePaths(projects, mavenProjectToModule, mavenProjectToModuleName, mavenProjectToModulePath, dedicatedModuleDir);
    }

    public static String resolveModuleName(MavenProject project2) {
        return new NameItem(project2, null).getResultName();
    }

    private static void resolveModuleNames(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName) {
        Object[] names = new NameItem[projects.size()];
        int i2 = 0;
        for (MavenProject each : projects) {
            names[i2++] = new NameItem(each, mavenProjectToModule.get(each));
        }
        Arrays.sort(names);
        HashMap<String, Integer> nameCountersLowerCase = new HashMap<String, Integer>();
        for (i2 = 0; i2 < names.length; ++i2) {
            if (((NameItem)names[i2]).hasDuplicatedGroup) continue;
            for (int k = i2 + 1; k < names.length; ++k) {
                if (!((NameItem)names[i2]).originalName.equalsIgnoreCase(((NameItem)names[k]).originalName)) continue;
                nameCountersLowerCase.put(((NameItem)names[i2]).originalName.toLowerCase(Locale.ROOT), 0);
                if (!((NameItem)names[i2]).groupId.equals(((NameItem)names[k]).groupId)) continue;
                ((NameItem)names[i2]).hasDuplicatedGroup = true;
                ((NameItem)names[k]).hasDuplicatedGroup = true;
            }
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Object name : names) {
            if (((NameItem)name).module == null) continue;
            boolean bl = existingNames.add(((NameItem)name).getResultName());
        }
        for (Object nameItem : names) {
            String name;
            if (((NameItem)nameItem).module != null) continue;
            Integer c = (Integer)nameCountersLowerCase.get(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT));
            if (c != null) {
                ((NameItem)nameItem).number = c;
                nameCountersLowerCase.put(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT), c + 1);
            }
            while (!existingNames.add(name = ((NameItem)nameItem).getResultName())) {
                ++((NameItem)nameItem).number;
                nameCountersLowerCase.put(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT), ((NameItem)nameItem).number + 1);
            }
        }
        for (Object each : names) {
            mavenProjectToModuleName.put(((NameItem)each).project, ((NameItem)each).getResultName());
        }
    }

    private static boolean isValidName(String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (name.equals("Unknown")) {
            return false;
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private static void resolveModulePaths(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        for (MavenProject each : projects) {
            Module module2 = mavenProjectToModule.get(each);
            String path = MavenModuleNameMapper.getPath(mavenProjectToModuleName.get(each), each, dedicatedModuleDir, module2);
            mavenProjectToModulePath.put(each, path);
        }
    }

    @NotNull
    @NonNls
    public static String getPath(@NotNull String moduleName, @NotNull MavenProject each, @Nullable String dedicatedModuleDir, @Nullable Module module2) {
        if (moduleName == null) {
            MavenModuleNameMapper.$$$reportNull$$$0(0);
        }
        if (each == null) {
            MavenModuleNameMapper.$$$reportNull$$$0(1);
        }
        return module2 != null ? module2.getModuleFilePath() : MavenModuleNameMapper.generateModulePath(each, moduleName, dedicatedModuleDir);
    }

    @NotNull
    public static String generateModulePath(MavenProject project2, String moduleName, String dedicatedModuleDir) {
        String dir2 = StringUtil.isEmptyOrSpaces((String)dedicatedModuleDir) ? project2.getDirectory() : dedicatedModuleDir;
        String fileName = moduleName + ".iml";
        String string = new File(dir2, fileName).getPath();
        if (string == null) {
            MavenModuleNameMapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String generateModulePath(String directory, String moduleName, String dedicatedModuleDir) {
        String dir2 = StringUtil.isEmptyOrSpaces((String)dedicatedModuleDir) ? directory : dedicatedModuleDir;
        String fileName = moduleName + ".iml";
        String string = new File(dir2, fileName).getPath();
        if (string == null) {
            MavenModuleNameMapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModuleNameMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModuleNameMapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class NameItem
    implements Comparable<NameItem> {
        public final MavenProject project;
        public final Module module;
        public final String originalName;
        public final String groupId;
        public int number = -1;
        public boolean hasDuplicatedGroup;

        private NameItem(MavenProject project2, @Nullable Module module2) {
            this.project = project2;
            this.module = module2;
            this.originalName = this.calcOriginalName();
            String group = project2.getMavenId().getGroupId();
            this.groupId = MavenModuleNameMapper.isValidName(group) ? group : "";
        }

        private String calcOriginalName() {
            if (this.module != null) {
                return this.module.getName();
            }
            String name = this.project.getMavenId().getArtifactId();
            if (!MavenModuleNameMapper.isValidName(name)) {
                name = this.project.getDirectoryFile().getName();
            }
            return name;
        }

        public String getResultName() {
            if (this.module != null) {
                return this.module.getName();
            }
            if (this.number == -1) {
                return this.originalName;
            }
            String result2 = this.originalName + " (" + (this.number + 1) + ")";
            if (!this.hasDuplicatedGroup && this.groupId.length() != 0) {
                result2 = result2 + " (" + this.groupId + ")";
            }
            return result2;
        }

        @Override
        public int compareTo(NameItem o) {
            return this.project.getPath().compareToIgnoreCase(o.project.getPath());
        }
    }
}

