/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.CacheForCompilerErrorMessages;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenAsyncProjectsManager;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenModificationTracker;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerUtilKt;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.project.importing.MavenProjectManagerListenerToBusBridge;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslCache;

@State(name="MavenProjectsManager")
public abstract class MavenProjectsManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponentJavaAdapter,
Disposable,
MavenAsyncProjectsManager {
    private static final int IMPORT_DELAY = 1000;
    private final ReentrantLock initLock;
    private final AtomicBoolean isInitialized;
    private MavenProjectsManagerState myState;
    private final Alarm myInitializationAlarm;
    private final MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectsManagerWatcher myWatcher;
    protected MavenMergingUpdateQueue myImportingQueue;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher;
    private final List<Listener> myManagerListeners;
    private final ModificationTracker myModificationTracker;
    protected BuildProgressListener myProgressListener;
    private MavenWorkspaceSettings myWorkspaceSettings;
    private final AtomicReference<MavenSyncConsole> mySyncConsole;
    private final MavenMergingUpdateQueue mySaveQueue;
    private static final int SAVE_DELAY = 1000;
    protected Module myPreviewModule;
    private transient boolean forceUpdateSnapshots;

    public static MavenProjectsManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(0);
        }
        return (MavenProjectsManager)project2.getService(MavenProjectsManager.class);
    }

    @Nullable
    public static MavenProjectsManager getInstanceIfCreated(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(1);
        }
        return (MavenProjectsManager)project2.getServiceIfCreated(MavenProjectsManager.class);
    }

    public MavenProjectsManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(2);
        }
        super(project2);
        this.initLock = new ReentrantLock();
        this.isInitialized = new AtomicBoolean();
        this.myState = new MavenProjectsManagerState();
        this.myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
        this.myManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mySyncConsole = new AtomicReference();
        this.forceUpdateSnapshots = false;
        this.myEmbeddersManager = new MavenEmbeddersManager(project2);
        this.myModificationTracker = new MavenModificationTracker(this);
        this.myInitializationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySaveQueue = new MavenMergingUpdateQueue("Maven save queue", 1000, !MavenUtil.isMavenUnitTestModeEnabled(), this);
        this.myProgressListener = (BuildProgressListener)this.myProject.getService(SyncViewManager.class);
        MavenRehighlighter.install(project2, this);
        Disposer.register((Disposable)this, this::projectClosed);
        CacheForCompilerErrorMessages.connectToJdkListener(project2, this);
    }

    @TestOnly
    public void setProgressListener(BuildProgressListener testViewManager) {
        this.myProgressListener = testViewManager;
    }

    @TestOnly
    public BuildProgressListener getProgressListener() {
        return this.myProgressListener;
    }

    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        return this.myState;
    }

    public void loadState(@NotNull MavenProjectsManagerState state2) {
        if (state2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(3);
        }
        this.myState = state2;
        if (this.isInitialized()) {
            MavenProjectsManager.applyStateToTree(this.myProjectsTree, this);
            this.scheduleUpdateAllProjects(new MavenImportSpec(false, false, false));
        }
    }

    public void dispose() {
        this.mySyncConsole.set(null);
        this.myManagerListeners.clear();
    }

    public static void setupCreatedMavenProject(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(4);
        }
        MavenProjectsManager.setupCreatedMavenProject(MavenProjectsManager.getInstance(project2).getImportingSettings());
    }

    public static void setupCreatedMavenProject(@NotNull MavenImportingSettings settings) {
        if (settings == null) {
            MavenProjectsManager.$$$reportNull$$$0(5);
        }
        settings.setWorkspaceImportEnabled(true);
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public MavenGeneralSettings getGeneralSettings() {
        MavenGeneralSettings generalSettings = this.getWorkspaceSettings().getGeneralSettings();
        generalSettings.setProject(this.myProject);
        return generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().getImportingSettings();
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        }
        return this.myWorkspaceSettings;
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    @ApiStatus.Internal
    public int getFilterConfigCrc(@NotNull ProjectFileIndex projectFileIndex) {
        if (projectFileIndex == null) {
            MavenProjectsManager.$$$reportNull$$$0(6);
        }
        return this.myProjectsTree.getFilterConfigCrc(projectFileIndex);
    }

    public void initializeComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        ProjectUtilKt.executeOnPooledThread((Project)this.myProject, () -> {
            boolean wasMavenized;
            boolean bl = wasMavenized = !this.myState.originalFiles.isEmpty();
            if (!wasMavenized) {
                return;
            }
            this.doInit(false);
            if (!MavenUtil.isLinearImportEnabled()) {
                this.myWatcher.scheduleUpdateAll(new MavenImportSpec(false, false, false));
            }
        });
    }

    @TestOnly
    public void initForTests() {
        this.doInit(false);
        if (!MavenUtil.isLinearImportEnabled()) {
            this.myWatcher.scheduleUpdateAll(new MavenImportSpec(false, false, false));
        }
    }

    private void doInit(boolean isNew) {
        this.initLock.lock();
        try {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initManagerListenerToBusBridge();
            this.initBusToManagerListenerBridge();
            this.initPreloadMavenServices();
            this.initProjectsTree(!isNew);
            this.initWorkers();
            this.listenForSettingsChanges();
            this.listenForProjectsTreeChanges();
            this.registerSyncConsoleListener();
            this.updateTabTitles();
            MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    MavenIndicesManager.getInstance(this.myProject).scheduleUpdateIndicesList(null);
                    this.fireActivated();
                    this.listenForExternalChanges();
                }
            }));
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void initBusToManagerListenerBridge() {
        if (!MavenUtil.isLinearImportEnabled()) {
            return;
        }
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(MavenImportingManager.LEGACY_PROJECT_MANAGER_LISTENER, (Object)new Listener(){

            @Override
            public void activated() {
                MavenProjectsManager.this.fireActivated();
            }

            @Override
            public void importAndResolveScheduled() {
                for (Listener each : MavenProjectsManager.this.myManagerListeners) {
                    each.importAndResolveScheduled();
                }
            }

            @Override
            public void projectImportCompleted() {
                MavenProjectsManager.this.fireProjectImportCompleted();
            }
        });
    }

    private void initManagerListenerToBusBridge() {
        if (MavenUtil.isLinearImportEnabled()) {
            return;
        }
        this.addManagerListener(new MavenProjectManagerListenerToBusBridge(this.myProject), this);
    }

    private void initPreloadMavenServices() {
        MavenProjectsNavigator.getInstance(this.myProject);
        MavenTasksManager.getInstance(this.myProject);
        MavenShortcutsManager.getInstance(this.myProject);
    }

    private void updateTabTitles() {
        Application app = ApplicationManager.getApplication();
        if (MavenUtil.isMavenUnitTestModeEnabled() || app.isHeadlessEnvironment()) {
            return;
        }
        this.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                if (updated == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (deleted == null) {
                    2.$$$reportNull$$$0(1);
                }
                MavenProjectsManager.updateTabName(MavenUtil.collectFirsts(updated), MavenProjectsManager.this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "updated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "deleted";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$2";
                objectArray[2] = "projectsUpdated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void updateTabName(@NotNull List<MavenProject> projects, @NotNull Project project2) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(8);
        }
        MavenUtil.invokeLater(project2, () -> {
            for (MavenProject each : projects) {
                FileEditorManagerEx.getInstanceEx((Project)project2).updateFilePresentation(each.getFile());
            }
        });
    }

    public MavenSyncConsole getSyncConsole() {
        if (null == this.mySyncConsole.get()) {
            this.mySyncConsole.compareAndSet(null, new MavenSyncConsole(this.myProject));
        }
        return this.mySyncConsole.get();
    }

    @NotNull
    private MavenProjectsTree initProjectsTree(boolean tryToLoadExisting) {
        if (tryToLoadExisting) {
            Path file = this.getProjectsTreeFile();
            try {
                if (Files.exists(file, new LinkOption[0])) {
                    this.myProjectsTree = MavenProjectsTree.read(this.myProject, file);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        if (this.myProjectsTree == null) {
            this.myProjectsTree = new MavenProjectsTree(this.myProject);
        }
        MavenProjectsManager.applyStateToTree(this.myProjectsTree, this);
        this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster(), this);
        MavenProjectsTree mavenProjectsTree = this.myProjectsTree;
        if (mavenProjectsTree == null) {
            MavenProjectsManager.$$$reportNull$$$0(9);
        }
        return mavenProjectsTree;
    }

    private void applyTreeToState() {
        this.myState.originalFiles = this.myProjectsTree.getManagedFilesPaths();
        this.myState.ignoredFiles = new HashSet<String>(this.myProjectsTree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = this.myProjectsTree.getIgnoredFilesPatterns();
    }

    public static void applyStateToTree(MavenProjectsTree tree, MavenProjectsManager manager) {
        MavenWorkspaceSettings settings = manager.getWorkspaceSettings();
        MavenExplicitProfiles explicitProfiles = new MavenExplicitProfiles(settings.enabledProfiles, settings.disabledProfiles);
        tree.resetManagedFilesPathsAndProfiles(manager.myState.originalFiles, explicitProfiles);
        tree.setIgnoredFilesPaths(new ArrayList<String>(manager.myState.ignoredFiles));
        tree.setIgnoredFilesPatterns(manager.myState.ignoredPathMasks);
    }

    public void doSave() {
        if (this.myProjectsTree == null) {
            return;
        }
        this.mySaveQueue.queue(new Update(this){

            public void run() {
                try {
                    MavenProjectsManager.this.myProjectsTree.save(MavenProjectsManager.this.getProjectsTreeFile());
                }
                catch (IOException e) {
                    MavenLog.LOG.info((Throwable)e);
                }
            }
        });
    }

    @ApiStatus.Internal
    public Path getProjectsTreeFile() {
        return MavenProjectsManager.getProjectsTreesDir().resolve(this.myProject.getLocationHash()).resolve("tree.dat");
    }

    @NotNull
    @ApiStatus.Internal
    public static Path getProjectsTreesDir() {
        Path path = MavenUtil.getPluginSystemDir("Projects");
        if (path == null) {
            MavenProjectsManager.$$$reportNull$$$0(10);
        }
        return path;
    }

    private void initWorkers() {
        this.myWatcher = new MavenProjectsManagerWatcher(this.myProject, this.myProjectsTree, this.getGeneralSettings());
        this.myImportingQueue = new MavenMergingUpdateQueue(this.getClass().getName() + ": Importing queue", 1000, !MavenUtil.isMavenUnitTestModeEnabled(), this);
        this.myImportingQueue.makeUserAware(this.myProject);
        this.myImportingQueue.makeModalAware(this.myProject);
    }

    protected abstract void listenForSettingsChanges();

    private void registerSyncConsoleListener() {
        if (MavenUtil.isLinearImportEnabled()) {
            return;
        }
        this.myProjectsTreeDispatcher.addListener((EventListener)new MavenProjectsTree.Listener(){

            @Override
            public void pluginsResolved(@NotNull MavenProject project2) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                MavenProjectsManager.this.getSyncConsole().getListener(MavenServerConsoleIndicator.ResolveType.PLUGIN).finish();
            }

            @Override
            public void artifactsDownloaded(@NotNull MavenProject project2) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                MavenProjectsManager.this.getSyncConsole().getListener(MavenServerConsoleIndicator.ResolveType.DEPENDENCY).finish();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginsResolved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactsDownloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void listenForProjectsTreeChanges() {
        if (MavenUtil.isLinearImportEnabled()) {
            return;
        }
        this.myProjectsTreeDispatcher.addListener((EventListener)new MavenProjectsTree.Listener(){

            @Override
            public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
                if (ignored == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (unignored == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!fromImport) {
                    MavenProjectsManager.this.scheduleImportChangedProjects();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ignored";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "unignored";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$5";
                objectArray[2] = "projectsIgnoredStateChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    @TestOnly
    public void enableAutoImportInTests() {
        assert (this.isInitialized());
        this.listenForExternalChanges();
        this.myWatcher.enableAutoImportInTests();
    }

    private void projectClosed() {
        this.initLock.lock();
        try {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            if (this.myImportingQueue != null) {
                Disposer.dispose((Disposable)this.myImportingQueue);
            }
            this.myWatcher.stop();
            this.mySaveQueue.flush();
            if (MavenUtil.isMavenUnitTestModeEnabled()) {
                PathKt.delete((Path)MavenProjectsManager.getProjectsTreesDir());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    public MavenEmbeddersManager getEmbeddersManager() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return !this.initLock.isLocked() && this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    public boolean isMavenizedModule(@NotNull Module m) {
        if (m == null) {
            MavenProjectsManager.$$$reportNull$$$0(11);
        }
        return MavenUtil.isMavenizedModule(m);
    }

    @TestOnly
    public void resetManagedFilesAndProfilesInTests(List<VirtualFile> files2, MavenExplicitProfiles profiles2) {
        this.myWatcher.resetManagedFilesAndProfilesInTests(files2, profiles2);
    }

    public void addManagedFilesWithProfiles(List<VirtualFile> files2, MavenExplicitProfiles profiles2, Module previewModuleToDelete) {
        this.doAddManagedFilesWithProfiles(files2, profiles2, previewModuleToDelete);
        this.myWatcher.scheduleUpdateAll(new MavenImportSpec(false, true, false));
    }

    protected void doAddManagedFilesWithProfiles(List<VirtualFile> files2, MavenExplicitProfiles profiles2, Module previewModuleToDelete) {
        this.myPreviewModule = previewModuleToDelete;
        if (!this.isInitialized()) {
            this.myState.originalFiles = MavenUtil.collectPaths(files2);
            MavenWorkspaceSettings workspaceSettings = this.getWorkspaceSettings();
            workspaceSettings.setEnabledProfiles(profiles2.getEnabledProfiles());
            workspaceSettings.setDisabledProfiles(profiles2.getDisabledProfiles());
            this.doInit(true);
        } else {
            this.myProjectsTree.addManagedFilesWithProfiles(files2, profiles2);
        }
    }

    public void addManagedFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(12);
        }
        this.addManagedFilesWithProfiles(files2, MavenExplicitProfiles.NONE, null);
    }

    public void addManagedFilesOrUnignore(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(13);
        }
        this.removeIgnoredFilesPaths(MavenUtil.collectPaths(files2));
        this.addManagedFiles(files2);
    }

    public void removeManagedFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(14);
        }
        this.myWatcher.removeManagedFiles(files2);
    }

    public boolean isManagedFile(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(15);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isManagedFile(f);
    }

    @NotNull
    public MavenExplicitProfiles getExplicitProfiles() {
        if (!this.isInitialized()) {
            MavenExplicitProfiles mavenExplicitProfiles = MavenExplicitProfiles.NONE;
            if (mavenExplicitProfiles == null) {
                MavenProjectsManager.$$$reportNull$$$0(16);
            }
            return mavenExplicitProfiles;
        }
        MavenExplicitProfiles mavenExplicitProfiles = this.myProjectsTree.getExplicitProfiles();
        if (mavenExplicitProfiles == null) {
            MavenProjectsManager.$$$reportNull$$$0(17);
        }
        return mavenExplicitProfiles;
    }

    public void setExplicitProfiles(@NotNull MavenExplicitProfiles profiles2) {
        if (profiles2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(18);
        }
        this.myWatcher.setExplicitProfiles(profiles2);
    }

    @NotNull
    public Collection<String> getAvailableProfiles() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(19);
            }
            return list;
        }
        Collection<String> collection = this.myProjectsTree.getAvailableProfiles();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        if (!this.isInitialized()) {
            List<Pair<String, MavenProfileKind>> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        Collection<Pair<String, MavenProfileKind>> collection = this.myProjectsTree.getProfilesWithStates();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(22);
        }
        return collection;
    }

    public boolean hasProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.hasProjects();
    }

    @NotNull
    public List<MavenProject> getProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getRootProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getRootProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getNonIgnoredProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getNonIgnoredProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getProjectsFiles() {
        if (!this.isInitialized()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(29);
            }
            return list;
        }
        List<VirtualFile> list = this.myProjectsTree.getProjectsFiles();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    public MavenProject findProject(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(31);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(f);
    }

    public MavenProject findSingleProjectInReactor(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(32);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findSingleProjectInReactor(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(33);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenProjectsManager.$$$reportNull$$$0(34);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(artifact);
    }

    @Nullable
    public MavenProject findProject(@NotNull Module module2) {
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(35);
        }
        MavenProject mavenProject2 = this.getMavenProject(module2);
        String moduleName = module2.getName();
        if (mavenProject2 == null && MavenImportUtil.isMainOrTestSubmodule(moduleName)) {
            Module parentModule = ModuleManager.getInstance((Project)this.myProject).findModuleByName(MavenImportUtil.getParentModuleName(moduleName));
            mavenProject2 = parentModule != null ? this.getMavenProject(parentModule) : null;
        }
        return mavenProject2;
    }

    private MavenProject getMavenProject(@NotNull Module module2) {
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(36);
        }
        return (MavenProject)CachedValuesManager.getManager((Project)module2.getProject()).getCachedValue((UserDataHolder)module2, () -> {
            VirtualFile f = this.findPomFile(module2, new MavenModelsProvider(){

                @Override
                public Module[] getModules() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public VirtualFile[] getContentRoots(Module module2) {
                    return ModuleRootManager.getInstance((Module)module2).getContentRoots();
                }
            });
            MavenProject result2 = f == null ? null : this.findProject(f);
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @RequiresReadLock
    @Nullable
    public Module findModule(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project2.getFile());
    }

    @NotNull
    public Collection<MavenProject> findInheritors(@Nullable MavenProject parent) {
        if (parent == null || !this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(38);
            }
            return list;
        }
        Collection<MavenProject> collection = this.myProjectsTree.findInheritors(parent);
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @Nullable
    public MavenProject findContainingProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectsManager.$$$reportNull$$$0(40);
        }
        if (!this.isInitialized()) {
            return null;
        }
        Module module2 = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module2 == null ? null : this.findProject(module2);
    }

    @Nullable
    private VirtualFile findPomFile(@NotNull Module module2, @NotNull MavenModelsProvider modelsProvider) {
        String pomFileUrl;
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(41);
        }
        if (modelsProvider == null) {
            MavenProjectsManager.$$$reportNull$$$0(42);
        }
        if ((pomFileUrl = MavenPomPathModuleService.getInstance(module2).getPomFileUrl()) != null) {
            return VirtualFileManager.getInstance().findFileByUrl(pomFileUrl);
        }
        for (VirtualFile root : modelsProvider.getContentRoots(module2)) {
            List<VirtualFile> pomFiles = MavenUtil.streamPomFiles(module2.getProject(), root).toList();
            if (pomFiles.isEmpty()) continue;
            if (pomFiles.size() == 1) {
                return pomFiles.get(0);
            }
            for (VirtualFile file : pomFiles) {
                if (module2.getName().equals(file.getNameWithoutExtension())) {
                    return file;
                }
                MavenProject mavenProject2 = this.findProject(file);
                if (mavenProject2 == null || !module2.getName().equals(mavenProject2.getMavenId().getArtifactId())) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public MavenProject findAggregator(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(43);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findAggregator(mavenProject2);
    }

    @Nullable
    public MavenProject findRootProject(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(44);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findRootProject(mavenProject2);
    }

    @NotNull
    public List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        if (aggregator == null) {
            MavenProjectsManager.$$$reportNull$$$0(45);
        }
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(46);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getModules(aggregator);
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public List<String> getIgnoredFilesPaths() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(48);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPaths();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(49);
        }
        return list;
    }

    public void setIgnoredFilesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            MavenProjectsManager.$$$reportNull$$$0(50);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPaths(paths);
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.removeIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(51);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.getIgnoredState(project2);
    }

    @ApiStatus.Internal
    public void setIgnoredStateForPoms(@NotNull List<String> pomPaths, boolean ignored) {
        if (pomPaths == null) {
            MavenProjectsManager.$$$reportNull$$$0(52);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredStateForPoms(pomPaths, ignored);
    }

    public void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(53);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredState(projects, ignored);
    }

    @NotNull
    public List<String> getIgnoredFilesPatterns() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(54);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPatterns();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(55);
        }
        return list;
    }

    public void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            MavenProjectsManager.$$$reportNull$$$0(56);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(57);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isIgnored(project2);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        HashSet<MavenRemoteRepository> result2 = new HashSet<MavenRemoteRepository>();
        for (MavenProject each : this.getProjects()) {
            result2.addAll(each.getRemoteRepositories());
        }
        return result2;
    }

    @TestOnly
    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    @ApiStatus.Internal
    public void setProjectsTree(@NotNull MavenProjectsTree newTree) {
        if (newTree == null) {
            MavenProjectsManager.$$$reportNull$$$0(58);
        }
        if (!this.isInitialized()) {
            this.doInit(true);
            if (!MavenUtil.isLinearImportEnabled()) {
                this.myWatcher.scheduleUpdateAll(new MavenImportSpec(false, true, false));
            }
        }
        newTree.addListenersFrom(this.myProjectsTree);
        this.myProjectsTree = newTree;
        this.myWatcher.setProjectsTree(newTree);
    }

    @ApiStatus.Internal
    public EventDispatcher<MavenProjectsTree.Listener> getTreeListenerEventDispatcher() {
        return this.myProjectsTreeDispatcher;
    }

    @ApiStatus.Internal
    @NotNull
    public MavenProjectsTree getProjectsTree() {
        if (this.myProjectsTree == null) {
            return this.initProjectsTree(true);
        }
        MavenProjectsTree mavenProjectsTree = this.myProjectsTree;
        if (mavenProjectsTree == null) {
            MavenProjectsManager.$$$reportNull$$$0(59);
        }
        return mavenProjectsTree;
    }

    private void scheduleUpdateAllProjects(MavenImportSpec spec) {
        this.doScheduleUpdateProjects(List.of(), spec);
    }

    @ApiStatus.Internal
    public void forceUpdateProjects() {
        this.doScheduleUpdateProjects(List.of(), MavenImportSpec.EXPLICIT_IMPORT);
    }

    public AsyncPromise<Void> forceUpdateProjects(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(60);
        }
        return (AsyncPromise)this.doScheduleUpdateProjects(projects, MavenImportSpec.EXPLICIT_IMPORT);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        this.forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenImportSpec.EXPLICIT_IMPORT);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenImportSpec spec) {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
        }
        if (MavenUtil.isLinearImportEnabled()) {
            MavenLog.LOG.warn("forceUpdateAllProjectsOrFindAllAvailablePomFiles: Linear Import is enabled");
            MavenImportingManager.getInstance(this.myProject).openProjectAndImport(new FilesList(this.myProjectsTree.getExistingManagedFiles()), this.getImportingSettings(), this.getGeneralSettings(), spec);
            return;
        }
        MavenLog.LOG.warn("forceUpdateAllProjectsOrFindAllAvailablePomFiles: Linear Import is disabled");
        this.doScheduleUpdateProjects(List.of(), spec);
    }

    private Promise<Void> doScheduleUpdateProjects(@NotNull Collection<MavenProject> projects, MavenImportSpec spec) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(61);
        }
        if (MavenUtil.isLinearImportEnabled()) {
            MavenLog.LOG.warn("doScheduleUpdateProjects: Linear Import is enabled");
            return MavenImportingManager.getInstance(this.myProject).openProjectAndImport(new FilesList(ContainerUtil.map(projects, MavenProject::getFile)), this.getImportingSettings(), this.getGeneralSettings(), spec).getFinishPromise().then(it -> null);
        }
        MavenLog.LOG.warn("doScheduleUpdateProjects: Linear Import is disabled");
        MavenDistributionsCache.getInstance(this.myProject).cleanCaches();
        MavenWslCache.getInstance().clearCache();
        AsyncPromise promise2 = new AsyncPromise();
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
            if (projects.isEmpty()) {
                this.myWatcher.scheduleUpdateAll(spec).processed((Promise)promise2);
            } else {
                this.myWatcher.scheduleUpdate(MavenUtil.collectFiles(projects), Collections.emptyList(), spec).processed((Promise)promise2);
            }
        }));
        return promise2;
    }

    @Deprecated
    public Promise<List<Module>> scheduleImportAndResolve() {
        AsyncPromise promise2 = new AsyncPromise();
        List modules = this.updateAllMavenProjectsSync(MavenImportSpec.EXPLICIT_IMPORT);
        promise2.setResult((Object)modules);
        return promise2;
    }

    public void showServerException(Throwable e) {
        this.getSyncConsole().addException(e, this.myProgressListener);
    }

    public void terminateImport(int exitCode) {
        this.getSyncConsole().terminated(exitCode);
    }

    @ApiStatus.Internal
    public Promise<?> waitForImportCompletion() {
        if (MavenUtil.isLinearImportEnabled()) {
            return MavenImportingManager.getInstance(this.myProject).getImportFinishPromise();
        }
        AsyncPromise promise2 = new AsyncPromise();
        promise2.setResult(null);
        return promise2;
    }

    public void scheduleFoldersResolveForAllProjects() {
        MavenProjectsManagerUtilKt.scheduleFoldersResolveForAllProjects(this.myProject);
    }

    private void scheduleImportChangedProjects() {
        this.runWhenFullyOpen(() -> this.myImportingQueue.queue(new Update(this){

            public void run() {
                MavenProjectsManager.this.importMavenProjectsSync();
                MavenProjectsManager.this.fireProjectImportCompleted();
            }
        }));
    }

    protected abstract void importMavenProjectsSync();

    @TestOnly
    public boolean hasScheduledImportsInTests() {
        MavenProjectsManager.checkNoLegacyImportInNewTests();
        if (!this.isInitialized()) {
            return false;
        }
        return !this.myImportingQueue.isEmpty();
    }

    @TestOnly
    public void performScheduledImportInTests() {
        if (!this.isInitialized()) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myImportingQueue.flush());
    }

    private static void checkNoLegacyImportInNewTests() {
        if (ApplicationManager.getApplication().isUnitTestMode() && MavenUtil.isLinearImportEnabled()) {
            throw new IllegalStateException("Do not call this API in tests");
        }
    }

    private void runWhenFullyOpen(Runnable runnable) {
        if (!this.isInitialized()) {
            return;
        }
        Ref wrapper = new Ref();
        wrapper.set(() -> {
            if (!StartupManagerEx.getInstanceEx((Project)this.myProject).postStartupActivityPassed()) {
                this.myInitializationAlarm.addRequest((Runnable)wrapper.get(), 1000);
                return;
            }
            runnable.run();
        });
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)wrapper.get());
    }

    public void waitForReadingCompletion() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
    }

    @Deprecated(forRemoval=true)
    public void waitForPostImportTasksCompletion() {
    }

    public void updateProjectTargetFolders() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenProjectImporter.tryUpdateTargetFolders(this.myProject);
            VirtualFileManager.getInstance().asyncRefresh();
        });
    }

    @Deprecated
    public List<Module> importProjects() {
        return this.updateAllMavenProjectsSync(MavenImportSpec.IMPLICIT_IMPORT);
    }

    @ApiStatus.Internal
    public Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        HashMap<VirtualFile, Module> result2 = new HashMap<VirtualFile, Module>();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = this.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result2.put(f, each);
        }
        return result2;
    }

    @ApiStatus.Internal
    public List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        MavenUtil.streamPomFiles(this.myProject, this.myProject.getBaseDir()).forEach(result2::add);
        return result2;
    }

    @Deprecated
    public void addManagerListener(Listener listener2) {
        this.myManagerListeners.add(listener2);
    }

    public void addManagerListener(Listener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(62);
        }
        this.myManagerListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myManagerListeners.remove(listener2));
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener2) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    public void addProjectsTreeListener(@NotNull MavenProjectsTree.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(63);
        }
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(64);
        }
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @TestOnly
    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    protected void fireImportAndResolveScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.importAndResolveScheduled();
        }
    }

    void fireProjectImportCompleted() {
        for (Listener each : this.myManagerListeners) {
            each.projectImportCompleted();
        }
    }

    public void setForceUpdateSnapshots(boolean forceUpdateSnapshots) {
        this.forceUpdateSnapshots = forceUpdateSnapshots;
    }

    public boolean getForceUpdateSnapshots() {
        return this.forceUpdateSnapshots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 38, 39, 46, 47, 48, 49, 54, 55, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 7: 
            case 53: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 54: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 35: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomPaths";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "initProjectsTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTreesDir";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitProfiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProfiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesWithStates";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProjects";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredProjects";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findInheritors";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPaths";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPatterns";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupCreatedMavenProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilterConfigCrc";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateTabName";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 54: 
            case 55: 
            case 59: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFilesOrUnignore";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeManagedFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isManagedFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setExplicitProfiles";
                break;
            }
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findSingleProjectInReactor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProject";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProject";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findPomFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findAggregator";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPaths";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredState";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredStateForPoms";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredState";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPatterns";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setProjectsTree";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProjects";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "doScheduleUpdateProjects";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addManagerListener";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addProjectsTreeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 38, 39, 46, 47, 48, 49, 54, 55, 59 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        default public void activated() {
        }

        default public void importAndResolveScheduled() {
        }

        default public void projectImportCompleted() {
        }
    }

    public static class ExternalWatcherContributor
    implements ExternalSystemProjectsWatcherImpl.Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project project2) {
            if (project2 == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(0);
            }
            ExternalWatcherContributor.runWhenFullyOpen(project2, manager -> manager.doScheduleUpdateProjects(List.of(), new MavenImportSpec(true, false, false)));
        }

        public void markDirty(@NotNull Module module2) {
            if (module2 == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(1);
            }
            ExternalWatcherContributor.runWhenFullyOpen(module2.getProject(), manager -> {
                MavenProject mavenProject2 = manager.findProject(module2);
                if (mavenProject2 != null) {
                    manager.doScheduleUpdateProjects(Collections.singletonList(mavenProject2), new MavenImportSpec(true, false, false));
                }
            });
        }

        private static void runWhenFullyOpen(@NotNull Project project2, @NotNull Consumer<MavenProjectsManager> consumer) {
            if (project2 == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(3);
            }
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
            manager.runWhenFullyOpen(() -> consumer.accept(manager));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$ExternalWatcherContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirtyAllExternalProjects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runWhenFullyOpen";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

