/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.structure.ArtifactNode;
import org.jetbrains.idea.maven.navigator.structure.MavenNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectNode;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ViewDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "Lorg/jetbrains/idea/maven/navigator/structure/MavenNode;", "()V", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedData", "getDependencyScope", "", "getModule", "Lcom/intellij/openapi/module/Module;", "getSelectedData", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "intellij.maven"})
public final class ViewDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction<MavenNode> {
    @NotNull
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        return projectSystemId;
    }

    @Nullable
    public MavenNode getSelectedData(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component data2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        SimpleTree simpleTree = data2 instanceof SimpleTree ? (SimpleTree)data2 : null;
        SimpleNode simpleNode = simpleTree != null ? simpleTree.getSelectedNode() : null;
        return simpleNode instanceof MavenNode ? (MavenNode)simpleNode : null;
    }

    @Nullable
    public Module getModule(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        MavenProjectNode mavenProjectNode = selectedData.findProjectNode();
        if (mavenProjectNode == null) {
            return null;
        }
        MavenProjectNode projectNode = mavenProjectNode;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project3);
        return mavenProjectsManager.findModule(projectNode.getMavenProject());
    }

    @Nullable
    public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        DependencyAnalyzerDependency.Data data2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        MavenNode mavenNode = selectedData;
        if (mavenNode instanceof ArtifactNode) {
            String string = ((ArtifactNode)((Object)selectedData)).getArtifact().getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.artifact.groupId");
            String string2 = ((ArtifactNode)((Object)selectedData)).getArtifact().getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selectedData.artifact.artifactId");
            String string3 = ((ArtifactNode)((Object)selectedData)).getArtifact().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"selectedData.artifact.version");
            data2 = (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
        } else if (mavenNode instanceof MavenProjectNode) {
            String string = ((MavenProjectNode)((Object)selectedData)).getMavenProject().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.mavenProject.displayName");
            data2 = (DependencyAnalyzerDependency.Data)new DAModule(string);
        } else {
            data2 = null;
        }
        return data2;
    }

    @Nullable
    public String getDependencyScope(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        if (selectedData instanceof ArtifactNode) {
            return ((ArtifactNode)((Object)selectedData)).getArtifact().getScope();
        }
        return null;
    }
}

