/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.importing;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.statistics.ProjectImportCollector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.importing.MavenImportStats;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.ImportPaths;
import org.jetbrains.idea.maven.project.importing.MavenImportContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFinishedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFlow;
import org.jetbrains.idea.maven.project.importing.MavenImportFlowKt;
import org.jetbrains.idea.maven.project.importing.MavenImportedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.project.importing.MavenImportingResult;
import org.jetbrains.idea.maven.project.importing.MavenInitialImportContext;
import org.jetbrains.idea.maven.project.importing.MavenPluginResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenReadContext;
import org.jetbrains.idea.maven.project.importing.MavenResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenStartedImport;
import org.jetbrains.idea.maven.project.importing.RootPath;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 b2\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002JF\u0010)\u001a\u0002H*\"\b\b\u0000\u0010**\u00020\r2\u000b\u0010+\u001a\u00070,\u00a2\u0006\u0002\b-2\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H*03H\u0002\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u000206J\f\u00107\u001a\b\u0012\u0004\u0012\u00020!08J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0006\u0010:\u001a\u00020;J\b\u0010<\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020CH\u0007J(\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010'\u001a\u00020(H\u0007J\"\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0I082\f\u0010K\u001a\b\u0012\u0004\u0012\u00020J0IH\u0007J\u001e\u0010L\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020!03H\u0002J)\u0010M\u001a\u0002062\u000b\u0010N\u001a\u00070,\u00a2\u0006\u0002\bO2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002060QH\u0002J\u000e\u0010R\u001a\u00020>2\u0006\u0010'\u001a\u00020(J*\u0010S\u001a\u00020>2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020@0U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020@0U2\u0006\u0010'\u001a\u00020(J\u0010\u0010W\u001a\u0002062\u0006\u0010X\u001a\u00020&H\u0002J$\u0010Y\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Z0U032\n\u0010[\u001a\u0006\u0012\u0002\b\u000301H\u0002J'\u0010\\\u001a\u0002H]\"\u0004\b\u0000\u0010]2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H]0QH\u0002\u00a2\u0006\u0002\u0010_J;\u0010\\\u001a\u0002H]\"\u0004\b\u0000\u0010]2\u0006\u0010`\u001a\u00020/2\n\u0010[\u001a\u0006\u0012\u0002\b\u0003012\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H]0QH\u0002\u00a2\u0006\u0002\u0010aR#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000b\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "kotlin.jvm.PlatformType", "getConsole", "()Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "console$delegate", "Lkotlin/Lazy;", "value", "Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "currentContext", "getCurrentContext", "()Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "setCurrentContext", "(Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "mavenPluginInfo", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getMavenPluginInfo", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "mavenPluginInfo$delegate", "getProject", "()Lcom/intellij/openapi/project/Project;", "waitingPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/idea/maven/project/importing/MavenImportFinishedContext;", "doImport", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "initialImport", "Lorg/jetbrains/idea/maven/project/importing/MavenInitialImportContext;", "spec", "Lorg/jetbrains/idea/maven/buildtool/MavenImportSpec;", "doTask", "Result", "message", "", "Lcom/intellij/build/events/BuildEventsNls$Message;", "parentActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "activityKlass", "Ljava/lang/Class;", "init", "Lkotlin/Function0;", "(Ljava/lang/String;Lcom/intellij/internal/statistic/StructuredIdeActivity;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "forceStopImport", "", "getImportFinishPromise", "Lorg/jetbrains/concurrency/Promise;", "getWaitingPromise", "isImportingInProgress", "", "isRecursiveImportCalledFromMavenProjectsManagerWatcher", "linkAndImportFile", "Lorg/jetbrains/idea/maven/project/importing/MavenImportingResult;", "pom", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectAndImport", "importPaths", "Lorg/jetbrains/idea/maven/project/importing/ImportPaths;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "resolveFolders", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "projects", "runSync", "runUnderIndicator", "title", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "action", "Lkotlin/Function1;", "scheduleImportAll", "scheduleUpdate", "filesToUpdate", "", "filesToDelete", "setProjectSettings", "initialImportContext", "withData", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "klass", "withStructuredIdeActivity", "T", "f", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "parent", "(Lcom/intellij/internal/statistic/StructuredIdeActivity;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.maven"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMavenImportingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenImportingManager.kt\norg/jetbrains/idea/maven/project/importing/MavenImportingManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1603#2,9:398\n1855#2:407\n1856#2:409\n1612#2:410\n1#3:408\n*S KotlinDebug\n*F\n+ 1 MavenImportingManager.kt\norg/jetbrains/idea/maven/project/importing/MavenImportingManager\n*L\n283#1:398,9\n283#1:407\n283#1:409\n283#1:410\n283#1:408\n*E\n"})
public final class MavenImportingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Lazy mavenPluginInfo$delegate;
    @Nullable
    private MavenImportContext currentContext;
    @NotNull
    private final Lazy console$delegate;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private AsyncPromise<MavenImportFinishedContext> waitingPromise;
    @JvmField
    @NotNull
    public static final Topic<MavenProjectsManager.Listener> LEGACY_PROJECT_MANAGER_LISTENER;

    public MavenImportingManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Disposable disposable = Disposer.newDisposable((String)"Maven Importing manager");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(\"Maven Importing manager\")");
        this.disposable = disposable;
        this.mavenPluginInfo$delegate = LazyKt.lazy((Function0)mavenPluginInfo.2.INSTANCE);
        this.console$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MavenSyncConsole>(this){
            final /* synthetic */ MavenImportingManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MavenSyncConsole invoke() {
                return ((MavenProjectsManager)this.this$0.getProject().getService(MavenProjectsManager.class)).getSyncConsole();
            }
        }));
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Maven importing executor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026n importing executor\", 1)");
        this.executor = executorService;
        MessageBusConnection connection = this.project.getMessageBus().connect(this.disposable);
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Disposer.dispose((Disposable)disposable);
                this.forceStopImport();
                executor.shutdownNow();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> 1.projectClosing$lambda$0(this), RunnerBundle.message("maven.server.shutdown", new Object[0]), false, this.getProject());
            }

            private static final void projectClosing$lambda$0(MavenImportingManager this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
        });
        this.waitingPromise = new AsyncPromise();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PluginInfo getMavenPluginInfo() {
        Lazy lazy = this.mavenPluginInfo$delegate;
        return (PluginInfo)lazy.getValue();
    }

    @Nullable
    public final MavenImportContext getCurrentContext() {
        return this.currentContext;
    }

    private final void setCurrentContext(MavenImportContext value) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.currentContext = value;
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> MavenImportingManager._set_currentContext_$lambda$0(this, value));
        }
    }

    private final MavenSyncConsole getConsole() {
        Lazy lazy = this.console$delegate;
        return (MavenSyncConsole)lazy.getValue();
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult linkAndImportFile(@NotNull VirtualFile pom) {
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        ImportPaths importPath = pom.isDirectory() ? (ImportPaths)new RootPath(pom) : (ImportPaths)new FilesList(pom);
        MavenImportingSettings mavenImportingSettings = manager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"manager.importingSettings");
        MavenGeneralSettings mavenGeneralSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"manager.generalSettings");
        MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"EXPLICIT_IMPORT");
        return this.openProjectAndImport(importPath, mavenImportingSettings, mavenGeneralSettings, mavenImportSpec);
    }

    @RequiresEdt
    @NotNull
    public final Promise<Collection<MavenProject>> resolveFolders(@NotNull Collection<? extends MavenProject> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        AsyncPromise result2 = new AsyncPromise();
        String string = MavenProjectBundle.message("maven.updating.folders", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.updating.folders\")");
        this.runUnderIndicator(string, (Function1<? super MavenProgressIndicator, Unit>)((Function1)new Function1<MavenProgressIndicator, Unit>(projects, this, (AsyncPromise<Collection<MavenProject>>)result2){
            final /* synthetic */ Collection<MavenProject> $projects;
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ AsyncPromise<Collection<MavenProject>> $result;
            {
                this.$projects = $projects;
                this.this$0 = $receiver;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull MavenProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    new MavenImportFlow().resolveFolders(this.$projects, this.this$0.getProject(), it);
                }
                catch (Throwable e) {
                    this.$result.setError(e);
                }
            }
        }));
        return (Promise)result2;
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult openProjectAndImport(@NotNull ImportPaths importPaths) {
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.project).getSettings();
        MavenImportingSettings mavenImportingSettings = settings.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.getGeneralSettings()");
        MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"EXPLICIT_IMPORT");
        return this.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, mavenImportSpec);
    }

    @RequiresEdt
    @NotNull
    public final MavenImportingResult openProjectAndImport(@NotNull ImportPaths importPaths, @NotNull MavenImportingSettings importingSettings, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isImportingInProgress()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.waitingPromise), null, null);
        }
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Project is closing");
        }
        this.waitingPromise = new AsyncPromise();
        MavenUtil.setupProjectSdk(this.project);
        this.setCurrentContext(new MavenStartedImport(this.project));
        Collection enabledProfiles = MavenProjectsManager.getInstance(this.project).getExplicitProfiles().getEnabledProfiles();
        Collection disabledProfiles = MavenProjectsManager.getInstance(this.project).getExplicitProfiles().getDisabledProfiles();
        MavenImportFlow mavenImportFlow = new MavenImportFlow();
        Intrinsics.checkNotNullExpressionValue((Object)enabledProfiles, (String)"enabledProfiles");
        Intrinsics.checkNotNullExpressionValue((Object)disabledProfiles, (String)"disabledProfiles");
        MavenInitialImportContext initialImportContext = mavenImportFlow.prepareNewImport(this.project, importPaths, generalSettings, importingSettings, enabledProfiles, disabledProfiles);
        MessageBus messageBus = this.project.getMessageBus();
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((MavenImportListener)messageBus.syncPublisher(topic)).importStarted();
        this.setProjectSettings(initialImportContext);
        String string = MavenProjectBundle.message("maven.project.importing", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.project.importing\")");
        this.runUnderIndicator(string, (Function1<? super MavenProgressIndicator, Unit>)((Function1)new Function1<MavenProgressIndicator, Unit>(this, initialImportContext, spec){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ MavenInitialImportContext $initialImportContext;
            final /* synthetic */ MavenImportSpec $spec;
            {
                this.this$0 = $receiver;
                this.$initialImportContext = $initialImportContext;
                this.$spec = $spec;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull MavenProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    MavenImportFinishedContext finishedContext = MavenImportingManager.access$doImport(this.this$0, indicator, this.$initialImportContext, this.$spec);
                    MavenImportingManager.access$getWaitingPromise(this.this$0).setResult((Object)finishedContext);
                }
                catch (Throwable e) {
                    MavenLog.LOG.debug("import started at: ", (Throwable)this.$initialImportContext.getStartImportStackTrace());
                    MavenLog.LOG.warn(e);
                    if (indicator.isCanceled()) {
                        MavenImportingManager.access$getWaitingPromise(this.this$0).setError("Cancelled");
                    } else {
                        MavenImportingManager.access$getWaitingPromise(this.this$0).setError(e);
                        MavenLog.LOG.error(e);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)this.$initialImportContext.getImportDisposable());
                }
            }
        }));
        AsyncPromise vfsRefreshPromise = new AsyncPromise();
        VirtualFileManager.getInstance().asyncRefresh(() -> MavenImportingManager.openProjectAndImport$lambda$1(vfsRefreshPromise));
        return new MavenImportingResult(this.getImportFinishPromise(), (Promise<Object>)((Promise)vfsRefreshPromise), initialImportContext.getPreviewModule());
    }

    private final void setProjectSettings(MavenInitialImportContext initialImportContext) {
        MavenGeneralSettings generalSettings = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject()).getSettings().getGeneralSettings();
        MavenImportingSettings importingSettings = MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject()).getSettings().getImportingSettings();
        MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject()).getSettings().setGeneralSettings(initialImportContext.getGeneralSettings());
        MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject()).getSettings().setImportingSettings(initialImportContext.getImportingSettings());
        initialImportContext.getGeneralSettings().copyListeners(generalSettings);
        initialImportContext.getImportingSettings().copyListeners(importingSettings);
        MavenWorkspaceSettingsComponent.getInstance(initialImportContext.getProject()).getSettings().setGeneralSettings(initialImportContext.getGeneralSettings());
    }

    private final MavenImportFinishedContext doImport(MavenProgressIndicator indicator, MavenInitialImportContext initialImport, MavenImportSpec spec) {
        return (MavenImportFinishedContext)this.withStructuredIdeActivity((Function1)new Function1<StructuredIdeActivity, MavenImportFinishedContext>(this, spec, initialImport, indicator){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ MavenImportSpec $spec;
            final /* synthetic */ MavenInitialImportContext $initialImport;
            final /* synthetic */ MavenProgressIndicator $indicator;
            {
                this.this$0 = $receiver;
                this.$spec = $spec;
                this.$initialImport = $initialImport;
                this.$indicator = $indicator;
                super(1);
            }

            @NotNull
            public final MavenImportFinishedContext invoke(@NotNull StructuredIdeActivity activity2) {
                MavenImportFinishedContext mavenImportFinishedContext;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
                    MavenImportFlow flow = new MavenImportFlow();
                    mavenImportFinishedContext = MavenImportingManager.access$runSync(this.this$0, this.$spec, (Function0)new Function0<MavenImportFinishedContext>(this.this$0, this.$initialImport, activity2, flow, this.$indicator){
                        final /* synthetic */ MavenImportingManager this$0;
                        final /* synthetic */ MavenInitialImportContext $initialImport;
                        final /* synthetic */ StructuredIdeActivity $activity;
                        final /* synthetic */ MavenImportFlow $flow;
                        final /* synthetic */ MavenProgressIndicator $indicator;
                        {
                            this.this$0 = $receiver;
                            this.$initialImport = $initialImport;
                            this.$activity = $activity;
                            this.$flow = $flow;
                            this.$indicator = $indicator;
                            super(0);
                        }

                        @NotNull
                        public final MavenImportFinishedContext invoke() {
                            MavenImportingManager.access$getConsole(this.this$0).addWarning("New Maven importing flow is enabled", "New Maven importing flow is enabled, it is experimental feature. \n\nTo revert to old importing flow, set \"maven.linear.import\" registry flag to false");
                            MavenImportingManager.access$setCurrentContext(this.this$0, this.$initialImport);
                            Ref.ObjectRef readMavenFiles2 = new Ref.ObjectRef();
                            String string = MavenProjectBundle.message("maven.reading", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.reading\")");
                            readMavenFiles2.element = MavenImportingManager.access$doTask(this.this$0, string, this.$activity, MavenImportStats.ReadingTask.class, (Function0)new Function0<MavenReadContext>(this.this$0, this.$flow, this.$initialImport, this.$indicator){
                                final /* synthetic */ MavenImportingManager this$0;
                                final /* synthetic */ MavenImportFlow $flow;
                                final /* synthetic */ MavenInitialImportContext $initialImport;
                                final /* synthetic */ MavenProgressIndicator $indicator;
                                {
                                    this.this$0 = $receiver;
                                    this.$flow = $flow;
                                    this.$initialImport = $initialImport;
                                    this.$indicator = $indicator;
                                    super(0);
                                }

                                @NotNull
                                public final MavenReadContext invoke() {
                                    block0: {
                                        Object object = this.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.$flow.readMavenFiles(this.$initialImport, this.$indicator);
                                }
                            });
                            if (((MavenReadContext)readMavenFiles2.element).getWrapperData() != null) {
                                try {
                                    readMavenFiles2.element = this.$flow.setupMavenWrapper((MavenReadContext)readMavenFiles2.element);
                                    ((MavenReadContext)readMavenFiles2.element).getInitialContext().getGeneralSettings().setMavenHome("Use Maven wrapper");
                                }
                                catch (Throwable e) {
                                    MavenLog.LOG.warn(e);
                                }
                            }
                            this.$flow.updateProjectManager((MavenReadContext)readMavenFiles2.element);
                            String string2 = MavenProjectBundle.message("maven.resolving", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"maven.resolving\")");
                            MavenResolvedContext dependenciesContext2 = (MavenResolvedContext)MavenImportingManager.access$doTask(this.this$0, string2, this.$activity, MavenImportStats.ResolvingTask.class, (Function0)new Function0<MavenResolvedContext>(this.this$0, this.$flow, (Ref.ObjectRef<MavenReadContext>)readMavenFiles2){
                                final /* synthetic */ MavenImportingManager this$0;
                                final /* synthetic */ MavenImportFlow $flow;
                                final /* synthetic */ Ref.ObjectRef<MavenReadContext> $readMavenFiles;
                                {
                                    this.this$0 = $receiver;
                                    this.$flow = $flow;
                                    this.$readMavenFiles = $readMavenFiles;
                                    super(0);
                                }

                                @NotNull
                                public final MavenResolvedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.$flow.resolveDependencies((MavenReadContext)this.$readMavenFiles.element);
                                }
                            });
                            String string3 = MavenProjectBundle.message("maven.downloading.plugins", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"maven.downloading.plugins\")");
                            MavenPluginResolvedContext resolvePlugins2 = (MavenPluginResolvedContext)MavenImportingManager.access$doTask(this.this$0, string3, this.$activity, MavenImportStats.PluginsResolvingTask.class, (Function0)new Function0<MavenPluginResolvedContext>(this.this$0, this.$flow, dependenciesContext2){
                                final /* synthetic */ MavenImportingManager this$0;
                                final /* synthetic */ MavenImportFlow $flow;
                                final /* synthetic */ MavenResolvedContext $dependenciesContext;
                                {
                                    this.this$0 = $receiver;
                                    this.$flow = $flow;
                                    this.$dependenciesContext = $dependenciesContext;
                                    super(0);
                                }

                                @NotNull
                                public final MavenPluginResolvedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.$flow.resolvePlugins(this.$dependenciesContext);
                                }
                            });
                            String string4 = MavenProjectBundle.message("maven.project.importing", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"maven.project.importing\")");
                            MavenImportedContext importContext2 = (MavenImportedContext)MavenImportingManager.access$doTask(this.this$0, string4, this.$activity, MavenImportStats.ApplyingModelTask.class, (Function0)new Function0<MavenImportedContext>(this.this$0, this.$flow, dependenciesContext2, this.$activity){
                                final /* synthetic */ MavenImportingManager this$0;
                                final /* synthetic */ MavenImportFlow $flow;
                                final /* synthetic */ MavenResolvedContext $dependenciesContext;
                                final /* synthetic */ StructuredIdeActivity $activity;
                                {
                                    this.this$0 = $receiver;
                                    this.$flow = $flow;
                                    this.$dependenciesContext = $dependenciesContext;
                                    this.$activity = $activity;
                                    super(0);
                                }

                                @NotNull
                                public final MavenImportedContext invoke() {
                                    block0: {
                                        Object object = this.this$0.getCurrentContext();
                                        if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    return this.$flow.commitToWorkspaceModel(this.$dependenciesContext, this.$activity);
                                }
                            });
                            String string5 = MavenProjectBundle.message("maven.post.processing", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"maven.post.processing\")");
                            return (MavenImportFinishedContext)MavenImportingManager.access$doTask(this.this$0, string5, this.$activity, MavenImportStats.ConfiguringProjectsTask.class, (Function0)new Function0<MavenImportFinishedContext>(this.this$0, this.$flow, importContext2, (Ref.ObjectRef<MavenReadContext>)readMavenFiles2, this.$initialImport){
                                final /* synthetic */ MavenImportingManager this$0;
                                final /* synthetic */ MavenImportFlow $flow;
                                final /* synthetic */ MavenImportedContext $importContext;
                                final /* synthetic */ Ref.ObjectRef<MavenReadContext> $readMavenFiles;
                                final /* synthetic */ MavenInitialImportContext $initialImport;
                                {
                                    this.this$0 = $receiver;
                                    this.$flow = $flow;
                                    this.$importContext = $importContext;
                                    this.$readMavenFiles = $readMavenFiles;
                                    this.$initialImport = $initialImport;
                                    super(0);
                                }

                                @NotNull
                                public final MavenImportFinishedContext invoke() {
                                    Object object = this.this$0.getCurrentContext();
                                    if (object != null && (object = ((MavenImportContext)object).getIndicator()) != null) {
                                        ((MavenProgressIndicator)object).checkCanceled();
                                    }
                                    this.$flow.runPostImportTasks(this.$importContext);
                                    MavenImportFlowKt.runLegacyListeners((MavenImportContext)this.$readMavenFiles.element, (Function1<? super MavenProjectsManager.Listener, Unit>)((Function1)doImport.1.INSTANCE));
                                    MavenImportingManager.access$setProjectSettings(this.this$0, this.$initialImport);
                                    MavenResolveResultProblemProcessor.notifyMavenProblems(this.this$0.getProject());
                                    return new MavenImportFinishedContext(this.$importContext);
                                }
                            });
                        }
                    });
                    MavenImportingManager mavenImportingManager = this.this$0;
                    MavenImportFinishedContext it = mavenImportFinishedContext;
                    boolean bl = false;
                    MavenImportedContext mavenImportedContext = it.getContext();
                    if (mavenImportedContext == null) break block0;
                    MavenImportedContext it2 = mavenImportedContext;
                    boolean bl2 = false;
                    MessageBus messageBus = mavenImportingManager.getProject().getMessageBus();
                    Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                    ((MavenImportListener)messageBus.syncPublisher(topic)).importFinished((Collection<MavenProject>)it2.getResolvedContext().getProjectsToImport(), it2.getModulesCreated());
                }
                return mavenImportFinishedContext;
            }
        });
    }

    private final AsyncPromise<MavenImportFinishedContext> getWaitingPromise() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return this.waitingPromise;
        }
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> MavenImportingManager.getWaitingPromise$lambda$2(ref, this));
        Object object = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
        return (AsyncPromise)object;
    }

    public final boolean isImportingInProgress() {
        MavenImportContext context2 = this.currentContext;
        return context2 != null && !(context2 instanceof MavenImportFinishedContext);
    }

    @NotNull
    public final Promise<MavenImportFinishedContext> getImportFinishPromise() {
        return (Promise)this.getWaitingPromise();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MavenImportingResult scheduleImportAll(@NotNull MavenImportSpec spec) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (this.isRecursiveImportCalledFromMavenProjectsManagerWatcher()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null, null);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        if (this.isImportingInProgress()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null, null);
        }
        MavenWorkspaceSettingsComponent settings = MavenWorkspaceSettingsComponent.getInstance(this.project);
        List<String> list = manager.getProjectsTree().getManagedFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.projectsTree.managedFilesPaths");
        Iterable iterable = list;
        MavenImportingManager mavenImportingManager = this;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (LocalFileSystem.getInstance().findFileByPath(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        ImportPaths importPaths = new FilesList(list2);
        MavenImportingSettings mavenImportingSettings = settings.getSettings().getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.settings.getGeneralSettings()");
        return mavenImportingManager.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, spec);
    }

    @NotNull
    public final MavenImportingResult scheduleUpdate(@NotNull List<? extends VirtualFile> filesToUpdate, @NotNull List<? extends VirtualFile> filesToDelete, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter(filesToUpdate, (String)"filesToUpdate");
        Intrinsics.checkNotNullParameter(filesToDelete, (String)"filesToDelete");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (this.isRecursiveImportCalledFromMavenProjectsManagerWatcher()) {
            return new MavenImportingResult((Promise<MavenImportFinishedContext>)((Promise)this.getWaitingPromise()), null, null);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        MavenWorkspaceSettingsComponent settings = MavenWorkspaceSettingsComponent.getInstance(this.project);
        manager.getProjectsTree().removeManagedFiles(filesToDelete);
        ImportPaths importPaths = new FilesList(filesToUpdate);
        MavenImportingSettings mavenImportingSettings = settings.getSettings().getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.settings.getGeneralSettings()");
        return this.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, spec);
    }

    private final boolean isRecursiveImportCalledFromMavenProjectsManagerWatcher() {
        return this.isImportingInProgress();
    }

    private final <Result extends MavenImportContext> Result doTask(String message, StructuredIdeActivity parentActivity, Class<?> activityKlass, Function0<? extends Result> init) {
        return (Result)((MavenImportContext)this.withStructuredIdeActivity(parentActivity, activityKlass, (Function1)new Function1<StructuredIdeActivity, Result>(this, message, init){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Function0<Result> $init;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$init = $init;
                super(1);
            }

            @NotNull
            public final Result invoke(@NotNull StructuredIdeActivity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Result Result2 = MavenImportingManager.access$getConsole(this.this$0).runTask(this.$message, this.$init);
                MavenImportingManager mavenImportingManager = this.this$0;
                MavenImportContext ctx = (MavenImportContext)Result2;
                boolean bl = false;
                MavenImportingManager.access$setCurrentContext(mavenImportingManager, ctx);
                return (Result)((MavenImportContext)Result2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenImportFinishedContext runSync(MavenImportSpec spec, Function0<MavenImportFinishedContext> init) {
        MavenSyncConsole mavenSyncConsole = this.getConsole();
        Object object = this.project.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(SyncViewManager::class.java)");
        mavenSyncConsole.startImport((BuildProgressListener)object, spec);
        try {
            MavenImportFinishedContext mavenImportFinishedContext = (MavenImportFinishedContext)init.invoke();
            return mavenImportFinishedContext;
        }
        catch (Exception e) {
            if (!this.project.isDisposed()) {
                MavenSyncConsole mavenSyncConsole2 = this.getConsole();
                Throwable throwable = e;
                Object object2 = this.project.getService(SyncViewManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.getService(SyncViewManager::class.java)");
                mavenSyncConsole2.addException(throwable, (BuildProgressListener)object2);
            } else {
                MavenLog.LOG.warn((Throwable)e);
            }
            MavenImportFinishedContext mavenImportFinishedContext = new MavenImportFinishedContext(e, this.project);
            return mavenImportFinishedContext;
        }
        finally {
            this.getConsole().finishImport();
        }
    }

    public final void forceStopImport() {
        block0: {
            Object object = this.currentContext;
            if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
            ((MavenProgressIndicator)object).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withStructuredIdeActivity(Function1<? super StructuredIdeActivity, ? extends T> f) {
        StructuredIdeActivity startedActivity2 = ProjectImportCollector.IMPORT_ACTIVITY.started(this.project, this.withData(MavenImportStats.ImportingTask.class));
        try {
            Object object = f.invoke((Object)startedActivity2);
            return (T)object;
        }
        finally {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)startedActivity2, null, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withStructuredIdeActivity(StructuredIdeActivity parent, Class<?> klass, Function1<? super StructuredIdeActivity, ? extends T> f) {
        StructuredIdeActivity startedActivity2 = ProjectImportCollector.IMPORT_STAGE.startedWithParent(this.project, parent, new Function0<List<? extends EventPair<?>>>(klass){
            final /* synthetic */ Class<?> $klass;
            {
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final List<EventPair<?>> invoke() {
                return CollectionsKt.listOf((Object)ProjectImportCollector.TASK_CLASS.with(this.$klass));
            }
        });
        try {
            Object object = f.invoke((Object)startedActivity2);
            return (T)object;
        }
        finally {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)startedActivity2, null, (int)1, null);
        }
    }

    private final Function0<List<EventPair<?>>> withData(Class<?> klass) {
        return new Function0<List<EventPair<?>>>(this, klass){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ Class<?> $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(0);
            }

            @NotNull
            public final List<EventPair<?>> invoke() {
                Object[] objectArray = new EventPair[]{ExternalSystemActionsCollector.Companion.getEXTERNAL_SYSTEM_ID().with((Object)"Maven")};
                List data2 = CollectionsKt.mutableListOf((Object[])objectArray);
                if (MavenImportingManager.access$getMavenPluginInfo(this.this$0) != null) {
                    data2.add(EventFields.PluginInfo.with((Object)MavenImportingManager.access$getMavenPluginInfo(this.this$0)));
                }
                data2.add(ProjectImportCollector.TASK_CLASS.with(this.$klass));
                return data2;
            }
        };
    }

    private final void runUnderIndicator(String title, Function1<? super MavenProgressIndicator, Unit> action) {
        this.executor.execute(() -> MavenImportingManager.runUnderIndicator$lambda$4(this, title, action));
    }

    private static final void _set_currentContext_$lambda$0(MavenImportingManager this$0, MavenImportContext $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.currentContext = $value;
    }

    private static final void openProjectAndImport$lambda$1(AsyncPromise $vfsRefreshPromise) {
        Intrinsics.checkNotNullParameter((Object)$vfsRefreshPromise, (String)"$vfsRefreshPromise");
        $vfsRefreshPromise.setResult(null);
    }

    private static final void getWaitingPromise$lambda$2(Ref $ref, MavenImportingManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$ref, (String)"$ref");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $ref.set(this$0.waitingPromise);
    }

    private static final void runUnderIndicator$lambda$4(MavenImportingManager this$0, String $title, Function1 $action) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Project project2 = this$0.project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable($title, (Function1<? super MavenProgressIndicator, Unit>)$action, this$0, project2){
            final /* synthetic */ Function1<MavenProgressIndicator, Unit> $action;
            final /* synthetic */ MavenImportingManager this$0;
            {
                this.$action = $action;
                this.this$0 = $receiver;
                super($super_call_param$1, $title);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$action.invoke((Object)new MavenProgressIndicator(this.getProject(), indicator, () -> runUnderIndicator.1.1.run$lambda$0(this.this$0)));
            }

            private static final MavenSyncConsole run$lambda$0(MavenImportingManager this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return MavenImportingManager.access$getConsole(this$0);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final MavenImportingManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ MavenImportFinishedContext access$doImport(MavenImportingManager $this, MavenProgressIndicator indicator, MavenInitialImportContext initialImport, MavenImportSpec spec) {
        return $this.doImport(indicator, initialImport, spec);
    }

    public static final /* synthetic */ AsyncPromise access$getWaitingPromise(MavenImportingManager $this) {
        return $this.getWaitingPromise();
    }

    public static final /* synthetic */ MavenImportFinishedContext access$runSync(MavenImportingManager $this, MavenImportSpec spec, Function0 init) {
        return $this.runSync(spec, (Function0<MavenImportFinishedContext>)init);
    }

    public static final /* synthetic */ MavenSyncConsole access$getConsole(MavenImportingManager $this) {
        return $this.getConsole();
    }

    public static final /* synthetic */ void access$setCurrentContext(MavenImportingManager $this, MavenImportContext value) {
        $this.setCurrentContext(value);
    }

    public static final /* synthetic */ MavenImportContext access$doTask(MavenImportingManager $this, String message, StructuredIdeActivity parentActivity, Class activityKlass, Function0 init) {
        return $this.doTask(message, parentActivity, activityKlass, init);
    }

    public static final /* synthetic */ void access$setProjectSettings(MavenImportingManager $this, MavenInitialImportContext initialImportContext) {
        $this.setProjectSettings(initialImportContext);
    }

    public static final /* synthetic */ PluginInfo access$getMavenPluginInfo(MavenImportingManager $this) {
        return $this.getMavenPluginInfo();
    }

    static {
        Topic topic = Topic.create((String)"Maven Project Manager Listener bus", MavenProjectsManager.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(\"Maven Project Ma\u2026ger.Listener::class.java)");
        LEGACY_PROJECT_MANAGER_LISTENER = topic;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager$Companion;", "", "()V", "LEGACY_PROJECT_MANAGER_LISTENER", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenImportingManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(MavenImportingManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Maven\u2026rtingManager::class.java)");
            return (MavenImportingManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

