/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.XAttr;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class XAttrUtil {
    public static List<String> listXAttr(String path2) {
        long bufferLength = XAttr.INSTANCE.listxattr(path2, null, 0L, 0);
        if (bufferLength < 0L) {
            return null;
        }
        if (bufferLength == 0L) {
            return new ArrayList<String>(0);
        }
        Memory valueBuffer = new Memory(bufferLength);
        long valueLength = XAttr.INSTANCE.listxattr(path2, valueBuffer, bufferLength, 0);
        if (valueLength < 0L) {
            return null;
        }
        return XAttrUtil.decodeStringSequence(valueBuffer.getByteBuffer(0L, valueLength));
    }

    public static String getXAttr(String path2, String name2) {
        long bufferLength = XAttr.INSTANCE.getxattr(path2, name2, null, 0L, 0, 0);
        if (bufferLength < 0L) {
            return null;
        }
        if (bufferLength == 0L) {
            return "";
        }
        Memory valueBuffer = new Memory(bufferLength);
        valueBuffer.clear();
        long valueLength = XAttr.INSTANCE.getxattr(path2, name2, valueBuffer, bufferLength, 0, 0);
        if (valueLength < 0L) {
            return null;
        }
        return Native.toString(valueBuffer.getByteArray(0L, (int)bufferLength), "UTF-8");
    }

    public static int setXAttr(String path2, String name2, String value2) {
        Memory valueBuffer = XAttrUtil.encodeString(value2);
        return XAttr.INSTANCE.setxattr(path2, name2, valueBuffer, valueBuffer.size(), 0, 0);
    }

    public static int removeXAttr(String path2, String name2) {
        return XAttr.INSTANCE.removexattr(path2, name2, 0);
    }

    protected static Memory encodeString(String s) {
        byte[] bb = s.getBytes(Charset.forName("UTF-8"));
        Memory valueBuffer = new Memory(bb.length);
        valueBuffer.write(0L, bb, 0, bb.length);
        return valueBuffer;
    }

    protected static String decodeString(ByteBuffer bb) {
        return Charset.forName("UTF-8").decode(bb).toString();
    }

    protected static List<String> decodeStringSequence(ByteBuffer bb) {
        ArrayList<String> names2 = new ArrayList<String>();
        bb.mark();
        while (bb.hasRemaining()) {
            if (bb.get() != 0) continue;
            ByteBuffer nameBuffer = (ByteBuffer)bb.duplicate().limit(bb.position() - 1).reset();
            if (nameBuffer.hasRemaining()) {
                names2.add(XAttrUtil.decodeString(nameBuffer));
            }
            bb.mark();
        }
        return names2;
    }
}

