/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.ir;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.BuiltinSymbolsBase;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0018\b&\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0012\u0010\u0016\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0012\u0010\u0018\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0012\u0010\u001a\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0012\u0010\u001c\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0012\u0010\u001e\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0016\u0010 \u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u0016\u0010&\u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0012\u0010(\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0010R\u0012\u0010*\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013R\u0014\u0010,\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0013R\u0012\u0010.\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0013R\u0012\u00100\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0013R\u0012\u00102\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0013R\u0012\u00104\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0013R\u0016\u00106\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0013\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;)V", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getArraysContentEquals", "()Ljava/util/Map;", "continuationClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getContinuationClass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "coroutineContextGetter", "getCoroutineContextGetter", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "coroutineGetContext", "getCoroutineGetContext", "coroutineImpl", "getCoroutineImpl", "coroutineSuspendedGetter", "getCoroutineSuspendedGetter", "defaultConstructorMarker", "getDefaultConstructorMarker", "functionAdapter", "getFunctionAdapter", "getContinuation", "getGetContinuation", "getWithoutBoundCheckName", "Lorg/jetbrains/kotlin/name/Name;", "getGetWithoutBoundCheckName", "()Lorg/jetbrains/kotlin/name/Name;", "returnIfSuspended", "getReturnIfSuspended", "setWithoutBoundCheckName", "getSetWithoutBoundCheckName", "stringBuilder", "getStringBuilder", "suspendCoroutineUninterceptedOrReturn", "getSuspendCoroutineUninterceptedOrReturn", "throwISE", "getThrowISE", "throwKotlinNothingValueException", "getThrowKotlinNothingValueException", "throwNullPointerException", "getThrowNullPointerException", "throwTypeCastException", "getThrowTypeCastException", "throwUninitializedPropertyAccessException", "getThrowUninitializedPropertyAccessException", "unsafeCoerceIntrinsic", "getUnsafeCoerceIntrinsic", "Companion", "ir.backend.common"})
public abstract class Symbols
extends BuiltinSymbolsBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IrSimpleFunctionSymbol unsafeCoerceIntrinsic;
    @Nullable
    private final Name getWithoutBoundCheckName;
    @Nullable
    private final Name setWithoutBoundCheckName;
    @Nullable
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public Symbols(@NotNull IrBuiltIns irBuiltIns, @NotNull ReferenceSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        super(irBuiltIns, symbolTable);
    }

    @NotNull
    public abstract IrSimpleFunctionSymbol getThrowNullPointerException();

    @NotNull
    public abstract IrSimpleFunctionSymbol getThrowTypeCastException();

    @NotNull
    public abstract IrSimpleFunctionSymbol getThrowUninitializedPropertyAccessException();

    @NotNull
    public abstract IrSimpleFunctionSymbol getThrowKotlinNothingValueException();

    @NotNull
    public IrSimpleFunctionSymbol getThrowISE() {
        throw new IllegalStateException("throwISE is not implemented".toString());
    }

    @NotNull
    public abstract IrClassSymbol getStringBuilder();

    @NotNull
    public abstract IrClassSymbol getDefaultConstructorMarker();

    @NotNull
    public abstract IrClassSymbol getCoroutineImpl();

    @NotNull
    public abstract IrSimpleFunctionSymbol getCoroutineSuspendedGetter();

    @NotNull
    public abstract IrSimpleFunctionSymbol getGetContinuation();

    @NotNull
    public abstract IrClassSymbol getContinuationClass();

    @NotNull
    public abstract IrSimpleFunctionSymbol getCoroutineContextGetter();

    @NotNull
    public abstract IrSimpleFunctionSymbol getSuspendCoroutineUninterceptedOrReturn();

    @NotNull
    public abstract IrSimpleFunctionSymbol getCoroutineGetContext();

    @NotNull
    public abstract IrSimpleFunctionSymbol getReturnIfSuspended();

    @NotNull
    public abstract IrClassSymbol getFunctionAdapter();

    @Nullable
    public IrSimpleFunctionSymbol getUnsafeCoerceIntrinsic() {
        return this.unsafeCoerceIntrinsic;
    }

    @Nullable
    public Name getGetWithoutBoundCheckName() {
        return this.getWithoutBoundCheckName;
    }

    @Nullable
    public Name getSetWithoutBoundCheckName() {
        return this.setWithoutBoundCheckName;
    }

    @Nullable
    public Map<IrType, IrSimpleFunctionSymbol> getArraysContentEquals() {
        return this.arraysContentEquals;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/Symbols$Companion;", "", "()V", "isLateinitIsInitializedPropertyGetter", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isTypeOfIntrinsic", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isLateinitIsInitializedPropertyGetter(@NotNull IrFunctionSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            if (!(symbol2 instanceof IrSimpleFunctionSymbol)) return false;
            IrSimpleFunction function2 = (IrSimpleFunction)((IrSimpleFunctionSymbol)symbol2).getOwner();
            boolean bl = false;
            if (!Intrinsics.areEqual(function2.getName().asString(), "<get-isInitialized>")) return false;
            if (!IrUtilsKt.isTopLevel(function2)) return false;
            if (!Intrinsics.areEqual(IrUtilsKt.getPackageFragment(function2).getFqName().asString(), "kotlin")) return false;
            if (!function2.getValueParameters().isEmpty()) return false;
            Object object = ((IrSimpleFunction)((IrSimpleFunctionSymbol)symbol2).getOwner()).getExtensionReceiverParameter();
            IrClass receiverClass = object != null && (object = object.getType()) != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null ? (IrClass)object.getOwner() : null;
            boolean bl2 = false;
            Object object2 = receiverClass;
            if (!Intrinsics.areEqual(object2 != null && (object2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object2)) != null ? ((FqName)object2).toUnsafe() : null, StandardNames.FqNames.kProperty0)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isTypeOfIntrinsic(@NotNull IrFunctionSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            if (!(symbol2 instanceof IrSimpleFunctionSymbol)) return false;
            IrSimpleFunction function2 = (IrSimpleFunction)((IrSimpleFunctionSymbol)symbol2).getOwner();
            boolean bl = false;
            if (!Intrinsics.areEqual(function2.getName().asString(), "typeOf")) return false;
            if (!function2.getValueParameters().isEmpty()) return false;
            IrDeclarationParent irDeclarationParent = function2.getParent();
            IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            if (!Intrinsics.areEqual(irPackageFragment != null ? irPackageFragment.getFqName() : null, StandardNames.KOTLIN_REFLECT_FQ_NAME)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

