/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SwitchOptimizer;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020)2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u0002002\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u0002022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u0002042\u0006\u0010\b\u001a\u00020\u0003H\u0016J.\u00105\u001a\u00020\u0002*\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00032\u0018\u00106\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020908\u0012\u0004\u0012\u00020\u000207H\u0002J \u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020;*\b\u0012\u0004\u0012\u00020\u00020;2\u0006\u0010\u0006\u001a\u00020<H\u0002\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "context", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "maybeOptimizeIntoSwitch", "transformer", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "wrapInCommentsInlineFunctionCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrElementToJsStatementTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n1549#2:248\n1620#2,3:249\n1#3:252\n*S KotlinDebug\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n*L\n37#1:240\n37#1:241,3\n46#1:244\n46#1:245,3\n74#1:248\n74#1:249,3\n*E\n"})
public final class IrElementToJsStatementTransformer
implements BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @Override
    @NotNull
    public JsStatement visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data2, "data");
        throw new IllegalStateException("All functions must be already lowered".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(context, "context");
        Iterable $this$map$iv = body2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it.accept(this, context));
        }
        List<JsStatement> list2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(list2), body2, context, null, context.getCurrentFunction(), 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context) {
        JsNode jsNode;
        void $this$mapTo$iv$iv;
        Object it;
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(context, "context");
                object = expression2 instanceof IrReturnableBlock ? (IrReturnableBlock)expression2 : null;
                if (object == null || (object = IrInlineUtilsKt.getInlineFunction((IrReturnableBlock)object)) == null) break block6;
                it = object;
                boolean bl = false;
                JsGenerationContext jsGenerationContext = context.newFile(IrUtilsKt.getFile((IrDeclaration)it), context.getCurrentFunction(), context.getLocalNames());
                object = jsGenerationContext;
                if (jsGenerationContext != null) break block7;
            }
            object = context;
        }
        Object newContext = object;
        List<IrStatement> container = IrInlineUtilsKt.getInnerInlinedBlockOrThis(expression2).getStatements();
        Iterable $this$map$iv = container;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it2.accept(this, newContext));
        }
        List<JsStatement> statements2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
        if (expression2 instanceof IrReturnableBlock) {
            JsName label = context.getNameForReturnableBlock((IrReturnableBlock)expression2);
            List<JsStatement> wrappedStatements = this.wrapInCommentsInlineFunctionCall(statements2, (IrReturnableBlock)expression2);
            jsNode = label != null ? (JsNode)new JsLabel(label, new JsBlock(wrappedStatements)) : (JsNode)new JsCompositeBlock((List<? extends JsStatement>)wrappedStatements);
        } else {
            jsNode = new JsBlock(statements2);
        }
        return (JsStatement)JsAstUtilsKt.withSource$default(jsNode, expression2, context, null, null, 12, null);
    }

    private final List<JsStatement> wrapInCommentsInlineFunctionCall(List<? extends JsStatement> $this$wrapInCommentsInlineFunctionCall, IrReturnableBlock expression2) {
        IrElement owner;
        IrFunction irFunction2 = IrInlineUtilsKt.getInlineFunction(expression2);
        if (irFunction2 == null) {
            return $this$wrapInCommentsInlineFunctionCall;
        }
        IrFunction inlineFunction2 = irFunction2;
        IrSimpleFunction irSimpleFunction = inlineFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)inlineFunction2 : null;
        IrPropertySymbol correspondingProperty2 = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        Object object = correspondingProperty2;
        IrElement irElement = owner = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)inlineFunction2;
        Object object2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)owner);
        if (object2 == null) {
            object2 = ((IrPossiblyExternalDeclaration)owner).getName();
        }
        FqName funName = object2;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(new JsSingleLineComment(" Inline function '" + funName + "' call")), (Iterable)$this$wrapInCommentsInlineFunctionCall);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (expression2.getStatements().isEmpty()) {
            jsStatement = JsEmpty.INSTANCE;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expression2.getStatements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrStatement irStatement = (IrStatement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((JsStatement)it.accept(this, context));
            }
            List<JsStatement> list2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
            jsStatement = (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(list2), expression2, context, null, null, 12, null);
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        JsStatement jsStatement = ((JsFunction)expression2.getFunction().accept(new IrFunctionToJsTransformer(), context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "expression.function.acce\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBreak(jsNameRef2), jump, context, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(jump, "jump");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsContinue(jsNameRef2), jump, context, null, null, 12, null);
    }

    private final JsStatement maybeOptimizeIntoSwitch(IrExpression $this$maybeOptimizeIntoSwitch, JsGenerationContext context, Function1<? super Function0<? extends JsExpression>, ? extends JsStatement> transformer2) {
        Function1 stmtTransformer2;
        JsStatement jsStatement;
        if ($this$maybeOptimizeIntoSwitch instanceof IrWhen && (jsStatement = new SwitchOptimizer(context, true, stmtTransformer2 = (Function1)new Function1<Function0<? extends JsStatement>, JsStatement>(transformer2, $this$maybeOptimizeIntoSwitch){
            final /* synthetic */ Function1<Function0<? extends JsExpression>, JsStatement> $transformer;
            final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
            {
                this.$transformer = $transformer;
                this.$this_maybeOptimizeIntoSwitch = $receiver;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull Function0<? extends JsStatement> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$transformer.invoke((Function0<? extends JsExpression>)new Function0<JsExpression>(it, this.$this_maybeOptimizeIntoSwitch){
                    final /* synthetic */ Function0<JsStatement> $it;
                    final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
                    {
                        this.$it = $it;
                        this.$this_maybeOptimizeIntoSwitch = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final JsExpression invoke() {
                        JsStatement stmt = this.$it.invoke();
                        boolean bl = stmt instanceof JsExpressionStatement;
                        IrExpression irExpression = this.$this_maybeOptimizeIntoSwitch;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl2 = false;
                            String string2 = RenderIrElementKt.render(irExpression) + " is not a statement " + stmt;
                            throw new AssertionError((Object)string2);
                        }
                        Intrinsics.checkNotNull(stmt, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
                        JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                        Intrinsics.checkNotNullExpressionValue(jsExpression, "stmt as JsExpressionStatement).expression");
                        return jsExpression;
                    }
                });
            }
        }).tryOptimize((IrWhen)$this$maybeOptimizeIntoSwitch)) != null) {
            JsStatement it = jsStatement;
            boolean bl = false;
            return it;
        }
        return transformer2.invoke(new Function0<JsExpression>($this$maybeOptimizeIntoSwitch, context){
            final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$this_maybeOptimizeIntoSwitch = $receiver;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final JsExpression invoke() {
                return (JsExpression)this.$this_maybeOptimizeIntoSwitch.accept(new IrElementToJsExpressionTransformer(), this.$context);
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName fieldName = context.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrElementToJsExpressionTransformer expressionTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(fieldName, irExpression != null ? (JsExpression)irExpression.accept(expressionTransformer, context) : null);
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)new Function1<Function0<? extends JsExpression>, JsStatement>(dest, expression2, context){
            final /* synthetic */ JsExpression $dest;
            final /* synthetic */ IrSetField $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$dest = $dest;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull Function0<? extends JsExpression> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(this.$dest, it.invoke()), this.$expression, this.$context, null, null, 12, null)).makeStmt();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(dest, it())\u2026sion, context).makeStmt()");
                return jsStatement;
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context.getNameForValueDeclaration(owner));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)new Function1<Function0<? extends JsExpression>, JsStatement>(ref, expression2, context){
            final /* synthetic */ JsNameRef $ref;
            final /* synthetic */ IrSetValue $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$ref = $ref;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull Function0<? extends JsExpression> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(this.$ref, it.invoke()), this.$expression, this.$context, null, null, 12, null)).makeStmt();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(ref, it()).\u2026sion, context).makeStmt()");
                return jsStatement;
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        IrReturnTargetSymbol targetSymbol = expression2.getReturnTargetSymbol();
        Function1 lastStatementTransformer2 = targetSymbol instanceof IrReturnableBlockSymbol ? (Function1)new Function1<Function0<? extends JsExpression>, JsStatement>(context, targetSymbol, expression2){
            final /* synthetic */ JsGenerationContext $context;
            final /* synthetic */ IrReturnTargetSymbol $targetSymbol;
            final /* synthetic */ IrReturn $expression;
            {
                this.$context = $context;
                this.$targetSymbol = $targetSymbol;
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final JsStatement invoke(@NotNull Function0<? extends JsExpression> it) {
                JsStatement jsStatement;
                JsName jsName;
                Intrinsics.checkNotNullParameter(it, "it");
                JsName jsName2 = this.$context.getNameForReturnableBlock((IrReturnableBlock)((IrReturnableBlockSymbol)this.$targetSymbol).getOwner());
                IrReturn irReturn = this.$expression;
                IrReturnTargetSymbol irReturnTargetSymbol = this.$targetSymbol;
                JsName it2 = jsName2;
                boolean bl = false;
                JsName jsName3 = jsName = !IrJsUtilsKt.isTheLastReturnStatementIn(irReturn, (IrReturnableBlockSymbol)irReturnTargetSymbol) ? jsName2 : null;
                if (jsName != null) {
                    JsName $this$invoke_u24lambda_u241 = jsName;
                    boolean bl2 = false;
                    jsStatement = new JsBreak($this$invoke_u24lambda_u241.makeRef());
                } else {
                    jsStatement = JsEmpty.INSTANCE;
                }
                return jsStatement;
            }
        } : (Function1)visitReturn.lastStatementTransformer.2.INSTANCE;
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context, lastStatementTransformer2), expression2, context, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context, visitThrow.1.INSTANCE), expression2, context, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext context) {
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Object object;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName varName = context.getNameForValueDeclaration(declaration);
        IrExpression value2 = declaration.getInitializer();
        if (value2 instanceof IrWhen) {
            JsNameRef jsNameRef = varName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "varName.makeRef()");
            JsNameRef varRef = jsNameRef;
            Function1 transformer2 = new Function1<Function0<? extends JsStatement>, JsStatement>(varRef){
                final /* synthetic */ JsNameRef $varRef;
                {
                    this.$varRef = $varRef;
                    super(1);
                }

                @NotNull
                public final JsStatement invoke(@NotNull Function0<? extends JsStatement> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    JsStatement jsStatement = it.invoke();
                    Intrinsics.checkNotNull(jsStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
                    JsExpression jsExpression = ((JsExpressionStatement)jsStatement).getExpression();
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "it() as JsExpressionStatement).expression");
                    JsExpression expr = jsExpression;
                    JsStatement jsStatement2 = new JsBinaryOperation(JsBinaryOperator.ASG, this.$varRef, expr).makeStmt();
                    Intrinsics.checkNotNullExpressionValue(jsStatement2, "JsBinaryOperation(JsBina\u2026 varRef, expr).makeStmt()");
                    return jsStatement2;
                }
            };
            object = new SwitchOptimizer(context, true, transformer2).tryOptimize((IrWhen)value2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                JsStatement[] jsStatementArray = new JsStatement[]{new JsVars(new JsVars.JsVar(varName)), it};
                return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(jsStatementArray), declaration, context, null, null, 12, null);
            }
        }
        IrExpression irExpression = value2;
        JsExpression jsInitializer = irExpression != null ? (JsExpression)irExpression.accept(new IrElementToJsExpressionTransformer(), context) : null;
        object = declaration.getOrigin();
        boolean syntheticVariable = object instanceof IrDeclarationOrigin.IR_TEMPORARY_VARIABLE ? true : (object instanceof IrDeclarationOrigin.IR_TEMPORARY_VARIABLE_FOR_INLINED_PARAMETER ? true : object instanceof IrDeclarationOrigin.IR_TEMPORARY_VARIABLE_FOR_INLINED_EXTENSION_RECEIVER);
        JsVars.JsVar $this$visitVariable_u24lambda_u248 = sourceInfoAwareJsNode = new JsVars.JsVar(varName, jsInitializer);
        boolean bl = false;
        JsAstUtilsKt.withSource$default($this$visitVariable_u24lambda_u248, declaration, context, declaration, null, 8, null);
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u248, syntheticVariable);
        JsVars.JsVar variable2 = sourceInfoAwareJsNode;
        SourceInfoAwareJsNode $this$visitVariable_u24lambda_u249 = sourceInfoAwareJsNode = new JsVars(variable2);
        boolean bl2 = false;
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u249, syntheticVariable);
        return (JsStatement)((Object)sourceInfoAwareJsNode);
    }

    @Override
    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getConstructedClassType((IrConstructor)expression2.getSymbol().getOwner()))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (IrJsUtilsKt.isUnitInstanceFunction(expression2.getSymbol(), data2.getStaticContext().getBackendContext())) {
            return JsEmpty.INSTANCE;
        }
        if (data2.checkIfJsCode(expression2.getSymbol()) || data2.checkIfHasAssociatedJsCode(expression2.getSymbol())) {
            return new JsCallTransformer(expression2, data2).generateStatement();
        }
        JsStatement jsStatement = ((JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.translateCall(expression2, data2, new IrElementToJsExpressionTransformer()), expression2, data2, null, null, 12, null)).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "translateCall(expression\u2026ression, data).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context) {
        JsCatch jsCatch;
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        Intrinsics.checkNotNullParameter(context, "context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept(this, context));
        IrCatch irCatch = CollectionsKt.singleOrNull(aTry.getCatches());
        if (irCatch != null) {
            IrCatch it = irCatch;
            boolean bl = false;
            JsName name2 = context.getNameForValueDeclaration(it.getCatchParameter());
            JsStatement jsCatchBlock = (JsStatement)it.getResult().accept(this, context);
            jsCatch = (JsCatch)JsAstUtilsKt.withSource$default(new JsCatch(JsGenerationContextKt.getEmptyScope(), name2.getIdent(), jsCatchBlock), it, context, null, null, 12, null);
        } else {
            jsCatch = null;
        }
        JsCatch jsCatch2 = jsCatch;
        Object object = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = object != null && (object = (JsStatement)object.accept(this, context)) != null ? JsAstUtilsKt.asBlock((JsStatement)object) : null;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock), aTry, context, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        JsStatement jsStatement = new SwitchOptimizer(context).tryOptimize(expression2);
        if (jsStatement == null && (jsStatement = (JsStatement)JsAstUtilsKt.toJsNode$default(expression2, this, context, visitWhen.1.INSTANCE, null, 8, null)) == null) {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName label = context.getNameForLoop(loop2);
        JsExpression jsExpression = (JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context);
        Object object = loop2.getBody();
        if (object == null || (object = (JsStatement)object.accept(this, context)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsWhile loopStatement = new JsWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        Intrinsics.checkNotNullParameter(context, "context");
        JsName label = context.getNameForLoop(loop2);
        JsExpression jsExpression = (JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context);
        Object object = loop2.getBody();
        if (object == null || (object = (JsStatement)object.accept(this, context)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsDoWhile loopStatement = new JsDoWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConst(@NotNull IrConst<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantArray(@NotNull IrConstantArray expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantObject(@NotNull IrConstantObject expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantValue(@NotNull IrConstantValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitField(@NotNull IrField declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFile(@NotNull IrFile declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitProperty(@NotNull IrProperty declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitScript(@NotNull IrScript declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public JsStatement visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVararg(this, expression2, data2);
    }
}

