/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleImport;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleRef;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleReferences;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleTransitiveExport;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleHeader;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0005H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0005H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder;", "", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "header", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "relativeRequirePath", "", "(Lorg/jetbrains/kotlin/serialization/js/ModuleKind;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;Z)V", "exportNames", "", "", "exports", "", "getExports", "()Ljava/util/Set;", "getHeader", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "imports", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleRef;", "getImports", "()Ljava/util/List;", "getModuleKind", "()Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "getRelativeRequirePath", "()Z", "transitiveJsExportFrom", "", "getTransitiveJsExportFrom", "setTransitiveJsExportFrom", "(Ljava/util/List;)V", "buildCrossModuleRefs", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleReferences;", "buildExportNames", "", "moduleHeader", "toJsImportedModule", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsIrProgramFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsIrProgramFragment.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,271:1\n1271#2,2:272\n1285#2,4:274\n1179#2,2:278\n1253#2,4:280\n1603#2,9:284\n1855#2:293\n1856#2:295\n1612#2:296\n1#3:294\n1#3:297\n372#4,7:298\n*S KotlinDebug\n*F\n+ 1 JsIrProgramFragment.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder\n*L\n150#1:272,2\n150#1:274,4\n166#1:278,2\n166#1:280,4\n178#1:284,9\n178#1:293\n178#1:295\n178#1:296\n178#1:294\n162#1:298,7\n*E\n"})
final class JsIrModuleCrossModuleReferenceBuilder {
    @NotNull
    private final ModuleKind moduleKind;
    @NotNull
    private final JsIrModuleHeader header;
    private final boolean relativeRequirePath;
    @NotNull
    private final List<CrossModuleRef> imports;
    @NotNull
    private final Set<String> exports;
    @NotNull
    private List<JsIrModuleHeader> transitiveJsExportFrom;
    private Map<String, String> exportNames;

    public JsIrModuleCrossModuleReferenceBuilder(@NotNull ModuleKind moduleKind, @NotNull JsIrModuleHeader header, boolean relativeRequirePath) {
        Intrinsics.checkNotNullParameter((Object)moduleKind, "moduleKind");
        Intrinsics.checkNotNullParameter(header, "header");
        this.moduleKind = moduleKind;
        this.header = header;
        this.relativeRequirePath = relativeRequirePath;
        this.imports = new ArrayList();
        this.exports = new LinkedHashSet();
        this.transitiveJsExportFrom = CollectionsKt.emptyList();
    }

    @NotNull
    public final ModuleKind getModuleKind() {
        return this.moduleKind;
    }

    @NotNull
    public final JsIrModuleHeader getHeader() {
        return this.header;
    }

    public final boolean getRelativeRequirePath() {
        return this.relativeRequirePath;
    }

    @NotNull
    public final List<CrossModuleRef> getImports() {
        return this.imports;
    }

    @NotNull
    public final Set<String> getExports() {
        return this.exports;
    }

    @NotNull
    public final List<JsIrModuleHeader> getTransitiveJsExportFrom() {
        return this.transitiveJsExportFrom;
    }

    public final void setTransitiveJsExportFrom(@NotNull List<JsIrModuleHeader> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.transitiveJsExportFrom = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildExportNames() {
        void $this$associateWith$iv;
        int index2 = 0;
        Iterable iterable = CollectionsKt.sorted((Iterable)this.exports);
        JsIrModuleCrossModuleReferenceBuilder jsIrModuleCrossModuleReferenceBuilder = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            int n = index2;
            index2 = n + 1;
            String string3 = NameTablesKt.toJsIdentifier(n);
            map.put(t, string3);
        }
        jsIrModuleCrossModuleReferenceBuilder.exportNames = result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CrossModuleReferences buildCrossModuleRefs() {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$associateTo$iv$iv;
        this.buildExportNames();
        boolean isImportOptional = this.moduleKind == ModuleKind.ES;
        Map importedModules = new LinkedHashMap();
        Iterable $this$associate$iv = this.imports;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            String exportedAs;
            object = destination$iv$iv;
            Object crossModuleRef = (CrossModuleRef)element$iv$iv;
            boolean bl = false;
            String tag = ((CrossModuleRef)crossModuleRef).getTag();
            if (!(((CrossModuleRef)crossModuleRef).getModule().exportNames != null)) {
                boolean $i$a$-require-JsIrModuleCrossModuleReferenceBuilder$buildCrossModuleRefs$resultImports$1$22 = false;
                String $i$a$-require-JsIrModuleCrossModuleReferenceBuilder$buildCrossModuleRefs$resultImports$1$22 = "Cross module dependency resolution failed due to signature '" + tag + "' redefinition";
                throw new IllegalArgumentException($i$a$-require-JsIrModuleCrossModuleReferenceBuilder$buildCrossModuleRefs$resultImports$1$22.toString());
            }
            Map<String, String> map = ((CrossModuleRef)crossModuleRef).getModule().exportNames;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exportNames");
                map = null;
            }
            Intrinsics.checkNotNull(map.get(tag));
            JsImportedModule importedModule = JsIrModuleCrossModuleReferenceBuilder.buildCrossModuleRefs$import(isImportOptional, this, importedModules, ((CrossModuleRef)crossModuleRef).getModule().header);
            crossModuleRef = TuplesKt.to(tag, new CrossModuleImport(exportedAs, importedModule));
            object.put(((Pair)crossModuleRef).getFirst(), ((Pair)crossModuleRef).getSecond());
        }
        Map resultImports = destination$iv$iv;
        Iterable $this$mapNotNull$iv = this.transitiveJsExportFrom;
        boolean $i$f$mapNotNull = false;
        $this$associateTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            CrossModuleTransitiveExport it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            JsIrModuleHeader it = (JsIrModuleHeader)element$iv$iv;
            boolean bl2 = false;
            if ((!it.getHasJsExports() ? null : new CrossModuleTransitiveExport(JsIrModuleCrossModuleReferenceBuilder.buildCrossModuleRefs$import(isImportOptional, this, importedModules, it).getInternalName(), it.getExternalModuleName())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List transitiveExport = (List)destination$iv$iv;
        List<JsImportedModule> list2 = CollectionsKt.toList(importedModules.values());
        Map<String, String> map = this.exportNames;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException("exportNames");
            map = null;
        }
        return new CrossModuleReferences(this.moduleKind, list2, transitiveExport, map, resultImports);
    }

    private final JsImportedModule toJsImportedModule(JsIrModuleHeader $this$toJsImportedModule) {
        JsName jsModuleName = new JsName($this$toJsImportedModule.getModuleName(), false);
        String relativeRequirePath = this.relativeRequirePath($this$toJsImportedModule);
        return new JsImportedModule($this$toJsImportedModule.getExternalModuleName(), jsModuleName, null, relativeRequirePath);
    }

    private final String relativeRequirePath(JsIrModuleHeader moduleHeader) {
        String relativePath;
        String string2;
        if (!this.relativeRequirePath) {
            return null;
        }
        File file2 = new File(this.header.getExternalModuleName()).getParentFile();
        if (file2 == null) {
            return "./" + moduleHeader.getExternalModuleName();
        }
        File parentMain = file2;
        String string3 = FilesKt.toRelativeString(new File(moduleHeader.getExternalModuleName()), parentMain);
        String string4 = File.separator;
        Intrinsics.checkNotNullExpressionValue(string4, "separator");
        String it = string2 = (relativePath = StringsKt.replace$default(string3, string4, "/", false, 4, null));
        boolean bl = false;
        String string5 = StringsKt.startsWith$default(it, "../", false, 2, null) ? string2 : null;
        if (string5 == null) {
            string5 = "./" + relativePath;
        }
        return string5;
    }

    private static final JsImportedModule buildCrossModuleRefs$import(boolean isImportOptional, JsIrModuleCrossModuleReferenceBuilder this$0, Map<JsIrModuleHeader, JsImportedModule> importedModules, JsIrModuleHeader moduleHeader) {
        JsImportedModule jsImportedModule;
        if (isImportOptional) {
            jsImportedModule = this$0.toJsImportedModule(moduleHeader);
        } else {
            JsImportedModule jsImportedModule2;
            Map<JsIrModuleHeader, JsImportedModule> $this$getOrPut$iv = importedModules;
            boolean $i$f$getOrPut = false;
            JsImportedModule value$iv = $this$getOrPut$iv.get(moduleHeader);
            if (value$iv == null) {
                boolean bl = false;
                JsImportedModule answer$iv = this$0.toJsImportedModule(moduleHeader);
                $this$getOrPut$iv.put(moduleHeader, answer$iv);
                jsImportedModule2 = answer$iv;
            } else {
                jsImportedModule2 = value$iv;
            }
            jsImportedModule = jsImportedModule2;
        }
        return jsImportedModule;
    }
}

