/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010(\u001a\u00020#J\b\u0010+\u001a\u00020'H\u0016R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "receiverClass", "Ljava/lang/Class;", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "getValue", "()Ljava/lang/Object;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getJavaOriginalName", "", "irFunction", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n2908#2,12:301\n2908#2,12:349\n12474#2,2:410\n1603#3,9:313\n1855#3:322\n1856#3:324\n1612#3:325\n618#3,12:326\n800#3,11:338\n1603#3,9:361\n1855#3:370\n1856#3:372\n1612#3:373\n618#3,12:374\n800#3,11:386\n800#3,11:397\n288#3:409\n289#3:412\n1#4:323\n1#4:371\n1#4:408\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper\n*L\n38#1:301,12\n44#1:349,12\n69#1:410,2\n39#1:313,9\n39#1:322\n39#1:324\n39#1:325\n40#1:326,12\n41#1:338,11\n45#1:361,9\n45#1:370\n45#1:372\n45#1:373\n46#1:374,12\n47#1:386,11\n50#1:397,11\n69#1:409\n69#1:412\n39#1:323\n45#1:371\n*E\n"})
public final class Wrapper
implements Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf(TuplesKt.to("kotlin.text.Regex$Companion", Regex.Companion));
    @NotNull
    private static final Set<String> intrinsicClasses;
    @NotNull
    private static final Map<String, String> intrinsicFunctionToHandler;
    @NotNull
    private static final Set<String> ranges;

    /*
     * WARNING - void declaration
     */
    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
        IrClass mutableMap;
        Object[] $this$single$iv;
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(environment, "environment");
        this.value = value2;
        this.irClass = irClass2;
        this.fields = new LinkedHashMap();
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
        Class<?> javaClass = this.value.getClass();
        if (Intrinsics.areEqual(javaClass, HashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            Map<Class<?>, IrClass> $this$single$iv2;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, "javaClass.declaredClasses");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "it.name");
                if (!StringsKt.contains$default((CharSequence)string2, "$Node", false, 2, null)) continue;
                if (found$iv22) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class nodeClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl3 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single22 = false;
            Object single$iv2 = null;
            boolean found$iv32 = false;
            Iterator $i$f$mapNotNullTo22 = $this$single$iv2.iterator();
            while ($i$f$mapNotNullTo22.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo22.next();
                IrClass it = (IrClass)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual(it.getName(), StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv32) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv32 = true;
            }
            if (!found$iv32) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv2;
            $this$single$iv2 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single22 = mutableMap.getDeclarations();
            Class clazz = nodeClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv32 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = TuplesKt.to(clazz, CollectionsKt.single((List)destination$iv$iv2));
            $this$single$iv2.put($this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual(javaClass, LinkedHashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv2;
            Map<Class<?>, IrClass> $this$single$iv3;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, "javaClass.declaredClasses");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv42 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "it.name");
                if (!StringsKt.contains$default((CharSequence)string3, "$Entry", false, 2, null)) continue;
                if (found$iv42) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv42 = true;
            }
            if (!found$iv42) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class entryClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv42 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl6 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl7 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single32 = false;
            Object single$iv3 = null;
            boolean found$iv52 = false;
            Iterator $i$f$mapNotNullTo32 = $this$single$iv3.iterator();
            while ($i$f$mapNotNullTo32.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo32.next();
                IrClass it = (IrClass)element$iv;
                boolean bl9 = false;
                if (!Intrinsics.areEqual(it.getName(), StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv52) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv3 = element$iv;
                found$iv52 = true;
            }
            if (!found$iv52) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv3;
            $this$single$iv3 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single32 = mutableMap.getDeclarations();
            Class clazz = entryClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv52 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = TuplesKt.to(clazz, CollectionsKt.single((List)destination$iv$iv3));
            $this$single$iv3.put($this$filterIsInstance$iv2.getFirst(), (IrClass)$this$filterIsInstance$iv2.getSecond());
        } else if (Intrinsics.areEqual(javaClass.getCanonicalName(), "java.util.Collections.SingletonMap")) {
            void $this$filterIsInstanceTo$iv$iv;
            Map<Class<?>, IrClass> $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable $this$filterIsInstance$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IrClass irClassMapEntry = (IrClass)CollectionsKt.single((List)destination$iv$iv);
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            Pair<Class, IrClass> $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleEntry.class, irClassMapEntry);
            $this$filterIsInstance$iv.put($i$f$filterIsInstance22.getFirst(), $i$f$filterIsInstance22.getSecond());
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleImmutableEntry.class, irClassMapEntry);
            $this$filterIsInstance$iv.put($i$f$filterIsInstance22.getFirst(), $i$f$filterIsInstance22.getSecond());
        }
        IrClass it = environment.getJavaClassToIrClass$ir_interpreter().get(this.value.getClass());
        boolean bl = false;
        boolean bl10 = it == null || IrUtilsKt.isSubclassOf(this.getIrClass(), it);
        if (bl10) {
            environment.getJavaClassToIrClass$ir_interpreter().put(this.value.getClass(), this.getIrClass());
        }
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        Object v4;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            Object object = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            String propertyName = object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null && (object = object.getName()) != null ? ((Name)object).asString() : null;
            Object object2 = new String[2];
            object2[0] = propertyName;
            String string2 = propertyName;
            object2[1] = "get" + (string2 != null ? CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2) : null);
            object2 = CollectionsKt.listOfNotNull(object2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block3: {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue(methodArray, "receiverClass.methods");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(method.getName(), it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        String propertyCall = v4;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        String string3 = intrinsicName;
        if (string3 == null && (string3 = propertyCall) == null) {
            String string4 = irFunction2.getName().toString();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "irFunction.name.toString()");
        }
        String methodName = string3;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, methodName, methodType);
    }

    private final String getJavaOriginalName(IrFunction irFunction2) {
        String string2;
        switch (UtilsKt.getFqName(UtilsKt.getLastOverridden(irFunction2))) {
            case "kotlin.collections.Map.<get-entries>": {
                string2 = "entrySet";
                break;
            }
            case "kotlin.collections.Map.<get-keys>": {
                string2 = "keySet";
                break;
            }
            case "kotlin.CharSequence.get": {
                string2 = "charAt";
                break;
            }
            case "kotlin.collections.MutableList.removeAt": {
                string2 = "remove";
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    static {
        Object[] objectArray = new String[]{"kotlin.text.StringBuilder", "kotlin.Pair", "kotlin.collections.ArrayList", "kotlin.collections.HashMap", "kotlin.collections.LinkedHashMap", "kotlin.collections.HashSet", "kotlin.collections.LinkedHashSet", "kotlin.text.RegexOption", "kotlin.text.Regex", "kotlin.text.Regex.Companion", "kotlin.text.MatchGroup"};
        intrinsicClasses = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to("Array.kotlin.collections.asList()", "kotlin.collections.ArraysKt"), TuplesKt.to("kotlin.collections.mutableListOf(Array)", "kotlin.collections.CollectionsKt"), TuplesKt.to("kotlin.collections.arrayListOf(Array)", "kotlin.collections.CollectionsKt"), TuplesKt.to("Char.kotlin.text.isWhitespace()", "kotlin.text.CharsKt"), TuplesKt.to("Array.kotlin.collections.toMutableList()", "kotlin.collections.ArraysKt"), TuplesKt.to("Array.kotlin.collections.copyToArrayOfAny(Boolean)", "kotlin.collections.CollectionsKt")};
        intrinsicFunctionToHandler = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"kotlin.ranges.CharRange", "kotlin.ranges.IntRange", "kotlin.ranges.LongRange"};
        ranges = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!*\u00020\"2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0017\u0010$\u001a\u0006\u0012\u0002\b\u00030!*\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u0004\u0018\u00010\u0005*\u00020\u0013H\u0002J\f\u0010(\u001a\u00020)*\u00020\u0013H\u0002J\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+*\u00020\u0013H\u0002J\f\u0010-\u001a\u00020\u0005*\u00020\u0013H\u0002J\f\u0010.\u001a\u00020\u001d*\u00020\u0013H\u0002J\f\u0010/\u001a\u00020\u001d*\u00020\u0013H\u0002J\u0014\u00100\u001a\u00020\u001d*\u00020\u00132\u0006\u00101\u001a\u00020%H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "intrinsicClasses", "", "intrinsicFunctionToHandler", "ranges", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "irEnumClass", "getReflectionMethod", "irFunction", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "mustBeHandledWithWrapper", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getCorrespondingFunction", "", "(Ljava/lang/Integer;)Ljava/lang/Class;", "getJvmClassName", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSignature", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1#2:301\n1549#3:302\n1620#3,3:303\n1855#3,2:306\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion\n*L\n188#1:302\n188#1:303,3\n268#1:306,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getSignature(IrFunction $this$getSignature) {
            Object object;
            String fqName2;
            block5: {
                block4: {
                    fqName2 = UtilsKt.getFqName($this$getSignature);
                    Object object2 = $this$getSignature.getDispatchReceiverParameter();
                    if (object2 == null) {
                        object2 = object = $this$getSignature.getExtensionReceiverParameter();
                    }
                    if (object2 == null || (object = object.getType()) == null || (object = UtilsKt.getOnlyName((IrType)object)) == null) break block4;
                    Object it = object;
                    boolean bl = false;
                    String string2 = (String)it + '.';
                    object = string2;
                    if (string2 != null) break block5;
                }
                object = "";
            }
            Object receiver = object;
            return CollectionsKt.joinToString$default($this$getSignature.getValueParameters(), null, (String)receiver + fqName2 + '(', ")", 0, null, getSignature.1.INSTANCE, 25, null);
        }

        private final String getJvmClassName(IrFunction $this$getJvmClassName) {
            return (String)intrinsicFunctionToHandler.get(this.getSignature($this$getJvmClassName));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean mustBeHandledWithWrapper(@NotNull IrDeclarationWithName declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (declaration instanceof IrFunction) {
                return intrinsicFunctionToHandler.containsKey(this.getSignature((IrFunction)declaration));
            }
            String fqName2 = UtilsKt.getFqName(declaration);
            if (ranges.contains(fqName2)) {
                IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor((IrClass)declaration);
                Intrinsics.checkNotNull(irConstructor2);
                if (irConstructor2.getBody() == null) {
                    return true;
                }
            }
            if (intrinsicClasses.contains(fqName2)) return true;
            if (!StringsKt.startsWith$default(fqName2, "java", false, 2, null)) return false;
            return true;
        }

        @NotNull
        public final MethodHandle getReflectionMethod(@NotNull IrFunction irFunction2) {
            String string2;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            Class<? extends Object> receiverClass = this.getClass(irValueParameter.getType(), true);
            MethodType methodType = this.getMethodType(irFunction2);
            if (irFunction2 instanceof IrSimpleFunction) {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                IrProperty property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                IrProperty irProperty2 = property;
                if (Intrinsics.areEqual(irProperty2 != null ? irProperty2.getGetter() : null, irFunction2)) {
                    StringBuilder stringBuilder2 = new StringBuilder().append("get");
                    String string3 = property.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string3, "property.name.asString()");
                    string2 = stringBuilder2.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string3)).toString();
                } else {
                    IrProperty irProperty3 = property;
                    if (Intrinsics.areEqual(irProperty3 != null ? irProperty3.getSetter() : null, irFunction2)) {
                        StringBuilder stringBuilder3 = new StringBuilder().append("set");
                        String string4 = property.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string4, "property.name.asString()");
                        string2 = stringBuilder3.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string4)).toString();
                    } else {
                        String string5 = irFunction2.getName().asString();
                        string2 = string5;
                        Intrinsics.checkNotNullExpressionValue(string5, "irFunction.name.asString()");
                    }
                }
            } else {
                String string6 = irFunction2.getName().asString();
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "irFunction.name.asString()");
            }
            String methodName = string2;
            MethodHandle methodHandle = MethodHandles.lookup().findVirtual(receiverClass, methodName, methodType);
            Intrinsics.checkNotNullExpressionValue(methodHandle, "lookup().findVirtual(rec\u2026, methodName, methodType)");
            return methodHandle;
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2, @NotNull IrInterpreterEnvironment environment) {
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            Intrinsics.checkNotNullParameter(environment, "environment");
            String objectName = UtilsKt.internalName(irClass2);
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new InternalError("Companion object " + objectName + " cannot be interpreted");
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2, environment);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter(irConstructor2, "irConstructor");
            String intrinsicValue = UtilsKt.internalName(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual(intrinsicValue, "kotlin.Char") || Intrinsics.areEqual(intrinsicValue, "kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = intrinsicName = this.getJvmClassName(irFunction2);
            if (!(string2 != null ? !(((CharSequence)string2).length() == 0) : false)) {
                return null;
            }
            Class<?> jvmClass = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClass, irFunction2.getName().asString(), methodType);
        }

        @NotNull
        public final MethodHandle getStaticGetter(@NotNull IrField field2) {
            Intrinsics.checkNotNullParameter(field2, "field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field2)), true);
            IrType it = field2.getType();
            boolean bl = false;
            Class<? extends Object> returnType2 = Companion.getClass(it, IrTypeUtilsKt.isNullable(it));
            MethodHandle methodHandle = MethodHandles.lookup().findStaticGetter(jvmClass, field2.getName().asString(), returnType2);
            Intrinsics.checkNotNullExpressionValue(methodHandle, "lookup().findStaticGette\u2026e.asString(), returnType)");
            return methodHandle;
        }

        @NotNull
        public final MethodHandle getEnumEntry(@NotNull IrClass irEnumClass) {
            Intrinsics.checkNotNullParameter(irEnumClass, "irEnumClass");
            String intrinsicName = UtilsKt.internalName(irEnumClass);
            Class<?> jvmEnumClass = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(jvmEnumClass, String.class);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(jvmEnumClass, StandardNames.ENUM_VALUE_OF.getIdentifier(), methodType);
            Intrinsics.checkNotNullExpressionValue(methodHandle, "lookup().findStatic(jvmE\u2026F.identifier, methodType)");
            return methodHandle;
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex())));
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrAnnotationContainer irAnnotationContainer = $this$getMethodType.getExtensionReceiverParameter();
                Class<? extends Object> extensionClass = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? this.getClass((IrType)irAnnotationContainer, this.isExtensionReceiverPrimitive($this$getMethodType)) : null;
                MethodType methodType2 = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
                methodType = methodType2;
                Intrinsics.checkNotNullExpressionValue(methodType2, "{\n                // for\u2026rgsClasses)\n            }");
            } else {
                MethodType methodType3 = MethodType.methodType(Void.TYPE, argsClasses);
                methodType = methodType3;
                Intrinsics.checkNotNullExpressionValue(methodType3, "{\n                // for\u2026rgsClasses)\n            }");
            }
            return methodType;
        }

        private final Class<?> getCorrespondingFunction(Integer $this$getCorrespondingFunction) {
            Class<?> clazz;
            if ($this$getCorrespondingFunction == null || $this$getCorrespondingFunction >= 23) {
                Class<?> clazz2 = Class.forName("kotlin.jvm.functions.FunctionN");
                clazz = clazz2;
                Intrinsics.checkNotNullExpressionValue(clazz2, "forName(\"kotlin.jvm.functions.FunctionN\")");
            } else {
                Class<?> clazz3 = Class.forName("kotlin.jvm.functions.Function" + $this$getCorrespondingFunction);
                clazz = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz3, "forName(\"kotlin.jvm.functions.Function$this\")");
            }
            return clazz;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class<Object> clazz;
            IrClass owner;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass irClass2 = owner = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            String fqName2 = irClass2 != null ? UtilsKt.getFqName(irClass2) : null;
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz2;
                Intrinsics.checkNotNull(clazz2);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                Class clazz3;
                Intrinsics.checkNotNull($this$getClass, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                Object object = IrTypesKt.getTypeOrNull(CollectionsKt.single(((IrSimpleType)$this$getClass).getArguments()));
                String argumentFqName = object != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null && (object = (IrClass)object.getOwner()) != null ? UtilsKt.getFqName((IrElement)object) : null;
                if (argumentFqName != null && !Intrinsics.areEqual(argumentFqName, "kotlin.Any")) {
                    String it = argumentFqName;
                    boolean bl = false;
                    clazz3 = Class.forName("[L" + it + ';');
                } else {
                    clazz3 = Object[].class;
                }
                Class<Object[]> clazz4 = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz4, "{\n                    va\u2026      }\n                }");
                clazz = clazz4;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isUnit(notNullType)) {
                if (asObject) {
                    clazz = Void.class;
                } else {
                    Class<Void> clazz5 = Void.TYPE;
                    clazz = clazz5;
                    Intrinsics.checkNotNull(clazz5);
                }
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isKFunction(notNullType) || org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isKSuspendFunction(notNullType)) {
                Class<?> clazz6 = Class.forName("kotlin.reflect.KFunction");
                clazz = clazz6;
                Intrinsics.checkNotNullExpressionValue(clazz6, "forName(\"kotlin.reflect.KFunction\")");
            } else {
                if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isFunction(notNullType)) {
                    String string2 = fqName2;
                    Integer arity = string2 != null && (string2 = StringsKt.removePrefix(string2, (CharSequence)"kotlin.Function")) != null ? StringsKt.toIntOrNull(string2) : null;
                    return this.getCorrespondingFunction(arity);
                }
                if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isSuspendFunction(notNullType)) {
                    throw new IllegalStateException(("Interpretation of " + fqName2 + " is not supported").toString());
                }
                if (Intrinsics.areEqual(fqName2, "kotlin.Enum")) {
                    clazz = Enum.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Collection") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableCollection")) {
                    clazz = Collection.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.List") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableList")) {
                    clazz = List.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Set") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableSet")) {
                    clazz = Set.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap")) {
                    clazz = Map.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.ListIterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableListIterator")) {
                    clazz = ListIterator.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Iterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableIterator")) {
                    clazz = Iterator.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map.Entry") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap.MutableEntry")) {
                    clazz = Map.Entry.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.ArrayList")) {
                    clazz = ArrayList.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.HashMap")) {
                    clazz = HashMap.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.HashSet")) {
                    clazz = HashSet.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.LinkedHashMap")) {
                    clazz = LinkedHashMap.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.LinkedHashSet")) {
                    clazz = LinkedHashSet.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.text.StringBuilder")) {
                    clazz = StringBuilder.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.text.Appendable")) {
                    clazz = Appendable.class;
                } else if (fqName2 == null) {
                    clazz = Object.class;
                } else {
                    Class<?> clazz7 = Class.forName(UtilsKt.internalName(owner));
                    clazz = clazz7;
                    Intrinsics.checkNotNullExpressionValue(clazz7, "forName(owner.internalName())");
                }
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                ListIterator iterator2;
                List pool = CollectionsKt.toMutableList(((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator listIterator = iterator2 = pool.listIterator();
                while (listIterator.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)listIterator.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        ((Collection)overriddenSymbols2).add(symbol2);
                        iterator2.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        iterator2.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrAnnotationContainer irAnnotationContainer = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? !IrTypePredicatesKt.isPrimitiveType$default((IrType)irAnnotationContainer, false, 1, null) : false;
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

