/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ChangeFormComponentTypeFix
implements IntentionAction {
    @FileModifier.SafeFieldForPreview
    private final PsiPlainTextFile myFormFile;
    private final String myFieldName;
    private final String myComponentTypeToSet;

    public ChangeFormComponentTypeFix(PsiPlainTextFile formFile, String fieldName, PsiType componentTypeToSet) {
        PsiClass psiClass;
        this.myFormFile = formFile;
        this.myFieldName = fieldName;
        this.myComponentTypeToSet = componentTypeToSet instanceof PsiClassType ? ((psiClass = ((PsiClassType)componentTypeToSet).resolve()) != null ? ClassUtil.getJVMClassName((PsiClass)psiClass) : ((PsiClassType)componentTypeToSet).rawType().getCanonicalText()) : componentTypeToSet.getCanonicalText();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"uidesigner.change.gui.component.type", (Object[])new Object[0]);
        if (string == null) {
            ChangeFormComponentTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ChangeFormComponentTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeFormComponentTypeFix.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ChangeFormComponentTypeFix.$$$reportNull$$$0(3);
        }
        CommandProcessor.getInstance().executeCommand(file.getProject(), () -> {
            ReadonlyStatusHandler readOnlyHandler = ReadonlyStatusHandler.getInstance((Project)this.myFormFile.getProject());
            ReadonlyStatusHandler.OperationStatus status = readOnlyHandler.ensureFilesWritable(Collections.singletonList(this.myFormFile.getVirtualFile()));
            if (!status.hasReadonlyFiles()) {
                FormReferenceProvider.setGUIComponentType(this.myFormFile, this.myFieldName, this.myComponentTypeToSet);
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/ChangeFormComponentTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

