/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.Nullable;

public abstract class EventProcessor {
    private Cursor myCursor;

    public final Cursor getCursor() {
        return this.myCursor;
    }

    public final void setCursor(Cursor cursor) {
        this.myCursor = cursor;
    }

    protected abstract void processKeyEvent(KeyEvent var1);

    protected abstract void processMouseEvent(MouseEvent var1);

    protected abstract boolean cancelOperation();

    public boolean isDragActive() {
        return false;
    }

    public boolean needMousePressed() {
        return false;
    }

    protected static ComponentDropLocation.Direction directionFromKey(int keyCode) {
        return switch (keyCode) {
            case 35, 39 -> ComponentDropLocation.Direction.RIGHT;
            case 36, 37 -> ComponentDropLocation.Direction.LEFT;
            case 33, 38 -> ComponentDropLocation.Direction.UP;
            case 34, 40 -> ComponentDropLocation.Direction.DOWN;
            default -> null;
        };
    }

    private static boolean isMoveToLast(int keyCode) {
        return keyCode == 36 || keyCode == 35 || keyCode == 33 || keyCode == 34;
    }

    @Nullable
    protected static ComponentDropLocation moveDropLocation(GuiEditor editor, ComponentDropLocation location, ComponentDragObject dragObject, KeyEvent e) {
        ComponentDropLocation.Direction dir = EventProcessor.directionFromKey(e.getKeyCode());
        boolean moveToLast = EventProcessor.isMoveToLast(e.getKeyCode());
        if (dir != null && location != null) {
            ComponentDropLocation adjacentLocation;
            e.consume();
            if (moveToLast) {
                ComponentDropLocation lastLocation = location;
                for (adjacentLocation = location.getAdjacentLocation(dir); adjacentLocation != null; adjacentLocation = adjacentLocation.getAdjacentLocation(dir)) {
                    if (!adjacentLocation.canDrop(dragObject)) continue;
                    lastLocation = adjacentLocation;
                }
                adjacentLocation = lastLocation;
            } else {
                for (adjacentLocation = location.getAdjacentLocation(dir); adjacentLocation != null && !adjacentLocation.canDrop(dragObject); adjacentLocation = adjacentLocation.getAdjacentLocation(dir)) {
                }
            }
            if (adjacentLocation != null && adjacentLocation.canDrop(dragObject)) {
                adjacentLocation.placeFeedback(editor.getActiveDecorationLayer(), dragObject);
                return adjacentLocation;
            }
        }
        return location;
    }
}

