/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.classFilter.ClassFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BreakpointComment {
    @Nullable
    private String kind;
    @Nullable
    private String kindValue;
    private final Map<@NotNull String, @NotNull String> values;
    private final Map<@NotNull String, Integer> index;
    private final Set<@NotNull String> validValues;
    @NotNull
    private final String fileName;
    private final int lineNumber;

    @NotNull
    public static BreakpointComment parse(@NotNull String text, @NotNull String fileName, int lineNumber) {
        if (text == null) {
            BreakpointComment.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            BreakpointComment.$$$reportNull$$$0(1);
        }
        BreakpointComment comment = new BreakpointComment(fileName, lineNumber);
        BreakpointComment breakpointComment = new Parser(text, comment).parse();
        if (breakpointComment == null) {
            BreakpointComment.$$$reportNull$$$0(2);
        }
        return breakpointComment;
    }

    private BreakpointComment(@NotNull String fileName, int lineNumber) {
        if (fileName == null) {
            BreakpointComment.$$$reportNull$$$0(3);
        }
        this.values = new LinkedHashMap<String, String>();
        this.index = new LinkedHashMap<String, Integer>();
        this.validValues = new TreeSet<String>();
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    @NotNull
    public String readKind() {
        String kind = this.kind;
        assert (kind != null);
        this.kind = null;
        String string = kind;
        if (string == null) {
            BreakpointComment.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String readKindValue() {
        String value = this.kindValue;
        this.kindValue = null;
        return value;
    }

    @Nullable
    public String readValue(@NotNull String name) {
        if (name == null) {
            BreakpointComment.$$$reportNull$$$0(5);
        }
        this.validValues.add(name);
        return this.values.remove(name);
    }

    @Nullable
    public Boolean readBooleanValue(@NotNull String name) {
        String value;
        if (name == null) {
            BreakpointComment.$$$reportNull$$$0(6);
        }
        if ((value = this.readValue(name)) == null) {
            return null;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw this.error("Invalid boolean value '" + value + "' for '" + name + "'", this.index.get(name));
    }

    @Nullable
    public Integer readIntValue(@NotNull String name) {
        String value;
        if (name == null) {
            BreakpointComment.$$$reportNull$$$0(7);
        }
        if ((value = this.readValue(name)) == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.error("Invalid integer value '" + value + "' for '" + name + "'", this.index.get(name));
        }
    }

    @NotNull
    public static Pair<ClassFilter[], ClassFilter[]> parseClassFilters(@NotNull String value) {
        if (value == null) {
            BreakpointComment.$$$reportNull$$$0(8);
        }
        ArrayList<ClassFilter> include = new ArrayList<ClassFilter>();
        ArrayList<ClassFilter> exclude = new ArrayList<ClassFilter>();
        for (String pattern : value.split(",")) {
            if (pattern.startsWith("-")) {
                exclude.add(new ClassFilter(pattern.substring(1)));
                continue;
            }
            include.add(new ClassFilter(pattern));
        }
        Pair pair = Pair.create((Object)include.toArray(ClassFilter.EMPTY_ARRAY), (Object)exclude.toArray(ClassFilter.EMPTY_ARRAY));
        if (pair == null) {
            BreakpointComment.$$$reportNull$$$0(9);
        }
        return pair;
    }

    public void done() {
        if (this.kind != null) {
            throw this.error("Unprocessed kind '" + this.kind + "'");
        }
        if (this.kindValue != null) {
            throw this.error("Unprocessed kind value '" + this.kindValue + "'");
        }
        if (this.values.size() >= 1) {
            String valid = String.join((CharSequence)", ", this.validValues);
            String msg = "Unprocessed %s '%s', %s".formatted(this.values.size() > 1 ? "values" : "value", String.join((CharSequence)", ", this.values.keySet()), this.validValues.size() > 1 ? "valid values are '" + valid + "'" : (this.validValues.size() == 1 ? "the only valid value is '" + valid + "'" : "the breakpoint takes no values"));
            throw this.error(msg, this.index.get(this.values.keySet().iterator().next()));
        }
    }

    @NotNull
    private RuntimeException error(String msg) {
        return new IllegalArgumentException(msg + " at " + this.fileName + ":" + (this.lineNumber + 1));
    }

    @NotNull
    private RuntimeException error(String msg, int index) {
        return new IllegalArgumentException(msg + " at " + this.fileName + ":" + (this.lineNumber + 1) + ":" + (index + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/BreakpointComment";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/BreakpointComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readBooleanValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readIntValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseClassFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 9 -> new IllegalStateException(string);
        };
    }

    private static class Parser {
        private final int[] s;
        private final int len;
        private int i;
        private final BreakpointComment comment;

        private Parser(@NotNull String lineText, BreakpointComment comment) {
            if (lineText == null) {
                Parser.$$$reportNull$$$0(0);
            }
            this.s = lineText.codePoints().toArray();
            this.len = this.s.length;
            this.comment = comment;
        }

        @NotNull
        BreakpointComment parse() {
            int nameStart;
            while (this.i + 1 < this.len && (this.s[this.i] != 47 || this.s[this.i + 1] != 47)) {
                ++this.i;
            }
            this.skip(47);
            this.skip(47);
            this.skipWhitespace();
            String head = this.parseName();
            if (this.i < this.len && this.s[this.i] == 40) {
                this.comment.kind = head;
                this.comment.kindValue = this.parseValue();
                this.skipWhitespace();
                nameStart = this.i;
                String tail = this.parseName();
                if (!tail.equals("Breakpoint")) {
                    throw this.errorAt(nameStart, "Expected 'Breakpoint' instead of '" + tail + "'");
                }
            } else {
                String kind = head.replaceFirst("\\s*Breakpoint$", "");
                this.comment.kind = kind.isEmpty() ? "Line" : kind;
            }
            this.skip(33);
            while (this.i < this.len) {
                this.skipWhitespace();
                if (this.i >= this.len) break;
                nameStart = this.i;
                String key = this.parseName();
                if (key.isEmpty()) {
                    throw this.errorAt(this.i, "Expected breakpoint property key");
                }
                if (this.comment.values.containsKey(key)) {
                    throw this.errorAt(nameStart, "Duplicate property key '" + key + "'");
                }
                String value = this.parseValue();
                this.comment.values.put(key, value);
                this.comment.index.put(key, nameStart);
            }
            this.skipWhitespace();
            if (this.i < this.len) {
                throw this.errorAt(this.i, "Extra '" + new String(this.s, this.i, this.len - this.i) + "'");
            }
            BreakpointComment breakpointComment = this.comment;
            if (breakpointComment == null) {
                Parser.$$$reportNull$$$0(1);
            }
            return breakpointComment;
        }

        private void skipWhitespace() {
            while (this.i < this.len && Character.isWhitespace(this.s[this.i])) {
                ++this.i;
            }
        }

        private void skip(int cp) {
            if (this.i >= this.len || this.s[this.i] != cp) {
                throw this.errorAt(this.i, "Expected '" + Character.toString(cp) + "'");
            }
            ++this.i;
        }

        @NotNull
        private String parseName() {
            int start = this.i;
            while (this.i < this.len && (Character.isJavaIdentifierPart(this.s[this.i]) || Character.isWhitespace(this.s[this.i]))) {
                ++this.i;
            }
            if (this.i == start) {
                throw this.errorAt(start, "Expected a name");
            }
            return new String(this.s, start, this.i - start);
        }

        @NotNull
        private String parseValue() {
            this.skip(40);
            int start = this.i;
            int depth = 1;
            while (this.i < this.len) {
                if (this.s[this.i] == 40) {
                    ++depth;
                }
                if (this.s[this.i] == 41 && --depth == 0) {
                    return new String(this.s, start, this.i++ - start);
                }
                ++this.i;
            }
            throw this.errorAt(start, "Unfinished value '" + new String(this.s, start, this.len - start) + "'");
        }

        @NotNull
        private RuntimeException errorAt(int index, String msg) {
            return new IllegalArgumentException(msg + " at " + this.comment.fileName + ":" + (this.comment.lineNumber + 1) + ":" + (index + 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/BreakpointComment$Parser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/BreakpointComment$Parser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

