/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ClassesTreeStructureProvider;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.projectView.TestProjectTreeStructure;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.testFramework.TestSourceBasedTestCase;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseProjectViewTestCase
extends TestSourceBasedTestCase {
    protected TestProjectTreeStructure myStructure;
    protected Queryable.PrintInfo myPrintInfo;
    @NotNull
    protected String packageViewPaneId = "ProjectPane";

    @Override
    protected boolean isCreateDirectoryBasedProject() {
        return true;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myStructure = new TestProjectTreeStructure(this.myProject, this.getTestRootDisposable()){

            protected AbstractTreeNode<?> createRoot(@NotNull Project project2, @NotNull ViewSettings settings) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                return switch (BaseProjectViewTestCase.this.packageViewPaneId) {
                    case "ProjectPane" -> super.createRoot(project2, settings);
                    case "PackagesPane" -> new PackageViewProjectNode(project2, settings);
                    default -> throw new IllegalStateException("Unexpected value: " + BaseProjectViewTestCase.this.packageViewPaneId);
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/projectView/BaseProjectViewTestCase$1";
                objectArray[2] = "createRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        this.myStructure = null;
        super.tearDown();
    }

    protected void assertStructureEqual(PsiDirectory packageDirectory, @NonNls String expected) {
        this.assertStructureEqual(packageDirectory, expected, 17, this.myStructure);
    }

    protected void assertStructureEqual(PsiDirectory packageDirectory, @NonNls String expected, int maxRowCount) {
        this.assertStructureEqual(packageDirectory, expected, maxRowCount, this.myStructure);
    }

    protected void useStandardProviders() {
        this.getProjectTreeStructure().setProviders(new TreeStructureProvider[]{new ClassesTreeStructureProvider(this.myProject)});
    }

    protected AbstractProjectTreeStructure getProjectTreeStructure() {
        return this.myStructure;
    }

    private void assertStructureEqual(PsiDirectory root, String expected, int maxRowCount, AbstractProjectTreeStructure structure) {
        BaseProjectViewTestCase.assertNotNull((Object)root);
        PsiDirectoryNode rootNode = new PsiDirectoryNode(this.myProject, root, (ViewSettings)structure);
        this.assertStructureEqual(expected, maxRowCount, rootNode);
    }

    protected void assertStructureEqual(@NotNull String expected) {
        if (expected == null) {
            BaseProjectViewTestCase.$$$reportNull$$$0(0);
        }
        this.assertStructureEqual(expected, -1, this.myStructure.getRootElement());
    }

    private void assertStructureEqual(String expected, int maxRowCount, Object rootNode) {
        ProjectViewTestUtil.assertStructureEqual((AbstractTreeStructure)this.myStructure, expected, maxRowCount, PlatformTestUtil.createComparator(this.myPrintInfo), rootNode, this.myPrintInfo);
    }

    protected static void assertListsEqual(ListModel<?> model2, String expected) {
        BaseProjectViewTestCase.assertEquals((String)expected, (String)PlatformTestUtil.print(model2));
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure) {
        ProjectViewTestUtil.checkContainsMethod(rootElement, structure, kid -> {
            if (kid instanceof PackageElementNode) {
                return ((PackageElementNode)kid).getVirtualFiles();
            }
            return null;
        });
    }

    @Override
    protected String getTestPath() {
        return "projectView";
    }

    protected static String getPackageRelativePath() {
        return "com/package1";
    }

    protected PsiDirectory getPackageDirectory() {
        return this.getPackageDirectory(BaseProjectViewTestCase.getPackageRelativePath());
    }

    public static void sortClassesByName(PsiClass @NotNull [] classes) {
        if (classes == null) {
            BaseProjectViewTestCase.$$$reportNull$$$0(1);
        }
        Arrays.sort(classes, Comparator.comparing(NavigationItem::getName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/projectView/BaseProjectViewTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertStructureEqual";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sortClassesByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

