/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TeamCityLogger {
    private static final Logger LOG = Logger.getInstance(TeamCityLogger.class);
    public static final boolean isUnderTC = System.getProperty("bootstrap.testcases") != null;

    private TeamCityLogger() {
    }

    private static File reportFile() {
        return new File(PathManager.getHomePath() + "/reports/report.txt");
    }

    public static void info(String message) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, null);
        } else {
            LOG.info(message);
        }
    }

    public static void warning(String message) {
        TeamCityLogger.warning(message, new Throwable());
    }

    public static void warning(String message, @Nullable Throwable throwable) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, "WARNING");
        } else {
            LOG.warn(message, throwable);
        }
    }

    public static void error(String message) {
        TeamCityLogger.error(message, new Throwable());
    }

    public static void error(String message, @Nullable Throwable throwable) {
        if (isUnderTC) {
            TeamCityLogger.tcLog(message, "ERROR");
        } else {
            LOG.error(message, throwable);
        }
    }

    private static void tcLog(String message, String level) {
        try {
            if (level != null) {
                message = level + ": " + (String)message;
            }
            FileUtil.appendToFile((File)TeamCityLogger.reportFile(), (String)((String)message + "\n"));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static <T extends Throwable> void block(@NotNull String caption, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (caption == null) {
            TeamCityLogger.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            TeamCityLogger.$$$reportNull$$$0(1);
        }
        if (isUnderTC) {
            TeamCityLogger.block(caption, () -> {
                runnable.run();
                return null;
            });
        } else {
            runnable.run();
        }
    }

    public static <R, T extends Throwable> R block(@NotNull String caption, @NotNull ThrowableComputable<R, T> computable) throws T {
        if (caption == null) {
            TeamCityLogger.$$$reportNull$$$0(2);
        }
        if (computable == null) {
            TeamCityLogger.$$$reportNull$$$0(3);
        }
        if (!isUnderTC) {
            return (R)computable.compute();
        }
        caption = TeamCityLogger.escapeTeamcityServiceMessage(caption);
        System.out.flush();
        System.out.println("##teamcity[blockOpened name='" + caption + "']");
        System.out.flush();
        try {
            Object object = computable.compute();
            return (R)object;
        }
        finally {
            System.out.flush();
            System.out.println("##teamcity[blockClosed name='" + caption + "']");
            System.out.flush();
        }
    }

    @NotNull
    private static String escapeTeamcityServiceMessage(@NotNull String s) {
        if (s == null) {
            TeamCityLogger.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char escape;
            char ch = s.charAt(i2);
            switch (ch) {
                case '\n': {
                    char c = 'n';
                    break;
                }
                case '\r': {
                    char c = 'r';
                    break;
                }
                case '\'': 
                case '[': 
                case ']': 
                case '|': {
                    char c = ch;
                    break;
                }
                default: {
                    char c = escape = '\u0000';
                }
            }
            if (escape != '\u0000') {
                sb.append('|').append(escape);
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                sb.append(String.format("0x%04x", (short)ch));
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString();
        if (string == null) {
            TeamCityLogger.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TeamCityLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TeamCityLogger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTeamcityServiceMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "block";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeTeamcityServiceMessage";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

