/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getApplicableConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nConfigureKotlinInProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1726#2,3:60\n1726#2,3:63\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction\n*L\n35#1:60,3\n28#1:63,3\n*E\n"})
public abstract class ConfigureKotlinInProjectAction
extends AnAction {
    @NotNull
    public abstract Collection<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Project var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        Collection configurators;
        Project project2;
        block9: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project3 = e.getProject();
            if (project3 == null) {
                return;
            }
            project2 = project3;
            String progressTitle = KotlinJvmBundle.message("lookup.project.configurators.progress.text", new Object[0]);
            Pair pair = (Pair)ActionUtil.underModalProgress((Project)project2, (String)progressTitle, () -> ConfigureKotlinInProjectAction.actionPerformed$lambda$0(project2, this));
            List modules2 = (List)pair.component1();
            configurators = (Collection)pair.component2();
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            String string2 = KotlinJvmBundle.message("all.modules.with.kotlin.files.are.configured", new Object[0]);
            String string3 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string3);
            Messages.showInfoMessage((String)string2, (String)string3);
            return;
        }
        if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((Iterable)configurators)).configure(project2, CollectionsKt.emptyList());
        } else if (configurators.isEmpty()) {
            String string4 = KotlinJvmBundle.message("there.aren.t.configurators.available", new Object[0]);
            String string5 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string5);
            Messages.showErrorDialog((String)string4, (String)string5);
        } else {
            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project2, CollectionsKt.toList((Iterable)configurators));
            configuratorsPopup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static final Pair actionPerformed$lambda$0(Project $project, ConfigureKotlinInProjectAction this$0) {
        boolean bl;
        List<ModuleSourceRootGroup> modules2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            modules2 = ConfigureKotlinInProjectUtilsKt.getConfigurableModules($project);
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return TuplesKt.to(modules2, (Object)CollectionsKt.emptyList());
        }
        Collection<KotlinProjectConfigurator> configurators = this$0.getApplicableConfigurators($project);
        return TuplesKt.to(modules2, configurators);
    }
}

