/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiProviders;

import com.intellij.java.workspace.entities.JavaSourceRootPropertiesEntity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.KotlinModuleStateTrackerProvider;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.ModuleStateTrackerImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 %2\u00020\u0001:\u0005%&'()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007JI\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001c*\u00020\u001d\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002H\u001b0\"H\u0002\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "libraryCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/ModuleStateTrackerImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scriptCache", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdkCache", "Lcom/intellij/openapi/projectRoots/Sdk;", "sourceModuleCache", "Lcom/intellij/openapi/module/Module;", "dispose", "", "getModuleStateTrackerFor", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "incrementModificationCountForAllModules", "includeBinaryModules", "", "getReplacedEntity", "E", "C", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Lcom/intellij/platform/workspace/storage/EntityChange$Replaced;", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "get", "Lkotlin/Function2;", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "(Lcom/intellij/platform/workspace/storage/EntityChange$Replaced;Lcom/intellij/platform/workspace/storage/VersionedStorageChange;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Companion", "JdkListener", "LibraryUpdatesListener", "ModelChangeListener", "ScriptFileListener", "kotlin.base.analysis-api-providers"})
public final class KotlinModuleStateTrackerProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Library, ModuleStateTrackerImpl> libraryCache;
    @NotNull
    private final ConcurrentHashMap<Module, ModuleStateTrackerImpl> sourceModuleCache;
    @NotNull
    private final ConcurrentHashMap<Sdk, ModuleStateTrackerImpl> sdkCache;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, ModuleStateTrackerImpl> scriptCache;

    public KotlinModuleStateTrackerProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener());
        Topic topic = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JDK_TABLE_TOPIC");
        busConnection.subscribe(topic, (Object)new JdkListener());
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        busConnection.subscribe(topic2, (Object)new ScriptFileListener());
        Topic topic3 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"VFS_CHANGES");
        busConnection.subscribe(topic3, (Object)new LibraryUpdatesListener());
        this.libraryCache = new ConcurrentHashMap();
        this.sourceModuleCache = new ConcurrentHashMap();
        this.sdkCache = new ConcurrentHashMap();
        this.scriptCache = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KtModuleStateTracker getModuleStateTrackerFor(@NotNull KtModule module2) {
        KtModuleStateTracker ktModuleStateTracker;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        KtModule ktModule = module2;
        if (ktModule instanceof KtScriptDependencyModule) {
            ktModuleStateTracker = new ModuleStateTrackerImpl();
        } else {
            if (ktModule instanceof KtLibraryModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo");
                LibraryInfo libraryInfo = (LibraryInfo)ideaModuleInfo;
                libraryInfo.checkValidity();
                ModuleStateTrackerImpl moduleStateTrackerImpl = this.libraryCache.computeIfAbsent((Library)libraryInfo.getLibrary(), arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$0(getModuleStateTrackerFor.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)moduleStateTrackerImpl, (String)"libraryCache.computeIfAb\u2026oduleStateTrackerImpl() }");
                return moduleStateTrackerImpl;
            }
            if (ktModule instanceof KtSdkModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo");
                SdkInfo sdkInfo = (SdkInfo)ideaModuleInfo;
                sdkInfo.checkValidity();
                Sdk sdk2 = sdkInfo.getSdk();
                ModuleStateTrackerImpl moduleStateTrackerImpl = this.sdkCache.computeIfAbsent(sdk2, arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$1(getModuleStateTrackerFor.2.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)moduleStateTrackerImpl, (String)"sdkCache.computeIfAbsent\u2026oduleStateTrackerImpl() }");
                return moduleStateTrackerImpl;
            }
            if (ktModule instanceof KtSourceModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo");
                ModuleSourceInfo sourceModule = (ModuleSourceInfo)ideaModuleInfo;
                sourceModule.checkValidity();
                ModuleStateTrackerImpl moduleStateTrackerImpl = this.sourceModuleCache.computeIfAbsent(sourceModule.getModule(), arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$2(getModuleStateTrackerFor.3.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)moduleStateTrackerImpl, (String)"sourceModuleCache.comput\u2026oduleStateTrackerImpl() }");
                return moduleStateTrackerImpl;
            }
            if (ktModule instanceof KtLibrarySourceModule) {
                ktModuleStateTracker = this.getModuleStateTrackerFor(((KtLibrarySourceModule)module2).getBinaryLibrary());
            } else if (ktModule instanceof KtBuiltinsModule) {
                ktModuleStateTracker = new ModuleStateTrackerImpl();
            } else if (ktModule instanceof KtScriptModule) {
                VirtualFile virtualFile2 = ((KtScriptModule)module2).getFile().getVirtualFile();
                if (virtualFile2 == null) {
                    throw new IllegalStateException(("Script " + ((KtScriptModule)module2).getFile() + " does not have a backing 'VirtualFile'").toString());
                }
                VirtualFile virtualFile3 = virtualFile2;
                ModuleStateTrackerImpl moduleStateTrackerImpl = this.scriptCache.computeIfAbsent(virtualFile3, arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$3(getModuleStateTrackerFor.4.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)moduleStateTrackerImpl, (String)"{\n                val vi\u2026kerImpl() }\n            }");
                ktModuleStateTracker = moduleStateTrackerImpl;
            } else if (ktModule instanceof KtNotUnderContentRootModule) {
                ktModuleStateTracker = new ModuleStateTrackerImpl();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktModuleStateTracker;
    }

    private final <C extends WorkspaceEntity, E> E getReplacedEntity(EntityChange.Replaced<C> $this$getReplacedEntity, VersionedStorageChange event, Function2<? super C, ? super EntityStorage, ? extends E> get2) {
        Object object;
        Object old = get2.invoke((Object)$this$getReplacedEntity.getOldEntity(), (Object)event.getStorageBefore());
        if (!Intrinsics.areEqual((Object)old, (Object)(object = get2.invoke((Object)$this$getReplacedEntity.getNewEntity(), (Object)event.getStorageAfter())))) {
            boolean bl = false;
            String string2 = old + " should be equal to " + object + " for " + EntityChange.Replaced.class;
            throw new IllegalStateException(string2.toString());
        }
        return (E)object;
    }

    @TestOnly
    public final void incrementModificationCountForAllModules(boolean includeBinaryModules) {
        this.sourceModuleCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$5(incrementModificationCountForAllModules.1.INSTANCE, arg_0, arg_1));
        if (includeBinaryModules) {
            this.libraryCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$6(incrementModificationCountForAllModules.2.INSTANCE, arg_0, arg_1));
            this.sdkCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$7(incrementModificationCountForAllModules.3.INSTANCE, arg_0, arg_1));
        }
    }

    public void dispose() {
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final void incrementModificationCountForAllModules$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void incrementModificationCountForAllModules$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void incrementModificationCountForAllModules$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis-api-providers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinModuleStateTrackerProvider getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(KotlinModuleStateTrackerProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Kotli\u2026ckerProvider::class.java)");
            return (KotlinModuleStateTrackerProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$JdkListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "jdkRemoved", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "kotlin.base.analysis-api-providers"})
    private final class JdkListener
    implements ProjectJdkTable.Listener {
        public void jdkRemoved(@NotNull Sdk jdk2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sdkCache.remove(jdk2);
                if (moduleStateTrackerImpl == null) break block0;
                moduleStateTrackerImpl.invalidate();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$LibraryUpdatesListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "index", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "kotlin.base.analysis-api-providers"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleStateTrackerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleStateTrackerProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$LibraryUpdatesListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1603#2,9:270\n1855#2:279\n288#2,2:280\n1856#2:283\n1612#2:284\n1855#2,2:285\n1#3:282\n*S KotlinDebug\n*F\n+ 1 KotlinModuleStateTrackerProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$LibraryUpdatesListener\n*L\n118#1:270,9\n118#1:279\n126#1:280,2\n118#1:283\n118#1:284\n127#1:285,2\n118#1:282\n*E\n"})
    private final class LibraryUpdatesListener
    implements BulkFileListener {
        @NotNull
        private final ProjectFileIndex index;

        public LibraryUpdatesListener() {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)KotlinModuleStateTrackerProvider.this.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project).fileIndex");
            this.index = projectFileIndex;
        }

        @NotNull
        public final ProjectFileIndex getIndex() {
            return this.index;
        }

        /*
         * WARNING - void declaration
         */
        public void after(@NotNull List<? extends VFileEvent> events) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$mapNotNull$iv = events;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VFileEvent event = (VFileEvent)element$iv$iv;
                boolean bl2 = false;
                if (!(event instanceof VFileContentChangeEvent)) {
                    object = null;
                } else {
                    VirtualFile virtualFile2 = ((VFileContentChangeEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"when (event) {\n         \u2026ll null\n                }");
                    VirtualFile file2 = virtualFile2;
                    if (!Intrinsics.areEqual((Object)file2.getExtension(), (Object)"jar")) {
                        object = null;
                    } else if (StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/") == null) {
                        object = null;
                    } else {
                        Object v2;
                        block9: {
                            VirtualFile jarRoot;
                            Intrinsics.checkNotNullExpressionValue((Object)jarRoot, (String)"StandardFileSystems.jar(\u2026?: return@mapNotNull null");
                            List list2 = this.index.getOrderEntriesForFile(jarRoot);
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"index.getOrderEntriesForFile(jarRoot)");
                            Iterable $this$firstOrNull$iv = list2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                OrderEntry it = (OrderEntry)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof LibraryOrderEntry)) continue;
                                v2 = element$iv;
                                break block9;
                            }
                            v2 = null;
                        }
                        Object var23_26 = v2;
                        LibraryOrderEntry libraryOrderEntry = var23_26 instanceof LibraryOrderEntry ? (LibraryOrderEntry)var23_26 : null;
                        object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
                    }
                }
                if (object == null) continue;
                Library it$iv$iv = object;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            KotlinModuleStateTrackerProvider kotlinModuleStateTrackerProvider = KotlinModuleStateTrackerProvider.this;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Library it = (Library)element$iv;
                boolean bl = false;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)kotlinModuleStateTrackerProvider.libraryCache.get(it);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$ModelChangeListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "beforeChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "handleContentRootInModuleChanges", "handleLibraryChanges", "handleModuleChanges", "getChangedModule", "Lcom/intellij/openapi/module/Module;", "contentRootBefore", "Lcom/intellij/platform/workspace/jps/entities/ContentRootEntity;", "contentRootAfter", "getChangedModules", "", "kotlin.base.analysis-api-providers"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleStateTrackerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleStateTrackerProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$ModelChangeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1611#2:270\n1855#2:271\n1856#2:273\n1612#2:274\n1611#2:275\n1855#2:276\n1856#2:278\n1612#2:279\n1611#2:280\n1855#2:281\n1856#2:283\n1612#2:284\n1#3:272\n1#3:277\n1#3:282\n1#3:285\n*S KotlinDebug\n*F\n+ 1 KotlinModuleStateTrackerProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$ModelChangeListener\n*L\n153#1:270\n153#1:271\n153#1:273\n153#1:274\n157#1:275\n157#1:276\n157#1:278\n157#1:279\n161#1:280\n161#1:281\n161#1:283\n161#1:284\n153#1:272\n157#1:277\n161#1:282\n*E\n"})
    private final class ModelChangeListener
    implements WorkspaceModelChangeListener {
        public void beforeChanged(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.handleLibraryChanges(event);
            this.handleModuleChanges(event);
            this.handleContentRootInModuleChanges(event);
        }

        private final void handleContentRootInModuleChanges(VersionedStorageChange event) {
            for (Module changedModule2 : this.getChangedModules(event)) {
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sourceModuleCache.get(changedModule2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }

        private final Set<Module> getChangedModules(VersionedStorageChange $this$getChangedModules) {
            Module it$iv;
            boolean bl;
            EntityChange it;
            boolean bl2;
            Object element$iv;
            Object element$iv$iv;
            Set set2;
            Set $this$getChangedModules_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl3 = false;
            Iterable $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(ContentRootEntity.class);
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = element$iv$iv = iterator2.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl4 = false;
                if (this.getChangedModule($this$getChangedModules, (ContentRootEntity)it.getOldEntity(), (ContentRootEntity)it.getNewEntity()) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(SourceRootEntity.class);
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = element$iv$iv = iterator2.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl5 = false;
                SourceRootEntity sourceRootEntity = (SourceRootEntity)it.getOldEntity();
                SourceRootEntity sourceRootEntity2 = (SourceRootEntity)it.getNewEntity();
                if (this.getChangedModule($this$getChangedModules, (ContentRootEntity)(sourceRootEntity != null ? sourceRootEntity.getContentRoot() : null), (ContentRootEntity)(sourceRootEntity2 != null ? sourceRootEntity2.getContentRoot() : null)) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(JavaSourceRootPropertiesEntity.class);
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity;
                element$iv = element$iv$iv = iterator2.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl6 = false;
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity2 = (JavaSourceRootPropertiesEntity)it.getOldEntity();
                if (this.getChangedModule($this$getChangedModules, javaSourceRootPropertiesEntity2 != null && (javaSourceRootPropertiesEntity2 = javaSourceRootPropertiesEntity2.getSourceRoot()) != null ? javaSourceRootPropertiesEntity2.getContentRoot() : null, (javaSourceRootPropertiesEntity = (JavaSourceRootPropertiesEntity)it.getNewEntity()) != null && (javaSourceRootPropertiesEntity = javaSourceRootPropertiesEntity.getSourceRoot()) != null ? javaSourceRootPropertiesEntity.getContentRoot() : null) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            return SetsKt.build((Set)set2);
        }

        private final Module getChangedModule(VersionedStorageChange $this$getChangedModule, ContentRootEntity contentRootBefore, ContentRootEntity contentRootAfter) {
            ModuleBridge newModule;
            ContentRootEntity contentRootEntity = contentRootBefore;
            ModuleBridge oldModule = contentRootEntity != null && (contentRootEntity = contentRootEntity.getModule()) != null ? ModuleEntityUtils.findModule((ModuleEntity)contentRootEntity, (EntityStorage)((EntityStorage)$this$getChangedModule.getStorageBefore())) : null;
            ContentRootEntity contentRootEntity2 = contentRootAfter;
            ModuleBridge moduleBridge = contentRootEntity2 != null && (contentRootEntity2 = contentRootEntity2.getModule()) != null ? ModuleEntityUtils.findModule((ModuleEntity)contentRootEntity2, (EntityStorage)((EntityStorage)$this$getChangedModule.getStorageAfter())) : (newModule = null);
            if (newModule != null && oldModule != null && !Intrinsics.areEqual((Object)oldModule, (Object)newModule)) {
                boolean bl = false;
                String string2 = oldModule + " should be equal to " + newModule + " for " + EntityChange.Replaced.class;
                throw new IllegalStateException(string2.toString());
            }
            ModuleBridge moduleBridge2 = oldModule;
            return moduleBridge2 != null ? (Module)moduleBridge2 : (Module)newModule;
        }

        private final void handleLibraryChanges(VersionedStorageChange event) {
            Collection collection = event.getChanges(LibraryEntity.class);
            if (collection.isEmpty()) {
                boolean bl = false;
                return;
            }
            List libraryEntities = (List)collection;
            for (EntityChange change : libraryEntities) {
                Library changedLibrary2;
                EntityChange entityChange = change;
                if (entityChange instanceof EntityChange.Added) continue;
                if (entityChange instanceof EntityChange.Removed) {
                    Library library2;
                    if (LibraryEntityUtils.findLibraryBridge((LibraryEntity)((LibraryEntity)((EntityChange.Removed)change).getOldEntity()), (EntityStorage)((EntityStorage)event.getStorageBefore())) == null) continue;
                    KotlinModuleStateTrackerProvider kotlinModuleStateTrackerProvider = KotlinModuleStateTrackerProvider.this;
                    Library library3 = library2;
                    boolean bl = false;
                    ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)kotlinModuleStateTrackerProvider.libraryCache.remove(library3);
                    if (moduleStateTrackerImpl == null) continue;
                    moduleStateTrackerImpl.invalidate();
                    continue;
                }
                if (!(entityChange instanceof EntityChange.Replaced) || (Library)KotlinModuleStateTrackerProvider.this.getReplacedEntity((EntityChange.Replaced)change, event, handleLibraryChanges.changedLibrary.1.INSTANCE) == null) continue;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.libraryCache.get(changedLibrary2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }

        private final void handleModuleChanges(VersionedStorageChange event) {
            Collection collection = event.getChanges(ModuleEntity.class);
            if (collection.isEmpty()) {
                boolean bl = false;
                return;
            }
            List moduleEntities = (List)collection;
            for (EntityChange change : moduleEntities) {
                ModuleBridge changedModule2;
                EntityChange entityChange = change;
                if (entityChange instanceof EntityChange.Added) continue;
                if (entityChange instanceof EntityChange.Removed) {
                    ModuleBridge moduleBridge;
                    if (ModuleEntityUtils.findModule((ModuleEntity)((ModuleEntity)((EntityChange.Removed)change).getOldEntity()), (EntityStorage)((EntityStorage)event.getStorageBefore())) == null) continue;
                    KotlinModuleStateTrackerProvider kotlinModuleStateTrackerProvider = KotlinModuleStateTrackerProvider.this;
                    ModuleBridge module2 = moduleBridge;
                    boolean bl = false;
                    ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)kotlinModuleStateTrackerProvider.sourceModuleCache.remove(module2);
                    if (moduleStateTrackerImpl == null) continue;
                    moduleStateTrackerImpl.invalidate();
                    continue;
                }
                if (!(entityChange instanceof EntityChange.Replaced) || (ModuleBridge)KotlinModuleStateTrackerProvider.this.getReplacedEntity((EntityChange.Replaced)change, event, handleModuleChanges.changedModule.1.INSTANCE) == null) continue;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sourceModuleCache.get(changedModule2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$ScriptFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "kotlin.base.analysis-api-providers"})
    private final class ScriptFileListener
    implements BulkFileListener {
        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VirtualFile virtualFile2;
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFileDeleteEvent) {
                    virtualFile2 = ((VFileDeleteEvent)vFileEvent).getFile();
                } else {
                    if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
                    virtualFile2 = ((VFileMoveEvent)vFileEvent).getFile();
                }
                VirtualFile virtualFile3 = virtualFile2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"when (event) {\n         \u2026ontinue\n                }");
                VirtualFile file2 = virtualFile3;
                if (!Intrinsics.areEqual((Object)file2.getExtension(), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX)) continue;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.scriptCache.remove(file2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.invalidate();
            }
        }
    }
}

