/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.codeInsight;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinResolutionScopeProvider;
import org.jetbrains.kotlin.idea.base.fir.codeInsight.HLIndexHelper;
import org.jetbrains.kotlin.idea.stubindex.CancelableCollectFilterProcessor;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasByExpansionShortNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bJ \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/codeInsight/HLIndexHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPossibleTypeAliasExpansionNames", "", "", "originalTypeName", "getTopLevelCallables", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getTopLevelExtensions", "receiverTypeNames", "Companion", "kotlin.base.fir.code-insight"})
@SourceDebugExtension(value={"SMAP\nHLIndexHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HLIndexHelper.kt\norg/jetbrains/kotlin/idea/base/fir/codeInsight/HLIndexHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,79:1\n1313#2,2:80\n*S KotlinDebug\n*F\n+ 1 HLIndexHelper.kt\norg/jetbrains/kotlin/idea/base/fir/codeInsight/HLIndexHelper\n*L\n55#1:80,2\n*E\n"})
public final class HLIndexHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;

    public HLIndexHelper(@NotNull Project project2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.project = project2;
        this.scope = scope2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<KtCallableDeclaration> getTopLevelCallables(@NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        SmartList values2 = new SmartList();
        CancelableCollectFilterProcessor processor2 = new CancelableCollectFilterProcessor((Collection)values2, getTopLevelCallables.processor.1.INSTANCE);
        Function1 keyFilter2 = (Function1)new Function1<String, Boolean>(nameFilter2){
            final /* synthetic */ Function1<Name, Boolean> $nameFilter;
            {
                this.$nameFilter = $nameFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$nameFilter.invoke((Object)org.jetbrains.kotlin.idea.base.fir.codeInsight.HLIndexHelper$Companion.access$getShortName(HLIndexHelper.Companion, it));
            }
        };
        KotlinTopLevelFunctionFqnNameIndex.Helper.processAllElements(this.project, this.scope, (Function1<String, Boolean>)keyFilter2, (Processor)processor2);
        KotlinTopLevelPropertyFqnNameIndex.Helper.processAllElements(this.project, this.scope, (Function1<String, Boolean>)keyFilter2, (Processor)processor2);
        return (Collection)values2;
    }

    @NotNull
    public final Collection<KtCallableDeclaration> getTopLevelExtensions(@NotNull Function1<? super Name, Boolean> nameFilter2, @NotNull Set<String> receiverTypeNames) {
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        Intrinsics.checkNotNullParameter(receiverTypeNames, (String)"receiverTypeNames");
        return KotlinTopLevelExtensionsByReceiverTypeIndex.Helper.getAllElements(this.project, this.scope, (Function1<String, Boolean>)((Function1)new Function1<String, Boolean>(receiverTypeNames, nameFilter2){
            final /* synthetic */ Set<String> $receiverTypeNames;
            final /* synthetic */ Function1<Name, Boolean> $nameFilter;
            {
                this.$receiverTypeNames = $receiverTypeNames;
                this.$nameFilter = $nameFilter;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull String it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$receiverTypeNames.contains(KotlinTopLevelExtensionsByReceiverTypeIndex.Helper.receiverTypeNameFromKey(it))) {
                    Name name2 = Name.identifier((String)KotlinTopLevelExtensionsByReceiverTypeIndex.Helper.callableNameFromKey(it));
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(KotlinTopLeve\u2026.callableNameFromKey(it))");
                    if (((Boolean)this.$nameFilter.invoke((Object)name2)).booleanValue()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }), (Function1)getTopLevelExtensions.2.INSTANCE);
    }

    @NotNull
    public final Set<String> getPossibleTypeAliasExpansionNames(@NotNull String originalTypeName) {
        Intrinsics.checkNotNullParameter((Object)originalTypeName, (String)"originalTypeName");
        Set out = new LinkedHashSet();
        HLIndexHelper.getPossibleTypeAliasExpansionNames$searchRecursively(this, out, originalTypeName);
        return out;
    }

    private static final void getPossibleTypeAliasExpansionNames$searchRecursively(HLIndexHelper this$0, Set<String> out, String typeName) {
        ProgressManager.checkCanceled();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KotlinTypeAliasByExpansionShortNameIndex.Helper.get(typeName, this$0.project, this$0.scope)), (Function1)getPossibleTypeAliasExpansionNames.searchRecursively.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(out){
            final /* synthetic */ Set<String> $out;
            {
                this.$out = $out;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$out.add(it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            HLIndexHelper.getPossibleTypeAliasExpansionNames$searchRecursively(this$0, out, p0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\fH\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/codeInsight/HLIndexHelper$Companion;", "", "()V", "createForPosition", "Lorg/jetbrains/kotlin/idea/base/fir/codeInsight/HLIndexHelper;", "position", "Lcom/intellij/psi/PsiElement;", "getShortName", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "", "asStringForIndexes", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.base.fir.code-insight"})
    public static final class Companion {
        private Companion() {
        }

        private final String asStringForIndexes(FqName $this$asStringForIndexes) {
            String string2 = $this$asStringForIndexes.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString()");
            return StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }

        private final String asStringForIndexes(ClassId $this$asStringForIndexes) {
            FqName fqName2 = $this$asStringForIndexes.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName()");
            return this.asStringForIndexes(fqName2);
        }

        private final Name getShortName(String fqName2) {
            Name name2 = Name.identifier((String)StringsKt.substringAfterLast$default((String)fqName2, (char)'.', null, (int)2, null));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(fqName.substringAfterLast('.'))");
            return name2;
        }

        @NotNull
        public final HLIndexHelper createForPosition(@NotNull PsiElement position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Project project2 = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"position.project");
            Project project3 = project2;
            KtModule module2 = ProjectStructureProvider.Companion.getModule(project3, position, null);
            GlobalSearchScope scope2 = KotlinResolutionScopeProvider.Companion.getInstance(project3).getResolutionScope(module2);
            return new HLIndexHelper(project3, scope2);
        }

        public static final /* synthetic */ Name access$getShortName(Companion $this, String fqName2) {
            return $this.getShortName(fqName2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

