/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.plugin;

import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKind;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKindProvider;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0006\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\b\u001a\u0006\u0010\n\u001a\u00020\b\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"currentPluginKind", "Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginKind;", "getCurrentPluginKind", "()Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginKind;", "checkKotlinPluginKind", "", "expectedPluginKind", "isFe10Plugin", "", "isK2Plugin", "suppressAndroidPlugin", "kotlin.base.plugin"})
public final class KotlinPluginKindProviderKt {
    private static final KotlinPluginKind getCurrentPluginKind() {
        return ((KotlinPluginKindProvider)ApplicationManager.getApplication().getService(KotlinPluginKindProvider.class)).getPluginKind();
    }

    public static final boolean isK2Plugin() {
        return KotlinPluginKindProviderKt.getCurrentPluginKind() == KotlinPluginKind.FIR_PLUGIN;
    }

    public static final boolean suppressAndroidPlugin() {
        return KotlinPluginKindProviderKt.isK2Plugin();
    }

    public static final boolean isFe10Plugin() {
        return KotlinPluginKindProviderKt.getCurrentPluginKind() == KotlinPluginKind.FE10_PLUGIN;
    }

    public static final void checkKotlinPluginKind(@NotNull KotlinPluginKind expectedPluginKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)expectedPluginKind), (String)"expectedPluginKind");
        KotlinPluginKind pluginKind = KotlinPluginKindProviderKt.getCurrentPluginKind();
        if (!(pluginKind == expectedPluginKind)) {
            boolean bl = false;
            String string2 = "Invalid Kotlin plugin detected: " + pluginKind + ", but " + expectedPluginKind + " was expected";
            throw new IllegalStateException(string2.toString());
        }
    }
}

