/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.AbstractKlibLibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.KlibCompatibilityInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.KlibCompatibilityInfoUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NativeKlibLibraryInfoKt;
import org.jetbrains.kotlin.idea.base.util.LoggingUtils;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000e\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/AbstractKlibLibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "libraryRoot", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;Ljava/lang/String;)V", "compatibilityInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/KlibCompatibilityInfo;", "getCompatibilityInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/KlibCompatibilityInfo;", "compatibilityInfo$delegate", "Lkotlin/Lazy;", "isInterop", "", "()Z", "isInterop$delegate", "getLibraryRoot", "()Ljava/lang/String;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "resolvedKotlinLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getResolvedKotlinLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "uniqueName", "getUniqueName", "uniqueName$delegate", "getLibraryRoots", "", "Companion", "kotlin.base.project-structure"})
public abstract class AbstractKlibLibraryInfo
extends LibraryInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String libraryRoot;
    @NotNull
    private final KotlinLibrary resolvedKotlinLibrary;
    @NotNull
    private final Lazy compatibilityInfo$delegate;
    @NotNull
    private final Lazy uniqueName$delegate;
    @NotNull
    private final Lazy isInterop$delegate;
    @NotNull
    private static final Logger LOG;

    public AbstractKlibLibraryInfo(@NotNull Project project2, @NotNull LibraryEx library2, @NotNull String libraryRoot) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libraryRoot, (String)"libraryRoot");
        super(project2, library2);
        this.libraryRoot = libraryRoot;
        this.resolvedKotlinLibrary = SingleFileResolveKt.resolveSingleFileKlib((File)new File(this.libraryRoot), (Logger)LOG, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        this.compatibilityInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KlibCompatibilityInfo>(this){
            final /* synthetic */ AbstractKlibLibraryInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KlibCompatibilityInfo invoke() {
                return KlibCompatibilityInfoUtils.getCompatibilityInfo(this.this$0.getResolvedKotlinLibrary());
            }
        }));
        this.uniqueName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AbstractKlibLibraryInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return NativeKlibLibraryInfoKt.safeRead(this.this$0.getResolvedKotlinLibrary(), null, uniqueName.1.INSTANCE);
            }
        }));
        this.isInterop$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ AbstractKlibLibraryInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return NativeKlibLibraryInfoKt.safeRead(this.this$0.getResolvedKotlinLibrary(), false, isInterop.1.INSTANCE);
            }
        }));
    }

    @NotNull
    public final String getLibraryRoot() {
        return this.libraryRoot;
    }

    @NotNull
    public final KotlinLibrary getResolvedKotlinLibrary() {
        return this.resolvedKotlinLibrary;
    }

    @NotNull
    public final KlibCompatibilityInfo getCompatibilityInfo() {
        Lazy lazy = this.compatibilityInfo$delegate;
        return (KlibCompatibilityInfo)lazy.getValue();
    }

    @NotNull
    public final List<String> getLibraryRoots() {
        return CollectionsKt.listOf((Object)this.libraryRoot);
    }

    @Override
    @NotNull
    public abstract TargetPlatform getPlatform();

    @Nullable
    public final String getUniqueName() {
        Lazy lazy = this.uniqueName$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isInterop() {
        Lazy lazy = this.isInterop$delegate;
        return (Boolean)lazy.getValue();
    }

    static {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(AbstractKlibLibraryInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AbstractKlibLibraryInfo::class.java)");
        LOG = LoggingUtils.asKotlinLogger(logger);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/AbstractKlibLibraryInfo$Companion;", "", "()V", "LOG", "Lorg/jetbrains/kotlin/util/Logger;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

