/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.LibraryModuleSourceInfoBase;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceScope;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J'\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0012H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibrarySourceInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/LibraryModuleSourceInfoBase;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "binariesModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getBinariesModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "modulesWhoseInternalsAreVisible", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "sourceScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "toString", "kotlin.base.project-structure"})
public final class LibrarySourceInfo
implements IdeaModuleInfo,
SourceForBinaryModuleInfo,
LibraryModuleSourceInfoBase {
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;
    @NotNull
    private final BinaryModuleInfo binariesModuleInfo;
    @NotNull
    private final Name name;

    public LibrarySourceInfo(@NotNull Project project2, @NotNull Library library2, @NotNull BinaryModuleInfo binariesModuleInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        this.project = project2;
        this.library = library2;
        this.binariesModuleInfo = binariesModuleInfo;
        Name name2 = Name.special((String)("<sources for library " + this.library.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<sources for library ${library.name}>\")");
        this.name = name2;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public BinaryModuleInfo getBinariesModuleInfo() {
        return this.binariesModuleInfo;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.library.getPresentableName(), (String)"library.presentableName");
        return KotlinBaseProjectStructureBundle.message("sources.for.library.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope sourceScope() {
        return KotlinSourceFilterScope.Companion.librarySources((GlobalSearchScope)new LibrarySourceScope(this.getProject(), this.library), this.getProject());
    }

    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return LibraryInfoCache.Companion.getInstance(this.getProject()).get(this.library);
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.getBinariesModuleInfo().getPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getBinariesModuleInfo().getAnalyzerServices();
    }

    @NotNull
    public String toString() {
        return "LibrarySourceInfo(libraryName=" + this.library.getName() + ")";
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Library component2() {
        return this.library;
    }

    @NotNull
    public final BinaryModuleInfo component3() {
        return this.binariesModuleInfo;
    }

    @NotNull
    public final LibrarySourceInfo copy(@NotNull Project project2, @NotNull Library library2, @NotNull BinaryModuleInfo binariesModuleInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        return new LibrarySourceInfo(project2, library2, binariesModuleInfo);
    }

    public static /* synthetic */ LibrarySourceInfo copy$default(LibrarySourceInfo librarySourceInfo, Project project2, Library library2, BinaryModuleInfo binaryModuleInfo, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = librarySourceInfo.project;
        }
        if ((n & 2) != 0) {
            library2 = librarySourceInfo.library;
        }
        if ((n & 4) != 0) {
            binaryModuleInfo = librarySourceInfo.binariesModuleInfo;
        }
        return librarySourceInfo.copy(project2, library2, binaryModuleInfo);
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.library.hashCode();
        result2 = result2 * 31 + this.binariesModuleInfo.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof LibrarySourceInfo)) {
            return false;
        }
        LibrarySourceInfo librarySourceInfo = (LibrarySourceInfo)other2;
        if (!Intrinsics.areEqual((Object)this.project, (Object)librarySourceInfo.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.library, (Object)librarySourceInfo.library)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.binariesModuleInfo, (Object)librarySourceInfo.binariesModuleInfo);
    }
}

