/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.scope;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleLibrariesSearchScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "moduleFileIndex", "Lcom/intellij/openapi/roots/ModuleFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "compare", "", "file1", "Lcom/intellij/openapi/vfs/VirtualFile;", "file2", "contains", "", "file", "isSearchInLibraries", "isSearchInModuleContent", "aModule", "kotlin.base.project-structure"})
public final class ModuleLibrariesSearchScope
extends GlobalSearchScope {
    @NotNull
    private final ProjectFileIndex projectFileIndex;
    @NotNull
    private final ModuleFileIndex moduleFileIndex;

    public ModuleLibrariesSearchScope(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        super(module2.getProject());
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(module.project).fileIndex");
        this.projectFileIndex = projectFileIndex;
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module2).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)moduleFileIndex, (String)"getInstance(module).fileIndex");
        this.moduleFileIndex = moduleFileIndex;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.projectFileIndex.isInLibraryClasses(file2)) {
            return false;
        }
        OrderEntry orderEntry = this.moduleFileIndex.getOrderEntryForFile(file2);
        return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        return Comparing.compare((Comparable)((Comparable)this.moduleFileIndex.getOrderEntryForFile(file2)), (Comparable)((Comparable)this.moduleFileIndex.getOrderEntryForFile(file1)));
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

