/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.VcsCodeVisionCurlyBracketLanguageContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionUsagesCollector;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\r\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinVcsCodeVisionContext;", "Lcom/intellij/codeInsight/hints/VcsCodeVisionCurlyBracketLanguageContext;", "()V", "handleClick", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAccepted", "", "isAcceptedClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isRBrace", "kotlin.idea"})
public final class KotlinVcsCodeVisionContext
extends VcsCodeVisionCurlyBracketLanguageContext {
    public boolean isAccepted(@NotNull PsiElement element3) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtClassOrObject) {
            bl = this.isAcceptedClassOrObject((KtClassOrObject)element3);
        } else if (psiElement2 instanceof KtNamedFunction) {
            bl = !ErrorUtil.containsError((PsiElement)element3) && (((KtNamedFunction)element3).isTopLevel() || this.isAcceptedClassOrObject(KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3))));
        } else if (psiElement2 instanceof KtSecondaryConstructor) {
            bl = true;
        } else if (psiElement2 instanceof KtClassInitializer) {
            bl = true;
        } else if (psiElement2 instanceof KtProperty) {
            List list2 = ((KtProperty)element3).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.accessors");
            bl = !((Collection)list2).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isAcceptedClassOrObject(KtClassOrObject element3) {
        KtClassOrObject ktClassOrObject = element3;
        return ktClassOrObject instanceof KtClass ? !(element3 instanceof KtEnumEntry) : (ktClassOrObject instanceof KtObjectDeclaration ? !((KtObjectDeclaration)element3).isObjectLiteral() : false);
    }

    public void handleClick(@NotNull MouseEvent mouseEvent, @NotNull Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        Project project3 = project2;
        String location2 = element3 instanceof KtClassOrObject ? "class" : "function";
        KotlinCodeVisionUsagesCollector.Companion.logCodeAuthorClicked(project3, location2);
    }

    protected boolean isRBrace(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return CommentSaver.Companion.getTokenType(element3) == KtTokens.RBRACE;
    }
}

