/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.AbstractChopListIntention;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B/\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010!J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u0013H\u0014J\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010&*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010'R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "listClass", "Ljava/lang/Class;", "elementClass", "textGetter", "Lkotlin/Function0;", "", "(Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function0;)V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "hasLineBreakAfter", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "hasLineBreakBefore", "isApplicableCaretOffset", "caretOffset", "", "(ILorg/jetbrains/kotlin/psi/KtElement;)Z", "isApplicableTo", "(Lorg/jetbrains/kotlin/psi/KtElement;I)Z", "leftParOnNewLine", "commonCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "nextBreak", "Lcom/intellij/psi/PsiWhiteSpace;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lcom/intellij/psi/PsiWhiteSpace;", "prevBreak", "rightParOnNewLine", "visitTargetTypeOnlyOnce", "elements", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "kotlin.code-insight.intentions-shared"})
@SourceDebugExtension(value={"SMAP\nChopParameterListIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChopParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1726#2,3:127\n316#3,7:130\n179#3,2:138\n179#3,2:140\n1#4:137\n*S KotlinDebug\n*F\n+ 1 ChopParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention\n*L\n37#1:127,3\n52#1:130,7\n72#1:138,2\n78#1:140,2\n*E\n"})
public abstract class AbstractChopListIntention<TList extends KtElement, TElement extends KtElement>
extends SelfTargetingIntention<TList> {
    @NotNull
    private final Class<TElement> elementClass;

    public AbstractChopListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull Function0<String> textGetter) {
        Intrinsics.checkNotNullParameter(listClass, (String)"listClass");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        super(listClass, textGetter, null, 4, null);
        this.elementClass = elementClass;
    }

    @Override
    protected boolean visitTargetTypeOnlyOnce() {
        return true;
    }

    public boolean leftParOnNewLine(@NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        return false;
    }

    public boolean rightParOnNewLine(@NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull TList element3, int caretOffset) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(element3, (String)"element");
            List<TElement> elements2 = this.elements(element3);
            if (elements2.size() <= 1) {
                return false;
            }
            if (!this.isApplicableCaretOffset(caretOffset, element3)) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.dropLast(elements2, (int)1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtElement it = (KtElement)element$iv;
                    boolean bl2 = false;
                    if (this.hasLineBreakAfter(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public void applyTo(@NotNull TList element3, @Nullable Editor editor2) {
        block5: {
            Sequence $this$lastOrNull$iv;
            Intrinsics.checkNotNullParameter(element3, (String)"element");
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            Project project3 = project2;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
                return;
            }
            Editor document = editor3;
            SmartPsiElementPointer pointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)element3));
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project3);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(project)");
            KotlinCommonCodeStyleSettings commonCodeStyleSettings = CodeStyleUtilsKt.getKotlinCommonSettings(codeStyleSettings);
            boolean leftParOnNewLine = this.leftParOnNewLine(commonCodeStyleSettings);
            boolean rightParOnNewLine = this.rightParOnNewLine(commonCodeStyleSettings);
            List<TElement> elements2 = this.elements(element3);
            if (rightParOnNewLine && !this.hasLineBreakAfter((KtElement)CollectionsKt.last(elements2))) {
                $this$lastOrNull$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element3));
                boolean $i$f$lastOrNull = false;
                Object last$iv = null;
                for (Object element$iv : $this$lastOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.RPAR)) continue;
                    last$iv = element$iv;
                }
                PsiElement psiElement2 = last$iv;
                if (psiElement2 != null) {
                    int it = PsiUtilsKt.getStartOffset((PsiElement)psiElement2);
                    boolean bl = false;
                    document.insertString(it, (CharSequence)"\n");
                }
            }
            int maxIndex = elements2.size() - 1;
            $this$lastOrNull$iv = CollectionsKt.asReversed(elements2).iterator();
            int n = 0;
            while ($this$lastOrNull$iv.hasNext()) {
                int index = n++;
                KtElement e = (KtElement)$this$lastOrNull$iv.next();
                if (index == maxIndex && !leftParOnNewLine) break;
                if (this.hasLineBreakBefore(e)) continue;
                document.insertString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)e)), (CharSequence)"\n");
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project3);
            documentManager.commitDocument((Document)document);
            KtElement ktElement = (KtElement)pointer.getElement();
            if (ktElement == null) break block5;
            GenericPsiUtils.reformatted$default((PsiElement)ktElement, false, 1, null);
        }
    }

    protected final boolean hasLineBreakAfter(@NotNull TElement element3) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        return this.nextBreak(element3) != null;
    }

    @Nullable
    protected final PsiWhiteSpace nextBreak(@NotNull TElement element3) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(element3, (String)"element");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)((PsiElement)element3), (boolean)false, (boolean)false, (int)1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention<TList, TElement> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return var2_8 instanceof PsiWhiteSpace ? (PsiWhiteSpace)var2_8 : null;
    }

    protected final boolean hasLineBreakBefore(@NotNull TElement element3) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        return this.prevBreak(element3) != null;
    }

    @Nullable
    protected final PsiWhiteSpace prevBreak(@NotNull TElement element3) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(element3, (String)"element");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)element3), (boolean)false, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
                final /* synthetic */ AbstractChopListIntention<TList, TElement> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return var2_8 instanceof PsiWhiteSpace ? (PsiWhiteSpace)var2_8 : null;
    }

    @NotNull
    protected final List<TElement> elements(@NotNull TList $this$elements) {
        Intrinsics.checkNotNullParameter($this$elements, (String)"<this>");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$elements))), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ AbstractChopListIntention<TList, TElement> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AbstractChopListIntention.access$getElementClass$p(this.this$0).isInstance(it);
            }
        })), (Function1)elements.2.INSTANCE));
    }

    protected final boolean isApplicableCaretOffset(int caretOffset, @NotNull TList element3) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        PsiElement psiElement2 = element3.getContainingFile().findElementAt(caretOffset - 1);
        if (psiElement2 == null) {
            return true;
        }
        PsiElement elementBeforeCaret = psiElement2;
        if (!Intrinsics.areEqual((Object)elementBeforeCaret.getNode().getElementType(), (Object)KtTokens.RPAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)elementBeforeCaret.getParent(), element3);
    }

    public static final /* synthetic */ Class access$getElementClass$p(AbstractChopListIntention $this) {
        return $this.elementClass;
    }
}

