/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "skipProcessingFurtherElementsAfter", "Lcom/intellij/psi/PsiElement;", "findChildBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Companion", "kotlin.code-insight.intentions-shared"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RemoveBracesIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage("remove.braces", new Object[0]), null, 4, null);
    }

    private final KtBlockExpression findChildBlock(KtElement $this$findChildBlock) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtElement ktElement = $this$findChildBlock;
        Object object = ktElement instanceof KtBlockExpression ? (KtBlockExpression)$this$findChildBlock : (ktElement instanceof KtLoopExpression ? ((ktExpression2 = ((KtLoopExpression)$this$findChildBlock).getBody()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null) : (ktElement instanceof KtWhenEntry ? ((ktExpression = ((KtWhenEntry)$this$findChildBlock).getExpression()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null) : null));
        return object;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block2 = ktBlockExpression;
        if (!Companion.isApplicableTo(block2)) {
            return false;
        }
        PsiElement container2 = block2.getParent();
        if (container2 instanceof KtContainerNode) {
            String string2 = KotlinPsiUtilsKt.getControlFlowElementDescription((KtContainerNode)container2);
            if (string2 == null) {
                return false;
            }
            String description2 = string2;
            Object[] objectArray = new Object[]{description2};
            this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.0.statement", objectArray));
        } else if (container2 instanceof KtWhenEntry) {
            this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.when.entry", new Object[0]));
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block2 = ktBlockExpression;
        Companion.removeBraces(element3, block2, editor2);
    }

    @Override
    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtBlockExpression && !(((KtBlockExpression)element3).getParent() instanceof KtWhenEntry);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Companion;", "", "()V", "handleComments", "", "construct", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isApplicableTo", "", "removeBraces", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.code-insight.intentions-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isApplicableTo(@NotNull KtBlockExpression block2) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
            List list2 = block2.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
            if (ktExpression == null) {
                return false;
            }
            KtExpression singleStatement = ktExpression;
            if (singleStatement instanceof KtLambdaExpression && ((KtLambdaExpression)singleStatement).getFunctionLiteral().getArrow() == null) {
                return false;
            }
            PsiElement container2 = block2.getParent();
            if (container2 instanceof KtContainerNode) {
                if (singleStatement instanceof KtProperty || singleStatement instanceof KtClass) {
                    return false;
                }
                if (singleStatement instanceof KtIfExpression) {
                    KtExpression elseExpression2;
                    PsiElement psiElement2 = ((KtContainerNode)container2).getParent();
                    KtIfExpression ktIfExpression = psiElement2 instanceof KtIfExpression ? (KtIfExpression)psiElement2 : null;
                    Object object = elseExpression2 = ktIfExpression != null ? ktIfExpression.getElse() : null;
                    if (elseExpression2 != null && !Intrinsics.areEqual((Object)elseExpression2, (Object)block2)) {
                        return false;
                    }
                }
                return true;
            }
            if (container2 instanceof KtWhenEntry) {
                return !(singleStatement instanceof KtNamedDeclaration);
            }
            return false;
        }

        public final void removeBraces(@NotNull KtElement element3, @NotNull KtBlockExpression block2, @Nullable Editor editor2) {
            block11: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                Project project2 = element3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
                KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
                List list2 = block2.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"block.statements");
                KtExpression statement2 = (KtExpression)CollectionsKt.single((List)list2);
                Editor editor3 = editor2;
                if (editor3 != null) {
                    int n = editor3.getCaretModel().getOffset();
                    Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"statement");
                    bl = n >= PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)statement2));
                } else {
                    bl = false;
                }
                boolean caretOnAfterStatement = bl;
                PsiElement container2 = block2.getParent();
                PsiElement psiElement2 = container2.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression construct = (KtExpression)psiElement2;
                this.handleComments(construct, block2);
                PsiElement newElement = block2.replace(statement2.copy());
                Editor editor4 = editor2;
                if (editor4 != null && (editor4 = editor4.getCaretModel()) != null) {
                    int n;
                    if (caretOnAfterStatement) {
                        Intrinsics.checkNotNullExpressionValue((Object)newElement, (String)"newElement");
                        n = PsiUtilsKt.getEndOffset((PsiElement)newElement);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)newElement, (String)"newElement");
                        n = PsiUtilsKt.getStartOffset((PsiElement)newElement);
                    }
                    editor4.moveToOffset(n);
                }
                if (construct instanceof KtDoWhileExpression) {
                    PsiElement psiElement3 = newElement.getParent();
                    Intrinsics.checkNotNull((Object)psiElement3);
                    psiElement3.addAfter(factory2.createNewLine(), newElement);
                } else if (editor2 != null) {
                    Document document = editor2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    Document document2 = document;
                    Intrinsics.checkNotNullExpressionValue((Object)newElement, (String)"newElement");
                    int line = document2.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)newElement));
                    int rightMargin = editor2.getSettings().getRightMargin(editor2.getProject());
                    if (document2.getLineEndOffset(line) - document2.getLineStartOffset(line) >= rightMargin) {
                        newElement.getParent().addBefore(factory2.createNewLine(), newElement);
                    }
                }
                if (!(construct instanceof KtIfExpression) || !Intrinsics.areEqual((Object)container2.getNode().getElementType(), (Object)KtNodeTypes.ELSE) || !(((KtIfExpression)construct).getParent() instanceof KtExpression) || ((KtIfExpression)construct).getParent() instanceof KtStatementExpression) break block11;
                Object[] objectArray = new Object[]{construct};
                PsiElement replaced2 = ((KtIfExpression)construct).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0)", (Object[])objectArray, (boolean)false, (int)4, null));
                PsiElement psiElement4 = replaced2.getChildren()[0];
                KtIfExpression ktIfExpression = psiElement4 instanceof KtIfExpression ? (KtIfExpression)psiElement4 : null;
                if (ktIfExpression != null && (ktIfExpression = ktIfExpression.getElse()) != null) {
                    KtIfExpression it = ktIfExpression;
                    boolean bl2 = false;
                    Editor editor5 = editor2;
                    if (editor5 != null && (editor5 = editor5.getCaretModel()) != null) {
                        editor5.moveToOffset(caretOnAfterStatement ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
                    }
                }
            }
        }

        public static /* synthetic */ void removeBraces$default(Companion companion, KtElement ktElement, KtBlockExpression ktBlockExpression, Editor editor2, int n, Object object) {
            if ((n & 4) != 0) {
                editor2 = null;
            }
            companion.removeBraces(ktElement, ktBlockExpression, editor2);
        }

        private final void handleComments(KtExpression construct, KtBlockExpression block2) {
            PsiElement sibling;
            PsiElement psiElement2 = block2.getFirstChild();
            Object object = sibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
            while (sibling != null) {
                if (sibling instanceof PsiComment) {
                    Project project2 = construct.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"construct.project");
                    KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
                    if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                        PsiElement psiElement3 = construct.getPrevSibling();
                        Intrinsics.checkNotNull((Object)psiElement3);
                        psiElement3.replace(psiFactory.createNewLine());
                    }
                    PsiElement commentElement = construct.getParent().addBefore(sibling, construct.getPrevSibling());
                    construct.getParent().addBefore(psiFactory.createNewLine(), commentElement);
                }
                sibling = sibling.getNextSibling();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

