/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.ItemPriority;
import org.jetbrains.kotlin.idea.completion.LookupElementsCollector;
import org.jetbrains.kotlin.idea.completion.OverridesCompletion;
import org.jetbrains.kotlin.idea.completion.OverridesCompletionLookupElementDecorator;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMembersHandler;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/OverridesCompletion;", "", "collector", "Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "(Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;)V", "PRESENTATION_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "canOverride", "", "descriptorToOverride", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "complete", "", "position", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl-k1"})
@SourceDebugExtension(value={"SMAP\nOverridesCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridesCompletion.kt\norg/jetbrains/kotlin/idea/completion/OverridesCompletion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,100:1\n146#2:101\n146#2:102\n*S KotlinDebug\n*F\n+ 1 OverridesCompletion.kt\norg/jetbrains/kotlin/idea/completion/OverridesCompletion\n*L\n31#1:101\n33#1:102\n*E\n"})
public final class OverridesCompletion {
    @NotNull
    private final LookupElementsCollector collector;
    @NotNull
    private final BasicLookupElementFactory lookupElementFactory;
    @NotNull
    private final DescriptorRenderer PRESENTATION_RENDERER;

    public OverridesCompletion(@NotNull LookupElementsCollector collector2, @NotNull BasicLookupElementFactory lookupElementFactory2) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)lookupElementFactory2, (String)"lookupElementFactory");
        this.collector = collector2;
        this.lookupElementFactory = lookupElementFactory2;
        this.PRESENTATION_RENDERER = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.withOptions((Function1)PRESENTATION_RENDERER.1.INSTANCE);
    }

    public final void complete(@NotNull PsiElement position, @Nullable KtCallableDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiElement $this$getNonStrictParentOfType$iv = position;
        boolean $i$f$getNonStrictParentOfType = false;
        boolean isConstructorParameter = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtPrimaryConstructor.class, (boolean)false) != null;
        PsiElement $this$getNonStrictParentOfType$iv2 = position;
        boolean $i$f$getNonStrictParentOfType2 = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        Collection<OverrideMemberChooserObject> members2 = new OverrideMembersHandler(isConstructorParameter).collectMembersToGenerate(classOrObject);
        for (OverrideMemberChooserObject memberObject : members2) {
            String baseClassName;
            Icon additionalIcon;
            CallableMemberDescriptor descriptor2 = memberObject.getDescriptor();
            if (declaration2 != null && !this.canOverride(descriptor2, declaration2) || isConstructorParameter && !(descriptor2 instanceof PropertyDescriptor)) continue;
            LookupElement lookupElement2 = BasicLookupElementFactory.createLookupElement$default(this.lookupElementFactory, (DeclarationDescriptor)descriptor2, false, false, false, 14, null);
            String text2 = "override " + this.PRESENTATION_RENDERER.render((DeclarationDescriptor)descriptor2);
            if (descriptor2 instanceof FunctionDescriptor) {
                text2 = text2 + " {...}";
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassDescriptor baseClass2 = (ClassDescriptor)declarationDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)baseClass2.getName().asString(), (String)"baseClass.name.asString()");
            Object object = lookupElement2.getObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject");
            Icon baseIcon = ((DescriptorBasedDeclarationLookupObject)object).getIcon(0);
            boolean isImplement = descriptor2.getModality() == Modality.ABSTRACT;
            Intrinsics.checkNotNullExpressionValue((Object)(isImplement ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod), (String)"if (isImplement)\n       \u2026s.Gutter.OverridingMethod");
            additionalIcon = additionalIcon;
            Icon[] iconArray = new Icon[]{baseIcon, additionalIcon};
            RowIcon icon = new RowIcon(iconArray);
            Project project2 = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"position.project");
            PsiElement baseClassDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)baseClass2);
            Icon baseClassIcon = KotlinDescriptorIconProvider.getIcon((DeclarationDescriptor)baseClass2, baseClassDeclaration, 0);
            lookupElement2 = (LookupElement)new OverridesCompletionLookupElementDecorator(lookupElement2, declaration2, text2, isImplement, icon, baseClassName, baseClassIcon, isConstructorParameter, DescriptorUtilsKt.isSuspend((CallableDescriptor)((CallableDescriptor)memberObject.getDescriptor())), (Function0<? extends KtCallableDeclaration>)((Function0)new Function0<KtCallableDeclaration>(memberObject, classOrObject){
                final /* synthetic */ OverrideMemberChooserObject $memberObject;
                final /* synthetic */ KtClassOrObject $classOrObject;
                {
                    this.$memberObject = $memberObject;
                    this.$classOrObject = $classOrObject;
                    super(0);
                }

                @NotNull
                public final KtCallableDeclaration invoke() {
                    return OverrideMemberChooserObjectKt.generateMember(this.$memberObject, this.$classOrObject, false);
                }
            }), (Function1<? super KtElement, Unit>)((Function1)new Function1<KtElement, Unit>((Object)ShortenReferences.DEFAULT){

                public final void invoke(@NotNull KtElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ShortenReferences.process$default((ShortenReferences)complete.2.access$getReceiver$p(this), p0, null, 2, null);
                }

                public static final /* synthetic */ Object access$getReceiver$p(complete.2 $this) {
                    return $this.receiver;
                }
            }));
            CompletionUtilsKt.assignPriority(lookupElement2, isImplement ? ItemPriority.IMPLEMENT : ItemPriority.OVERRIDE);
            LookupElementsCollector.addElement$default(this.collector, lookupElement2, false, 2, null);
        }
    }

    private final boolean canOverride(CallableMemberDescriptor descriptorToOverride, KtCallableDeclaration declaration2) {
        KtCallableDeclaration ktCallableDeclaration2 = declaration2;
        if (ktCallableDeclaration2 instanceof KtFunction) {
            return descriptorToOverride instanceof FunctionDescriptor;
        }
        if (ktCallableDeclaration2 instanceof KtValVarKeywordOwner) {
            if (!(descriptorToOverride instanceof PropertyDescriptor)) {
                return false;
            }
            PsiElement psiElement2 = ((KtValVarKeywordOwner)declaration2).getValOrVarKeyword();
            return Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.VAL_KEYWORD) ? !((PropertyDescriptor)descriptorToOverride).isVar() : true;
        }
        return false;
    }
}

