/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategyKt;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.idea.completion.lookups.UtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionCallLookupObject;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "()V", "addArguments", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "offsetElement", "Lcom/intellij/psi/PsiElement;", "lookupObject", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionCallLookupObject;", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isInsertSpacesInOneLineFunctionEnabled", "", "file", "shouldPlaceCaretInBrackets", "completionChar", "", "kotlin.completion.impl-k2"})
@SourceDebugExtension(value={"SMAP\nFunctionLookupElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionLookupElementFactory.kt\norg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionInsertionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n1#2:297\n*E\n"})
public final class FunctionInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @NotNull
    public static final FunctionInsertionHandler INSTANCE = new FunctionInsertionHandler();

    private FunctionInsertionHandler() {
    }

    private final void addArguments(InsertionContext context2, PsiElement offsetElement, FunctionCallLookupObject lookupObject) {
        Integer n;
        Integer openingBracketOffset;
        int offset1;
        char completionChar = context2.getCompletionChar();
        if (completionChar == '(') {
            context2.setAddCompletionChar(false);
        }
        int offset2 = context2.getTailOffset();
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
        Document document2 = document;
        Editor editor2 = context2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"context.editor");
        Editor editor3 = editor2;
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        Project project3 = project2;
        CharSequence charSequence2 = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.charsSequence");
        CharSequence chars = charSequence2;
        boolean isSmartEnterCompletion = completionChar == '\r';
        boolean isReplaceCompletion = completionChar == '\t';
        boolean isNormalCompletion = completionChar == '\n';
        boolean insertTypeArguments = lookupObject.getInputTypeArgumentsAreRequired() && (isNormalCompletion || isReplaceCompletion || isSmartEnterCompletion);
        boolean preferParentheses = completionChar == '(' || isReplaceCompletion && HandlerUtilsKt.isCharAt(chars, offset2, '(');
        boolean insertLambda = !preferParentheses && lookupObject.getInsertEmptyLambda();
        Pair pair = insertLambda ? TuplesKt.to((Object)Character.valueOf('{'), (Object)Character.valueOf('}')) : TuplesKt.to((Object)Character.valueOf('('), (Object)Character.valueOf(')'));
        char openingBracket = ((Character)pair.component1()).charValue();
        char closingBracket = ((Character)pair.component2()).charValue();
        if (isReplaceCompletion && (offset1 = UtilsKt.skipSpaces(chars, offset2)) < chars.length() && chars.charAt(offset1) == '<') {
            PsiElement parent2;
            PsiElement psiElement2 = context2.getFile().findElementAt(offset1);
            Intrinsics.checkNotNull((Object)psiElement2);
            PsiElement token = psiElement2;
            if (Intrinsics.areEqual((Object)token.getNode().getElementType(), (Object)KtTokens.LT) && (parent2 = token.getParent()) instanceof KtTypeArgumentList) {
                String string2 = parent2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.getText()");
                if (StringsKt.indexOf$default((CharSequence)string2, (char)'\n', (int)0, (boolean)false, (int)6, null) < 0) {
                    offset2 = com.intellij.refactoring.suggested.UtilsKt.getEndOffset((PsiElement)parent2);
                    insertTypeArguments = false;
                }
            }
        }
        if (insertTypeArguments) {
            document2.insertString(offset2, (CharSequence)"<>");
            editor3.getCaretModel().moveToOffset(offset2 + 1);
            offset2 += 2;
        }
        Integer n2 = openingBracketOffset = UtilsKt.indexOfSkippingSpace(chars, openingBracket, offset2);
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = UtilsKt.indexOfSkippingSpace(chars, closingBracket, it + 1);
        } else {
            n = null;
        }
        Integer closeBracketOffset = n;
        int inBracketsShift = 0;
        if (openingBracketOffset == null) {
            if (insertLambda) {
                if (completionChar == ' ' || completionChar == '{') {
                    context2.setAddCompletionChar(false);
                }
                PsiFile psiFile2 = context2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"context.file");
                if (this.isInsertSpacesInOneLineFunctionEnabled((PsiElement)psiFile2)) {
                    document2.insertString(offset2, (CharSequence)" {  }");
                    inBracketsShift = 1;
                } else {
                    document2.insertString(offset2, (CharSequence)" {}");
                }
            } else if (isSmartEnterCompletion) {
                document2.insertString(offset2, (CharSequence)"(");
            } else {
                document2.insertString(offset2, (CharSequence)"()");
            }
            context2.commitDocument();
            CharSequence charSequence3 = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"document.charsSequence");
            Integer n3 = UtilsKt.indexOfSkippingSpace(charSequence3, openingBracket, offset2);
            Intrinsics.checkNotNull((Object)n3);
            openingBracketOffset = n3;
            CharSequence charSequence4 = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence4, (String)"document.charsSequence");
            closeBracketOffset = UtilsKt.indexOfSkippingSpace(charSequence4, closingBracket, openingBracketOffset + 1);
        }
        if (!insertTypeArguments) {
            if (this.shouldPlaceCaretInBrackets(completionChar, lookupObject) || closeBracketOffset == null) {
                editor3.getCaretModel().moveToOffset(openingBracketOffset + 1 + inBracketsShift);
                AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project3);
                if (autoPopupController != null) {
                    autoPopupController.autoPopupParameterInfo(editor3, offsetElement);
                }
            } else {
                editor3.getCaretModel().moveToOffset(closeBracketOffset + 1);
            }
        }
    }

    private final boolean shouldPlaceCaretInBrackets(char completionChar, FunctionCallLookupObject lookupObject) {
        if (completionChar == ',' || completionChar == '.' || completionChar == '=') {
            return false;
        }
        if (completionChar == '(') {
            return true;
        }
        return lookupObject.getInputValueArgumentsAreRequired() || lookupObject.getInsertEmptyLambda();
    }

    private final boolean isInsertSpacesInOneLineFunctionEnabled(PsiElement file2) {
        return true;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile2 = context2.getFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return;
        }
        KtFile targetFile2 = ktFile;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionCallLookupObject");
        FunctionCallLookupObject lookupObject = (FunctionCallLookupObject)object;
        super.handleInsert(context2, item);
        int startOffset = context2.getStartOffset();
        PsiElement psiElement2 = context2.getFile().findElementAt(startOffset);
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        ImportStrategy importStrategy = lookupObject.getOptions().getImportingStrategy();
        if (importStrategy instanceof ImportStrategy.InsertFqNameAndShorten) {
            context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)RenderingUtilsKt.render((FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(((ImportStrategy.InsertFqNameAndShorten)importStrategy).getFqName(), null, 1, null)));
            context2.commitDocument();
            this.addArguments(context2, element3, lookupObject);
            context2.commitDocument();
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile2, new TextRange(context2.getStartOffset(), context2.getTailOffset()), null, null, 12, null);
        } else {
            this.addArguments(context2, element3, lookupObject);
            context2.commitDocument();
            if (importStrategy instanceof ImportStrategy.AddImport) {
                ImportStrategyKt.addCallableImportIfRequired(targetFile2, ((ImportStrategy.AddImport)importStrategy).getNameToImport());
            }
        }
    }
}

