/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAddLibraryAction;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.base.codeInsight.CliArgumentStringBuilder;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.ui.CreateLibraryDialogWithModules;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 U*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001UB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0016J6\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0014\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0,\u0018\u00010+H\u0002J(\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u001e\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f08H\u0017J\u0016\u00109\u001a\u00020\u001d2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0;H\u0014J2\u0010<\u001a\u00020\u001d2\u0006\u00105\u001a\u0002062\u0006\u0010\"\u001a\u00020=2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?J0\u0010@\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0016\b\u0002\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0,\u0018\u00010+H\u0016J.\u0010A\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0014\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0,\u0018\u00010+H\u0002J\u000e\u0010B\u001a\u00020\u001d2\u0006\u00105\u001a\u000206J\u0018\u0010C\u001a\u00020'2\u0006\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)H\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0014J\u0012\u0010E\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010'2\u0006\u00105\u001a\u000206H\u0002J\u0016\u0010F\u001a\u00020\u001d2\u0006\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010L\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0018\u0010M\u001a\u0002032\u0006\u0010\"\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0002J4\u0010N\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010O\u001a\u0004\u0018\u00010\u00062\b\u0010P\u001a\u0004\u0018\u00010\u00062\u0006\u0010Q\u001a\u00020R2\u0006\u00102\u001a\u000203H\u0016J(\u0010S\u001a\u00020\u001d*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0,\u0018\u00010+2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001d0,H\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0012\u0010\u000f\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "P", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "libraryName", "getLibraryName", "libraryProperties", "getLibraryProperties", "()Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "stdlibDetector", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "getStdlibDetector", "()Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "addLibraryToModuleIfNeeded", "Lcom/intellij/openapi/roots/libraries/Library;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "writeActions", "", "Lkotlin/Function0;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureKotlinSettings", "modules", "", "configureLibraryJar", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "configureModule", "configureModuleWithLibrary", "configureSilently", "createNewLibrary", "findAndFixBrokenKotlinLibrary", "getKotlinLibrary", "getOrCreateKotlinLibrary", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "isApplicable", "isConfigured", "isKotlinLibrary", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "addOrExecute", "writeAction", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinWithLibraryConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinWithLibraryConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,389:1\n76#2:390\n76#2:391\n76#2:401\n1855#3,2:392\n1855#3,2:394\n1282#4,2:396\n1282#4,2:398\n110#5:400\n*S KotlinDebug\n*F\n+ 1 KotlinWithLibraryConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator\n*L\n79#1:390\n99#1:391\n116#1:401\n128#1:392,2\n198#1:394,2\n207#1:396,2\n208#1:398,2\n373#1:400\n*E\n"})
public abstract class KotlinWithLibraryConfigurator<P extends LibraryProperties<?>>
implements KotlinProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected KotlinWithLibraryConfigurator() {
    }

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract String getMessageForOverrideDialog();

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    public abstract LibraryType<P> getLibraryType();

    @NotNull
    public abstract LibraryJarDescriptor getLibraryJarDescriptor();

    @NotNull
    public abstract P getLibraryProperties();

    @NotNull
    public abstract StdlibDetectorFacility getStdlibDetector();

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module2 = moduleSourceRootGroup.getBaseModule();
        if (!this.isApplicable(module2)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        if (this.isConfigured(module2)) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    public abstract boolean isConfigured(@NotNull Module var1);

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project2, @NotNull Collection<Module> excludeModules) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        boolean $i$f$isUnitTestMode2 = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            list2 = (List)ApplicationUtilsKt.underModalProgressOrUnderWriteActionWithNonCancellableProgressInDispatchThread(project2, KotlinProjectConfigurationBundle.message("lookup.modules.configurations.progress.text", new Object[0]), (Function0)new Function0<List<? extends Module>>(project2, this){
                final /* synthetic */ Project $project;
                final /* synthetic */ KotlinWithLibraryConfigurator<P> this$0;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<Module> invoke() {
                    return ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(this.$project, this.this$0);
                }
            });
        } else {
            Module[] $i$f$isUnitTestMode2 = ModuleManager.Companion.getInstance(project2).getModules();
            list2 = CollectionsKt.listOf((Object[])Arrays.copyOf($i$f$isUnitTestMode2, $i$f$isUnitTestMode2.length));
        }
        List nonConfiguredModules2 = list2;
        nonConfiguredModules2 = CollectionsKt.minus((Iterable)nonConfiguredModules2, (Iterable)excludeModules);
        Ref.ObjectRef modulesToConfigure = new Ref.ObjectRef();
        modulesToConfigure.element = nonConfiguredModules2;
        if (nonConfiguredModules2.size() > 1) {
            CreateLibraryDialogWithModules dialog2 = new CreateLibraryDialogWithModules(project2, this, this.getDialogTitle(), excludeModules);
            boolean $i$f$isUnitTestMode3 = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dialog2.show();
                if (!dialog2.isOK()) {
                    return;
                }
            } else {
                dialog2.close(0);
            }
            List<Module> list3 = dialog2.getModulesToConfigure();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"dialog.modulesToConfigure");
            modulesToConfigure.element = list3;
        }
        NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create(project2);
        this.getOrCreateKotlinLibrary(project2, collector2);
        List writeActions = new ArrayList();
        ActionUtil.underModalProgress((Project)project2, (String)KotlinProjectConfigurationBundle.message("configure.kotlin.in.modules.progress.text", new Object[0]), () -> KotlinWithLibraryConfigurator.configure$lambda$1(modulesToConfigure, this, collector2, writeActions));
        Iterable $this$forEach$iv = writeActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
        this.configureKotlinSettings((List)modulesToConfigure.element);
        collector2.showNotification();
    }

    public final void getOrCreateKotlinLibrary(@NotNull Project project2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Library library2 = this.getKotlinLibrary(project2);
        if (library2 == null) {
            library2 = this.createNewLibrary(project2, collector2);
        }
    }

    public final void configureSilently(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create(project2);
        this.getOrCreateKotlinLibrary(project2, collector2);
        for (Module module2 : ModuleManager.Companion.getInstance(project2).getModules()) {
            KotlinWithLibraryConfigurator.configureModule$default(this, module2, collector2, null, 4, null);
        }
    }

    public void configureModule(@NotNull Module module2, @NotNull NotificationMessageCollector collector2, @Nullable List<Function0<Unit>> writeActions) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        this.configureModuleWithLibrary(module2, collector2, writeActions);
    }

    public static /* synthetic */ void configureModule$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Module module2, NotificationMessageCollector notificationMessageCollector, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureModule");
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        kotlinWithLibraryConfigurator.configureModule(module2, notificationMessageCollector, list2);
    }

    private final void configureModuleWithLibrary(Module module2, NotificationMessageCollector collector2, List<Function0<Unit>> writeActions) {
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        Library library2 = this.findAndFixBrokenKotlinLibrary(module2, collector2);
        if (library2 == null && (library2 = this.getKotlinLibrary(module2)) == null && (library2 = this.getKotlinLibrary(project3)) == null) {
            throw new IllegalStateException("Kotlin Library has to be created in advance".toString());
        }
        LibraryEx library3 = (LibraryEx)library2;
        Sdk sdk2 = ProjectStructureUtils.getSdk(module2);
        LibraryEx.ModifiableModelEx libraryModel = library3.getModifiableModel();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)libraryModel, (String)"libraryModel");
        this.configureLibraryJar(project3, libraryModel, this.getLibraryJarDescriptor(), collector2, ProgressManager.getGlobalProgressIndicator());
        this.addOrExecute(writeActions, (Function0<Unit>)((Function0)new Function0<Unit>(libraryModel){
            final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel;
            {
                this.$libraryModel = $libraryModel;
                super(0);
            }

            public final void invoke() {
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$libraryModel){
                    final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel;
                    {
                        this.$libraryModel = $libraryModel;
                        super(0);
                    }

                    public final void invoke() {
                        this.$libraryModel.commit();
                    }
                }));
            }
        }));
        this.addLibraryToModuleIfNeeded(module2, (Library)library3, collector2, writeActions);
    }

    private final void addOrExecute(List<Function0<Unit>> $this$addOrExecute, Function0<Unit> writeAction) {
        if ($this$addOrExecute != null) {
            $this$addOrExecute.add(writeAction);
        } else {
            writeAction.invoke();
        }
    }

    public final void configureLibraryJar(@NotNull Project project2, @NotNull LibraryEx.ModifiableModelEx library2, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull NotificationMessageCollector collector2, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        library2.setKind(RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties properties2 = libraryJarDescriptor.getRepositoryLibraryProperties();
        library2.setProperties((LibraryProperties)properties2);
        Collection dependencies2 = progressIndicator != null ? JarRepositoryManager.loadDependenciesSync((Project)project2, (RepositoryLibraryProperties)properties2, (boolean)true, (boolean)true, null, null, (ProgressIndicator)progressIndicator) : JarRepositoryManager.loadDependenciesModal((Project)project2, (RepositoryLibraryProperties)properties2, (boolean)true, (boolean)true, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)dependencies2, (String)"dependencies");
        Iterable $this$forEach$iv = dependencies2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrderRoot it = (OrderRoot)element$iv;
            boolean bl = false;
            library2.addRoot(it.getFile(), it.getType());
        }
        Object[] objectArray = new Object[]{libraryJarDescriptor.getMavenArtifactId()};
        collector2.addMessage(KotlinProjectConfigurationBundle.message("added.0.to.library.configuration", objectArray));
    }

    public static /* synthetic */ void configureLibraryJar$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Project project2, LibraryEx.ModifiableModelEx modifiableModelEx, LibraryJarDescriptor libraryJarDescriptor, NotificationMessageCollector notificationMessageCollector, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureLibraryJar");
        }
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        kotlinWithLibraryConfigurator.configureLibraryJar(project2, modifiableModelEx, libraryJarDescriptor, notificationMessageCollector, progressIndicator);
    }

    private final Library getKotlinLibrary(Project project2) {
        Library library2;
        Object object;
        Library it;
        boolean $i$f$firstOrNull;
        Object[] $this$firstOrNull$iv;
        block3: {
            Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project2).getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getInstance().getLibraryTable(project).libraries");
            $this$firstOrNull$iv = libraryArray;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Library)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.isKotlinLibrary(it, project2)) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        if ((library2 = (Library)object) == null) {
            Object object2;
            block4: {
                Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getInstance().libraryTable.libraries");
                $this$firstOrNull$iv = libraryArray;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Library)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isKotlinLibrary(it, project2)) continue;
                    object2 = element$iv;
                    break block4;
                }
                object2 = null;
            }
            library2 = (Library)object2;
        }
        return library2;
    }

    private final void addLibraryToModuleIfNeeded(Module module2, Library library2, NotificationMessageCollector collector2, List<Function0<Unit>> writeActions) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<ModifiableRootModel>(module2){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(0);
            }

            @NotNull
            public final ModifiableRootModel invoke() {
                return ModuleRootManager.getInstance((Module)this.$module).getModifiableModel();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module: Module,\n        \u2026module).modifiableModel }");
        ModifiableRootModel model2 = (ModifiableRootModel)object;
        DependencyScope expectedDependencyScope2 = (DependencyScope)ActionsKt.runReadAction((Function0)((Function0)new Function0<DependencyScope>(module2){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(0);
            }

            @NotNull
            public final DependencyScope invoke() {
                return org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator$Companion.access$getDependencyScope(KotlinWithLibraryConfigurator.Companion, this.$module);
            }
        }));
        Library kotlinLibrary2 = (Library)ActionsKt.runReadAction((Function0)((Function0)new Function0<Library>(this, module2){
            final /* synthetic */ KotlinWithLibraryConfigurator<P> this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(0);
            }

            @Nullable
            public final Library invoke() {
                return KotlinWithLibraryConfigurator.access$getKotlinLibrary(this.this$0, this.$module);
            }
        }));
        if (kotlinLibrary2 == null) {
            LibraryOrderEntry libraryOrderEntry = model2.addLibraryEntry(library2);
            Intrinsics.checkNotNullExpressionValue((Object)libraryOrderEntry, (String)"model.addLibraryEntry(library)");
            LibraryOrderEntry entry = libraryOrderEntry;
            entry.setExported(false);
            entry.setScope(expectedDependencyScope2);
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(library2.getName());
            Intrinsics.checkNotNullExpressionValue((Object)module2.getName(), (String)"module.name");
            collector2.addMessage(KotlinProjectConfigurationBundle.message("0.library.was.added.to.module.1", objectArray));
        } else {
            LibraryOrderEntry libraryOrderEntry = model2.findLibraryOrderEntry(kotlinLibrary2);
            if (libraryOrderEntry != null) {
                LibraryOrderEntry libraryEntry = libraryOrderEntry;
                boolean bl = false;
                DependencyScope dependencyScope = libraryEntry.getScope();
                Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"libraryEntry.scope");
                DependencyScope libraryDependencyScope = dependencyScope;
                if (expectedDependencyScope2 != libraryDependencyScope) {
                    libraryEntry.setScope(expectedDependencyScope2);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = String.valueOf(kotlinLibrary2.getName());
                    objectArray[1] = libraryDependencyScope;
                    objectArray[2] = expectedDependencyScope2;
                    Intrinsics.checkNotNullExpressionValue((Object)module2.getName(), (String)"module.name");
                    collector2.addMessage(KotlinProjectConfigurationBundle.message("0.library.scope.has.changed.from.1.to.2.for.module.3", objectArray));
                }
            }
        }
        this.addOrExecute(writeActions, (Function0<Unit>)((Function0)new Function0<Unit>(model2){
            final /* synthetic */ ModifiableRootModel $model;
            {
                this.$model = $model;
                super(0);
            }

            public final void invoke() {
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$model){
                    final /* synthetic */ ModifiableRootModel $model;
                    {
                        this.$model = $model;
                        super(0);
                    }

                    public final void invoke() {
                        this.$model.commit();
                    }
                }));
            }
        }));
    }

    private final Library createNewLibrary(Project project2, NotificationMessageCollector collector2) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project2);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getInstance().getLibraryTable(project)");
        LibraryTable table = libraryTable;
        Library library2 = (Library)ActionsKt.runWriteAction((Function0)((Function0)new Function0<Library>(table, this){
            final /* synthetic */ LibraryTable $table;
            final /* synthetic */ KotlinWithLibraryConfigurator<P> this$0;
            {
                this.$table = $table;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Library invoke() {
                LibraryTable.ModifiableModel modifiableModel = this.$table.getModifiableModel();
                KotlinWithLibraryConfigurator<P> kotlinWithLibraryConfigurator = this.this$0;
                LibraryTable.ModifiableModel $this$invoke_u24lambda_u240 = modifiableModel;
                boolean bl = false;
                Library library2 = $this$invoke_u24lambda_u240.createLibrary(kotlinWithLibraryConfigurator.getLibraryName(), kotlinWithLibraryConfigurator.getLibraryType().getKind());
                Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"createLibrary(libraryName, libraryType.kind)");
                Library library3 = library2;
                $this$invoke_u24lambda_u240.commit();
                return library3;
            }
        }));
        Object[] objectArray = new Object[]{String.valueOf(library2.getName())};
        collector2.addMessage(KotlinProjectConfigurationBundle.message("0.library.was.created", objectArray));
        return library2;
    }

    private final Library getKotlinLibrary(Module module2) {
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        return ProjectStructureUtils.findLibrary(module2, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(this, project3){
            final /* synthetic */ KotlinWithLibraryConfigurator<P> this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Library it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinWithLibraryConfigurator.access$isKotlinLibrary(this.this$0, it, this.$project);
            }
        }));
    }

    private final boolean isKotlinLibrary(Library library2, Project project2) {
        return Intrinsics.areEqual((Object)library2.getName(), (Object)this.getLibraryName()) || StdlibDetectorFacility.isStdlib$default(this.getStdlibDetector(), project2, library2, false, 4, null);
    }

    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
    }

    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        return null;
    }

    protected boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType(module2) == BuildSystemType.JPS;
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module2, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        KotlinFacetSettings facetSettings;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.getRuntimeLibraryVersionOrDefault(module2).getApiVersion().compareTo(sinceVersion) < 0 && !KotlinProjectConfigurationUtils.askUpdateRuntime(module2, sinceVersion)) {
            return;
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project2);
        Object object = facetSettings = kotlinFacetSettingsProvider != null ? kotlinFacetSettingsProvider.getInitializedSettings(module2) : null;
        if (facetSettings != null) {
            ModuleRootModificationUtil.updateModel((Module)module2, arg_0 -> KotlinWithLibraryConfigurator.changeGeneralFeatureConfiguration$lambda$8((Function1)new Function1<ModifiableRootModel, Unit>(facetSettings, feature, state, module2){
                final /* synthetic */ KotlinFacetSettings $facetSettings;
                final /* synthetic */ LanguageFeature $feature;
                final /* synthetic */ LanguageFeature.State $state;
                final /* synthetic */ Module $module;
                {
                    this.$facetSettings = $facetSettings;
                    this.$feature = $feature;
                    this.$state = $state;
                    this.$module = $module;
                    super(1);
                }

                public final void invoke(ModifiableRootModel it) {
                    block0: {
                        this.$facetSettings.setApiLevel(this.$feature.getSinceVersion());
                        this.$facetSettings.setLanguageLevel(this.$feature.getSinceVersion());
                        CompilerSettings compilerSettings = this.$facetSettings.getCompilerSettings();
                        if (compilerSettings == null) break block0;
                        CompilerSettings compilerSettings2 = compilerSettings;
                        LanguageFeature languageFeature = this.$feature;
                        LanguageFeature.State state = this.$state;
                        Module module2 = this.$module;
                        CompilerSettings $this$invoke_u24lambda_u240 = compilerSettings2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setAdditionalArguments(CliArgumentStringBuilder.replaceLanguageFeature$default(CliArgumentStringBuilder.INSTANCE, $this$invoke_u24lambda_u240.getAdditionalArguments(), languageFeature, state, KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2), null, null, " ", false, 24, null));
                    }
                }
            }, arg_0));
        }
    }

    @Override
    public void updateLanguageVersion(@NotNull Module module2, @Nullable String languageVersion, @Nullable String apiVersion2, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        KotlinFacetSettings facetSettings;
        boolean runtimeUpdateRequired;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2);
        if (ideKotlinVersion != null && (ideKotlinVersion = ideKotlinVersion.getApiVersion()) != null) {
            IdeKotlinVersion runtimeVersion = ideKotlinVersion;
            boolean bl = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired && !KotlinProjectConfigurationUtils.askUpdateRuntime(module2, requiredStdlibVersion)) {
            return;
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project2);
        Object object = facetSettings = kotlinFacetSettingsProvider != null ? kotlinFacetSettingsProvider.getSettings(module2) : null;
        if (facetSettings != null) {
            ModifiableFacetModel modifiableFacetModel = FacetManager.getInstance((Module)module2).createModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableFacetModel, (String)"getInstance(module).createModifiableModel()");
            ModifiableFacetModel model2 = modifiableFacetModel;
            KotlinFacetSettings $this$updateLanguageVersion_u24lambda_u2410 = facetSettings;
            boolean bl = false;
            if (languageVersion != null) {
                $this$updateLanguageVersion_u24lambda_u2410.setLanguageLevel(LanguageVersion.Companion.fromVersionString(languageVersion));
            }
            if (apiVersion2 != null) {
                $this$updateLanguageVersion_u24lambda_u2410.setApiLevel(LanguageVersion.Companion.fromVersionString(apiVersion2));
            }
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(model2){
                final /* synthetic */ ModifiableFacetModel $model;
                {
                    this.$model = $model;
                    super(0);
                }

                public final void invoke() {
                    this.$model.commit();
                }
            }));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element, @NotNull ExternalLibraryDescriptor library, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull DependencyScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libraryJarDescriptor, (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        v0 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module.project");
        project = v0;
        foundLibrary = new Ref.ObjectRef();
        KotlinRuntimeLibraryUtilKt.forEachAllUsedLibraries(project, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(libraryJarDescriptor, (Ref.ObjectRef<Library>)foundLibrary){
            final /* synthetic */ LibraryJarDescriptor $libraryJarDescriptor;
            final /* synthetic */ Ref.ObjectRef<Library> $foundLibrary;
            {
                this.$libraryJarDescriptor = $libraryJarDescriptor;
                this.$foundLibrary = $foundLibrary;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Library it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$libraryJarDescriptor.findExistingJar(it) != null) {
                    LibraryEx libraryEx;
                    Library $this$safeAs$iv = it;
                    boolean $i$f$safeAs = false;
                    Library library2 = $this$safeAs$iv;
                    if (!(library2 instanceof LibraryEx)) {
                        library2 = null;
                    }
                    boolean bl = (libraryEx = (LibraryEx)library2) != null && (libraryEx = libraryEx.getModule()) != null ? libraryEx.equals(null) : false;
                    if (bl) {
                        this.$foundLibrary.element = it;
                        return false;
                    }
                }
                return true;
            }
        }));
        v1 = (Library)foundLibrary.element;
        if (v1 != null) {
            it = v1;
            $i$a$-let-KotlinWithLibraryConfigurator$addLibraryDependency$2 = false;
            ModuleRootModificationUtil.addDependency((Module)module, (Library)it, (DependencyScope)scope, (boolean)false);
        }
        var9_11 = ProjectStructureUtils.findLibrary(module, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(this, project){
            final /* synthetic */ KotlinWithLibraryConfigurator<P> this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Library it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinWithLibraryConfigurator.access$isKotlinLibrary(this.this$0, it, this.$project);
            }
        }));
        if (var9_11 == null) ** GOTO lbl-1000
        $i$a$-let-KotlinWithLibraryConfigurator$addLibraryDependency$2 = var9_11;
        $i$f$safeAs = false;
        v2 = $this$safeAs$iv;
        if (!(v2 instanceof LibraryEx)) {
            v2 = null;
        }
        if ((var10_8 = (LibraryEx)v2) == null || (var11_10 = var10_8.getProperties()) == null) ** GOTO lbl-1000
        $this$safeAs$iv = var11_10;
        $i$f$safeAs = false;
        v3 = $this$safeAs$iv;
        if (!(v3 instanceof RepositoryLibraryProperties)) {
            v3 = null;
        }
        if ((var12_13 = (RepositoryLibraryProperties)v3) != null) {
            v4 = var12_13.getVersion();
        } else lbl-1000:
        // 3 sources

        {
            v4 = null;
        }
        kotlinStdlibVersion = v4;
        v5 = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)libraryJarDescriptor.getRepositoryLibraryProperties());
        v6 = kotlinStdlibVersion;
        if (v6 == null) {
            v6 = KotlinPluginLayout.getStandaloneCompilerVersion().getArtifactVersion();
        }
        RepositoryAddLibraryAction.addLibraryToModule((RepositoryLibraryDescription)v5, (Module)module, (String)v6, (DependencyScope)scope, (boolean)true, (boolean)true);
    }

    private static final Unit configure$lambda$1(Ref.ObjectRef $modulesToConfigure, KotlinWithLibraryConfigurator this$0, NotificationMessageCollector $collector, List $writeActions) {
        Intrinsics.checkNotNullParameter((Object)$modulesToConfigure, (String)"$modulesToConfigure");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$collector, (String)"$collector");
        Intrinsics.checkNotNullParameter((Object)$writeActions, (String)"$writeActions");
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        Iterator iterator2 = ((List)$modulesToConfigure.element).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Module module2 = (Module)iterator2.next();
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (progressIndicator != null) {
                    ProgressIndicator it;
                    boolean bl = false;
                    it.checkCanceled();
                    it.setFraction((double)index * 1.0 / (double)((List)$modulesToConfigure.element).size());
                    it.setText(KotlinProjectConfigurationBundle.message("configure.kotlin.in.modules.progress.text", new Object[0]));
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)module2.getName(), (String)"module.name");
                    it.setText2(KotlinProjectConfigurationBundle.message("configure.kotlin.in.module.0.progress.text", objectArray));
                }
            }
            this$0.configureModule(module2, $collector, $writeActions);
        }
        return Unit.INSTANCE;
    }

    private static final void changeGeneralFeatureConfiguration$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Library access$getKotlinLibrary(KotlinWithLibraryConfigurator $this, Module module2) {
        return $this.getKotlinLibrary(module2);
    }

    public static final /* synthetic */ boolean access$isKotlinLibrary(KotlinWithLibraryConfigurator $this, Library library2, Project project2) {
        return $this.isKotlinLibrary(library2, project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$Companion;", "", "()V", "getDependencyScope", "Lcom/intellij/openapi/roots/DependencyScope;", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        private final DependencyScope getDependencyScope(Module module2) {
            return ProjectStructureUtils.hasKotlinFilesInTestsOnly(module2) ? DependencyScope.TEST : DependencyScope.COMPILE;
        }

        public static final /* synthetic */ DependencyScope access$getDependencyScope(Companion $this, Module module2) {
            return $this.getDependencyScope(module2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

