/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import java.time.LocalDate;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationBundle;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u0004"}, d2={"showEapSurveyNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.migration"})
public final class EapSurveyNotificationKt {
    @ApiStatus.Internal
    public static final void showEapSurveyNotification(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (LocalDate.now().compareTo(LocalDate.of(2022, 5, 8)) > 0) {
            return;
        }
        IdeKotlinVersion compilerVersion = KotlinPluginLayout.getIdeCompilerVersion();
        if (!Intrinsics.areEqual((Object)compilerVersion.getKotlinVersion(), (Object)new KotlinVersion(1, 7, 0))) {
            return;
        }
        if (!Intrinsics.areEqual((Object)compilerVersion.getKind(), (Object)new IdeKotlinVersion.Kind.Beta(1))) {
            return;
        }
        RunOnceUtil.runOnceForApp((String)"kotlin.eap.survey.was.shown.once", () -> EapSurveyNotificationKt.showEapSurveyNotification$lambda$0(project2));
    }

    private static final void showEapSurveyNotification$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin EAP Survey").createNotification(KotlinMigrationBundle.message("kotlin.eap.survey.notification.title", new Object[0]), KotlinMigrationBundle.message("kotlin.eap.survey.notification.text", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction(KotlinMigrationBundle.message("kotlin.eap.survey.notification.action", new Object[0]), KotlinMigrationBundle.message("kotlin.eap.survey.notification.link", new Object[0]))).setSuggestionType(true).setIcon(KotlinIcons.SMALL_LOGO).setImportant(true).notify($project);
    }
}

