/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeaturesPanel;
import org.jetbrains.kotlin.idea.preferences.KotlinPreferencesBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

public class KotlinLanguageConfigurationForm {
    public JComboBox<String> channelCombo;
    public JButton reCheckButton;
    public JPanel mainPanel;
    public AsyncProcessIcon updateCheckProgressIcon;
    public JLabel updateStatusLabel;
    public JButton installButton;
    public JLabel installStatusLabel;
    private JLabel verifierDisabledText;
    private JPanel pluginVersionPanel;
    private JTextPane currentVersion;
    public ExperimentalFeaturesPanel experimentalFeaturesPanel;
    private JPanel experimentalFeaturesPanelContainer;
    private JTextPane currentAnalyzerVersion;
    private JPanel analyzerVersionPanel;

    public KotlinLanguageConfigurationForm() {
        this.$$$setupUI$$$();
        this.showVerifierDisabledStatus();
        this.experimentalFeaturesPanelContainer.setVisible(ExperimentalFeaturesPanel.Companion.shouldBeShown());
        KotlinIdePlugin kotlinPlugin = KotlinIdePlugin.INSTANCE;
        @NlsSafe String pluginVersion = kotlinPlugin.getVersion();
        if (kotlinPlugin.getHasPatchedVersion()) {
            String pluginVersionFromIdea = kotlinPlugin.getOriginalVersion();
            this.currentVersion.setText(KotlinPreferencesBundle.message("configuration.text.patched.original", pluginVersion, pluginVersionFromIdea));
        } else {
            this.currentVersion.setText(pluginVersion);
        }
        this.analyzerVersionPanel.setVisible(ApplicationUtilsKt.isApplicationInternalMode());
        this.currentAnalyzerVersion.setText(KotlinPluginLayout.getIdeCompilerVersion().getRawVersion());
        this.currentVersion.setBackground(this.pluginVersionPanel.getBackground());
        this.currentAnalyzerVersion.setBackground(this.analyzerVersionPanel.getBackground());
    }

    public void initChannels(List<@NlsSafe String> channels) {
        this.channelCombo.removeAllItems();
        for (String channel : channels) {
            this.channelCombo.addItem(channel);
        }
        int size = this.channelCombo.getModel().getSize();
        String maxLengthItem = "";
        for (int i2 = 0; i2 < size; ++i2) {
            String item = (String)this.channelCombo.getModel().getElementAt(i2);
            if (item.length() <= maxLengthItem.length()) continue;
            maxLengthItem = item;
        }
        this.channelCombo.setPrototypeDisplayValue(maxLengthItem + " ");
    }

    private void createUIComponents() {
        this.updateCheckProgressIcon = new AsyncProcessIcon("Plugin update check progress");
    }

    public void resetUpdateStatus() {
        this.updateStatusLabel.setText(" ");
        this.installButton.setVisible(false);
        this.installStatusLabel.setVisible(false);
    }

    public void setUpdateStatus(@Nls String message2, boolean showInstallButton) {
        this.installButton.setEnabled(true);
        this.installButton.setVisible(showInstallButton);
        this.updateStatusLabel.setText(message2);
        this.installStatusLabel.setVisible(true);
        this.installStatusLabel.setText("");
    }

    public void showInstallButton() {
        this.installButton.setEnabled(true);
        this.installButton.setVisible(true);
    }

    public void hideInstallButton() {
        this.installButton.setEnabled(false);
        this.installButton.setVisible(false);
    }

    private void showVerifierDisabledStatus() {
        if (!Registry.is((String)"kotlin.plugin.update.verifier.enabled", (boolean)true)) {
            this.verifierDisabledText.setText(KotlinPreferencesBundle.message("configuration.message.verifier.disabled", new Object[0]));
        } else {
            this.verifierDisabledText.setText("");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ExperimentalFeaturesPanel experimentalFeaturesPanel;
        JPanel jPanel2;
        JTextPane jTextPane;
        JPanel jPanel3;
        JTextPane jTextPane2;
        JPanel jPanel4;
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JButton jButton2;
        JLabel jLabel3;
        JPanel jPanel5;
        this.createUIComponents();
        this.mainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, 5, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.updateStatusLabel = jLabel3 = new JLabel();
        jLabel3.setText(" ");
        Component component2 = jPanel6.add(jLabel3);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel7, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(97, 21), null));
        this.installButton = jButton2 = new JButton();
        jButton2.setActionCommand(DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("action.text.install"));
        jButton2.setLabel(DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("action.text.install"));
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("mnemonic.install"));
        ((Component)jButton2).setVisible(true);
        Component component3 = jPanel7.add(jButton2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(1, 0, 5));
        Component component4 = jPanel7.add(jPanel8);
        this.installStatusLabel = jLabel2 = new JLabel();
        jLabel2.setText(" ");
        Component component5 = jPanel8.add(jLabel2);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel9, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.verifierDisabledText = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("status"));
        Component component6 = jPanel9.add(jLabel);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("update.channel"));
        Component component7 = jPanel10.add(jLabel4);
        JComboBox jComboBox = new JComboBox();
        this.channelCombo = jComboBox;
        Component component8 = jPanel10.add(jComboBox);
        this.reCheckButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("action.check.again"));
        Component component9 = jPanel10.add(jButton);
        AsyncProcessIcon asyncProcessIcon = this.updateCheckProgressIcon;
        Component component10 = jPanel10.add((Component)asyncProcessIcon);
        this.pluginVersionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(335, 24), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("current.kotlin.plugin.version"));
        Component component11 = jPanel4.add(jLabel5);
        this.currentVersion = jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setText(DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("version"));
        Component component12 = jPanel4.add(jTextPane2);
        this.analyzerVersionPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(335, 24), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("analyzer.version"));
        Component component13 = jPanel3.add(jLabel6);
        this.currentAnalyzerVersion = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText(DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("version"));
        Component component14 = jPanel3.add(jTextPane);
        this.experimentalFeaturesPanelContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinPreferencesBundle", KotlinLanguageConfigurationForm.class).getString("experimental.features"), (int)0, (int)0, null, null));
        this.experimentalFeaturesPanel = experimentalFeaturesPanel = new ExperimentalFeaturesPanel();
        jPanel2.add((Component)experimentalFeaturesPanel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel4.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

