/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.ElementsAndTextsProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.KotlinPasteFromJavaDialog;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.ParseContext;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.j2k.WithProgressProcessor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a2\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a&\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\n\u0010\u0018\u001a\u00020\u000b*\u00020\u0015\u00a8\u0006\u0019"}, d2={"checkUseNewJ2k", "", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "confirmConvertJavaOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "isPlainText", "isNoConversionPosition", "file", "offset", "", "runPostProcessing", "", "bounds", "Lcom/intellij/openapi/util/TextRange;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "useNewJ2k", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "targetModule", "Lcom/intellij/openapi/module/Module;", "linesCount", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertJavaCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertJavaCopyPasteProcessorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n800#2,11:380\n800#2,11:391\n1#3:402\n*S KotlinDebug\n*F\n+ 1 ConvertJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertJavaCopyPasteProcessorKt\n*L\n254#1:380,11\n333#1:391,11\n*E\n"})
public final class ConvertJavaCopyPasteProcessorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversionResult convertCodeToKotlin(@NotNull ElementAndTextList $this$convertCodeToKotlin, @NotNull Project project2, @Nullable Module targetModule, boolean useNewJ2k) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$convertCodeToKotlin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JavaToKotlinConverter converter = J2kConverterExtension.Companion.extension(useNewJ2k).createJavaToKotlinConverter(project2, targetModule, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
        Iterable $this$filterIsInstance$iv = $this$convertCodeToKotlin.toList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputElements = (List)destination$iv$iv;
        Result result2 = (Result)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin$lambda$0(converter, inputElements), JavaToKotlinAction.Companion.getTitle(), true, project2);
        List<ElementResult> results2 = result2.component1();
        ConverterContext converterContext = result2.component3();
        LinkedHashSet<FqName> importsToAdd = new LinkedHashSet<FqName>();
        Ref.IntRef resultIndex = new Ref.IntRef();
        StringBuilder convertedCodeBuilder = new StringBuilder();
        StringBuilder originalCodeBuilder = new StringBuilder();
        Ref.ObjectRef parseContext = new Ref.ObjectRef();
        $this$convertCodeToKotlin.process(new ElementsAndTextsProcessor(originalCodeBuilder, results2, resultIndex, convertedCodeBuilder, (Ref.ObjectRef<ParseContext>)parseContext, importsToAdd){
            final /* synthetic */ StringBuilder $originalCodeBuilder;
            final /* synthetic */ List<ElementResult> $results;
            final /* synthetic */ Ref.IntRef $resultIndex;
            final /* synthetic */ StringBuilder $convertedCodeBuilder;
            final /* synthetic */ Ref.ObjectRef<ParseContext> $parseContext;
            final /* synthetic */ LinkedHashSet<FqName> $importsToAdd;
            {
                this.$originalCodeBuilder = $originalCodeBuilder;
                this.$results = $results;
                this.$resultIndex = $resultIndex;
                this.$convertedCodeBuilder = $convertedCodeBuilder;
                this.$parseContext = $parseContext;
                this.$importsToAdd = $importsToAdd;
            }

            public void processElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                String originalText = element3.getText();
                this.$originalCodeBuilder.append(originalText);
                int n = this.$resultIndex.element;
                this.$resultIndex.element = n + 1;
                ElementResult result2 = this.$results.get(n);
                if (result2 != null) {
                    this.$convertedCodeBuilder.append(result2.getText());
                    if (this.$parseContext.element == null) {
                        this.$parseContext.element = result2.getParseContext();
                    }
                    this.$importsToAdd.addAll((Collection<FqName>)result2.getImportsToAdd());
                } else {
                    this.$convertedCodeBuilder.append(originalText);
                }
            }

            public void processText(@NotNull String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                this.$originalCodeBuilder.append(string2);
                this.$convertedCodeBuilder.append(string2);
            }
        });
        String string2 = convertedCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertedCodeBuilder.toString()");
        String convertedCode = string2;
        String string3 = originalCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"originalCodeBuilder.toString()");
        String originalCode = string3;
        ParseContext parseContext2 = (ParseContext)((Object)parseContext.element);
        if (parseContext2 == null) {
            parseContext2 = ParseContext.CODE_BLOCK;
        }
        return new ConversionResult(convertedCode, parseContext2, (Set<FqName>)importsToAdd, !Intrinsics.areEqual((Object)convertedCode, (Object)originalCode), converterContext);
    }

    public static final boolean isNoConversionPosition(@NotNull KtFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (offset2 == 0) {
            return false;
        }
        PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
        if (psiElement2 == null) {
            return true;
        }
        PsiElement token = psiElement2;
        if (!(token instanceof PsiWhiteSpace) && PsiUtilsKt.getEndOffset((PsiElement)token) != offset2) {
            return true;
        }
        for (PsiElement element3 : PsiUtilsKt.getParentsWithSelf((PsiElement)token)) {
            PsiElement psiElement3 = element3;
            if (psiElement3 instanceof PsiComment) {
                return Intrinsics.areEqual((Object)((PsiComment)element3).getNode().getElementType(), (Object)KtTokens.EOL_COMMENT) || offset2 != PsiUtilsKt.getEndOffset((PsiElement)element3);
            }
            if (psiElement3 instanceof KtStringTemplateEntryWithExpression) {
                return false;
            }
            if (!(psiElement3 instanceof KtStringTemplateExpression)) continue;
            return true;
        }
        return false;
    }

    public static final boolean confirmConvertJavaOnPaste(@NotNull Project project2, boolean isPlainText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (KotlinEditorOptions.getInstance().isDonTShowConversionDialog()) {
            return true;
        }
        KotlinPasteFromJavaDialog dialog2 = new KotlinPasteFromJavaDialog(project2, isPlainText);
        dialog2.show();
        return dialog2.isOK();
    }

    /*
     * WARNING - void declaration
     */
    public static final int linesCount(@NotNull ElementAndTextList $this$linesCount) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$linesCount, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$linesCount.toList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            PsiElement $i$f$filterIsInstanceTo2 = (PsiElement)e;
            int n2 = n;
            boolean bl = false;
            int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
            n = n2 + n3;
        }
        return n;
    }

    public static final boolean checkUseNewJ2k(@NotNull KtFile targetFile2) {
        Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
        if (targetFile2 instanceof KtCodeFragment) {
            return false;
        }
        return ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled();
    }

    public static final void runPostProcessing(@NotNull Project project2, @NotNull KtFile file2, @Nullable TextRange bounds, @Nullable ConverterContext converterContext, boolean useNewJ2k) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PostProcessor postProcessor2 = J2kConverterExtension.Companion.extension(useNewJ2k).createPostProcessor(true);
        if (useNewJ2k) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ConvertJavaCopyPasteProcessorKt.runPostProcessing$lambda$2(postProcessor2, project2, file2, converterContext, bounds), KotlinBundle.message("copy.text.convert.java.to.kotlin.title", new Object[0]), true, project2);
        } else {
            AfterConversionPass.run$default(new AfterConversionPass(project2, postProcessor2), file2, converterContext, bounds, null, 8, null);
        }
    }

    private static final Result convertCodeToKotlin$lambda$0(JavaToKotlinConverter $converter, List $inputElements) {
        Intrinsics.checkNotNullParameter((Object)$converter, (String)"$converter");
        Intrinsics.checkNotNullParameter((Object)$inputElements, (String)"$inputElements");
        return (Result)ActionsKt.runReadAction((Function0)((Function0)new Function0<Result>($converter, (List<? extends PsiElement>)$inputElements){
            final /* synthetic */ JavaToKotlinConverter $converter;
            final /* synthetic */ List<PsiElement> $inputElements;
            {
                this.$converter = $converter;
                this.$inputElements = $inputElements;
                super(0);
            }

            @NotNull
            public final Result invoke() {
                return this.$converter.elementsToKotlin(this.$inputElements);
            }
        }));
    }

    private static final void runPostProcessing$lambda$2(PostProcessor $postProcessor, Project $project, KtFile $file, ConverterContext $converterContext, TextRange $bounds) {
        Intrinsics.checkNotNullParameter((Object)$postProcessor, (String)"$postProcessor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        J2kConverterExtension j2kConverterExtension = J2kConverterExtension.Companion.extension(true);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNull((Object)progressIndicator);
        WithProgressProcessor processor2 = j2kConverterExtension.createWithProgressProcessor(progressIndicator, CollectionsKt.emptyList(), $postProcessor.getPhasesCount());
        new AfterConversionPass($project, $postProcessor).run($file, $converterContext, $bounds, (Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(processor2){
            final /* synthetic */ WithProgressProcessor $processor;
            {
                this.$processor = $processor;
                super(2);
            }

            public final void invoke(int phase, @NotNull String description2) {
                Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
                this.$processor.updateState(0, phase, description2);
            }
        }));
    }
}

