/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.configurationStore.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.idea.util.ReflectionUtil;

public class KotlinCodeStyleSettings
extends CustomCodeStyleSettings {
    @ReflectionUtil.SkipInEquals
    @Property(externalName="packages_to_use_import_on_demand")
    @NotNull
    public KotlinPackageEntryTable PACKAGES_TO_USE_STAR_IMPORTS;
    @ReflectionUtil.SkipInEquals
    @Property(externalName="imports_layout")
    @NotNull
    public KotlinPackageEntryTable PACKAGES_IMPORT_LAYOUT;
    public static final int DEFAULT_NAME_COUNT_TO_USE_STAR_IMPORT = 5;
    public static final int DEFAULT_NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS = 3;
    public boolean SPACE_AROUND_RANGE;
    public boolean SPACE_BEFORE_TYPE_COLON;
    public boolean SPACE_AFTER_TYPE_COLON;
    public boolean SPACE_BEFORE_EXTEND_COLON;
    public boolean SPACE_AFTER_EXTEND_COLON;
    public boolean INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD;
    public boolean ALIGN_IN_COLUMNS_CASE_BRANCH;
    public boolean LINE_BREAK_AFTER_MULTILINE_WHEN_ENTRY;
    public boolean SPACE_AROUND_FUNCTION_TYPE_ARROW;
    public boolean SPACE_AROUND_WHEN_ARROW;
    public boolean SPACE_BEFORE_LAMBDA_ARROW;
    public boolean SPACE_BEFORE_WHEN_PARENTHESES;
    public boolean LBRACE_ON_NEXT_LINE;
    public int NAME_COUNT_TO_USE_STAR_IMPORT;
    public int NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS;
    public boolean IMPORT_NESTED_CLASSES;
    public boolean CONTINUATION_INDENT_IN_PARAMETER_LISTS;
    public boolean CONTINUATION_INDENT_IN_ARGUMENT_LISTS;
    public boolean CONTINUATION_INDENT_FOR_EXPRESSION_BODIES;
    public boolean CONTINUATION_INDENT_FOR_CHAINED_CALLS;
    public boolean CONTINUATION_INDENT_IN_SUPERTYPE_LISTS;
    public boolean CONTINUATION_INDENT_IN_IF_CONDITIONS;
    public boolean CONTINUATION_INDENT_IN_ELVIS;
    public int BLANK_LINES_AROUND_BLOCK_WHEN_BRANCHES;
    public int WRAP_EXPRESSION_BODY_FUNCTIONS;
    public int WRAP_ELVIS_EXPRESSIONS;
    public boolean IF_RPAREN_ON_NEW_LINE;
    public boolean ALLOW_TRAILING_COMMA;
    public boolean ALLOW_TRAILING_COMMA_ON_CALL_SITE;
    public int BLANK_LINES_BEFORE_DECLARATION_WITH_COMMENT_OR_ANNOTATION_ON_SEPARATE_LINE;
    @ReflectionUtil.SkipInEquals
    public String CODE_STYLE_DEFAULTS;
    private final boolean isTempForDeserialize;

    public KotlinCodeStyleSettings(CodeStyleSettings container2) {
        this(container2, false);
    }

    private KotlinCodeStyleSettings(@NotNull CodeStyleSettings container2, boolean isTempForDeserialize) {
        if (container2 == null) {
            KotlinCodeStyleSettings.$$$reportNull$$$0(0);
        }
        super("JetCodeStyleSettings", container2);
        this.PACKAGES_TO_USE_STAR_IMPORTS = new KotlinPackageEntryTable();
        this.PACKAGES_IMPORT_LAYOUT = new KotlinPackageEntryTable();
        this.SPACE_AROUND_RANGE = false;
        this.SPACE_BEFORE_TYPE_COLON = false;
        this.SPACE_AFTER_TYPE_COLON = true;
        this.SPACE_BEFORE_EXTEND_COLON = true;
        this.SPACE_AFTER_EXTEND_COLON = true;
        this.INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD = true;
        this.ALIGN_IN_COLUMNS_CASE_BRANCH = false;
        this.LINE_BREAK_AFTER_MULTILINE_WHEN_ENTRY = true;
        this.SPACE_AROUND_FUNCTION_TYPE_ARROW = true;
        this.SPACE_AROUND_WHEN_ARROW = true;
        this.SPACE_BEFORE_LAMBDA_ARROW = true;
        this.SPACE_BEFORE_WHEN_PARENTHESES = true;
        this.LBRACE_ON_NEXT_LINE = false;
        this.NAME_COUNT_TO_USE_STAR_IMPORT = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : 5;
        this.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : 3;
        this.IMPORT_NESTED_CLASSES = false;
        this.CONTINUATION_INDENT_IN_PARAMETER_LISTS = true;
        this.CONTINUATION_INDENT_IN_ARGUMENT_LISTS = true;
        this.CONTINUATION_INDENT_FOR_EXPRESSION_BODIES = true;
        this.CONTINUATION_INDENT_FOR_CHAINED_CALLS = true;
        this.CONTINUATION_INDENT_IN_SUPERTYPE_LISTS = true;
        this.CONTINUATION_INDENT_IN_IF_CONDITIONS = true;
        this.CONTINUATION_INDENT_IN_ELVIS = true;
        this.BLANK_LINES_AROUND_BLOCK_WHEN_BRANCHES = 0;
        this.WRAP_EXPRESSION_BODY_FUNCTIONS = 0;
        this.WRAP_ELVIS_EXPRESSIONS = 1;
        this.IF_RPAREN_ON_NEW_LINE = false;
        this.ALLOW_TRAILING_COMMA = false;
        this.ALLOW_TRAILING_COMMA_ON_CALL_SITE = false;
        this.BLANK_LINES_BEFORE_DECLARATION_WITH_COMMENT_OR_ANNOTATION_ON_SEPARATE_LINE = 1;
        this.CODE_STYLE_DEFAULTS = null;
        this.isTempForDeserialize = isTempForDeserialize;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new KotlinPackageEntry("java.util", false));
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new KotlinPackageEntry("kotlinx.android.synthetic", true));
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new KotlinPackageEntry("io.ktor", true));
        }
        this.PACKAGES_IMPORT_LAYOUT.addEntry(KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.PACKAGES_IMPORT_LAYOUT.addEntry(new KotlinPackageEntry("java", true));
        this.PACKAGES_IMPORT_LAYOUT.addEntry(new KotlinPackageEntry("javax", true));
        this.PACKAGES_IMPORT_LAYOUT.addEntry(new KotlinPackageEntry("kotlin", true));
        this.PACKAGES_IMPORT_LAYOUT.addEntry(KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY);
    }

    public Object clone() {
        KotlinCodeStyleSettings clone2 = (KotlinCodeStyleSettings)((Object)super.clone());
        clone2.PACKAGES_TO_USE_STAR_IMPORTS = new KotlinPackageEntryTable();
        clone2.PACKAGES_TO_USE_STAR_IMPORTS.copyFrom(this.PACKAGES_TO_USE_STAR_IMPORTS);
        clone2.PACKAGES_IMPORT_LAYOUT = new KotlinPackageEntryTable();
        clone2.PACKAGES_IMPORT_LAYOUT.copyFrom(this.PACKAGES_IMPORT_LAYOUT);
        return clone2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KotlinCodeStyleSettings)) {
            return false;
        }
        KotlinCodeStyleSettings that = (KotlinCodeStyleSettings)((Object)obj);
        if (!Comparing.equal((Object)this.PACKAGES_TO_USE_STAR_IMPORTS, (Object)that.PACKAGES_TO_USE_STAR_IMPORTS)) {
            return false;
        }
        if (!Comparing.equal((Object)this.PACKAGES_IMPORT_LAYOUT, (Object)that.PACKAGES_IMPORT_LAYOUT)) {
            return false;
        }
        return ReflectionUtil.comparePublicNonFinalFieldsWithSkip((Object)this, (Object)that);
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            KotlinCodeStyleSettings.$$$reportNull$$$0(1);
        }
        if (this.CODE_STYLE_DEFAULTS != null) {
            KotlinCodeStyleSettings defaultKotlinCodeStyle = (KotlinCodeStyleSettings)((Object)parentSettings.clone());
            FormatterUtilKt.applyKotlinCodeStyle(this.CODE_STYLE_DEFAULTS, defaultKotlinCodeStyle, false);
            parentSettings = defaultKotlinCodeStyle;
        }
        super.writeExternal(parentElement, parentSettings);
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        if (this.isTempForDeserialize) {
            super.readExternal(parentElement);
            return;
        }
        KotlinCodeStyleSettings tempSettings = KotlinCodeStyleSettings.readExternalToTemp(parentElement);
        String customDefaults = tempSettings.CODE_STYLE_DEFAULTS;
        FormatterUtilKt.applyKotlinCodeStyle(customDefaults, this, true);
        super.readExternal(parentElement);
    }

    private static KotlinCodeStyleSettings readExternalToTemp(Element parentElement) {
        KotlinCodeStyleSettings tempSettings = new KotlinCodeStyleSettings(CodeStyleSettings.getDefaults(), true);
        tempSettings.readExternal(parentElement);
        return tempSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

