/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.platforms.StableModuleNameProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator;", "", "()V", "getAccessorName", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isSetter", "", "getFunctionName", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getInternalPostfix", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getParameterName", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isPublishedApi", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "CallableName", "kotlin.jvm-debugger.base.util"})
public final class CallableNameCalculator {
    @NotNull
    public static final CallableNameCalculator INSTANCE = new CallableNameCalculator();

    private CallableNameCalculator() {
    }

    @Nullable
    public final CallableName getFunctionName(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        String jvmName = KotlinPsiHeuristics.findJvmName$default((KtAnnotated)function2, null, 2, null);
        if (jvmName != null) {
            return new CallableName.Exact(jvmName);
        }
        String string2 = function2.getName();
        if (string2 == null) {
            return null;
        }
        String name2 = string2;
        String string3 = JvmCodegenUtil.sanitizeNameIfNeeded((String)name2, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function2));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sanitizeNameIfNeeded(nam\u2026.languageVersionSettings)");
        String prefix2 = string3;
        if (function2.hasModifier(KtTokens.INTERNAL_KEYWORD) && !function2.isTopLevel() && !this.isPublishedApi((KtAnnotated)function2)) {
            return new CallableName.Mangled(prefix2, this.getInternalPostfix((KtDeclaration)function2));
        }
        return new CallableName.Mangled(prefix2, null);
    }

    @Nullable
    public final CallableName getAccessorName(@NotNull KtProperty property2, boolean isSetter) {
        String prefix2;
        String jvmName;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        String string2 = jvmName = isSetter ? KotlinPsiHeuristics.findJvmSetterName((KtValVarKeywordOwner)property2) : KotlinPsiHeuristics.findJvmGetterName((KtValVarKeywordOwner)property2);
        if (jvmName != null) {
            return new CallableName.Exact(jvmName);
        }
        String string3 = property2.getName();
        if (string3 == null) {
            return null;
        }
        String propertyName = string3;
        String string4 = prefix2 = isSetter ? JvmAbi.setterName((String)propertyName) : JvmAbi.getterName((String)propertyName);
        if (property2.hasModifier(KtTokens.INTERNAL_KEYWORD) && !property2.isTopLevel() && !this.isPublishedApi((KtAnnotated)property2)) {
            return new CallableName.Mangled(prefix2, this.getInternalPostfix((KtDeclaration)property2));
        }
        return new CallableName.Mangled(prefix2, null);
    }

    @Nullable
    public final String getParameterName(@NotNull KtParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        String string2 = parameter2.getName();
        if (string2 == null) {
            return null;
        }
        String name2 = string2;
        if (Intrinsics.areEqual((Object)name2, (Object)"_")) {
            PsiElement parent2 = parameter2.getParent();
            int index = parent2 instanceof KtParameterList ? ((KtParameterList)parent2).getParameters().indexOf(parameter2) : 0;
            return "$noName_" + index;
        }
        return name2;
    }

    private final String getInternalPostfix(KtDeclaration declaration2) {
        Module module2 = GenericPsiUtils.getModule((PsiElement)declaration2);
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        Project project2 = declaration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"declaration.project");
        String moduleName2 = StableModuleNameProvider.Companion.getInstance(project2).getStableModuleName(module3);
        return "$" + NameUtils.sanitizeAsJavaIdentifier((String)moduleName2);
    }

    private final boolean isPublishedApi(KtAnnotated declaration2) {
        return KotlinPsiHeuristics.hasPublishedApiAnnotation(declaration2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "", "()V", "matches", "", "name", "", "Exact", "Mangled", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Exact;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Mangled;", "kotlin.jvm-debugger.base.util"})
    public static abstract class CallableName {
        private CallableName() {
        }

        public abstract boolean matches(@NotNull String var1);

        public /* synthetic */ CallableName(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Exact;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "matches", "", "kotlin.jvm-debugger.base.util"})
        public static final class Exact
        extends CallableName {
            @NotNull
            private final String name;

            public Exact(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(null);
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            public boolean matches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)this.name);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Mangled;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "prefix", "", "postfix", "(Ljava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "matches", "", "name", "kotlin.jvm-debugger.base.util"})
        public static final class Mangled
        extends CallableName {
            @NotNull
            private final String prefix;
            @Nullable
            private final String postfix;

            public Mangled(@NotNull String prefix2, @Nullable String postfix) {
                Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
                super(null);
                this.prefix = prefix2;
                this.postfix = postfix;
            }

            @NotNull
            public final String getPrefix() {
                return this.prefix;
            }

            @Override
            public boolean matches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return StringsKt.startsWith$default((String)name2, (String)this.prefix, (boolean)false, (int)2, null) && (this.postfix == null || StringsKt.endsWith$default((String)name2, (String)this.postfix, (boolean)false, (int)2, null));
            }
        }
    }
}

