/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a'\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001aK\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\t0\b\"\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"findElementsOfTypeInRange", "", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "classes", "", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;[Ljava/lang/Class;)Ljava/util/List;", "getParentOfLine", "getRangeOfLine", "line", "", "kotlin.jvm-debugger.base.util"})
@JvmName(name="JvmDebuggerBasePsiUtils")
@SourceDebugExtension(value={"SMAP\nJvmDebuggerBasePsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n766#2:58\n857#2,2:59\n*S KotlinDebug\n*F\n+ 1 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n*L\n42#1:58\n42#1:59,2\n*E\n"})
public final class JvmDebuggerBasePsiUtils {
    @Nullable
    public static final TextRange getRangeOfLine(@NotNull PsiFile $this$getRangeOfLine, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getRangeOfLine, (String)"<this>");
        if (line < 0) {
            return null;
        }
        Integer n = PsiLinesUtilsKt.getLineStartOffset($this$getRangeOfLine, line);
        if (n == null) {
            return null;
        }
        int startOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset($this$getRangeOfLine, line);
        if (n2 == null) {
            return null;
        }
        int endOffset2 = n2;
        if (TextRange.isProperRange((int)startOffset, (int)endOffset2)) {
            return new TextRange(startOffset, endOffset2);
        }
        return null;
    }

    public static final /* synthetic */ <T extends PsiElement> List<T> findElementsOfTypeInRange(PsiFile $this$findElementsOfTypeInRange, TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementsOfTypeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        boolean $i$f$findElementsOfTypeInRange = false;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        return JvmDebuggerBasePsiUtils.findElementsOfTypeInRange($this$findElementsOfTypeInRange, range2, classArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends PsiElement> List<T> findElementsOfTypeInRange(@NotNull PsiFile $this$findElementsOfTypeInRange, @NotNull TextRange range2, Class<? extends T> ... classes2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findElementsOfTypeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        PsiElement psiElement2 = JvmDebuggerBasePsiUtils.getParentOfLine($this$findElementsOfTypeInRange, range2);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent2 = psiElement2;
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)parent2, (boolean)false, (Class[])Arrays.copyOf(classes2, classes2.length));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(parent, false, *classes)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement el = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!range2.intersects(el.getTextRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiElement getParentOfLine(PsiFile $this$getParentOfLine, TextRange range2) {
        PsiElement psiElement2 = $this$getParentOfLine.findElementAt(range2.getStartOffset());
        if (psiElement2 == null) {
            return null;
        }
        PsiElement parent2 = psiElement2;
        while ((PsiUtilsKt.getStartOffset((PsiElement)parent2) > range2.getStartOffset() || PsiUtilsKt.getEndOffset((PsiElement)parent2) < range2.getEndOffset()) && parent2.getParent() != null) {
        }
        return parent2;
    }
}

