/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointTypeKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinLineBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u001c\u0010\u001e\u001a\u00020\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0014\u001a\u00020\u001fH\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "calculateSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "computeVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "position", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "getContainingMethod", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getSourcePosition", "matchesPosition", "Lcom/intellij/debugger/SourcePosition;", "KotlinBreakpointVariant", "LineKotlinBreakpointVariant", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n30#2,2:250\n1864#3,3:252\n57#4,2:255\n1#5:257\n*S KotlinDebug\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType\n*L\n115#1:250,2\n129#1:252,3\n160#1:255,2\n*E\n"})
public final class KotlinLineBreakpointType
extends JavaLineBreakpointType
implements KotlinBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", KotlinDebuggerCoreBundle.message("line.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return (Breakpoint)new KotlinLineBreakpoint(project2, breakpoint2);
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        JavaBreakpointProperties properties2 = KotlinLineBreakpointTypeKt.access$getJavaBreakpointProperties(breakpoint2);
        if (properties2 == null || properties2 instanceof JavaLineBreakpointProperties) {
            if (position instanceof KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties2 != null && ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement psiElement2 = this.getContainingMethod(breakpoint2);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement containingMethod = psiElement2;
            return KotlinLineBreakpointTypeKt.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        SourcePosition sourcePosition2 = breakpoint2.getSourcePosition();
        return sourcePosition2 != null && (sourcePosition2 = sourcePosition2.getElementAt()) != null ? KotlinLineBreakpointTypeKt.getContainingMethod$default((PsiElement)sourcePosition2, false, 1, null) : null;
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(file2, line){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $line;
            {
                this.$file = $file;
                this.$line = $line;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                LineBreakpointExpressionVisitor visitor2;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                ApplicabilityResult applicabilityResult = element3 instanceof KtDestructuringDeclaration ? ApplicabilityResult.MAYBE_YES : (KotlinLineBreakpointTypeKt.access$isInlineOnlyDeclaration(KotlinLineBreakpointTypeKt.getContainingMethod$default(element3, false, 1, null)) ? ApplicabilityResult.DEFINITELY_NO : (KotlinLineBreakpointTypeKt.access$isClosingBraceInMethod(element3) ? ApplicabilityResult.MAYBE_YES : (element3 instanceof KtElement ? ((visitor2 = LineBreakpointExpressionVisitor.Companion.of(this.$file, this.$line)) != null ? (ApplicabilityResult)((KtElement)element3).accept((KtVisitor)visitor2, null) : ApplicabilityResult.UNKNOWN) : ApplicabilityResult.UNKNOWN)));
                return applicabilityResult;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position) {
        Object element$iv2;
        LinkedList<Object> result2;
        PsiElement condRet;
        List<KtFunction> lambdas2;
        SourcePosition pos;
        block9: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(position.getFile());
            KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile == null) {
                return CollectionsKt.emptyList();
            }
            KtFile file2 = ktFile;
            pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)position.getLine());
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            lambdas2 = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(pos);
            PsiElement psiElement2 = condRet = JavaLineBreakpointType.canStopOnConditionalReturn((PsiFile)((PsiFile)file2)) ? JavaLineBreakpointType.findSingleConditionalReturn((PsiFile)((PsiFile)file2), (int)position.getLine()) : null;
            if (lambdas2.isEmpty() && condRet == null) {
                return CollectionsKt.emptyList();
            }
            result2 = new LinkedList<Object>();
            PsiElement psiElement3 = pos.getElementAt();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"pos.elementAt");
            Sequence $this$firstIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement3);
            boolean $i$f$firstIsInstance = false;
            for (Object element$iv2 : $this$firstIsInstance$iv) {
                if (!(element$iv2 instanceof KtElement)) continue;
                break block9;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        KtElement elementAt = (KtElement)element$iv2;
        PsiElement mainMethod = KotlinLineBreakpointTypeKt.access$getContainingMethod((PsiElement)elementAt, false);
        boolean mainMethodAdded = false;
        if (mainMethod != null) {
            boolean isLambdaResult;
            KtExpression bodyExpression = mainMethod instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)mainMethod).getBodyExpression() : null;
            boolean bl = isLambdaResult = bodyExpression instanceof KtLambdaExpression && lambdas2.contains(((KtLambdaExpression)bodyExpression).getFunctionLiteral());
            if (!isLambdaResult) {
                PsiElement variantElement = KotlinPsiUtils.getTopmostElementAtOffset((PsiElement)elementAt, pos.getOffset());
                result2.add((Object)new LineKotlinBreakpointVariant(position, variantElement, -1));
                mainMethodAdded = true;
            }
        }
        Iterable $this$forEachIndexed$iv = lambdas2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void lambda2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtFunction ktFunction = (KtFunction)item$iv;
            int ordinal = n;
            boolean bl = false;
            XSourcePositionImpl positionImpl = XSourcePositionImpl.createByElement((PsiElement)((PsiElement)lambda2.getBodyExpression()));
            if (positionImpl == null) continue;
            result2.add(new JavaLineBreakpointType.LambdaJavaBreakpointVariant((JavaLineBreakpointType)this, (XSourcePosition)positionImpl, (PsiElement)lambda2, ordinal));
        }
        if (mainMethodAdded && result2.size() > 1) {
            result2.add((Object)new KotlinBreakpointVariant(position, lambdas2.size()));
        }
        if (condRet != null) {
            PsiElement method = KotlinLineBreakpointTypeKt.getContainingMethod$default(condRet, false, 1, null);
            int ordinal = CollectionsKt.indexOf(lambdas2, (Object)method);
            result2.add(new JavaLineBreakpointType.ConditionalReturnJavaBreakpointVariant((JavaLineBreakpointType)this, position, condRet, ordinal));
        }
        return result2;
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (javaLineBreakpointProperties == null) {
            return null;
        }
        JavaLineBreakpointProperties properties2 = javaLineBreakpointProperties;
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        LineBreakpoint lineBreakpoint = breakpoint3 instanceof LineBreakpoint ? (LineBreakpoint)breakpoint3 : null;
        if (lineBreakpoint == null || (lineBreakpoint = lineBreakpoint.getSourcePosition()) == null) {
            return null;
        }
        LineBreakpoint position = lineBreakpoint;
        if (properties2.isConditionalReturn()) {
            PsiElement psiElement2 = JavaLineBreakpointType.findSingleConditionalReturn((SourcePosition)position);
            return psiElement2 != null ? psiElement2.getTextRange() : null;
        }
        Integer n = properties2.getLambdaOrdinal();
        if (n == null) {
            return null;
        }
        int lambdaOrdinal = ((Number)n).intValue();
        PsiElement psiElement3 = position.getElementAt();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"position.elementAt");
        PsiElement $this$parentOfType_u24default$iv = psiElement3;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return null;
        }
        KtFunction function2 = ktFunction;
        SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)function2));
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition updatedPosition = sourcePosition2;
        KtFunction ktFunction2 = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(updatedPosition, lambdaOrdinal);
        return ktFunction2 != null ? ktFunction2.getTextRange() : null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        XSourcePosition xSourcePosition = this.calculateSourcePosition(breakpoint2);
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition(breakpoint2);
        }
        return xSourcePosition;
    }

    private final XSourcePosition calculateSourcePosition(XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        XSourcePositionImpl xSourcePositionImpl;
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (javaLineBreakpointProperties == null) {
            return null;
        }
        JavaLineBreakpointProperties javaBreakpointProperties = javaLineBreakpointProperties;
        Intrinsics.checkNotNull(breakpoint2, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl<*>");
        SourcePosition sourcePosition2 = KotlinLineBreakpointTypeKt.access$createLineSourcePosition((XLineBreakpointImpl)breakpoint2);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (javaBreakpointProperties.isConditionalReturn() && (xSourcePositionImpl = (XSourcePositionImpl)ActionsKt.runReadAction((Function0)((Function0)new Function0<XSourcePositionImpl>(sourcePosition3){
            final /* synthetic */ SourcePosition $sourcePosition;
            {
                this.$sourcePosition = $sourcePosition;
                super(0);
            }

            @Nullable
            public final XSourcePositionImpl invoke() {
                XSourcePositionImpl xSourcePositionImpl;
                PsiElement psiElement2 = JavaLineBreakpointType.findSingleConditionalReturn((SourcePosition)this.$sourcePosition);
                if (psiElement2 != null) {
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)it);
                } else {
                    xSourcePositionImpl = null;
                }
                return xSourcePositionImpl;
            }
        }))) != null) {
            XSourcePositionImpl it = xSourcePositionImpl;
            boolean bl = false;
            return (XSourcePosition)it;
        }
        Integer n = javaBreakpointProperties.getLambdaOrdinal();
        if (n == null) {
            return null;
        }
        int lambdaOrdinal = ((Number)n).intValue();
        KtFunction ktFunction = KotlinLineBreakpointTypeKt.access$getLambdaByOrdinal(sourcePosition3, lambdaOrdinal);
        if (ktFunction == null) {
            return null;
        }
        KtFunction function2 = ktFunction;
        Object object = function2.getBodyBlockExpression();
        if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
            return null;
        }
        Object firstStatement = object;
        return (XSourcePosition)ActionsKt.runReadAction((Function0)((Function0)new Function0<XSourcePosition>((KtExpression)firstStatement, lambdaOrdinal){
            final /* synthetic */ KtExpression $firstStatement;
            final /* synthetic */ int $lambdaOrdinal;
            {
                this.$firstStatement = $firstStatement;
                this.$lambdaOrdinal = $lambdaOrdinal;
                super(0);
            }

            @Nullable
            public final XSourcePosition invoke() {
                SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)this.$firstStatement));
                if (sourcePosition2 == null) {
                    return null;
                }
                SourcePosition linePosition = sourcePosition2;
                return DebuggerUtilsEx.toXSourcePosition((SourcePosition)((SourcePosition)new PositionManagerImpl.JavaSourcePosition(linePosition, this.$lambdaOrdinal)));
            }
        }));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "lambdaCount", "", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;I)V", "kotlin.jvm-debugger.core"})
    public final class KotlinBreakpointVariant
    extends JavaLineBreakpointType.JavaBreakpointVariant {
        public KotlinBreakpointVariant(XSourcePosition position, int lambdaCount) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, lambdaCount);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "element", "Lcom/intellij/psi/PsiElement;", "lambdaOrdinal", "", "(Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/psi/PsiElement;I)V", "kotlin.jvm-debugger.core"})
    public final class LineKotlinBreakpointVariant
    extends JavaLineBreakpointType.LineJavaBreakpointVariant {
        public LineKotlinBreakpointVariant(@Nullable XSourcePosition position, PsiElement element3, int lambdaOrdinal) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, element3, lambdaOrdinal);
        }
    }
}

