/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.MockStackFrame;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0004\u001a\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\n\u0010\u001f\u001a\u00020\u0003*\u00020 \u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"*\u00020 \u001a\u001c\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150&0$*\u00020'\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)*\u00020'\u001a1\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,*\u00020\u00042\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u0001H+0.\u00a2\u0006\u0002\u00100\u001a\n\u00101\u001a\u00020\u0003*\u00020\u0015\u001a\n\u00101\u001a\u00020\u0003*\u00020 \u001a\u0010\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\"*\u00020 \u001a\n\u00103\u001a\u00020\u0003*\u000204\u001a\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020%06*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00067"}, d2={"INVOKE_SUSPEND_SIGNATURE", "", "canRunEvaluation", "", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "continuationAsmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "findElementAtLine", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "functionNameByArgument", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionNameByLocalVariable", "name", "getFirstMethodLocation", "Lcom/sun/jdi/Location;", "location", "isInSuspendMethod", "isInsideInlineArgument", "inlineArgument", "debugProcess", "isKotlinFakeLineNumber", "isOnSuspendReturnOrReenter", "lambdaOrdinalByArgument", "lambdaOrdinalByLocalVariable", "containsKotlinStrata", "Lcom/sun/jdi/ReferenceType;", "containsKotlinStrataAsync", "Ljava/util/concurrent/CompletableFuture;", "getInlineFunctionAndArgumentVariablesToBordersMap", "", "Lcom/sun/jdi/LocalVariable;", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/Method;", "getInlineFunctionOrArgumentVariables", "Lkotlin/sequences/Sequence;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isInKotlinSources", "isInKotlinSourcesAsync", "isOnSuspensionPoint", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "visibleVariables", "", "kotlin.jvm-debugger.core"})
@JvmName(name="DebuggerUtil")
@SourceDebugExtension(value={"SMAP\ndebuggerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,285:1\n766#2:286\n857#2,2:287\n32#3,7:289\n55#4:296\n54#4,3:297\n75#4,8:300\n*S KotlinDebug\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n*L\n71#1:286\n71#1:287,2\n116#1:289,7\n116#1:296\n116#1:297,3\n116#1:300,8\n*E\n"})
public final class DebuggerUtil {
    @NotNull
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
        ReferenceType referenceType = $this$isInKotlinSources.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType()");
        return DebuggerUtil.isInKotlinSources(referenceType);
    }

    public static final boolean isInKotlinSources(@NotNull ReferenceType $this$isInKotlinSources) {
        String string2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
                string2 = SafeUtilKt.safeSourceName($this$isInKotlinSources);
                if (string2 == null || (string2 = StringsKt.substringAfterLast$default((String)string2, (char)'.', null, (int)2, null)) == null) break block2;
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string2 = string4;
                if (string4 != null) break block3;
            }
            string2 = "";
        }
        String fileExtension2 = string2;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension2) || DebuggerUtil.containsKotlinStrata($this$isInKotlinSources);
    }

    @NotNull
    public static final CompletableFuture<Boolean> isInKotlinSourcesAsync(@NotNull ReferenceType $this$isInKotlinSourcesAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSourcesAsync, (String)"<this>");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.sourceName((ReferenceType)$this$isInKotlinSourcesAsync).thenApply(arg_0 -> DebuggerUtil.isInKotlinSourcesAsync$lambda$0(isInKotlinSourcesAsync.1.INSTANCE, arg_0))).exceptionally(DebuggerUtil::isInKotlinSourcesAsync$lambda$1)).thenCombine(DebuggerUtil.containsKotlinStrataAsync($this$isInKotlinSourcesAsync), (arg_0, arg_1) -> DebuggerUtil.isInKotlinSourcesAsync$lambda$2(isInKotlinSourcesAsync.3.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"sourceName(this)\n       \u2026tlinExt || kotlinStrata }");
        return completionStage;
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrata, (String)"<this>");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    @NotNull
    public static final CompletableFuture<Boolean> containsKotlinStrataAsync(@NotNull ReferenceType $this$containsKotlinStrataAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrataAsync, (String)"<this>");
        CompletionStage completionStage = DebuggerUtilsAsync.availableStrata((ReferenceType)$this$containsKotlinStrataAsync).thenApply(arg_0 -> DebuggerUtil.containsKotlinStrataAsync$lambda$3(containsKotlinStrataAsync.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"availableStrata(this).th\u2026ins(KOTLIN_STRATA_NAME) }");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isInsideInlineArgument(@NotNull KtFunction inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inlineArgument, (String)"inlineArgument");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        List<LocalVariable> visibleVariables = DebuggerUtil.visibleVariables(location2, debugProcess);
        Iterable $this$filter$iv = visibleVariables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalVariable it = (LocalVariable)element$iv$iv;
            boolean bl = false;
            String string2 = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name()");
            if (!StringsKt.startsWith$default((String)string2, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(inlineArgument, (List<? extends LocalVariable>)markerLocalVariables){
            final /* synthetic */ KtFunction $inlineArgument;
            final /* synthetic */ List<LocalVariable> $markerLocalVariables;
            {
                this.$inlineArgument = $inlineArgument;
                this.$markerLocalVariables = $markerLocalVariables;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block9: {
                    void $this$any$iv;
                    void $this$mapTo$iv$iv;
                    int lambdaOrdinal = DebuggerUtil.access$lambdaOrdinalByArgument(this.$inlineArgument);
                    String string2 = DebuggerUtil.access$functionNameByArgument(this.$inlineArgument);
                    if (string2 == null) {
                        string2 = "unknown";
                    }
                    String functionName = string2;
                    Iterable $this$map$iv = this.$markerLocalVariables;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LocalVariable localVariable = (LocalVariable)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string3 = it.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name()");
                        collection.add(StringsKt.drop((String)string3, (int)5));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    KtFunction ktFunction = this.$inlineArgument;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl3;
                            String variableName = (String)element$iv;
                            boolean bl4 = false;
                            if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                                String string4 = ClassNameCalculator.INSTANCE.getClassName((KtElement)ktFunction);
                                if (string4 == null || (string4 = StringsKt.substringAfterLast$default((String)string4, (char)'.', null, (int)2, null)) == null) {
                                    bl3 = false;
                                } else {
                                    String lambdaClassName = string4;
                                    bl3 = Intrinsics.areEqual((Object)InlineUtilsKt.dropInlineSuffix(variableName), (Object)("-" + functionName + "-" + lambdaClassName));
                                }
                            } else {
                                bl3 = DebuggerUtil.access$lambdaOrdinalByLocalVariable(variableName) == lambdaOrdinal && Intrinsics.areEqual((Object)DebuggerUtil.access$functionNameByLocalVariable(variableName), (Object)functionName);
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        DebuggerCommandImpl command2 = new DebuggerCommandImpl(result2, f2, $this$invokeInManagerThread){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function1<DebuggerContextImpl, T> $f;
            final /* synthetic */ DebugProcessImpl $this_invokeInManagerThread;
            {
                this.$result = $result;
                this.$f = $f;
                this.$this_invokeInManagerThread = $receiver;
            }

            protected void action() {
                DebuggerContextImpl debuggerContextImpl = this.$this_invokeInManagerThread.getDebuggerContext();
                Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"debuggerContext");
                this.$result.element = this.$f.invoke((Object)debuggerContextImpl);
            }
        };
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            $this$invokeInManagerThread.getManagerThread().invoke(command2);
        } else {
            $this$invokeInManagerThread.getManagerThread().invokeAndWait(command2);
        }
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt) {
        String string2 = ClassNameCalculator.INSTANCE.getClassName((KtElement)elementAt);
        if (string2 == null) {
            return 0;
        }
        String className = string2;
        return Integer.parseInt(StringsKt.substringAfterLast$default((String)className, (String)"$", null, (int)2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final String functionNameByArgument(KtFunction elementAt) {
        void this_$iv$iv$iv;
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)elementAt).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)elementAt, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtFunctionSymbol ktFunctionSymbol;
            KtCallExpression ktCallExpression;
            KtAnalysisSession $this$functionNameByArgument_u24lambda_u245 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)elementAt));
            if ((ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) == null) {
                String string2 = null;
                return string2;
            }
            KtCallExpression parentCall2 = ktCallExpression;
            KtLifetimeOwner ktLifetimeOwner = $this$functionNameByArgument_u24lambda_u245.resolveCall((KtElement)parentCall2);
            if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
                String string3 = null;
                return string3;
            }
            KtLifetimeOwner call = ktLifetimeOwner;
            Object s = KtCallKt.getSymbol(((KtCallableMemberCall)call).getPartiallyAppliedSymbol());
            if ((s instanceof KtFunctionSymbol ? (KtFunctionSymbol)s : null) == null) {
                String string4 = null;
                return string4;
            }
            KtFunctionSymbol function2 = ktFunctionSymbol;
            String string5 = function2.getName().asString();
            return string5;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private static final List<LocalVariable> visibleVariables(Location $this$visibleVariables, DebugProcessImpl debugProcess) {
        VirtualMachine virtualMachine = debugProcess.getVirtualMachineProxy().getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"debugProcess.virtualMachineProxy.virtualMachine");
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        int n;
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            n = Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isOnSuspensionPoint(@NotNull StackFrameProxyImpl $this$isOnSuspensionPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSuspensionPoint, (String)"<this>");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)$this$isOnSuspensionPoint);
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        if (DebuggerUtil.isInSuspendMethod(location3)) {
            Location location4 = DebuggerUtil.getFirstMethodLocation(location3);
            if (location4 == null) {
                return false;
            }
            Location firstLocation = location4;
            return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location3) && firstLocation.codeIndex() != location3.codeIndex();
        }
        return false;
    }

    public static final boolean isInSuspendMethod(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Method method = location2.method();
        String signature2 = method.signature();
        Type continuationAsmType = DebuggerUtil.continuationAsmType();
        Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"signature");
        CharSequence charSequence2 = signature2;
        String string2 = continuationAsmType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"continuationAsmType.toString()");
        return StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string2, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)signature2, (Object)INVOKE_SUSPEND_SIGNATURE);
    }

    private static final Type continuationAsmType() {
        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier((String)"Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        return CodegenUtilKt.topLevelClassAsmType((FqName)fqName2);
    }

    private static final Location getFirstMethodLocation(Location location2) {
        Method method = SafeUtilKt.safeMethod(location2);
        Location location3 = method != null ? method.location() : null;
        if (location3 == null) {
            return null;
        }
        Location firstLocation = location3;
        if (SafeUtilKt.safeLineNumber(firstLocation) < 0) {
            return null;
        }
        return firstLocation;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Location location3 = DebuggerUtil.getFirstMethodLocation(location2);
        if (location3 == null) {
            return false;
        }
        Location firstLocation = location3;
        return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location2);
    }

    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file2, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        return (PsiElement)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiElement>(lineStartOffset, lineEndOffset, file2){
            final /* synthetic */ int $lineStartOffset;
            final /* synthetic */ int $lineEndOffset;
            final /* synthetic */ KtFile $file;
            {
                this.$lineStartOffset = $lineStartOffset;
                this.$lineEndOffset = $lineEndOffset;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                PsiElement topMostElement = null;
                PsiElement elementAt = null;
                for (int offset2 = this.$lineStartOffset; !(offset2 >= this.$lineEndOffset || (elementAt = this.$file.findElementAt(offset2)) != null && (topMostElement = KotlinPsiUtils.getTopmostElementAtOffset(elementAt, offset2)) instanceof KtElement); ++offset2) {
                }
                return topMostElement;
            }
        }));
    }

    public static final boolean isKotlinFakeLineNumber(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        try {
            if (location2.lineNumber("Kotlin") == 1 && Intrinsics.areEqual((Object)location2.sourceName("Kotlin"), (Object)"fake.kt") && Intrinsics.areEqual((Object)Path.of(location2.sourcePath("Kotlin"), new String[0]), (Object)Path.of("kotlin/jvm/internal/FakeKt", new String[0]))) {
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionAndArgumentVariablesToBordersMap(@NotNull Method $this$getInlineFunctionAndArgumentVariablesToBordersMap) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionAndArgumentVariablesToBordersMap, (String)"<this>");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionAndArgumentVariablesToBordersMap), (Function1)getInlineFunctionAndArgumentVariablesToBordersMap.1.INSTANCE));
    }

    @NotNull
    public static final Sequence<LocalVariable> getInlineFunctionOrArgumentVariables(@NotNull Method $this$getInlineFunctionOrArgumentVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionOrArgumentVariables, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionOrArgumentVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), (Function1)getInlineFunctionOrArgumentVariables.1.INSTANCE);
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"<this>");
        return $this$canRunEvaluation.getSuspendManager().getPausedContext() != null;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$1(Throwable it) {
        if (!(DebuggerUtilsAsync.unwrap((Throwable)it) instanceof AbsentInformationException)) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            throw it;
        }
        return false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Boolean containsKotlinStrataAsync$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(KtFunction elementAt) {
        return DebuggerUtil.lambdaOrdinalByArgument(elementAt);
    }

    public static final /* synthetic */ String access$functionNameByArgument(KtFunction elementAt) {
        return DebuggerUtil.functionNameByArgument(elementAt);
    }

    public static final /* synthetic */ int access$lambdaOrdinalByLocalVariable(String name2) {
        return DebuggerUtil.lambdaOrdinalByLocalVariable(name2);
    }

    public static final /* synthetic */ String access$functionNameByLocalVariable(String name2) {
        return DebuggerUtil.functionNameByLocalVariable(name2);
    }
}

