/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.DynamicBundle;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinPropertyBreakpointProperties;

public class KotlinBreakpointFiltersPanel<T extends KotlinPropertyBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JPanel myConditionsPanel;
    private JPanel myInstanceFiltersPanel;
    private JCheckBox myInstanceFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JPanel myClassFiltersPanel;
    private JCheckBox myClassFiltersCheckBox;
    private JPanel myClassFiltersFieldPanel;
    private JPanel myPassCountPanel;
    private JCheckBox myPassCountCheckbox;
    private JTextField myPassCountField;
    private final FieldPanel myInstanceFiltersField;
    private final FieldPanel myClassFiltersField;
    private com.intellij.ui.classFilter.ClassFilter[] myClassFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private com.intellij.ui.classFilter.ClassFilter[] myClassExclusionFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    protected final Project myProject;
    private PsiClass myBreakpointPsiClass;

    public KotlinBreakpointFiltersPanel(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(KotlinBreakpointFiltersPanel.this.myProject);
                _dialog.setFilters(KotlinBreakpointFiltersPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    KotlinBreakpointFiltersPanel.this.myInstanceFilters = _dialog.getFilters();
                    KotlinBreakpointFiltersPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        this.myClassFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.reloadClassFilters();
                ClassFilter classFilter = KotlinBreakpointFiltersPanel.this.createClassConditionFilter();
                EditClassFiltersDialog _dialog = new EditClassFiltersDialog(KotlinBreakpointFiltersPanel.this.myProject, classFilter);
                _dialog.setFilters(KotlinBreakpointFiltersPanel.this.myClassFilters, KotlinBreakpointFiltersPanel.this.myClassExclusionFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    KotlinBreakpointFiltersPanel.this.myClassFilters = _dialog.getFilters();
                    KotlinBreakpointFiltersPanel.this.myClassExclusionFilters = _dialog.getExclusionFilters();
                    KotlinBreakpointFiltersPanel.this.updateClassFilterEditor(true);
                }
            }
        }, null);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(updateListener);
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        ToolTipManager.sharedInstance().registerComponent(this.myClassFiltersField.getTextField());
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        KotlinBreakpointFiltersPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        KotlinBreakpointFiltersPanel.insert(this.myClassFiltersFieldPanel, (JComponent)this.myClassFiltersField);
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myPassCountCheckbox, (JComponent)this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myInstanceFiltersCheckBox, (JComponent)this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myClassFiltersCheckBox, (JComponent)this.myClassFiltersField.getTextField());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel2 = this.myConditionsPanel;
        if (jPanel2 == null) {
            KotlinBreakpointFiltersPanel.$$$reportNull$$$0(0);
        }
        return jPanel2;
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint2) {
        JavaBreakpointProperties properties2;
        if (breakpoint2 == null) {
            KotlinBreakpointFiltersPanel.$$$reportNull$$$0(1);
        }
        if ((properties2 = (JavaBreakpointProperties)breakpoint2.getProperties()) != null) {
            return properties2.isCOUNT_FILTER_ENABLED() || properties2.isCLASS_FILTERS_ENABLED() || properties2.isINSTANCE_FILTERS_ENABLED();
        }
        return false;
    }

    public void saveTo(@NotNull B breakpoint2) {
        JavaBreakpointProperties properties2;
        if (breakpoint2 == null) {
            KotlinBreakpointFiltersPanel.$$$reportNull$$$0(2);
        }
        if ((properties2 = (JavaBreakpointProperties)breakpoint2.getProperties()) == null) {
            return;
        }
        boolean changed2 = false;
        try {
            int filter2;
            String text2 = this.myPassCountField.getText().trim();
            int n = filter2 = !text2.isEmpty() ? Integer.parseInt(text2) : 0;
            if (filter2 < 0) {
                filter2 = 0;
            }
            changed2 = properties2.setCOUNT_FILTER(filter2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        changed2 = properties2.setCOUNT_FILTER_ENABLED(properties2.getCOUNT_FILTER() > 0 && this.myPassCountCheckbox.isSelected()) || changed2;
        this.reloadInstanceFilters();
        this.reloadClassFilters();
        this.updateInstanceFilterEditor(true);
        this.updateClassFilterEditor(true);
        changed2 = properties2.setINSTANCE_FILTERS_ENABLED(this.myInstanceFiltersField.getText().length() > 0 && this.myInstanceFiltersCheckBox.isSelected()) || changed2;
        changed2 = properties2.setCLASS_FILTERS_ENABLED(this.myClassFiltersField.getText().length() > 0 && this.myClassFiltersCheckBox.isSelected()) || changed2;
        changed2 = properties2.setClassFilters(this.myClassFilters) || changed2;
        changed2 = properties2.setClassExclusionFilters(this.myClassExclusionFilters) || changed2;
        boolean bl = changed2 = properties2.setInstanceFilters(this.myInstanceFilters) || changed2;
        if (changed2) {
            ((XBreakpointBase)breakpoint2).fireBreakpointChanged();
        }
    }

    private static void insert(JPanel panel2, JComponent component2) {
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)component2, "Center");
    }

    public void loadFrom(@NotNull B breakpoint2) {
        JavaBreakpointProperties properties2;
        if (breakpoint2 == null) {
            KotlinBreakpointFiltersPanel.$$$reportNull$$$0(3);
        }
        if ((properties2 = (JavaBreakpointProperties)breakpoint2.getProperties()) != null) {
            if (properties2.getCOUNT_FILTER() > 0) {
                this.myPassCountField.setText(Integer.toString(properties2.getCOUNT_FILTER()));
            } else {
                this.myPassCountField.setText("");
            }
            this.myPassCountCheckbox.setSelected(properties2.isCOUNT_FILTER_ENABLED());
            this.myInstanceFiltersCheckBox.setSelected(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.setEnabled(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.getTextField().setEditable(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFilters = properties2.getInstanceFilters();
            this.updateInstanceFilterEditor(true);
            this.myClassFiltersCheckBox.setSelected(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.setEnabled(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.getTextField().setEditable(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFilters = properties2.getClassFilters();
            this.myClassExclusionFilters = properties2.getClassExclusionFilters();
            this.updateClassFilterEditor(true);
            XSourcePosition xSourcePosition = breakpoint2.getSourcePosition();
        }
        this.updateCheckboxes();
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join(filters, (String)" "));
        }
        String tipText = KotlinBreakpointFiltersPanel.concatWithEx(new StringBuilder(), filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n").toString();
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadClassFilters() {
        String filtersText = this.myClassFiltersField.getText();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> classFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> exclusionFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        int startFilter = -1;
        for (int i2 = 0; i2 <= filtersText.length(); ++i2) {
            if (i2 < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i2))) {
                if (startFilter != -1) continue;
                startFilter = i2;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter + 1, i2)));
            } else {
                classFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter, i2)));
            }
            startFilter = -1;
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (classFilter.isEnabled()) continue;
            classFilters.add(classFilter);
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (classFilter.isEnabled()) continue;
            exclusionFilters.add(classFilter);
        }
        this.myClassFilters = classFilters.toArray(com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY);
        this.myClassExclusionFilters = exclusionFilters.toArray(com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i2 = 0; i2 <= filtersText.length(); ++i2) {
            if (i2 < filtersText.length() && Character.isDigit(filtersText.charAt(i2))) {
                if (startNumber != -1) continue;
                startNumber = i2;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create((String)filtersText.substring(startNumber, i2)));
            startNumber = -1;
        }
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(InstanceFilter.EMPTY_ARRAY);
    }

    private void updateClassFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (!classFilter.isEnabled()) continue;
            filters.add(classFilter.getPattern());
        }
        ArrayList<String> excludeFilters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (!classFilter.isEnabled()) continue;
            excludeFilters.add("-" + classFilter.getPattern());
        }
        if (updateText) {
            Object editorText = StringUtil.join(filters, (String)" ");
            if (!filters.isEmpty()) {
                editorText = (String)editorText + " ";
            }
            editorText = (String)editorText + StringUtil.join(excludeFilters, (String)" ");
            this.myClassFiltersField.setText((String)editorText);
        }
        int width = (int)Math.sqrt(this.myClassExclusionFilters.length + this.myClassFilters.length) + 1;
        StringBuilder tipTextBuilder = new StringBuilder();
        KotlinBreakpointFiltersPanel.concatWithEx(tipTextBuilder, filters, " ", width, "\n");
        if (!filters.isEmpty()) {
            tipTextBuilder.append("\n");
        }
        String tipText = KotlinBreakpointFiltersPanel.concatWithEx(tipTextBuilder, excludeFilters, " ", width, "\n").toString();
        this.myClassFiltersField.getTextField().setToolTipText(tipText);
    }

    @NlsSafe
    private static StringBuilder concatWithEx(StringBuilder builder2, List<String> s, String glue, int N, String nthGlue) {
        int i2 = 1;
        Iterator<String> iterator2 = s.iterator();
        while (iterator2.hasNext()) {
            String str = iterator2.next();
            builder2.append(str);
            if (iterator2.hasNext()) {
                if (i2 % N == 0) {
                    builder2.append(nthGlue);
                } else {
                    builder2.append(glue);
                }
            }
            ++i2;
        }
        return builder2;
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return KotlinBreakpointFiltersPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(KotlinBreakpointFiltersPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.getTextField().setEditable(this.myClassFiltersCheckBox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JPanel jPanel4;
        JPanel jPanel5;
        JCheckBox jCheckBox3;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinDebuggerCoreBundle", KotlinBreakpointFiltersPanel.class).getString("property.watchpoint.properties.panel.panel.group.conditions"), (int)0, (int)0, null, null));
        this.myInstanceFiltersPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinDebuggerCoreBundle", KotlinBreakpointFiltersPanel.class).getString("property.watchpoint.properties.panel.option.instance.filters"));
        jPanel6.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel5 = new JPanel();
        jPanel9.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinDebuggerCoreBundle", KotlinBreakpointFiltersPanel.class).getString("property.watchpoint.properties.panel.option.class.filters"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersFieldPanel = jPanel3 = new JPanel();
        jPanel10.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myPassCountPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinDebuggerCoreBundle", KotlinBreakpointFiltersPanel.class).getString("property.watchpoint.properties.panel.option.pass.count"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jTextField.setHorizontalAlignment(10);
        jPanel11.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel11.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinBreakpointFiltersPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinBreakpointFiltersPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleOnPopup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    private class MyTextField
    extends JTextField {
        private MyTextField() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            KotlinBreakpointFiltersPanel.this.reloadClassFilters();
            KotlinBreakpointFiltersPanel.this.updateClassFilterEditor(false);
            KotlinBreakpointFiltersPanel.this.reloadInstanceFilters();
            KotlinBreakpointFiltersPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }
}

