/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.dfaassist;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.impl.dfaassist.DfaHint;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.dfaassist.KotlinDfaAssistProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtVariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider;", "Lcom/intellij/debugger/engine/dfaassist/DfaAssistProvider;", "()V", "constraintFromJvmClassName", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "anchor", "Lcom/intellij/psi/PsiElement;", "jvmClassName", "", "createListener", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "getAnchor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "getCodeBlock", "getJdiValueForDfaVariable", "Lcom/sun/jdi/Value;", "proxy", "Lcom/intellij/debugger/jdi/StackFrameProxyEx;", "dfaVar", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "locationMatches", "", "location", "Lcom/sun/jdi/Location;", "postprocess", "value", "KotlinDebuggerDfaListener", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinDfaAssistProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,241:1\n1247#2,2:242\n*S KotlinDebug\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider\n*L\n46#1:242,2\n*E\n"})
public final class KotlinDfaAssistProvider
implements DfaAssistProvider {
    public boolean locationMatches(@NotNull PsiElement element3, @NotNull Location location2) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            String jdiClassName = location2.method().declaringType().name();
            PsiFile file2 = element3.getContainingFile();
            if (!(file2 instanceof KtFile)) {
                return false;
            }
            Map<KtElement, String> classNames = ClassNameCalculator.INSTANCE.getClassNames((KtFile)file2);
            Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)element3);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement e = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)classNames.get(e), (Object)jdiClassName)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public KtExpression getAnchor(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement cur = element3;
        while (cur instanceof PsiWhiteSpace || cur instanceof PsiComment) {
            Intrinsics.checkNotNullExpressionValue((Object)cur.getNextSibling(), (String)"cur.nextSibling");
        }
        while (true) {
            PsiElement parent2;
            if ((parent2 = cur.getParent()) instanceof KtBlockExpression || parent2 instanceof KtFunction) {
                PsiElement psiElement2 = cur;
                return psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            }
            if (parent2 == null || cur.getStartOffsetInParent() > 0) {
                return null;
            }
            cur = parent2;
        }
    }

    @Nullable
    public KtExpression getCodeBlock(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (!(anchor instanceof KtExpression)) {
            return null;
        }
        PsiElement parent2 = ((KtExpression)anchor).getParent();
        if (parent2 instanceof KtBlockExpression) {
            return (KtExpression)parent2;
        }
        if (parent2 instanceof KtFunction) {
            return (KtExpression)anchor;
        }
        return null;
    }

    @Nullable
    public Value getJdiValueForDfaVariable(@NotNull StackFrameProxyEx proxy, @NotNull DfaVariableValue dfaVar, @NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)dfaVar, (String)"dfaVar");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        DfaVariableValue qualifier2 = dfaVar.getQualifier();
        PsiElement psiVariable = dfaVar.getPsiVariable();
        if (qualifier2 == null) {
            LocalVariableProxy variable2;
            VariableDescriptor variableDescriptor = dfaVar.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"dfaVar.descriptor");
            VariableDescriptor descriptor2 = variableDescriptor;
            if (descriptor2 instanceof KtThisDescriptor) {
                String jvmName;
                String signature2;
                DeclarationDescriptor declarationDescriptor = ((KtThisDescriptor)descriptor2).getDescriptor();
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    String thisName = "$this$" + ((FunctionDescriptor)declarationDescriptor).getName();
                    LocalVariableProxy thisVar = proxy.visibleVariableByName(thisName);
                    if (thisVar != null) {
                        return this.postprocess(proxy.getVariableValue(thisVar));
                    }
                    return null;
                }
                ObjectReference thisObject = proxy.thisObject();
                if (thisObject != null && Intrinsics.areEqual((Object)(signature2 = Type.getType((String)thisObject.referenceType().signature()).getClassName()), (Object)(jvmName = KotlinPsiHeuristics.getJvmName(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor))))) {
                    return thisObject;
                }
                return null;
            }
            if (descriptor2 instanceof KtVariableDescriptor && psiVariable instanceof KtCallableDeclaration && (variable2 = proxy.visibleVariableByName(((KtNamedDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(proxy.getVariableValue(variable2));
            }
        } else {
            ReferenceType type2;
            Field field2;
            Value jdiQualifier = this.getJdiValueForDfaVariable(proxy, qualifier2, anchor);
            if (jdiQualifier instanceof ObjectReference && psiVariable instanceof KtCallableDeclaration && (field2 = (type2 = ((ObjectReference)jdiQualifier).referenceType()).fieldByName(((KtCallableDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(((ObjectReference)jdiQualifier).getValue(field2));
            }
        }
        return null;
    }

    private final Value postprocess(Value value2) {
        Value value3 = DfaAssistProvider.wrap((Value)EvaluatorValueConverter.Companion.unref(value2));
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"wrap(EvaluatorValueConverter.unref(value))");
        return value3;
    }

    @NotNull
    public DebuggerDfaListener createListener() {
        return new KotlinDebuggerDfaListener();
    }

    @NotNull
    public TypeConstraint constraintFromJvmClassName(@NotNull PsiElement anchor, @NotNull String jvmClassName) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
        TypeConstraints.ClassDef classDef2 = KtClassDef.Companion.fromJvmClassName((KtElement)anchor, jvmClassName);
        if (classDef2 == null) {
            TypeConstraint typeConstraint = TypeConstraints.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"TOP");
            return typeConstraint;
        }
        TypeConstraints.ClassDef classDef3 = classDef2;
        TypeConstraint.Exact exact = TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef3);
        Intrinsics.checkNotNullExpressionValue((Object)exact, (String)"exactClass(classDef)");
        return (TypeConstraint)exact;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0019H\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0002J(\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider$KotlinDebuggerDfaListener;", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "()V", "SHORT_CIRCUITING_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "hints", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/xdebugger/impl/dfaassist/DfaHint;", "Lkotlin/collections/HashMap;", "getHints", "()Ljava/util/HashMap;", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "computeHints", "", "createRange", "Lcom/intellij/openapi/util/TextRange;", "element", "startAnchor", "unreachableElements", "", "onCondition", "problem", "Lcom/intellij/codeInspection/dataFlow/lang/UnsatisfiedConditionProblem;", "failed", "Lcom/intellij/util/ThreeState;", "shouldTrackExpressionValue", "", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "unreachableSegments", "", "kotlin.jvm-debugger.evaluation"})
    @SourceDebugExtension(value={"SMAP\nKotlinDfaAssistProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider$KotlinDebuggerDfaListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n1#2:245\n1611#3:243\n1855#3:244\n1856#3:246\n1612#3:247\n*S KotlinDebug\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider$KotlinDebuggerDfaListener\n*L\n187#1:245\n187#1:243\n187#1:244\n187#1:246\n187#1:247\n*E\n"})
    public static final class KotlinDebuggerDfaListener
    implements DebuggerDfaListener {
        @NotNull
        private final HashMap<PsiElement, DfaHint> hints = new HashMap();
        @NotNull
        private final TokenSet SHORT_CIRCUITING_TOKENS;

        public KotlinDebuggerDfaListener() {
            IElementType[] iElementTypeArray = new IElementType[]{KtTokens.ANDAND, KtTokens.OROR, KtTokens.ELVIS};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(KtTokens.ANDAND, \u2026ens.OROR, KtTokens.ELVIS)");
            this.SHORT_CIRCUITING_TOKENS = tokenSet;
        }

        @NotNull
        public final HashMap<PsiElement, DfaHint> getHints() {
            return this.hints;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value2, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            KtElement ktElement;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            DfType dfType = state.getDfType(value2);
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"state.getDfType(value)");
            DfType dfType2 = dfType;
            DfaAnchor dfaAnchor = anchor;
            if (dfaAnchor instanceof KotlinAnchor.KotlinExpressionAnchor) {
                if (!this.shouldTrackExpressionValue(((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                    return;
                }
                if (KotlinConstantConditionsInspection.Companion.shouldSuppress(dfType2, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                    boolean bl;
                    DfType dfType3 = dfType2.tryNegate();
                    if (dfType3 != null) {
                        DfType negated = dfType3;
                        boolean bl2 = false;
                        bl = !KotlinConstantConditionsInspection.Companion.shouldSuppress(negated, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression());
                    } else {
                        bl = false;
                    }
                    if (!bl) {
                        return;
                    }
                }
                ktElement = (KtElement)((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
            } else if (dfaAnchor instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                ktElement = (KtElement)((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
            } else {
                return;
            }
            KtElement psi2 = ktElement;
            DfaHint hint = DfaHint.ANY_VALUE;
            if (dfType2 == DfTypes.TRUE) {
                hint = DfaHint.TRUE;
            } else if (dfType2 == DfTypes.FALSE) {
                hint = DfaHint.FALSE;
            } else if (dfType2 == DfTypes.NULL) {
                PsiElement parent2 = psi2.getParent();
                if (parent2 instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                    hint = DfaHint.NPE;
                } else if (parent2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference().textMatches((CharSequence)"as")) {
                    KotlinType type2;
                    KtTypeReference typeReference2;
                    KtTypeReference ktTypeReference = typeReference2 = ((KtBinaryExpressionWithTypeRHS)parent2).getRight();
                    KotlinType kotlinType = type2 = ktTypeReference != null ? BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)typeReference2, BodyResolveMode.FULL)) : null;
                    if (type2 != null && !type2.isMarkedNullable()) {
                        hint = DfaHint.NPE;
                        KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
                        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"parent.operationReference");
                        psi2 = (KtElement)ktSimpleNameExpression;
                    }
                } else if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                    hint = DfaHint.NULL;
                } else if (psi2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)psi2).getOperationReference().textMatches((CharSequence)"as?")) {
                    hint = DfaHint.NULL;
                }
            }
            this.hints.merge((PsiElement)psi2, hint, (arg_0, arg_1) -> KotlinDebuggerDfaListener.beforePush$lambda$1(beforePush.1.INSTANCE, arg_0, arg_1));
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value2, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)failed, (String)"failed");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (problem instanceof KotlinProblem.KotlinCastProblem) {
                this.hints.merge((PsiElement)((KotlinProblem.KotlinCastProblem)problem).getCast().getOperationReference(), failed == ThreeState.YES ? DfaHint.CCE : DfaHint.NONE, (arg_0, arg_1) -> KotlinDebuggerDfaListener.onCondition$lambda$2(onCondition.1.INSTANCE, arg_0, arg_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Collection<TextRange> unreachableSegments(@NotNull PsiElement startAnchor, @NotNull Set<? extends PsiElement> unreachableElements) {
            void $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter((Object)startAnchor, (String)"startAnchor");
            Intrinsics.checkNotNullParameter(unreachableElements, (String)"unreachableElements");
            Iterable iterable = unreachableElements;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TextRange it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                PsiElement element3 = (PsiElement)element$iv;
                boolean bl2 = false;
                if (this.createRange(element3, startAnchor, unreachableElements) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            return destination$iv;
        }

        private final TextRange createRange(PsiElement element3, PsiElement startAnchor, Set<? extends PsiElement> unreachableElements) {
            Object object;
            PsiElement parent2;
            PsiElement psiElement2 = parent2 = element3.getParent();
            PsiElement gParent = psiElement2 != null ? psiElement2.getParent() : null;
            if (parent2 instanceof KtContainerNode && (gParent instanceof KtIfExpression || gParent instanceof KtWhileExpression || gParent instanceof KtForExpression) || parent2 instanceof KtWhenEntry) {
                object = element3.getTextRange();
            } else if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getRight(), (Object)element3) && this.SHORT_CIRCUITING_TOKENS.contains(((KtBinaryExpression)parent2).getOperationToken())) {
                object = ((KtBinaryExpression)parent2).getOperationReference().getTextRange().union(element3.getTextRange());
            } else if (parent2 instanceof KtSafeQualifiedExpression && Intrinsics.areEqual((Object)((KtSafeQualifiedExpression)parent2).getSelectorExpression(), (Object)element3)) {
                object = ((KtSafeQualifiedExpression)parent2).getOperationTokenNode().getTextRange().union(element3.getTextRange());
            } else if (parent2 instanceof KtBlockExpression) {
                KtExpression prevExpression;
                PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element3);
                KtExpression ktExpression = prevExpression = psiElement3 instanceof KtExpression ? (KtExpression)psiElement3 : null;
                if (prevExpression != null && unreachableElements.contains(prevExpression)) {
                    object = null;
                } else {
                    List list2 = ((KtBlockExpression)parent2).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parent.statements");
                    KtExpression lastExpression = (KtExpression)CollectionsKt.last((List)list2);
                    object = lastExpression == null || prevExpression == null ? null : (prevExpression instanceof KtLoopExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)prevExpression), (PsiElement)startAnchor, (boolean)false) ? null : element3.getTextRange().union(lastExpression.getTextRange()));
                }
            } else {
                object = null;
            }
            return object;
        }

        private final boolean shouldTrackExpressionValue(KtExpression expr) {
            if (expr instanceof KtBinaryExpression) {
                IElementType iElementType = ((KtBinaryExpression)expr).getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
                IElementType token = iElementType;
                if (Intrinsics.areEqual((Object)token, (Object)KtTokens.EQ)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR)) {
                    return false;
                }
            }
            PsiElement parent2 = expr.getParent();
            while (parent2 instanceof KtParenthesizedExpression) {
                parent2 = ((KtParenthesizedExpression)parent2).getParent();
            }
            PsiElement psiElement2 = parent2;
            KtPrefixExpression ktPrefixExpression = psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
            return !Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL);
        }

        @NotNull
        public Map<PsiElement, DfaHint> computeHints() {
            this.hints.values().removeIf(arg_0 -> KotlinDebuggerDfaListener.computeHints$lambda$4(computeHints.1.INSTANCE, arg_0));
            return this.hints;
        }

        private static final DfaHint beforePush$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (DfaHint)$tmp0.invoke(p0, p1);
        }

        private static final DfaHint onCondition$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (DfaHint)$tmp0.invoke(p0, p1);
        }

        private static final boolean computeHints$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

