/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentEditor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentEditorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerHandler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentDataKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OldCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u000289B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002JI\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u001a\u0010.\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0004\u0012\u0002H-0/H\u0002\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\f\u00106\u001a\u00020%*\u000207H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calculateMainMethodCallArguments", "", "Lcom/sun/jdi/Value;", "variableFinder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "compileCodeFragment", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "doAnalyze", "evaluate", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "getCompiledCodeFragment", "getModifier", "", "isCoroutineScopeAvailable", "", "frameProxy", "Lcom/intellij/debugger/engine/jdi/StackFrameProxy;", "reportErrorDiagnosticIfAny", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "runEvaluation", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;Lcom/sun/jdi/ClassLoaderReference;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateLocalVariableValue", "converter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "ref", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "isIllegalSuspendFunCallInCodeFragment", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Companion", "ErrorCheckingResult", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinEvaluatorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,534:1\n288#2,2:535\n766#2:537\n857#2,2:538\n288#2,2:540\n223#2,2:543\n766#2:545\n857#2,2:546\n1855#2,2:548\n1549#2:550\n1620#2,3:551\n1747#2,3:554\n1#3:542\n*S KotlinDebug\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n*L\n266#1:535,2\n274#1:537\n274#1:538,2\n275#1:540,2\n304#1:543,2\n348#1:545\n348#1:546,2\n349#1:548,2\n389#1:550\n389#1:551,3\n399#1:554,3\n*E\n"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @Nullable
    private final SourcePosition sourcePosition;
    private static boolean LOG_COMPILATIONS;
    @NotNull
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    @NotNull
    private static final List<Type> DEFAULT_METHOD_MARKERS;

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition2;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string2 = this.codeFragment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"codeFragment.text");
        if (((CharSequence)string2).length() == 0) {
            return context2.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        }
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ KotlinEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Project project2 = this.this$0.getCodeFragment().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"codeFragment.project");
                if (DumbService.Companion.getInstance(project2).isDumb()) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.dumb.mode", new Object[0]));
                    throw new KotlinNothingValueException();
                }
            }
        }));
        if (!context2.getDebugProcess().isAttached()) {
            EvaluateException evaluateException = EvaluateExceptionUtil.PROCESS_EXITED;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"PROCESS_EXITED");
            throw (Throwable)evaluateException;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u240 = this;
            boolean bl = false;
            EvaluateException evaluateException = EvaluateExceptionUtil.NULL_STACK_FRAME;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"NULL_STACK_FRAME");
            throw (Throwable)evaluateException;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u241 = this;
            boolean bl = false;
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.unavailable", new Object[0]));
            throw new KotlinNothingValueException();
        }
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.not.suspended", new Object[0]));
            throw new KotlinNothingValueException();
        }
        try {
            ExecutionContext executionContext2 = new ExecutionContext(context2, frameProxy);
            return this.evaluateSafe(executionContext2);
        }
        catch (CodeFragmentCodegenException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getReason());
            throw new KotlinNothingValueException();
        }
        catch (EvaluateException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e);
            throw new KotlinNothingValueException();
        }
        catch (Eval4JInterpretingException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getCause());
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                KotlinEvaluatorBuilderKt.evaluationException(e);
                throw new KotlinNothingValueException();
            }
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = KotlinDebuggerEvaluationBundle.message("error.exception.occurred", new Object[0]);
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string3, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.evaluate", new Object[0]) + cause);
            throw new KotlinNothingValueException();
        }
    }

    private final Object evaluateSafe(ExecutionContext context2) {
        InterpreterResult interpreterResult;
        CompiledCodeFragmentData compiledData = this.getCompiledCodeFragment(context2);
        Object classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context2, (Collection<ClassToLoad>)compiledData.getClasses());
        ClassLoaderReference classLoaderRef = (ClassLoaderReference)(Result.isFailure-impl((Object)classLoadingResult) ? null : classLoadingResult);
        if (classLoaderRef != null) {
            try {
                return this.evaluateWithCompilation(context2, compiledData, classLoaderRef);
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult2;
                KotlinEvaluatorBuilderKt.getLOG().warn("Compiling evaluator failed: " + e.getMessage(), e);
                interpreterResult = interpreterResult2 = this.evaluateWithEval4J(context2, compiledData, classLoaderRef);
            }
        } else {
            interpreterResult = this.evaluateWithEval4J(context2, compiledData, null);
        }
        InterpreterResult result2 = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result2, context2);
    }

    private final CompiledCodeFragmentData getCompiledCodeFragment(ExecutionContext context2) {
        StringBuilder stringBuilder;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)ActionsKt.runReadAction((Function0)((Function0)new Function0<ConcurrentFactoryCache<String, CompiledCodeFragmentData>>(this){
            final /* synthetic */ KotlinEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ConcurrentFactoryCache<String, CompiledCodeFragmentData> invoke() {
                PsiElement psiElement2 = this.this$0.getCodeFragment().getContext();
                if (psiElement2 == null) {
                    return null;
                }
                PsiElement contextElement = psiElement2;
                return (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)contextElement, getCompiledCodeFragment.cache.1::invoke$lambda$0);
            }

            private static final CachedValueProvider.Result invoke$lambda$0() {
                ConcurrentHashMap<K, V> storage = new ConcurrentHashMap<K, V>();
                Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
                return new CachedValueProvider.Result(new ConcurrentFactoryCache<Key, Value>((ConcurrentMap)storage), objectArray);
            }
        }));
        if (cache2 == null) {
            return this.compileCodeFragment(context2);
        }
        StringBuilder $this$getCompiledCodeFragment_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$getCompiledCodeFragment_u24lambda_u242.append(this.codeFragment.importsToString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        $this$getCompiledCodeFragment_u24lambda_u242.append(this.codeFragment.getText());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String key = string2;
        Object Value2 = cache2.get(key, (Function1)new Function1<String, CompiledCodeFragmentData>(this, context2){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final CompiledCodeFragmentData invoke(String it) {
                return KotlinEvaluator.access$compileCodeFragment(this.this$0, this.$context);
            }
        });
        Intrinsics.checkNotNullExpressionValue(Value2, (String)"private fun getCompiledC\u2026(context)\n        }\n    }");
        return (CompiledCodeFragmentData)Value2;
    }

    private final CompiledCodeFragmentData compileCodeFragment(ExecutionContext context2) {
        Diagnostic diagnostic;
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        ErrorCheckingResult analysisResult2 = this.analyze(this.codeFragment, debugProcess);
        boolean codeFragmentWasEdited = KotlinCodeFragmentEditorKt.withSuspendFunctionWrapper(KotlinCodeFragmentEditorKt.withToStringWrapper(new KotlinCodeFragmentEditor(this.codeFragment), analysisResult2.getBindingContext()), analysisResult2.getBindingContext(), context2, this.isCoroutineScopeAvailable((StackFrameProxy)context2.getFrameProxy())).editCodeFragment();
        if (codeFragmentWasEdited) {
            analysisResult2 = this.analyze(this.codeFragment, debugProcess);
        }
        if ((diagnostic = analysisResult2.getIllegalSuspendFunCallDiagnostic()) != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            String string2 = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"render(it)");
            KotlinEvaluatorBuilderKt.evaluationException(string2);
            throw new KotlinNothingValueException();
        }
        CodeFragmentCompilingStrategy compilerStrategy = CodeFragmentCompiler.Companion.useIRFragmentCompiler() ? (CodeFragmentCompilingStrategy)new IRCodeFragmentCompilingStrategy(this.codeFragment) : (CodeFragmentCompilingStrategy)new OldCodeFragmentCompilingStrategy(this.codeFragment);
        CodeFragmentCompilerHandler compilerHandler = new CodeFragmentCompilerHandler(compilerStrategy);
        CodeFragmentCompiler.CompilationResult result2 = compilerHandler.compileCodeFragment(this.codeFragment, analysisResult2.getModuleDescriptor(), analysisResult2.getBindingContext(), context2);
        if (LOG_COMPILATIONS) {
            KotlinEvaluatorBuilderKt.getLOG().debug("Compile bytecode for " + this.codeFragment.getText());
        }
        return KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(result2);
    }

    private final boolean isCoroutineScopeAvailable(StackFrameProxy frameProxy) {
        return frameProxy instanceof CoroutineStackFrameProxyImpl ? ((CoroutineStackFrameProxyImpl)frameProxy).isCoroutineScopeAvailable() : false;
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess) {
        Result result2 = (Result)ReadAction.nonBlocking(() -> KotlinEvaluator.analyze$lambda$4(this, codeFragment, debugProcess)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        Object object = result2.unbox-impl();
        ResultKt.throwOnFailure((Object)object);
        return (ErrorCheckingResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ErrorCheckingResult doAnalyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess) {
        Object v4;
        BindingContext bindingContext2;
        ModuleDescriptor moduleDescriptor;
        List<KtCodeFragment> list2;
        block5: {
            void $this$firstOrNull$iv;
            try {
                AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)codeFragment));
            }
            catch (IllegalArgumentException e) {
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = e.toString();
                }
                KotlinEvaluatorBuilderKt.evaluationException(string2);
                throw new KotlinNothingValueException();
            }
            ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(codeFragment);
            new DebugLabelPropertyDescriptorProvider(codeFragment, debugProcess).supplyDebugLabels();
            AnalysisResult analysisResult2 = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade2, (KtElement)codeFragment, null, 2, null);
            if (analysisResult2.isError()) {
                KotlinEvaluatorBuilderKt.evaluationException(analysisResult2.getError());
                throw new KotlinNothingValueException();
            }
            BindingContext bindingContext3 = analysisResult2.getBindingContext();
            this.reportErrorDiagnosticIfAny(bindingContext3);
            ModuleDescriptor moduleDescriptor2 = analysisResult2.getModuleDescriptor();
            List<KtCodeFragment> list3 = Collections.singletonList(codeFragment);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(codeFragment)");
            Diagnostics diagnostics2 = bindingContext3.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"bindingContext.diagnostics");
            Iterable iterable = (Iterable)diagnostics2;
            list2 = list3;
            moduleDescriptor = moduleDescriptor2;
            bindingContext2 = bindingContext3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!this.isIllegalSuspendFunCallInCodeFragment(it)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        Object var15_16 = v4;
        Diagnostic diagnostic = var15_16;
        List<KtCodeFragment> list4 = list2;
        ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
        BindingContext bindingContext4 = bindingContext2;
        return new ErrorCheckingResult(bindingContext4, moduleDescriptor3, list4, diagnostic);
    }

    private final void reportErrorDiagnosticIfAny(BindingContext bindingContext2) {
        Object v1;
        block3: {
            Iterator $this$filterTo$iv$iv;
            Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"bindingContext.diagnostics");
            Iterable $this$filter$iv = (Iterable)diagnostics2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Diagnostic it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!IGNORED_DIAGNOSTICS.contains(it.getFactory()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!(it.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)it.getPsiElement().getContainingFile(), (Object)this.codeFragment))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Diagnostic diagnostic = v1;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            String string2 = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"render(it)");
            KotlinEvaluatorBuilderKt.evaluationException(string2);
            throw new KotlinNothingValueException();
        }
    }

    private final boolean isIllegalSuspendFunCallInCodeFragment(Diagnostic $this$isIllegalSuspendFunCallInCodeFragment) {
        return $this$isIllegalSuspendFunCallInCodeFragment.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getPsiElement().getContainingFile(), (Object)this.codeFragment) && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getFactory(), (Object)Errors.ILLEGAL_SUSPEND_FUNCTION_CALL);
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2) {
        return (com.sun.jdi.Value)this.runEvaluation(context2, compiledData, classLoader2, (Function1)new Function1<List<? extends com.sun.jdi.Value>, com.sun.jdi.Value>(context2, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$classLoader = $classLoader;
                super(1);
            }

            @Nullable
            public final com.sun.jdi.Value invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                ReferenceType referenceType = this.$context.findClass("Generated_for_debugger_class", this.$classLoader);
                ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
                if (classType == null) {
                    throw new IllegalStateException("Can not find class \"Generated_for_debugger_class\"".toString());
                }
                ClassType mainClassType = classType;
                List<Method> list2 = mainClassType.methods();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"mainClassType.methods()");
                Iterable $this$single$iv = list2;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    String string2 = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name()");
                    if (!ClassToLoadKt.isEvaluationEntryPoint(string2)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Method mainMethod = single$iv;
                Intrinsics.checkNotNullExpressionValue((Object)mainMethod, (String)"mainMethod");
                com.sun.jdi.Value returnValue = this.$context.invokeMethod(mainClassType, mainMethod, args);
                return EvaluatorValueConverter.Companion.unref(returnValue);
            }
        });
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2) {
        Object element$iv2;
        block2: {
            ClassNode classNode;
            byte[] mainClassBytecode = CompiledCodeFragmentDataKt.getMainClass(compiledData).getBytes();
            ClassNode $this$evaluateWithEval4J_u24lambda_u249 = classNode = new ClassNode();
            boolean bl = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$evaluateWithEval4J_u24lambda_u249, 0);
            ClassNode mainClassAsmNode = classNode;
            List list2 = mainClassAsmNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"mainClassAsmNode.methods");
            Iterable $this$first$iv = list2;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!ClassToLoadKt.isEvaluationEntryPoint(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader2;
        if (classLoaderReference == null) {
            classLoaderReference = context2.getEvaluationContext().getClassLoader();
        }
        return (InterpreterResult)this.runEvaluation(context2, compiledData, classLoaderReference, (Function1)new Function1<List<? extends com.sun.jdi.Value>, InterpreterResult>(context2, mainMethod, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ MethodNode $mainMethod;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$mainMethod = $mainMethod;
                this.$classLoader = $classLoader;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InterpreterResult invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Collection<Value> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object;
                Object object2;
                VirtualMachine vm;
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        VirtualMachine virtualMachine = this.$context.getVm().getVirtualMachine();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"context.vm.virtualMachine");
                        vm = virtualMachine;
                        object2 = this.$context.getSuspendContext().getThread();
                        if (object2 == null || (object2 = object2.getThreadReference()) == null) break block3;
                        Object it = object = object2;
                        boolean bl = false;
                        object2 = it.isSuspended() ? object : null;
                        if (object2 != null) break block4;
                    }
                    throw new IllegalStateException("Can not find a thread to run evaluation on".toString());
                }
                Object thread = object2;
                int n = this.$context.getInvokePolicy();
                JDIEval eval2 = new JDIEval(vm, this.$classLoader, (ThreadReference)thread, this.$context, n){
                    final /* synthetic */ ExecutionContext $context;
                    {
                        this.$context = $context;
                        super($vm, $classLoader, $thread, $super_call_param$1);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(obj, method, args, 2);
                    }

                    @NotNull
                    public com.sun.jdi.Value jdiNewInstance(@NotNull ClassType clazz, @NotNull Method ctor, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                        Intrinsics.checkNotNullParameter((Object)ctor, (String)"ctor");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.newInstance(clazz, ctor, args);
                    }

                    @NotNull
                    public StringReference jdiMirrorOfString(@NotNull String str) {
                        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                        StringReference stringReference = DebuggerUtilsEx.mirrorOfString((String)str, (VirtualMachineProxyImpl)this.$context.getVm(), (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                        Intrinsics.checkNotNullExpressionValue((Object)stringReference, (String)"mirrorOfString(str, cont\u2026ontext.evaluationContext)");
                        return stringReference;
                    }

                    @NotNull
                    public ArrayReference jdiNewArray(@NotNull ArrayType arrayType, int size) {
                        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
                        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray((ArrayType)arrayType, (int)size, (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                        Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfArray(arrayType,\u2026ontext.evaluationContext)");
                        return arrayReference;
                    }
                };
                MethodNode methodNode = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"mainMethod");
                MethodNode methodNode2 = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode2, (String)"mainMethod");
                Iterable iterable = args;
                MethodNode methodNode3 = methodNode2;
                MethodNode methodNode4 = methodNode;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JdiValuesKt.asValue((com.sun.jdi.Value)it));
                }
                collection = (List)destination$iv$iv;
                return InterpreterLoopKt.interpreterLoop$default(methodNode4, JdiValuesKt.makeInitialFrame(methodNode3, (List<? extends Value>)collection), eval2, null, 8, null);
            }
        });
    }

    private final <T> T runEvaluation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block2) {
        Iterator<Type> $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = compiledData.getClasses();
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context2.findClass(it.getClassName(), classLoader2);
        }
        for (Type parameterType : compiledData.getMainMethodSignature().getParameterTypes()) {
            context2.findClass(parameterType, classLoader2);
        }
        VariableFinder variableFinder = new VariableFinder(context2);
        List<com.sun.jdi.Value> args = this.calculateMainMethodCallArguments(variableFinder, compiledData);
        Object result2 = block2.invoke(args);
        for (VariableFinder.RefWrapper wrapper : variableFinder.getRefWrappers()) {
            this.updateLocalVariableValue(variableFinder.getEvaluatorValueConverter(), wrapper);
        }
        return (T)result2;
    }

    private final void updateLocalVariableValue(EvaluatorValueConverter converter, VariableFinder.RefWrapper ref) {
        StackFrameProxyImpl frameProxy = converter.getContext().getFrameProxy();
        com.sun.jdi.Value newValue = EvaluatorValueConverter.Companion.unref(ref.getWrapper());
        LocalVariableProxyImpl variable2 = SafeUtilKt.safeVisibleVariableByName(frameProxy, ref.getLocalVariableName());
        if (variable2 != null) {
            try {
                frameProxy.setValue(variable2, newValue);
            }
            catch (InvalidTypeException e) {
                com.sun.jdi.Value value2 = newValue;
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot update local variable value: expected type " + variable2.getType() + ", actual type " + (value2 != null ? value2.type() : null), (Throwable)e);
            }
        } else if (frameProxy instanceof CoroutineStackFrameProxyImpl) {
            ((CoroutineStackFrameProxyImpl)frameProxy).updateSpilledVariableValue(ref.getLocalVariableName(), newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(VariableFinder variableFinder, CompiledCodeFragmentData compiledData) {
        void $this$mapTo$iv$iv;
        List<Type> asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List<CodeFragmentParameter.Dumb> valueParameters2 = compiledData.getParameters();
        if (!(asmValueParameters.size() == valueParameters2.size())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters2, (Iterable)asmValueParameters);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Type asmType;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Dumb parameter2 = (CodeFragmentParameter.Dumb)pair.component1();
            VariableFinder.Result result2 = variableFinder.find(parameter2, asmType = (Type)pair.component2());
            if (result2 == null) {
                String name2 = parameter2.getDebugString();
                StackFrameProxyImpl frameProxy = variableFinder.getContext().getFrameProxy();
                if (parameter2.getKind() == CodeFragmentParameter.Kind.COROUTINE_CONTEXT) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.coroutine.context.unavailable", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (compiledData.getCrossingBounds().contains(parameter2)) {
                    Object[] objectArray = new Object[]{name2};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.not.captured", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    Object[] objectArray = new Object[]{parameter2.getName()};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.backing.field", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && KotlinEvaluator.calculateMainMethodCallArguments$lambda$14$isInsideDefaultInterfaceMethod(frameProxy)) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.parameter.evaluation.default.methods", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && frameProxy instanceof CoroutineStackFrameProxyImpl) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.variable.was.optimised", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = name2;
                Intrinsics.checkNotNullExpressionValue((Object)asmType.getClassName(), (String)"asmType.className");
                KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.variable", objectArray));
                throw new KotlinNothingValueException();
            }
            collection.add(result2.getValue());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Void getModifier() {
        return null;
    }

    private static final Result analyze$lambda$4(KotlinEvaluator this$0, KtCodeFragment $codeFragment, DebugProcessImpl $debugProcess) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$codeFragment, (String)"$codeFragment");
        Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
        try {
            object = Result.constructor-impl((Object)this$0.doAnalyze($codeFragment, $debugProcess));
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex));
        }
        return Result.box-impl((Object)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateMainMethodCallArguments$lambda$14$isInsideDefaultInterfaceMethod(StackFrameProxyImpl frameProxy) {
        Type it;
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        Comparable<Location> comparable = location2;
        if (location2 == null) return false;
        if ((comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return false;
        }
        Comparable<Location> method = comparable;
        String desc2 = method.signature();
        String string2 = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name()");
        if (!StringsKt.endsWith$default((String)string2, (String)"$default", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = DEFAULT_METHOD_MARKERS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Type)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)desc2, (String)"desc");
        } while (!StringsKt.contains$default((CharSequence)desc2, (CharSequence)("I" + it.getDescriptor() + ")"), (boolean)false, (int)2, null));
        return true;
    }

    public static final /* synthetic */ CompiledCodeFragmentData access$compileCodeFragment(KotlinEvaluator $this, ExecutionContext context2) {
        return $this.compileCodeFragment(context2);
    }

    static {
        ImmutableSet immutableSet = Errors.INVISIBLE_REFERENCE_DIAGNOSTICS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"INVISIBLE_REFERENCE_DIAGNOSTICS");
        Object[] objectArray = new DiagnosticFactoryWithPsiElement[]{Errors.OPT_IN_USAGE_ERROR, Errors.MISSING_DEPENDENCY_SUPERCLASS, Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS, Errors.FIR_COMPILED_CLASS, Errors.ILLEGAL_SUSPEND_FUNCTION_CALL};
        IGNORED_DIAGNOSTICS = SetsKt.plus((Set)((Set)immutableSet), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Type[]{AsmTypes.OBJECT_TYPE, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER};
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "DEFAULT_METHOD_MARKERS", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation", "()Ljava/util/Set;", "LOG_COMPILATIONS", "", "getLOG_COMPILATIONS", "()Z", "setLOG_COMPILATIONS", "(Z)V", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @ApiStatus.Internal
        public final boolean getLOG_COMPILATIONS() {
            return LOG_COMPILATIONS;
        }

        public final void setLOG_COMPILATIONS(boolean bl) {
            LOG_COMPILATIONS = bl;
        }

        @NotNull
        public final Set<DiagnosticFactory<?>> getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation() {
            return IGNORED_DIAGNOSTICS;
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $this$toJdiValue, ExecutionContext context2) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    switch (WhenMappings.$EnumSwitchMapping$0[((ExceptionThrown)$this$toJdiValue).getKind().ordinal()]) {
                        case 1: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                            ObjectReference exceptionReference = (ObjectReference)v;
                            KotlinEvaluatorBuilderKt.evaluationException(new InvocationException(exceptionReference));
                            throw new KotlinNothingValueException();
                        }
                        case 2: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Throwable");
                            throw (Throwable)v;
                        }
                    }
                    KotlinEvaluatorBuilderKt.evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw new KotlinNothingValueException();
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    KotlinEvaluatorBuilderKt.evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw new KotlinNothingValueException();
                }
                throw new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                VirtualMachine virtualMachine = context2.getVm().getVirtualMachine();
                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"context.vm.virtualMachine");
                object = JdiValuesKt.asJdiValue(jdiValue, virtualMachine, jdiValue.getAsmType());
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value2) {
            Object object = ValuesKt.obj(value2, value2.getAsmType());
            ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(EvaluatorValueConverter.Companion.unref(obj));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExceptionThrown.ExceptionKind.values().length];
                try {
                    nArray[ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExceptionThrown.ExceptionKind.BROKEN_CODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "illegalSuspendFunCallDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getIllegalSuspendFunCallDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;
        @Nullable
        private final Diagnostic illegalSuspendFunCallDiagnostic;

        public ErrorCheckingResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            this.bindingContext = bindingContext2;
            this.moduleDescriptor = moduleDescriptor;
            this.files = files2;
            this.illegalSuspendFunCallDiagnostic = illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        @Nullable
        public final Diagnostic getIllegalSuspendFunCallDiagnostic() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @Nullable
        public final Diagnostic component4() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            return new ErrorCheckingResult(bindingContext2, moduleDescriptor, files2, illegalSuspendFunCallDiagnostic);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list2, Diagnostic diagnostic, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list2 = errorCheckingResult.files;
            }
            if ((n & 8) != 0) {
                diagnostic = errorCheckingResult.illegalSuspendFunCallDiagnostic;
            }
            return errorCheckingResult.copy(bindingContext2, moduleDescriptor, list2, diagnostic);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ", illegalSuspendFunCallDiagnostic=" + this.illegalSuspendFunCallDiagnostic + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.moduleDescriptor.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            result2 = result2 * 31 + (this.illegalSuspendFunCallDiagnostic == null ? 0 : this.illegalSuspendFunCallDiagnostic.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ErrorCheckingResult)) {
                return false;
            }
            ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)other2;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.files, errorCheckingResult.files)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.illegalSuspendFunCallDiagnostic, (Object)errorCheckingResult.illegalSuspendFunCallDiagnostic);
        }
    }
}

