/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "box", "Lcom/sun/jdi/Value;", "value", "coerce", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "coerceBoxing", "coerceRef", "ref", "typeMatches", "", "requestedType", "actualTypeObj", "Lcom/sun/jdi/Type;", "unbox", "Companion", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nEvaluatorValueConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluatorValueConverter.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1#2:270\n618#3,12:271\n*S KotlinDebug\n*F\n+ 1 EvaluatorValueConverter.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter\n*L\n179#1:271,12\n*E\n"})
public final class EvaluatorValueConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private static final Map<String, String> UNBOXING_METHOD_NAMES;

    public EvaluatorValueConverter(@NotNull ExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    public final boolean typeMatches(@NotNull Type requestedType, @Nullable com.sun.jdi.Type actualTypeObj) {
        Intrinsics.checkNotNullParameter((Object)requestedType, (String)"requestedType");
        if (actualTypeObj == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)requestedType.getDescriptor(), (Object)"Ljava/lang/Object;") || JdiTypeUtils.isSubtype(actualTypeObj, requestedType)) {
            return true;
        }
        Type actualType = EvaluatorValueConverterKt.access$asmType(actualTypeObj);
        if (EvaluatorValueConverter.typeMatches$isRefWrapper(actualType, requestedType) || EvaluatorValueConverter.typeMatches$isRefWrapper(requestedType, actualType)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)requestedType, (Object)AsmTypes.K_CLASS_TYPE) && Intrinsics.areEqual((Object)actualType, (Object)AsmTypes.JAVA_CLASS_TYPE)) {
            return true;
        }
        Type unwrappedActualType = EvaluatorValueConverterKt.access$unwrap(actualType);
        Type unwrappedRequestedType = EvaluatorValueConverterKt.access$unwrap(requestedType);
        return Intrinsics.areEqual((Object)unwrappedActualType, (Object)unwrappedRequestedType);
    }

    @Nullable
    public final VariableFinder.Result coerce(@Nullable Value value2, @NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        VariableFinder.Result unrefResult = this.coerceRef(value2, type2);
        return this.coerceBoxing(unrefResult.getValue(), type2);
    }

    private final VariableFinder.Result coerceRef(Value value2, Type type2) {
        if (EvaluatorValueConverterKt.isRefType(type2)) {
            if (value2 != null && EvaluatorValueConverterKt.isRefType(EvaluatorValueConverterKt.access$asmType(value2))) {
                return new VariableFinder.Result(value2);
            }
            return new VariableFinder.Result(this.ref(value2));
        }
        if (value2 != null && EvaluatorValueConverterKt.isRefType(EvaluatorValueConverterKt.access$asmType(value2))) {
            if (EvaluatorValueConverterKt.isRefType(type2)) {
                return new VariableFinder.Result(value2);
            }
            return new VariableFinder.Result(Companion.unref(value2));
        }
        return new VariableFinder.Result(value2);
    }

    private final VariableFinder.Result coerceBoxing(Value value2, Type type2) {
        if (value2 == null) {
            return new VariableFinder.Result(null);
        }
        if (Intrinsics.areEqual((Object)type2, (Object)Type.VOID_TYPE)) {
            return new VariableFinder.Result(this.context.getVm().mirrorOfVoid());
        }
        if (EvaluatorValueConverterKt.access$isBoxedType(type2)) {
            if (EvaluatorValueConverterKt.access$isBoxedType(EvaluatorValueConverterKt.access$asmType(value2))) {
                return new VariableFinder.Result(value2);
            }
            if (!(value2 instanceof PrimitiveValue)) {
                return null;
            }
            return new VariableFinder.Result(this.box(value2));
        }
        if (EvaluatorValueConverterKt.access$isPrimitiveType(type2)) {
            if (value2 instanceof PrimitiveValue) {
                return new VariableFinder.Result(value2);
            }
            if (!(value2 instanceof ObjectReference) || !EvaluatorValueConverterKt.access$isBoxedType(EvaluatorValueConverterKt.access$asmType(value2))) {
                return null;
            }
            return new VariableFinder.Result(this.unbox(value2));
        }
        if (value2 instanceof PrimitiveValue) {
            Value boxedValue;
            if (type2.getSort() != 10) {
                return null;
            }
            Value value3 = boxedValue = this.box(value2);
            if (!this.typeMatches(type2, value3 != null ? value3.type() : null)) {
                return null;
            }
            return new VariableFinder.Result(boxedValue);
        }
        return new VariableFinder.Result(value2);
    }

    private final Value box(Value value2) {
        if (!(value2 instanceof PrimitiveValue)) {
            return value2;
        }
        Type unboxedType = EvaluatorValueConverterKt.access$asmType(value2);
        Type boxedType = EvaluatorValueConverterKt.box(unboxedType);
        ClassType classType = (ClassType)BaseExecutionContext.findClass$default((BaseExecutionContext)this.context, boxedType, null, 2, null);
        if (classType == null) {
            throw new IllegalStateException(("Class " + boxedType + " is not loaded").toString());
        }
        ClassType boxedTypeClass = classType;
        Type[] typeArray = new Type[]{unboxedType};
        String methodDesc = Type.getMethodDescriptor((Type)boxedType, (Type[])typeArray);
        List<Method> list2 = boxedTypeClass.methodsByName("valueOf", methodDesc);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"boxedTypeClass.methodsBy\u2026me(\"valueOf\", methodDesc)");
        Method valueOfMethod = (Method)CollectionsKt.first(list2);
        Intrinsics.checkNotNullExpressionValue((Object)valueOfMethod, (String)"valueOfMethod");
        return this.context.invokeMethod(boxedTypeClass, valueOfMethod, (List<? extends Value>)CollectionsKt.listOf((Object)value2));
    }

    private final Value unbox(Value value2) {
        Type type2;
        if (!(value2 instanceof ObjectReference)) {
            return value2;
        }
        ReferenceType referenceType = ((ObjectReference)value2).referenceType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            return value2;
        }
        ClassType boxedTypeClass = classType;
        Type it = type2 = EvaluatorValueConverterKt.access$asmType(boxedTypeClass);
        boolean bl = false;
        Object object = EvaluatorValueConverterKt.access$isBoxedType(it) ? type2 : null;
        if (object == null) {
            return value2;
        }
        Type boxedType = object;
        Type unboxedType = EvaluatorValueConverterKt.access$unbox(boxedType);
        String string2 = boxedType.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"boxedType.internalName");
        String unboxingMethodName = (String)MapsKt.getValue(UNBOXING_METHOD_NAMES, (Object)string2);
        String methodDesc = Type.getMethodDescriptor((Type)unboxedType, (Type[])new Type[0]);
        List<Method> list2 = boxedTypeClass.methodsByName(unboxingMethodName, methodDesc);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"boxedTypeClass.methodsBy\u2026ngMethodName, methodDesc)");
        Method valueMethod = (Method)CollectionsKt.first(list2);
        BaseExecutionContext baseExecutionContext = this.context;
        ObjectReference objectReference = (ObjectReference)value2;
        Intrinsics.checkNotNullExpressionValue((Object)valueMethod, (String)"valueMethod");
        return BaseExecutionContext.invokeMethod$default(baseExecutionContext, objectReference, valueMethod, CollectionsKt.emptyList(), 0, 8, null);
    }

    private final Value ref(Value value2) {
        if (value2 instanceof VoidValue) {
            return value2;
        }
        if (value2 instanceof PrimitiveValue) {
            Type primitiveType = EvaluatorValueConverterKt.access$asmType(value2);
            Type refType = (Type)MapsKt.getValue((Map)EvaluatorValueConverterKt.access$getPRIMITIVE_TO_REF$p(), (Object)primitiveType);
            ClassType classType = (ClassType)BaseExecutionContext.findClass$default((BaseExecutionContext)this.context, refType, null, 2, null);
            if (classType == null) {
                throw new IllegalStateException(("Class " + refType + " is not loaded").toString());
            }
            ClassType refTypeClass = classType;
            return EvaluatorValueConverter.ref$wrapRef(this, value2, refTypeClass);
        }
        Type refType = Type.getType(Ref.ObjectRef.class);
        BaseExecutionContext baseExecutionContext = this.context;
        Intrinsics.checkNotNullExpressionValue((Object)refType, (String)"refType");
        ClassType classType = (ClassType)BaseExecutionContext.findClass$default(baseExecutionContext, refType, null, 2, null);
        if (classType == null) {
            throw new IllegalStateException(("Class " + refType + " is not loaded").toString());
        }
        ClassType refTypeClass = classType;
        return EvaluatorValueConverter.ref$wrapRef(this, value2, refTypeClass);
    }

    private static final boolean typeMatches$isRefWrapper(Type wrapperType, Type objType) {
        return !EvaluatorValueConverterKt.access$isPrimitiveType(objType) && Intrinsics.areEqual((Object)wrapperType.getClassName(), (Object)Ref.ObjectRef.class.getName());
    }

    private static final Value ref$wrapRef(EvaluatorValueConverter this$0, Value value2, ClassType refTypeClass) {
        List<Method> list2 = refTypeClass.methods();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"refTypeClass.methods()");
        Iterable $this$single$iv = list2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!it.isConstructor()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Method constructor2 = single$iv;
        ExecutionContext executionContext2 = this$0.context;
        Intrinsics.checkNotNullExpressionValue((Object)constructor2, (String)"constructor");
        ObjectReference ref = executionContext2.newInstance(refTypeClass, constructor2, CollectionsKt.emptyList());
        this$0.context.keepReference(ref);
        Field field2 = refTypeClass.fieldByName("element");
        if (field2 == null) {
            throw new IllegalStateException("'element' field not found".toString());
        }
        Field elementField = field2;
        ref.setValue(elementField, value2);
        return ref;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java/lang/Boolean", (Object)"booleanValue"), TuplesKt.to((Object)"java/lang/Character", (Object)"charValue"), TuplesKt.to((Object)"java/lang/Byte", (Object)"byteValue"), TuplesKt.to((Object)"java/lang/Short", (Object)"shortValue"), TuplesKt.to((Object)"java/lang/Integer", (Object)"intValue"), TuplesKt.to((Object)"java/lang/Float", (Object)"floatValue"), TuplesKt.to((Object)"java/lang/Long", (Object)"longValue"), TuplesKt.to((Object)"java/lang/Double", (Object)"doubleValue")};
        UNBOXING_METHOD_NAMES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter$Companion;", "", "()V", "UNBOXING_METHOD_NAMES", "", "", "getUNBOXING_METHOD_NAMES", "()Ljava/util/Map;", "unref", "Lcom/sun/jdi/Value;", "value", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getUNBOXING_METHOD_NAMES() {
            return UNBOXING_METHOD_NAMES;
        }

        @Nullable
        public final Value unref(@Nullable Value value2) {
            com.sun.jdi.Type type2;
            block6: {
                block5: {
                    if (!(value2 instanceof ObjectReference)) {
                        return value2;
                    }
                    type2 = ((ObjectReference)value2).type();
                    if (!(type2 instanceof ClassType)) break block5;
                    String string2 = type2.signature();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.signature()");
                    if (StringsKt.startsWith$default((String)string2, (String)"Lkotlin/jvm/internal/Ref$", (boolean)false, (int)2, null)) break block6;
                }
                return value2;
            }
            Field field2 = ((ClassType)type2).fieldByName("element");
            if (field2 == null) {
                return value2;
            }
            Field field3 = field2;
            return ((ObjectReference)value2).getValue(field3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

