/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.impl;

import com.intellij.debugger.streams.psi.ChainTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.StreamCallChecker;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.impl.KotlinChainBuilderBase;
import org.jetbrains.kotlin.psi.KtCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase;", "transformer", "Lcom/intellij/debugger/streams/psi/ChainTransformer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callChecker", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;", "(Lcom/intellij/debugger/streams/psi/ChainTransformer;Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;)V", "existenceChecker", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "getExistenceChecker", "()Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "createChainsBuilder", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ChainBuilder;", "MyBuilderVisitor", "MyExistenceChecker", "kotlin.jvm-debugger.sequence"})
public class TerminatedChainBuilder
extends KotlinChainBuilderBase {
    @NotNull
    private final StreamCallChecker callChecker;
    @NotNull
    private final KotlinChainBuilderBase.ExistenceChecker existenceChecker;

    public TerminatedChainBuilder(@NotNull ChainTransformer<KtCallExpression> transformer2, @NotNull StreamCallChecker callChecker) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)callChecker, (String)"callChecker");
        super(transformer2);
        this.callChecker = callChecker;
        this.existenceChecker = new MyExistenceChecker();
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ExistenceChecker getExistenceChecker() {
        return this.existenceChecker;
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ChainBuilder createChainsBuilder() {
        return new MyBuilderVisitor();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder$MyBuilderVisitor;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ChainBuilder;", "(Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;)V", "myPreviousCalls", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "myTerminationCalls", "", "chains", "", "updateCallTree", "", "expression", "visitCallExpression", "kotlin.jvm-debugger.sequence"})
    private final class MyBuilderVisitor
    extends KotlinChainBuilderBase.ChainBuilder {
        @NotNull
        private final Set<KtCallExpression> myTerminationCalls = new LinkedHashSet();
        @NotNull
        private final Map<KtCallExpression, KtCallExpression> myPreviousCalls = new LinkedHashMap();

        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super.visitCallExpression(expression2);
            if (!this.myPreviousCalls.containsKey(expression2) && TerminatedChainBuilder.this.callChecker.isStreamCall(expression2)) {
                this.updateCallTree(expression2);
            }
        }

        private final void updateCallTree(KtCallExpression expression2) {
            KtCallExpression parentCall2;
            if (TerminatedChainBuilder.this.callChecker.isTerminationCall(expression2)) {
                this.myTerminationCalls.add(expression2);
            }
            if ((parentCall2 = KotlinPsiUtilKt.previousCall(expression2)) != null && TerminatedChainBuilder.this.callChecker.isStreamCall(parentCall2)) {
                this.myPreviousCalls.put(expression2, parentCall2);
                this.updateCallTree(parentCall2);
            }
        }

        @Override
        @NotNull
        public List<List<KtCallExpression>> chains() {
            ArrayList chains = new ArrayList();
            for (KtCallExpression terminationCall : this.myTerminationCalls) {
                ArrayList<KtCallExpression> chain = new ArrayList<KtCallExpression>();
                KtCallExpression current = terminationCall;
                while (current != null && TerminatedChainBuilder.this.callChecker.isStreamCall(current)) {
                    chain.add(current);
                    current = this.myPreviousCalls.get(current);
                }
                CollectionsKt.reverse((List)chain);
                chains.add(chain);
            }
            return chains;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder$MyExistenceChecker;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "(Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;)V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlin.jvm-debugger.sequence"})
    private final class MyExistenceChecker
    extends KotlinChainBuilderBase.ExistenceChecker {
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (TerminatedChainBuilder.this.callChecker.isTerminationCall(expression2)) {
                this.fireElementFound();
            } else {
                super.visitCallExpression(expression2);
            }
        }
    }
}

