/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategyKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "", "()V", "getIndent", "Lcom/intellij/formatting/Indent;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Companion", "ConstIndentStrategy", "PositionStrategy", "kotlin.formatter"})
public abstract class NodeIndentStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Indent getIndent(@NotNull ASTNode var1, @NotNull CodeStyleSettings var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$Companion;", "", "()V", "constIndent", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "strategy", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "debugInfo", "", "kotlin.formatter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeIndentStrategy constIndent(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            return new ConstIndentStrategy(indent);
        }

        @NotNull
        public final PositionStrategy strategy(@NonNls @Nullable String debugInfo2) {
            return new PositionStrategy(debugInfo2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$ConstIndentStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/formatting/Indent;)V", "getIndent", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "kotlin.formatter"})
    public static final class ConstIndentStrategy
    extends NodeIndentStrategy {
        @NotNull
        private final Indent indent;

        public ConstIndentStrategy(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            this.indent = indent;
        }

        @Override
        @NotNull
        public Indent getIndent(@NotNull ASTNode node2, @NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            return this.indent;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u001a\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ'\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00072\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000eH\u0016J'\u0010$\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00072\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007\u00a2\u0006\u0002\u0010 J'\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00072\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007\u00a2\u0006\u0002\u0010 J\u001a\u0010(\u001a\u00020\u00002\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000fJ\b\u0010*\u001a\u00020\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ'\u0010\u0012\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00072\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "debugInfo", "", "(Ljava/lang/String;)V", "forElement", "Ljava/util/ArrayList;", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/collections/ArrayList;", "forElementCallback", "Lkotlin/Function1;", "Lcom/intellij/lang/ASTNode;", "", "indentCallback", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Lcom/intellij/formatting/Indent;", "notForElement", "notIn", "within", "withinCallback", "fillTypes", "", "resultCollection", "", "singleType", "otherTypes", "", "(Ljava/util/List;Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)V", "forAny", "callback", "forType", "elementType", "(Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "getIndent", "node", "settings", "notForType", "notWithin", "parentType", "orParentTypes", "set", "indent", "toString", "parents", "Lcom/intellij/psi/tree/TokenSet;", "withinAny", "kotlin.formatter"})
    public static final class PositionStrategy
    extends NodeIndentStrategy {
        @Nullable
        private final String debugInfo;
        @NotNull
        private Function1<? super CodeStyleSettings, ? extends Indent> indentCallback;
        @NotNull
        private final ArrayList<IElementType> within;
        @Nullable
        private Function1<? super ASTNode, Boolean> withinCallback;
        @NotNull
        private final ArrayList<IElementType> notIn;
        @NotNull
        private final ArrayList<IElementType> forElement;
        @NotNull
        private final ArrayList<IElementType> notForElement;
        @Nullable
        private Function1<? super ASTNode, Boolean> forElementCallback;

        public PositionStrategy(@Nullable String debugInfo2) {
            this.debugInfo = debugInfo2;
            this.indentCallback = indentCallback.1.INSTANCE;
            this.within = new ArrayList();
            this.notIn = new ArrayList();
            this.forElement = new ArrayList();
            this.notForElement = new ArrayList();
        }

        @NotNull
        public String toString() {
            String string2 = this.debugInfo;
            if (string2 == null) {
                string2 = "No debug info";
            }
            return "PositionStrategy " + string2;
        }

        @NotNull
        public final PositionStrategy set(@NotNull Indent indent) {
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            this.indentCallback = (Function1)new Function1<CodeStyleSettings, Indent>(indent){
                final /* synthetic */ Indent $indent;
                {
                    this.$indent = $indent;
                    super(1);
                }

                @NotNull
                public final Indent invoke(@NotNull CodeStyleSettings it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$indent;
                }
            };
            return this;
        }

        @NotNull
        public final PositionStrategy set(@NotNull Function1<? super CodeStyleSettings, ? extends Indent> indentCallback2) {
            Intrinsics.checkNotNullParameter(indentCallback2, (String)"indentCallback");
            this.indentCallback = indentCallback2;
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull TokenSet parents2) {
            Intrinsics.checkNotNullParameter((Object)parents2, (String)"parents");
            Object[] objectArray = parents2.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parents.types");
            Object[] types2 = objectArray;
            if (types2.length == 0) {
                throw new IllegalArgumentException("Empty token set is unexpected");
            }
            List list2 = this.within;
            IElementType iElementType = types2[0];
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"types[0]");
            Object[] objectArray2 = types2;
            int n = 1;
            int n2 = types2.length;
            this.fillTypes(list2, iElementType, (IElementType[])ArraysKt.copyOfRange((Object[])objectArray2, (int)n, (int)n2));
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
            Intrinsics.checkNotNullParameter((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.within, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull Function1<? super ASTNode, Boolean> callback2) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            this.withinCallback = callback2;
            return this;
        }

        @NotNull
        public final PositionStrategy notWithin(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
            Intrinsics.checkNotNullParameter((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.notIn, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy withinAny() {
            this.within.clear();
            this.notIn.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.forElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy notForType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.notForElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy forAny() {
            this.forElement.clear();
            this.notForElement.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forElement(@NotNull Function1<? super ASTNode, Boolean> callback2) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            this.forElementCallback = callback2;
            return this;
        }

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node2, @NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            if (!NodeIndentStrategyKt.access$isValidIndent(this.forElement, this.notForElement, node2, this.forElementCallback)) {
                return null;
            }
            ASTNode parent2 = node2.getTreeParent();
            if (parent2 != null ? !NodeIndentStrategyKt.access$isValidIndent(this.within, this.notIn, parent2, this.withinCallback) : !((Collection)this.within).isEmpty()) {
                return null;
            }
            return (Indent)this.indentCallback.invoke((Object)settings2);
        }

        private final void fillTypes(List<IElementType> resultCollection, IElementType singleType, IElementType[] otherTypes) {
            resultCollection.clear();
            resultCollection.add(singleType);
            CollectionsKt.addAll((Collection)resultCollection, (Object[])otherTypes);
        }
    }
}

